/*
 * Decompiled with CFR 0.152.
 */
package com.fr.dialog.core;

import com.fr.base.Inter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ColorSelectPane
extends JPanel {
    private Color color = null;
    private boolean isSupportTransparent = false;
    private Dimension colorCellDimension = new Dimension(15, 15);
    private Color colorCellBorderColor = Color.gray;
    private List colorChangeListenerList = new ArrayList();
    private final Color[] MenuColors = new Color[]{Color.black, new Color(153, 51, 0), new Color(51, 51, 0), new Color(0, 51, 0), new Color(0, 51, 102), new Color(0, 0, 128), new Color(51, 51, 153), new Color(51, 51, 51), new Color(128, 0, 0), new Color(252, 102, 0), new Color(128, 128, 0), new Color(0, 128, 0), new Color(0, 128, 128), new Color(0, 0, 255), new Color(102, 102, 153), new Color(128, 128, 128), new Color(255, 0, 0), new Color(255, 153, 0), new Color(153, 204, 0), new Color(51, 153, 102), new Color(51, 204, 204), new Color(51, 102, 255), new Color(128, 0, 128), new Color(150, 150, 150), new Color(255, 0, 255), new Color(255, 204, 0), new Color(255, 255, 0), new Color(0, 255, 0), new Color(0, 255, 255), new Color(0, 204, 255), new Color(153, 51, 102), new Color(192, 192, 192), new Color(255, 153, 204), new Color(255, 204, 153), new Color(255, 255, 153), new Color(204, 255, 204), new Color(204, 255, 255), new Color(153, 204, 255), new Color(204, 153, 255), new Color(255, 255, 255)};
    private final Color[] MenuColors2 = new Color[]{new Color(153, 153, 255), new Color(153, 51, 102), new Color(255, 255, 204), new Color(204, 255, 255), new Color(102, 0, 102), new Color(255, 128, 128), new Color(0, 102, 204), new Color(204, 204, 255), new Color(0, 0, 128), new Color(255, 0, 255), new Color(255, 255, 0), new Color(0, 255, 255), new Color(128, 0, 128), new Color(128, 0, 0), new Color(0, 128, 128), new Color(0, 0, 255)};

    public ColorSelectPane() {
        this((Color)null);
    }

    public ColorSelectPane(Color color) {
        this.setColor(color);
        this.initComponents();
    }

    private void initComponents() {
        JComponent jComponent;
        this.removeAll();
        this.setLayout(new BorderLayout(0, 4));
        if (this.isSupportTransparent) {
            jComponent = new JButton("Transparent");
            jComponent.setCursor(new Cursor(12));
            ((AbstractButton)jComponent).addActionListener(new TransparentActionListener());
            this.add((Component)jComponent, "North");
        }
        jComponent = new JPanel();
        this.add((Component)jComponent, "Center");
        jComponent.setLayout(new BoxLayout(jComponent, 1));
        JPanel jPanel = new JPanel();
        jComponent.add(jPanel);
        jPanel.setLayout(new GridLayout(5, 8, 5, 5));
        for (int i = 0; i < this.MenuColors.length; ++i) {
            jPanel.add(new ColorCell(this.MenuColors[i]));
        }
        jComponent.add(Box.createVerticalStrut(5));
        jComponent.add(new JSeparator());
        jComponent.add(Box.createVerticalStrut(5));
        JPanel jPanel2 = new JPanel();
        jComponent.add(jPanel2);
        jPanel2.setLayout(new GridLayout(2, 8, 5, 5));
        for (int i = 0; i < this.MenuColors2.length; ++i) {
            jPanel2.add(new ColorCell(this.MenuColors2[i]));
        }
        JButton jButton = new JButton();
        jButton.setText(Inter.getLocText("Custom") + "...");
        jButton.setCursor(new Cursor(12));
        jButton.addActionListener(new CustomActionListener());
        this.add((Component)jButton, "South");
        this.revalidate();
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.colorChangeListenerList.add(changeListener);
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
        if (this.colorChangeListenerList.size() > 0) {
            ChangeEvent changeEvent = new ChangeEvent(this);
            for (int i = 0; i < this.colorChangeListenerList.size(); ++i) {
                ((ChangeListener)this.colorChangeListenerList.get(i)).stateChanged(changeEvent);
            }
        }
        this.repaint();
    }

    public boolean isSupportTransparent() {
        return this.isSupportTransparent;
    }

    public void setSupportTransparent(boolean bl) {
        boolean bl2 = this.isSupportTransparent;
        this.isSupportTransparent = bl;
        if (bl2 != bl) {
            this.initComponents();
        }
    }

    public Dimension getColorCellDimension() {
        return this.colorCellDimension;
    }

    public void setColorCellDimension(Dimension dimension) {
        Dimension dimension2 = this.colorCellDimension;
        this.colorCellDimension = dimension;
        if (!dimension2.equals(this.colorCellDimension)) {
            this.initComponents();
        }
    }

    public Color getColorCellBorderLineColor() {
        return this.colorCellBorderColor;
    }

    public void setColorCellBorderLineColor(Color color) {
        Color color2 = this.colorCellBorderColor;
        this.colorCellBorderColor = color;
        if (!color2.equals(this.colorCellBorderColor)) {
            this.initComponents();
        }
    }

    class CustomActionListener
    implements ActionListener {
        CustomActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Color color = JColorChooser.showDialog(ColorSelectPane.this, "Select Color.", ColorSelectPane.this.getColor());
            if (color != null) {
                ColorSelectPane.this.setColor(color);
            }
        }
    }

    class TransparentActionListener
    implements ActionListener {
        TransparentActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ColorSelectPane.this.setColor(null);
        }
    }

    class ColorCell
    extends JComponent {
        private Color color = Color.white;

        public ColorCell() {
            this.enableEvents(16L);
            this.setBorder(new LineBorder(ColorSelectPane.this.getColorCellBorderLineColor()));
            this.setCursor(new Cursor(12));
        }

        public ColorCell(Color color) {
            this();
            this.setColor(color);
        }

        public void setColor(Color color) {
            this.color = color;
            this.repaint();
        }

        public Color getColor() {
            return this.color;
        }

        public void paintComponent(Graphics graphics) {
            Dimension dimension = this.getSize();
            Insets insets = this.getInsets();
            int n = dimension.width - insets.left - insets.right;
            int n2 = dimension.height - insets.top - insets.bottom;
            if (this.color == null) {
                graphics.setColor(Color.white);
                graphics.fillRect(insets.left, insets.top, dimension.width - insets.left - insets.right, dimension.height - insets.top - insets.bottom);
                graphics.setColor(Color.gray);
                graphics.drawLine(insets.left, insets.top, n, n2);
                graphics.drawLine(n, insets.top, insets.left, n2);
            } else {
                graphics.setColor(this.color);
                graphics.fillRect(insets.left, insets.top, n, n2);
            }
            if (ColorSelectPane.this.getColor() != null && ColorSelectPane.this.getColor().equals(this.getColor())) {
                graphics.setColor(Color.black);
                graphics.drawRect(insets.left, insets.top, n - 1, n2 - 1);
            }
        }

        public void processMouseEvent(MouseEvent mouseEvent) {
            if (mouseEvent == null || mouseEvent.getID() == 502) {
                ColorSelectPane.this.setColor(this.getColor());
                this.repaint();
            }
            if (mouseEvent != null) {
                super.processMouseEvent(mouseEvent);
            }
        }

        public Dimension getPreferredSize() {
            return ColorSelectPane.this.getColorCellDimension();
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }
    }
}

