/*
 * Decompiled with CFR 0.152.
 */
package com.fr.dialog.core;

import com.fr.base.BaseUtils;
import com.fr.base.Inter;
import com.fr.cell.core.layout.LayoutFactory;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ColorSelectionPane
extends JPanel {
    private Color color = null;
    private boolean isCanBeNull = false;
    private JComponent displayComponent;
    private JButton triggleButton;
    private ColorControlWindow colorSetPopupWindow;
    private List changeListenerList = new ArrayList();
    private final Color[] menuColors = new Color[]{Color.black, new Color(153, 51, 0), new Color(51, 51, 0), new Color(0, 51, 0), new Color(0, 51, 102), new Color(0, 0, 128), new Color(51, 51, 153), new Color(51, 51, 51), new Color(128, 0, 0), new Color(252, 102, 0), new Color(128, 128, 0), new Color(0, 128, 0), new Color(0, 128, 128), new Color(0, 0, 255), new Color(102, 102, 153), new Color(128, 128, 128), new Color(255, 0, 0), new Color(255, 153, 0), new Color(153, 204, 0), new Color(51, 153, 102), new Color(51, 204, 204), new Color(51, 102, 255), new Color(128, 0, 128), new Color(150, 150, 150), new Color(255, 0, 255), new Color(255, 204, 0), new Color(255, 255, 0), new Color(0, 255, 0), new Color(0, 255, 255), new Color(0, 204, 255), new Color(153, 51, 102), new Color(192, 192, 192), new Color(255, 153, 204), new Color(255, 204, 153), new Color(255, 255, 153), new Color(204, 255, 204), new Color(204, 255, 255), new Color(153, 204, 255), new Color(204, 153, 255), new Color(255, 255, 255)};
    private final Color[] menuColors2 = new Color[]{new Color(153, 153, 255), new Color(153, 51, 102), new Color(255, 255, 204), new Color(204, 255, 255), new Color(102, 0, 102), new Color(255, 128, 128), new Color(0, 102, 204), new Color(204, 204, 255), new Color(0, 0, 128), new Color(255, 0, 255), new Color(255, 255, 0), new Color(0, 255, 255), new Color(128, 0, 128), new Color(128, 0, 0), new Color(0, 128, 128), new Color(0, 0, 255)};

    public ColorSelectionPane(int n) {
        this(n, 24, 16);
    }

    public ColorSelectionPane(int n, int n2, int n3) {
        this.setLayout(LayoutFactory.createBorderLayout());
        this.displayComponent = new JLabel();
        this.displayComponent.setBorder(BorderFactory.createLineBorder(Color.gray));
        this.triggleButton = new JButton(BaseUtils.readIcon("/com/fr/dialog/images/color/popupCenter.png"));
        this.triggleButton.setBorder(new TriggleLineBorder());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel.add((Component)this.displayComponent, "Center");
        jPanel.setOpaque(true);
        this.displayComponent.setOpaque(true);
        this.displayComponent.addMouseListener(new PopupMouseListener());
        this.triggleButton.addMouseListener(new PopupMouseListener());
        this.add((Component)jPanel, "Center");
        this.add((Component)this.triggleButton, "East");
        Dimension dimension = new Dimension(n3, n2);
        this.triggleButton.setMaximumSize(dimension);
        this.triggleButton.setMinimumSize(dimension);
        this.triggleButton.setPreferredSize(dimension);
        this.triggleButton.setSize(dimension);
        Dimension dimension2 = new Dimension(Math.max(n, jPanel.getPreferredSize().width), n2);
        jPanel.setMaximumSize(dimension2);
        jPanel.setMinimumSize(dimension2);
        jPanel.setPreferredSize(dimension2);
        jPanel.setSize(dimension2);
        this.addAncestorListener(new AncestorListener(){

            public void ancestorAdded(AncestorEvent ancestorEvent) {
            }

            public void ancestorRemoved(AncestorEvent ancestorEvent) {
                ColorSelectionPane.this.hidePopupMenu();
            }

            public void ancestorMoved(AncestorEvent ancestorEvent) {
                ColorSelectionPane.this.hidePopupMenu();
            }
        });
    }

    public Color getColor() {
        if (!this.isEnabled()) {
            return null;
        }
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
        if (color == null || color.getAlpha() == 0) {
            this.displayComponent.setBackground(null);
        } else {
            this.displayComponent.setBackground(color);
        }
        if (this.changeListenerList.size() > 0) {
            ChangeEvent changeEvent = new ChangeEvent(this);
            for (int i = 0; i < this.changeListenerList.size(); ++i) {
                ((ChangeListener)this.changeListenerList.get(i)).stateChanged(changeEvent);
            }
        }
        this.displayComponent.repaint();
    }

    public boolean isCanBeNull() {
        return this.isCanBeNull;
    }

    public void setCanBeNull(boolean bl) {
        this.isCanBeNull = bl;
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.displayComponent.setEnabled(bl);
        this.triggleButton.setEnabled(bl);
    }

    private void showPopupMenu() {
        if (this.colorSetPopupWindow != null && this.colorSetPopupWindow.isVisible()) {
            this.hidePopupMenu();
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        this.colorSetPopupWindow = this.getColorControlWindow();
        Point point = new Point(0, 0);
        SwingUtilities.convertPointToScreen(point, this);
        this.colorSetPopupWindow.setLocation(point.x, point.y + this.getSize().height);
        this.colorSetPopupWindow.setVisible(true);
    }

    private void hidePopupMenu() {
        if (this.colorSetPopupWindow != null) {
            this.colorSetPopupWindow.setVisible(false);
        }
        this.colorSetPopupWindow = null;
    }

    private ColorControlWindow getColorControlWindow() {
        Window window;
        if (this.colorSetPopupWindow == null && (window = SwingUtilities.windowForComponent(this)) != null) {
            this.colorSetPopupWindow = new ColorControlWindow(window, this.isCanBeNull());
        }
        return this.colorSetPopupWindow;
    }

    public void addColorChangeListener(ChangeListener changeListener) {
        this.changeListenerList.add(changeListener);
    }

    class TriggleLineBorder
    extends AbstractBorder {
        protected Insets borderInsets = new Insets(1, 0, 1, 0);

        TriggleLineBorder() {
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            graphics.translate(n, n2);
            graphics.setColor(Color.gray);
            graphics.drawLine(0, 0, n3, 0);
            graphics.drawLine(0, n4 - 1, n3, n4 - 1);
            graphics.drawLine(n3 - 1, 0, n3 - 1, n4);
            graphics.translate(-n, -n2);
        }

        public Insets getBorderInsets(Component component) {
            return this.borderInsets;
        }
    }

    private class ColorCell
    extends JComponent {
        private Color color = Color.white;

        public ColorCell() {
            this.enableEvents(16L);
            this.setPreferredSize(new Dimension(14, 14));
            this.setBorder(new LineBorder(Color.gray));
            this.setCursor(new Cursor(12));
        }

        public ColorCell(Color color) {
            this();
            this.setColor(color);
        }

        public void setColor(Color color) {
            this.color = color;
            this.repaint();
        }

        public Color getColor() {
            return this.color;
        }

        public void paintComponent(Graphics graphics) {
            Dimension dimension = this.getSize();
            Insets insets = this.getInsets();
            int n = dimension.width - insets.left - insets.right;
            int n2 = dimension.height - insets.top - insets.bottom;
            if (this.color == null) {
                graphics.setColor(Color.white);
                graphics.fillRect(insets.left, insets.top, dimension.width - insets.left - insets.right, dimension.height - insets.top - insets.bottom);
                graphics.setColor(Color.gray);
                graphics.drawLine(insets.left, insets.top, n, n2);
                graphics.drawLine(n, insets.top, insets.left, n2);
            } else {
                graphics.setColor(this.color);
                graphics.fillRect(insets.left, insets.top, n, n2);
            }
            if (ColorSelectionPane.this.getColor() != null && ColorSelectionPane.this.getColor().equals(this.getColor())) {
                graphics.setColor(Color.black);
                graphics.drawRect(insets.left, insets.top, n - 1, n2 - 1);
            }
        }

        public void processMouseEvent(MouseEvent mouseEvent) {
            if (mouseEvent == null || mouseEvent.getID() == 502) {
                ColorSelectionPane.this.setColor(this.getColor());
                ColorSelectionPane.this.hidePopupMenu();
            }
            if (mouseEvent != null) {
                super.processMouseEvent(mouseEvent);
            }
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }
    }

    class ColorSelectionPopupPane
    extends JPanel {
        public ColorSelectionPopupPane(boolean bl) {
            JComponent jComponent;
            this.setLayout(new BorderLayout(0, 4));
            this.setBorder(BorderFactory.createEmptyBorder(2, 4, 2, 4));
            if (bl) {
                jComponent = new JButton(Inter.getLocText("Transparent"));
                jComponent.setCursor(new Cursor(12));
                ((AbstractButton)jComponent).addActionListener(new TransparentActionListener());
                this.add((Component)jComponent, "North");
            }
            jComponent = new JPanel();
            this.add((Component)jComponent, "Center");
            jComponent.setLayout(new BoxLayout(jComponent, 1));
            JPanel jPanel = new JPanel();
            jComponent.add(jPanel);
            jPanel.setLayout(new GridLayout(5, 8, 5, 5));
            for (int i = 0; i < ColorSelectionPane.this.menuColors.length; ++i) {
                jPanel.add(new ColorCell(ColorSelectionPane.this.menuColors[i]));
            }
            jComponent.add(Box.createVerticalStrut(5));
            jComponent.add(new JSeparator());
            jComponent.add(Box.createVerticalStrut(5));
            JPanel jPanel2 = new JPanel();
            jComponent.add(jPanel2);
            jPanel2.setLayout(new GridLayout(2, 8, 5, 5));
            for (int i = 0; i < ColorSelectionPane.this.menuColors2.length; ++i) {
                jPanel2.add(new ColorCell(ColorSelectionPane.this.menuColors2[i]));
            }
            JButton jButton = new JButton(Inter.getLocText("Custom") + "...");
            jButton.setCursor(new Cursor(12));
            jButton.addActionListener(new CustomActionListener());
            this.add((Component)jButton, "South");
        }

        class CustomActionListener
        implements ActionListener {
            CustomActionListener() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                ColorSelectionPane.this.hidePopupMenu();
                Color color = JColorChooser.showDialog(SwingUtilities.getWindowAncestor(ColorSelectionPane.this), "Select Color", ColorSelectionPane.this.getColor());
                if (color != null) {
                    ColorSelectionPane.this.setColor(color);
                }
            }
        }

        class TransparentActionListener
        implements ActionListener {
            TransparentActionListener() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                Color color = new Color(255, 255, 255, 0);
                ColorSelectionPane.this.setColor(color);
                ColorSelectionPane.this.hidePopupMenu();
            }
        }
    }

    class ColorControlWindow
    extends JWindow {
        public ColorControlWindow(Window window, boolean bl) {
            super(window);
            this.initComponents(bl);
        }

        public void initComponents(boolean bl) {
            JPanel jPanel = new JPanel();
            this.setContentPane(jPanel);
            jPanel.setBorder(UIManager.getBorder("PopupMenu.border"));
            jPanel.setLayout(LayoutFactory.createBorderLayout());
            jPanel.add((Component)new ColorSelectionPopupPane(bl), "Center");
            this.pack();
        }
    }

    class PopupMouseListener
    extends MouseAdapter {
        PopupMouseListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            ColorSelectionPane.this.showPopupMenu();
        }
    }
}

