/*
 * Decompiled with CFR 0.152.
 */
package com.fr.dialog.core;

import com.fr.base.ColumnRow;
import com.fr.base.Inter;
import com.fr.base.core.BaseCoreUtils;
import com.fr.cell.core.GUICoreUtils;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerDateModel;
import javax.swing.SpinnerListModel;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.DocumentFilter;

public class ColumnRowPane
extends JPanel {
    private UpperCaseSpinner columnSpinner;
    private JSpinner rowSpinner;
    private boolean isShowLabel = true;
    public static String PropChangeName = "ColumnRowPaneChangeName";
    private PropertyChangeSupport changeSupport;
    DocumentListener documentListener = new DocumentListener(){

        public void changedUpdate(DocumentEvent documentEvent) {
            ColumnRowPane.this.newColumnRow();
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            ColumnRowPane.this.newColumnRow();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            ColumnRowPane.this.newColumnRow();
        }
    };

    public ColumnRowPane() {
        this(true);
    }

    public ColumnRowPane(boolean bl) {
        this.isShowLabel = bl;
        this.initComponents();
    }

    public void addListener(ChangeListener changeListener) {
        this.columnSpinner.addChangeListener(changeListener);
        this.rowSpinner.addChangeListener(changeListener);
    }

    public void initComponents() {
        this.setLayout(new GridLayout(1, 2));
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 1; i < 1000; ++i) {
            arrayList.add(BaseCoreUtils.convertIntToABC(i));
        }
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (int i = 1; i < 5000; ++i) {
            arrayList2.add("" + i);
        }
        SpinnerListModel spinnerListModel = new SpinnerListModel(arrayList);
        JPanel jPanel = new JPanel();
        this.add(jPanel);
        jPanel.setLayout(new FlowLayout(0, 1, 0));
        JLabel jLabel = new JLabel(Inter.getLocText("Column") + ":");
        if (this.isShowLabel) {
            jPanel.add(jLabel);
        }
        this.columnSpinner = new UpperCaseSpinner(spinnerListModel);
        this.columnSpinner.setPreferredSize(new Dimension(60, 24));
        this.columnSpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                ColumnRowPane.this.firePropertyChange(PropChangeName, null, ColumnRowPane.this.columnSpinner.getValue());
            }
        });
        JFormattedTextField jFormattedTextField = GUICoreUtils.getSpinnerTextField(this.columnSpinner);
        if (jFormattedTextField != null) {
            jFormattedTextField.setColumns(3);
            jFormattedTextField.setHorizontalAlignment(2);
        }
        ((AbstractDocument)jFormattedTextField.getDocument()).setDocumentFilter(new DocumentFilter(){

            public void insertString(DocumentFilter.FilterBypass filterBypass, int n, String string, AttributeSet attributeSet) throws BadLocationException {
                filterBypass.insertString(n, string.toUpperCase(), attributeSet);
            }

            public void replace(DocumentFilter.FilterBypass filterBypass, int n, int n2, String string, AttributeSet attributeSet) throws BadLocationException {
                if (string != null) {
                    string = string.toUpperCase();
                }
                filterBypass.replace(n, n2, string, attributeSet);
            }
        });
        jPanel.add(this.columnSpinner);
        JPanel jPanel2 = new JPanel();
        this.add(jPanel2);
        jPanel2.setLayout(new FlowLayout(0, 1, 0));
        JLabel jLabel2 = new JLabel(Inter.getLocText("Row") + ":");
        if (this.isShowLabel) {
            jPanel2.add(jLabel2);
        }
        this.rowSpinner = new JSpinner(new SpinnerListModel(arrayList2));
        this.rowSpinner.setPreferredSize(new Dimension(60, 24));
        this.rowSpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                ColumnRowPane.this.firePropertyChange(PropChangeName, null, ColumnRowPane.this.rowSpinner.getValue());
            }
        });
        JFormattedTextField jFormattedTextField2 = GUICoreUtils.getSpinnerTextField(this.rowSpinner);
        if (jFormattedTextField2 != null) {
            jFormattedTextField2.setColumns(4);
            jFormattedTextField2.setHorizontalAlignment(2);
        }
        jPanel2.add(this.rowSpinner);
        this.addDocumentListener(this.documentListener);
    }

    public void addDocumentListener(DocumentListener documentListener) {
        ((JSpinner.DefaultEditor)this.columnSpinner.getEditor()).getTextField().getDocument().addDocumentListener(documentListener);
        ((JSpinner.DefaultEditor)this.rowSpinner.getEditor()).getTextField().getDocument().addDocumentListener(documentListener);
    }

    public void newColumnRow() {
        String string = ((JSpinner.DefaultEditor)this.columnSpinner.getEditor()).getTextField().getText();
        String string2 = ((JSpinner.DefaultEditor)this.rowSpinner.getEditor()).getTextField().getText();
        if (string.length() > 0 && string2.length() > 0) {
            ColumnRow columnRow = ColumnRow.valueOf(BaseCoreUtils.convertABCToInt(string) - 1, Integer.valueOf(string2) - 1);
            try {
                this.populate(columnRow);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void populate(ColumnRow columnRow) {
        int n = columnRow.getColumn();
        this.columnSpinner.setValue(BaseCoreUtils.convertIntToABC(n + 1));
        int n2 = columnRow.getRow();
        this.rowSpinner.setValue("" + (n2 + 1));
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        for (int i = 0; i < this.getComponentCount(); ++i) {
            JPanel jPanel = (JPanel)this.getComponent(i);
            for (int j = 0; j < jPanel.getComponentCount(); ++j) {
                JComponent jComponent = (JComponent)jPanel.getComponent(j);
                jComponent.setEnabled(bl);
            }
        }
    }

    public ColumnRow update() {
        return ColumnRow.valueOf(BaseCoreUtils.convertABCToInt((String)this.columnSpinner.getValue()) - 1, Integer.parseInt((String)this.rowSpinner.getValue()) - 1);
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        if (this.changeSupport == null || object != null && object2 != null && object.equals(object2)) {
            return;
        }
        this.changeSupport.firePropertyChange(string, object, object2);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.changeSupport == null) {
            this.changeSupport = new PropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.changeSupport == null) {
            return;
        }
        this.changeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public synchronized PropertyChangeListener[] getPropertyChangeListeners() {
        if (this.changeSupport == null) {
            return new PropertyChangeListener[0];
        }
        return this.changeSupport.getPropertyChangeListeners();
    }

    private class UpperCaseSpinner
    extends JSpinner {
        public UpperCaseSpinner(SpinnerModel spinnerModel) {
            super(spinnerModel);
        }

        protected JComponent createEditor(SpinnerModel spinnerModel) {
            if (spinnerModel instanceof SpinnerDateModel) {
                return new JSpinner.DateEditor(this);
            }
            if (spinnerModel instanceof SpinnerListModel) {
                return new UpperCaseEditor(this);
            }
            if (spinnerModel instanceof SpinnerNumberModel) {
                return new JSpinner.NumberEditor(this);
            }
            return new JSpinner.DefaultEditor(this);
        }

        private class UpperCaseEditor
        extends JSpinner.DefaultEditor {
            public UpperCaseEditor(JSpinner jSpinner) {
                super(jSpinner);
                if (!(jSpinner.getModel() instanceof SpinnerListModel)) {
                    throw new IllegalArgumentException("model not a SpinnerListModel");
                }
                this.getTextField().setEditable(true);
                this.getTextField().setFormatterFactory(new DefaultFormatterFactory(new ListFormatter()));
            }

            public SpinnerListModel getModel() {
                return (SpinnerListModel)this.getSpinner().getModel();
            }

            private class ListFormatter
            extends JFormattedTextField.AbstractFormatter {
                private DocumentFilter filter;

                private ListFormatter() {
                }

                public String valueToString(Object object) throws ParseException {
                    if (object == null) {
                        return "";
                    }
                    return object.toString();
                }

                public Object stringToValue(String string) throws ParseException {
                    return string;
                }

                protected DocumentFilter getDocumentFilter() {
                    if (this.filter == null) {
                        this.filter = new Filter();
                    }
                    return this.filter;
                }

                private class Filter
                extends DocumentFilter {
                    private Filter() {
                    }

                    public void replace(DocumentFilter.FilterBypass filterBypass, int n, int n2, String string, AttributeSet attributeSet) throws BadLocationException {
                        if ((string = string.toUpperCase()) != null && n + n2 == filterBypass.getDocument().getLength()) {
                            String string2;
                            List<?> list = UpperCaseEditor.this.getModel().getList();
                            Object object = null;
                            for (int i = 0; i < list.size(); ++i) {
                                Object obj = list.get(i);
                                String string3 = obj.toString();
                                if (string3 == null || !string3.startsWith(filterBypass.getDocument().getText(0, n) + string)) continue;
                                object = obj;
                                break;
                            }
                            String string4 = string2 = object != null ? object.toString() : null;
                            if (string2 != null) {
                                filterBypass.remove(0, n + n2);
                                filterBypass.insertString(0, string2, null);
                                ListFormatter.this.getFormattedTextField().select(n + string.length(), string2.length());
                                return;
                            }
                        }
                        super.replace(filterBypass, n, n2, string, attributeSet);
                    }

                    public void insertString(DocumentFilter.FilterBypass filterBypass, int n, String string, AttributeSet attributeSet) throws BadLocationException {
                        this.replace(filterBypass, n, 0, string, attributeSet);
                    }
                }
            }
        }
    }
}

