/*
 * Decompiled with CFR 0.152.
 */
package com.fr.dialog.core;

import com.fr.base.DefaultValues;
import com.fr.base.FRContext;
import com.fr.base.FRFont;
import com.fr.base.Inter;
import com.fr.base.core.BaseCoreConstants;
import com.fr.base.core.GraphHelper;
import com.fr.cell.core.JNumberField;
import com.fr.cell.core.layout.LayoutFactory;
import com.fr.dialog.BasicPane;
import com.fr.dialog.core.ColorSelectionPane;
import com.fr.dialog.core.LineComboBox;
import com.fr.util.Utils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class FRFontPane
extends BasicPane {
    private JTextField familyField;
    private JList familyList;
    private JNumberField sizeField;
    private JList sizeList;
    private JTextField styleField;
    private JList styleList;
    private ColorSelectionPane foregroundColorPane;
    private LineComboBox underlineCombo;
    private JCheckBox isStrikethroughCheckBox;
    private JCheckBox isShadowCheckBox;
    private JCheckBox isSuperscriptCheckBox;
    private JCheckBox isSubscriptCheckBox;
    private PreivewArea preview;
    private EventListenerList eventChangeList = new EventListenerList();
    ActionListener actionListener = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            FRFontPane.this.fireStateChanged();
        }
    };
    ChangeListener changeListener = new ChangeListener(){

        public void stateChanged(ChangeEvent changeEvent) {
            FRFontPane.this.fireStateChanged();
        }
    };
    ListSelectionListener listSelectionListener = new ListSelectionListener(){

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            FRFontPane.this.fireStateChanged();
        }
    };
    DocumentListener documentListener = new DocumentListener(){

        public void changedUpdate(DocumentEvent documentEvent) {
            FRFontPane.this.fireStateChanged();
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            FRFontPane.this.fireStateChanged();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            FRFontPane.this.fireStateChanged();
        }
    };
    static /* synthetic */ Class class$javax$swing$event$ChangeListener;

    public FRFontPane() {
        this.initComponents();
    }

    protected void initComponents() {
        this.setLayout(LayoutFactory.createBorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        JPanel jPanel = new JPanel();
        this.add((Component)jPanel, "North");
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        JPanel jPanel2 = new JPanel();
        jPanel.add(jPanel2);
        jPanel2.setLayout(new GridLayout(1, 2, 0, 0));
        this.familyField = new JTextField();
        this.familyField.setEditable(false);
        this.familyList = new JList<String>(Utils.getAvailableFontFamilyNames4Report());
        this.familyList.setVisibleRowCount(4);
        this.familyList.addListSelectionListener(this.listSelectionListener);
        JPanel jPanel3 = new JPanel();
        jPanel2.add(jPanel3);
        jPanel3.setLayout(LayoutFactory.createBorderLayout());
        jPanel3.add((Component)this.createTextFieldListPane("", this.familyField, this.familyList), "Center");
        jPanel3.setBorder(BorderFactory.createTitledBorder(Inter.getLocText("FRFont-Family")));
        JPanel jPanel4 = new JPanel();
        jPanel2.add(jPanel4);
        jPanel4.setLayout(new BoxLayout(jPanel4, 0));
        jPanel4.setBorder(BorderFactory.createTitledBorder(Inter.getLocText("FRFont-Style") + Inter.getLocText("FRFont-Size")));
        String[] stringArray = new String[]{Inter.getLocText("FRFont-plain"), Inter.getLocText("FRFont-bold"), Inter.getLocText("FRFont-italic"), Inter.getLocText("FRFont-bolditalic")};
        this.styleField = new JTextField();
        this.styleField.setEditable(false);
        this.styleList = new JList<String>(stringArray);
        this.styleList.setVisibleRowCount(4);
        this.styleList.addListSelectionListener(this.listSelectionListener);
        JPanel jPanel5 = this.createTextFieldListPane("", this.styleField, this.styleList);
        jPanel4.add(jPanel5);
        jPanel4.add(Box.createHorizontalStrut(6));
        Integer[] integerArray = new Integer[]{new Integer(6), new Integer(8), new Integer(9), new Integer(10), new Integer(11), new Integer(12), new Integer(14), new Integer(16), new Integer(18), new Integer(20), new Integer(22), new Integer(24), new Integer(26), new Integer(28), new Integer(36), new Integer(48), new Integer(72)};
        this.sizeField = new JNumberField();
        this.sizeList = new JList<Integer>(integerArray);
        JPanel jPanel6 = this.createTextFieldListPane("", this.sizeField, this.sizeList);
        this.sizeField.setMaxDecimalLength(0);
        this.sizeField.getDocument().addDocumentListener(this.documentListener);
        this.sizeField.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                FRFontPane.this.updatePreviewLabel();
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                FRFontPane.this.updatePreviewLabel();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                FRFontPane.this.updatePreviewLabel();
            }
        });
        this.sizeList.setVisibleRowCount(4);
        this.sizeList.addListSelectionListener(this.listSelectionListener);
        jPanel4.add(jPanel6);
        this.styleField.setText((String)this.styleList.getSelectedValue());
        JPanel jPanel7 = new JPanel();
        jPanel.add(jPanel7);
        jPanel7.setLayout(new GridLayout(1, 2, 0, 0));
        JPanel jPanel8 = new JPanel();
        jPanel7.add(jPanel8);
        jPanel8.setBorder(BorderFactory.createTitledBorder(Inter.getLocText("FRFont-Underline")));
        jPanel8.setLayout(LayoutFactory.createBorderLayout());
        this.underlineCombo = new LineComboBox(BaseCoreConstants.UnderlineStyleArray);
        this.underlineCombo.addActionListener(this.actionListener);
        jPanel8.add((Component)this.underlineCombo, "Center");
        JPanel jPanel9 = new JPanel();
        jPanel7.add(jPanel9);
        jPanel9.setLayout(LayoutFactory.createBorderLayout());
        jPanel9.setBorder(BorderFactory.createTitledBorder(Inter.getLocText("FRFont-Foreground")));
        this.foregroundColorPane = new ColorSelectionPane(120);
        this.foregroundColorPane.addColorChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                FRFontPane.this.fireStateChanged();
            }
        });
        jPanel9.add((Component)this.foregroundColorPane, "Center");
        JPanel jPanel10 = new JPanel();
        this.add((Component)jPanel10, "Center");
        jPanel10.setLayout(new BorderLayout(4, 4));
        JPanel jPanel11 = new JPanel();
        jPanel10.add((Component)jPanel11, "West");
        jPanel11.setLayout(LayoutFactory.createBorderLayout());
        JPanel jPanel12 = new JPanel();
        jPanel11.add((Component)jPanel12, "Center");
        jPanel12.setLayout(LayoutFactory.createBorderLayout());
        jPanel12.setBorder(BorderFactory.createTitledBorder(Inter.getLocText("FRFont-Effects")));
        JPanel jPanel13 = new JPanel();
        jPanel12.add((Component)jPanel13, "North");
        jPanel13.setLayout(new GridLayout(4, 1));
        this.isStrikethroughCheckBox = new JCheckBox(Inter.getLocText("FRFont-Strikethrough") + "  ");
        this.isStrikethroughCheckBox.addChangeListener(this.changeListener);
        this.isStrikethroughCheckBox.setMnemonic('K');
        this.isShadowCheckBox = new JCheckBox(Inter.getLocText("FRFont-Shadow"));
        this.isShadowCheckBox.addChangeListener(this.changeListener);
        this.isShadowCheckBox.setMnemonic('S');
        this.isSuperscriptCheckBox = new JCheckBox(Inter.getLocText("FRFont-Superscript"));
        this.isSuperscriptCheckBox.addChangeListener(this.changeListener);
        this.isSuperscriptCheckBox.setMnemonic('E');
        this.isSubscriptCheckBox = new JCheckBox(Inter.getLocText("FRFont-Subscript"));
        this.isSubscriptCheckBox.addChangeListener(this.changeListener);
        this.isSubscriptCheckBox.setMnemonic('B');
        jPanel13.add(this.getLeftJustPane(this.isStrikethroughCheckBox));
        jPanel13.add(this.getLeftJustPane(this.isShadowCheckBox));
        jPanel13.add(this.getLeftJustPane(this.isSuperscriptCheckBox));
        jPanel13.add(this.getLeftJustPane(this.isSubscriptCheckBox));
        JPanel jPanel14 = new JPanel();
        jPanel10.add((Component)jPanel14, "Center");
        jPanel14.setLayout(LayoutFactory.createBorderLayout());
        this.preview = new PreivewArea();
        this.preview.setBorder(BorderFactory.createTitledBorder(Inter.getLocText("Preview")));
        jPanel14.add((Component)this.preview, "Center");
        this.isSuperscriptCheckBox.addChangeListener(this.changeListener);
        this.isSuperscriptCheckBox.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (FRFontPane.this.isSuperscriptCheckBox.isSelected()) {
                    FRFontPane.this.isSubscriptCheckBox.setSelected(false);
                }
            }
        });
        this.isSubscriptCheckBox.addChangeListener(this.changeListener);
        this.isSubscriptCheckBox.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (FRFontPane.this.isSubscriptCheckBox.isSelected()) {
                    FRFontPane.this.isSuperscriptCheckBox.setSelected(false);
                }
            }
        });
        DefaultValues defaultValues = FRContext.getDefaultValues();
        this.populate(defaultValues.getFRFont());
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.eventChangeList.add(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = FRFontPane.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, changeListener);
    }

    public void fireStateChanged() {
        Object[] objectArray = this.eventChangeList.getListenerList();
        ChangeEvent changeEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$javax$swing$event$ChangeListener == null ? FRFontPane.class$("javax.swing.event.ChangeListener") : class$javax$swing$event$ChangeListener)) continue;
            if (changeEvent == null) {
                changeEvent = new ChangeEvent(this);
            }
            ((ChangeListener)objectArray[i + 1]).stateChanged(changeEvent);
        }
    }

    private JPanel getLeftJustPane(JComponent jComponent) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(LayoutFactory.createBorderLayout());
        jPanel.add((Component)jComponent, "Center");
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 0));
        return jPanel;
    }

    public void populate(FRFont fRFont) {
        this.familyList.setSelectedValue(fRFont.getName(), true);
        this.familyField.setText(fRFont.getName());
        this.styleList.setSelectedIndex(fRFont.getStyle());
        this.sizeList.setSelectedValue(new Integer(fRFont.getSize()), true);
        this.sizeField.setValue(fRFont.getSize());
        this.foregroundColorPane.setColor(fRFont.getForeground());
        this.underlineCombo.setSelectedLineStyle(fRFont.getUnderline());
        this.isStrikethroughCheckBox.setSelected(fRFont.isStrikethrough());
        this.isShadowCheckBox.setSelected(fRFont.isShadow());
        this.isSuperscriptCheckBox.setSelected(fRFont.isSuperscript());
        this.isSubscriptCheckBox.setSelected(fRFont.isSubscript());
        ListHandler listHandler = new ListHandler();
        this.familyList.addListSelectionListener(listHandler);
        this.styleList.addListSelectionListener(listHandler);
        this.sizeList.addListSelectionListener(listHandler);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FRFontPane.this.updatePreviewLabel();
            }
        };
        this.isStrikethroughCheckBox.addActionListener(actionListener);
        this.isShadowCheckBox.addActionListener(actionListener);
        this.isSuperscriptCheckBox.addActionListener(actionListener);
        this.isSubscriptCheckBox.addActionListener(actionListener);
        this.underlineCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                FRFontPane.this.updatePreviewLabel();
            }
        });
        this.foregroundColorPane.addColorChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                FRFontPane.this.updatePreviewLabel();
            }
        });
        this.updatePreviewLabel();
    }

    public FRFont update() {
        return FRFont.getInstance(this.familyField.getText(), this.styleList.getSelectedIndex(), (int)this.sizeField.getValue(), this.foregroundColorPane.getColor(), this.underlineCombo.getSelectedLineStyle(), this.isStrikethroughCheckBox.isSelected(), this.isShadowCheckBox.isSelected(), this.isSuperscriptCheckBox.isSelected(), this.isSubscriptCheckBox.isSelected());
    }

    private JPanel createTextFieldListPane(String string, JTextField jTextField, JList jList) {
        GridBagLayout gridBagLayout = new GridBagLayout();
        JPanel jPanel = new JPanel(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        JLabel jLabel = new JLabel(string);
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        gridBagConstraints.gridy = 1;
        Component component = Box.createVerticalStrut(0);
        gridBagLayout.setConstraints(component, gridBagConstraints);
        jPanel.add(component);
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(jTextField, gridBagConstraints);
        jPanel.add(jTextField);
        gridBagConstraints.gridy = 3;
        component = Box.createVerticalStrut(2);
        gridBagLayout.setConstraints(component, gridBagConstraints);
        jPanel.add(component);
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.weighty = 1.0;
        JScrollPane jScrollPane = new JScrollPane(jList);
        gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
        jPanel.add(jScrollPane);
        return jPanel;
    }

    private void updatePreviewLabel() {
        this.preview.setPaintFont(this.update());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class PreivewArea
    extends JComponent {
        private String paintText = "Report";
        private FRFont paintFont = FRContext.getDefaultValues().getFRFont();

        public void setPaintFont(FRFont fRFont) {
            this.paintFont = fRFont;
            this.repaint();
        }

        public void paintComponent(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Dimension dimension = this.getSize();
            graphics2D.setColor(this.getBackground());
            GraphHelper.fillRect(graphics2D, 0.0, 0.0, dimension.width, dimension.height);
            if (this.paintFont == null) {
                return;
            }
            FontMetrics fontMetrics = this.getFontMetrics(this.paintFont);
            graphics2D.setColor(this.paintFont.getForeground());
            graphics2D.setFont(this.paintFont);
            int n = (dimension.width - fontMetrics.stringWidth(this.paintText)) / 2;
            int n2 = (dimension.width + fontMetrics.stringWidth(this.paintText)) / 2;
            int n3 = (dimension.height - fontMetrics.getHeight()) / 2 + fontMetrics.getAscent();
            GraphHelper.drawLine(graphics2D, 4.0, n3, n - 8, n3, 1);
            GraphHelper.drawString(graphics2D, this.paintText, n, n3);
            GraphHelper.drawLine(graphics2D, n2 + 8, n3, dimension.width - 4, n3, 1);
        }
    }

    class ListHandler
    implements ListSelectionListener {
        ListHandler() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            String string;
            Object object = listSelectionEvent.getSource();
            if (object == FRFontPane.this.familyList) {
                String string2 = (String)FRFontPane.this.familyList.getSelectedValue();
                if (string2 != null) {
                    FRFontPane.this.familyField.setText(string2);
                }
            } else if (object == FRFontPane.this.sizeList) {
                Integer n = (Integer)FRFontPane.this.sizeList.getSelectedValue();
                if (n != null) {
                    FRFontPane.this.sizeField.setValue(n.intValue());
                }
            } else if (object == FRFontPane.this.styleList && (string = (String)FRFontPane.this.styleList.getSelectedValue()) != null) {
                FRFontPane.this.styleField.setText(string);
            }
            FRFontPane.this.updatePreviewLabel();
        }
    }
}

