/*
 * Decompiled with CFR 0.152.
 */
package com.fr.dialog.core;

import com.fr.base.FRContext;
import com.fr.base.FRFont;
import com.fr.base.core.GraphHelper;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JTextArea;

public class FRFontPreviewArea
extends JTextArea {
    private String paintText = "Report";
    private FRFont frFont = null;

    public FRFontPreviewArea() {
        this.frFont = FRContext.getDefaultValues().getFRFont();
    }

    public FRFontPreviewArea(FRFont fRFont) {
        this.setFontObject(fRFont);
        this.repaint();
    }

    public void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Dimension dimension = this.getSize();
        graphics2D.setColor(this.getBackground());
        GraphHelper.fillRect(graphics2D, 0.0, 0.0, dimension.width, dimension.height);
        if (this.frFont == null) {
            return;
        }
        FontMetrics fontMetrics = this.getFontMetrics(this.frFont);
        graphics2D.setColor(this.frFont.getForeground());
        graphics2D.setFont(this.frFont);
        int n = (dimension.width - fontMetrics.stringWidth(this.paintText)) / 2;
        int n2 = (dimension.width + fontMetrics.stringWidth(this.paintText)) / 2;
        int n3 = (dimension.height - fontMetrics.getHeight()) / 2 + fontMetrics.getAscent();
        GraphHelper.drawLine(graphics2D, 4.0, n3, n - 8, n3, 1);
        GraphHelper.drawString(graphics2D, this.paintText, n, n3);
        GraphHelper.drawLine(graphics2D, n2 + 8, n3, dimension.width - 4, n3, 1);
    }

    public FRFont getFontObject() {
        return this.frFont;
    }

    public void setFontObject(FRFont fRFont) {
        this.frFont = fRFont;
        this.repaint();
    }
}

