/*
 * Decompiled with CFR 0.152.
 */
package com.fr.dialog.core;

import com.fr.base.FRContext;
import com.fr.base.Inter;
import com.fr.cell.core.GUICoreUtils;
import com.fr.cell.core.layout.LayoutFactory;
import com.fr.report.cellElement.TextFormat;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class FormatPane
extends JPanel {
    private Format format;
    ActionListener radioActionListener = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            FormatPane.this.patternTextField.setEnabled(true);
            FormatPane.this.patternTextField.setEditable(true);
            FormatPane.this.patternList.setEnabled(true);
            String[] stringArray = None_Array;
            if (object.equals(FormatPane.this.nullRadioButton)) {
                FormatPane.this.patternTextField.setEnabled(false);
                FormatPane.this.patternTextField.setEditable(false);
                FormatPane.this.patternTextField.setText("");
                FormatPane.this.patternList.setEnabled(false);
                stringArray = None_Array;
            } else if (object.equals(FormatPane.this.numberRadioButton)) {
                stringArray = Number_Array;
            } else if (object.equals(FormatPane.this.currencyRadioButton)) {
                stringArray = Currency_Array;
            } else if (object.equals(FormatPane.this.percentRadioButton)) {
                stringArray = Percent_Array;
            } else if (object.equals(FormatPane.this.scientificRadioButton)) {
                stringArray = Scientfic_Array;
            } else if (object.equals(FormatPane.this.dateRadioButton)) {
                stringArray = Date_Array;
            } else if (object.equals(FormatPane.this.timeRadioButton)) {
                stringArray = Time_Array;
            } else if (object.equals(FormatPane.this.textRadioButton)) {
                FormatPane.this.patternTextField.setEnabled(false);
                FormatPane.this.patternTextField.setEditable(false);
                FormatPane.this.patternTextField.setText("");
                FormatPane.this.patternList.setEnabled(false);
                stringArray = Text_Array;
            }
            DefaultListModel defaultListModel = (DefaultListModel)FormatPane.this.patternList.getModel();
            defaultListModel.removeAllElements();
            for (int i = 0; i < stringArray.length; ++i) {
                defaultListModel.addElement(stringArray[i]);
            }
            String string = FormatPane.this.patternTextField.getText();
            if ((string == null || string.length() <= 0) && defaultListModel.size() > 0) {
                String string2 = null;
                if (FormatPane.this.format instanceof DecimalFormat) {
                    string2 = ((DecimalFormat)FormatPane.this.format).toPattern();
                } else if (FormatPane.this.format instanceof SimpleDateFormat) {
                    string2 = ((SimpleDateFormat)FormatPane.this.format).toPattern();
                } else if (FormatPane.this.format instanceof TextFormat) {
                    // empty if block
                }
                if (string2 != null) {
                    FormatPane.this.patternList.setSelectedValue(string2, true);
                } else {
                    FormatPane.this.patternList.setSelectedIndex(0);
                }
            }
        }
    };
    DocumentListener patternTextDocumentListener = new DocumentListener(){

        public void insertUpdate(DocumentEvent documentEvent) {
            FormatPane.this.refreshPreviewLabel();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            FormatPane.this.refreshPreviewLabel();
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            FormatPane.this.refreshPreviewLabel();
        }
    };
    ListSelectionListener patternListSelectionListener = new ListSelectionListener(){

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            FormatPane.this.patternTextField.setText((String)FormatPane.this.patternList.getSelectedValue());
        }
    };
    private JLabel sampleLabel;
    private JRadioButton nullRadioButton;
    private JRadioButton numberRadioButton;
    private JRadioButton currencyRadioButton;
    private JRadioButton percentRadioButton;
    private JRadioButton scientificRadioButton;
    private JRadioButton dateRadioButton;
    private JRadioButton timeRadioButton;
    private JRadioButton textRadioButton;
    private JTextField patternTextField = null;
    private JList patternList = null;
    static double DoubleValue = 12345.6789;
    static String[] None_Array = new String[0];
    static String[] Number_Array = new String[]{"0", "0.00", "#0.0#", "#,##0", "#,##0.00"};
    static String[] Currency_Array = new String[]{"\u00a40", "\u00a40.00", "\u00a4#,##0", "\u00a4#,##0.0", "\u00a4#,##0.00", "\u00a4#,##0;\u00a4-#,##0", "\u00a4#,##0.00;\u00a4-#,##0.00", "\u00a4#,##0.00;(\u00a4#,##0.00)", "$#,##0;($#,##0)", "$#,##0.00;($#,##0.00)", "#,##0;-#,##0", "#,##0;[Red]-#,##0", "#,##0.00;-#,##0.00"};
    static String[] Percent_Array = new String[]{"0%", "0.0%", "0.00%", "0.000%", "0.0000%"};
    static String[] Scientfic_Array = new String[]{"0.00E00", "##0.0E0"};
    static String[] Date_Array = new String[]{"MM/dd/yyyy", "yyyy-MM-dd", "EEEEE, MMMMM dd, yyyy", "MMMM d, yyyy", "MM/d/yy", "d-MMM-yy", "MM.d.yyyy", "MMM. d, yyyy", "d MMMMM yyyy", "MMMMM yy", "MM-yy", "yyyy-M-d", "d-MMM", "M-d-yy"};
    static String[] Time_Array = new String[]{"h:mm", "H:mm", "h:mm:ss", "H:mm:ss", "hh:mm", "HH:mm", "mm:ss", "mm:ss.0", "[h]:mm:ss", "[H]:mm:ss", "yyyy-M-d h:mm", "yyyy-M-d H:mm", "MM/dd/yyyy hh:mm:ss", "MM/dd/yyyy HH:mm:ss", "MM/dd/yyyy hh:mm:ss a", "MM/dd/yyyy HH:mm:ss a", "MM/dd/yyyy h:mm a", "MM/dd/yyyy H:mm a", "h:mm:ss a", "HH:mm:ss a", "h:mm:ss a, z", "HH:mm:ss a, z"};
    static String[] Text_Array = new String[0];

    public FormatPane() {
        this.initComponents();
    }

    protected void initComponents() {
        this.setLayout(new BorderLayout(4, 0));
        this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        JPanel jPanel = new JPanel();
        this.add((Component)jPanel, "North");
        jPanel.setBorder(GUICoreUtils.createTitledBorder(Inter.getLocText("StyleFormat-Sample"), null));
        jPanel.setLayout(LayoutFactory.createBorderLayout());
        this.sampleLabel = new JLabel("" + DoubleValue);
        jPanel.add((Component)this.sampleLabel, "Center");
        this.sampleLabel.setBorder(BorderFactory.createEmptyBorder(2, 4, 4, 4));
        this.sampleLabel.setHorizontalAlignment(0);
        this.sampleLabel.setFont(FRContext.getDefaultValues().getFRFont());
        JPanel jPanel2 = new JPanel();
        this.add((Component)jPanel2, "West");
        jPanel2.setBorder(GUICoreUtils.createTitledBorder(Inter.getLocText("StyleFormat-Category"), null));
        jPanel2.setLayout(new GridLayout(8, 1, 4, 4));
        this.nullRadioButton = new JRadioButton(Inter.getLocText("StyleFormat-None"));
        this.nullRadioButton.setMnemonic('o');
        this.numberRadioButton = new JRadioButton(Inter.getLocText("Number"));
        this.numberRadioButton.setMnemonic('N');
        this.currencyRadioButton = new JRadioButton(Inter.getLocText("StyleFormat-Currency"));
        this.currencyRadioButton.setMnemonic('C');
        this.percentRadioButton = new JRadioButton(Inter.getLocText("StyleFormat-Percent"));
        this.percentRadioButton.setMnemonic('P');
        this.scientificRadioButton = new JRadioButton(Inter.getLocText("StyleFormat-Scientific"));
        this.scientificRadioButton.setMnemonic('S');
        this.dateRadioButton = new JRadioButton(Inter.getLocText("StyleFormat-Date"));
        this.dateRadioButton.setMnemonic('D');
        this.timeRadioButton = new JRadioButton(Inter.getLocText("StyleFormat-Time"));
        this.timeRadioButton.setMnemonic('I');
        this.textRadioButton = new JRadioButton(Inter.getLocText("StyleFormat-Text"));
        this.textRadioButton.setMnemonic('T');
        this.nullRadioButton.addActionListener(this.radioActionListener);
        this.numberRadioButton.addActionListener(this.radioActionListener);
        this.currencyRadioButton.addActionListener(this.radioActionListener);
        this.percentRadioButton.addActionListener(this.radioActionListener);
        this.scientificRadioButton.addActionListener(this.radioActionListener);
        this.dateRadioButton.addActionListener(this.radioActionListener);
        this.timeRadioButton.addActionListener(this.radioActionListener);
        this.textRadioButton.addActionListener(this.radioActionListener);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.nullRadioButton);
        buttonGroup.add(this.numberRadioButton);
        buttonGroup.add(this.currencyRadioButton);
        buttonGroup.add(this.percentRadioButton);
        buttonGroup.add(this.scientificRadioButton);
        buttonGroup.add(this.dateRadioButton);
        buttonGroup.add(this.timeRadioButton);
        buttonGroup.add(this.textRadioButton);
        jPanel2.add(this.createRadioCenterPane(this.nullRadioButton));
        jPanel2.add(this.createRadioCenterPane(this.numberRadioButton));
        jPanel2.add(this.createRadioCenterPane(this.currencyRadioButton));
        jPanel2.add(this.createRadioCenterPane(this.percentRadioButton));
        jPanel2.add(this.createRadioCenterPane(this.scientificRadioButton));
        jPanel2.add(this.createRadioCenterPane(this.dateRadioButton));
        jPanel2.add(this.createRadioCenterPane(this.timeRadioButton));
        jPanel2.add(this.createRadioCenterPane(this.textRadioButton));
        JPanel jPanel3 = new JPanel();
        this.add((Component)jPanel3, "Center");
        jPanel3.setBorder(BorderFactory.createEmptyBorder(4, 0, 2, 0));
        jPanel3.setLayout(new BorderLayout(0, 3));
        this.patternTextField = new JTextField();
        jPanel3.add((Component)this.patternTextField, "North");
        this.patternTextField.getDocument().addDocumentListener(this.patternTextDocumentListener);
        this.patternList = new JList(new DefaultListModel());
        jPanel3.add((Component)new JScrollPane(this.patternList), "Center");
        this.patternList.addListSelectionListener(this.patternListSelectionListener);
        this.nullRadioButton.setSelected(true);
        this.applyRadioActionListener(this.nullRadioButton);
    }

    private JPanel createRadioCenterPane(JRadioButton jRadioButton) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0, 0, 0));
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 0));
        jPanel.add(jRadioButton);
        return jPanel;
    }

    public void populate(Format format) {
        this.format = format;
        if (format == null) {
            this.nullRadioButton.setSelected(true);
            this.applyRadioActionListener(this.nullRadioButton);
        } else if (format instanceof DecimalFormat) {
            String string = ((DecimalFormat)format).toPattern();
            if (string.startsWith("\u00a4") || string.startsWith("$")) {
                this.currencyRadioButton.setSelected(true);
                this.applyRadioActionListener(this.currencyRadioButton);
            } else if (string.endsWith("%")) {
                this.percentRadioButton.setSelected(true);
                this.applyRadioActionListener(this.percentRadioButton);
            } else if (string.indexOf("E") > 0) {
                this.scientificRadioButton.setSelected(true);
                this.applyRadioActionListener(this.scientificRadioButton);
            } else {
                this.numberRadioButton.setSelected(true);
                this.applyRadioActionListener(this.numberRadioButton);
            }
            this.patternTextField.setText(string);
        } else if (format instanceof SimpleDateFormat) {
            String string = ((SimpleDateFormat)format).toPattern();
            int n = this.isArrayContainPattern(Date_Array, string);
            if (n != -1) {
                this.dateRadioButton.setSelected(true);
                this.applyRadioActionListener(this.dateRadioButton);
            } else {
                n = this.isArrayContainPattern(Time_Array, string);
                if (n != -1) {
                    this.timeRadioButton.setSelected(true);
                    this.applyRadioActionListener(this.timeRadioButton);
                }
            }
            if (n != -1) {
                this.patternList.setSelectedIndex(n);
            } else {
                this.dateRadioButton.setSelected(true);
                this.applyRadioActionListener(this.dateRadioButton);
                this.patternTextField.setText(string);
            }
        } else if (format instanceof TextFormat) {
            this.textRadioButton.setSelected(true);
            this.applyRadioActionListener(this.textRadioButton);
        }
    }

    public void onlyUseDatePane() {
        this.numberRadioButton.setEnabled(false);
        this.currencyRadioButton.setEnabled(false);
        this.scientificRadioButton.setEnabled(false);
        this.textRadioButton.setEnabled(false);
        this.percentRadioButton.setEnabled(false);
        this.nullRadioButton.setEnabled(true);
        this.dateRadioButton.setEnabled(true);
        this.timeRadioButton.setEnabled(true);
    }

    public void percentFormatPane() {
        this.nullRadioButton.setEnabled(false);
        this.numberRadioButton.setEnabled(false);
        this.currencyRadioButton.setEnabled(false);
        this.percentRadioButton.addActionListener(this.radioActionListener);
        this.scientificRadioButton.setEnabled(false);
        this.dateRadioButton.setEnabled(false);
        this.timeRadioButton.setEnabled(false);
        this.textRadioButton.setEnabled(false);
        this.percentRadioButton.setSelected(true);
        this.applyRadioActionListener(this.percentRadioButton);
    }

    private int isArrayContainPattern(String[] stringArray, String string) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string)) continue;
            return i;
        }
        return -1;
    }

    public Format update() {
        if (this.nullRadioButton.isSelected()) {
            return null;
        }
        if (this.numberRadioButton.isSelected() || this.currencyRadioButton.isSelected() || this.percentRadioButton.isSelected() || this.scientificRadioButton.isSelected()) {
            String string = this.patternTextField.getText();
            if (string != null && string.length() > 0) {
                try {
                    DecimalFormat decimalFormat = new DecimalFormat(string);
                    this.sampleLabel.setText(decimalFormat.format(DoubleValue));
                    return decimalFormat;
                }
                catch (Exception exception) {
                    return new DecimalFormat("");
                }
            }
            return new DecimalFormat("");
        }
        if (this.dateRadioButton.isSelected() || this.timeRadioButton.isSelected()) {
            String string = this.patternTextField.getText();
            if (string != null && string.length() > 0) {
                try {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat(this.patternTextField.getText());
                    this.sampleLabel.setText(simpleDateFormat.format(new Date()));
                    return simpleDateFormat;
                }
                catch (Exception exception) {
                    return new SimpleDateFormat("");
                }
            }
            return new SimpleDateFormat("");
        }
        if (this.textRadioButton.isSelected()) {
            return TextFormat.getInstance();
        }
        return null;
    }

    private void refreshPreviewLabel() {
        this.sampleLabel.setText("" + DoubleValue);
        this.sampleLabel.setForeground(UIManager.getColor("Label.foreground"));
        if (!this.nullRadioButton.isSelected()) {
            if (this.numberRadioButton.isSelected() || this.currencyRadioButton.isSelected() || this.percentRadioButton.isSelected() || this.scientificRadioButton.isSelected()) {
                String string = this.patternTextField.getText();
                if (string != null && string.length() > 0) {
                    try {
                        DecimalFormat decimalFormat = new DecimalFormat(string);
                        this.sampleLabel.setText(decimalFormat.format(DoubleValue));
                    }
                    catch (Exception exception) {
                        this.sampleLabel.setForeground(Color.red);
                        this.sampleLabel.setText(exception.getMessage());
                    }
                }
            } else if (this.dateRadioButton.isSelected() || this.timeRadioButton.isSelected()) {
                String string = this.patternTextField.getText();
                if (string != null && string.length() > 0) {
                    try {
                        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(this.patternTextField.getText());
                        this.sampleLabel.setText(simpleDateFormat.format(new Date()));
                    }
                    catch (Exception exception) {
                        this.sampleLabel.setForeground(Color.red);
                        this.sampleLabel.setText(exception.getMessage());
                    }
                } else {
                    this.sampleLabel.setText(new Date().toString());
                }
            } else if (this.textRadioButton.isSelected()) {
                // empty if block
            }
        }
    }

    private void applyRadioActionListener(JRadioButton jRadioButton) {
        ActionEvent actionEvent = new ActionEvent(jRadioButton, 100, "");
        this.radioActionListener.actionPerformed(actionEvent);
    }

    public JLabel getSampleLabel() {
        return this.sampleLabel;
    }

    public void setSampleLabel(JLabel jLabel) {
        this.sampleLabel = jLabel;
    }
}

