/*
 * Decompiled with CFR 0.152.
 */
package com.fr.dialog.core;

import com.fr.base.Inter;
import com.fr.base.background.Background;
import com.fr.base.background.GradientBackground;
import com.fr.cell.core.GUICoreUtils;
import com.fr.cell.core.JNumberField;
import com.fr.dialog.BasicPane;
import com.fr.dialog.core.ColorSelectionPane;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class GradientPane
extends BasicPane {
    private static final long serialVersionUID = -6854603990673031897L;
    private JRadioButton left2right;
    private JRadioButton top2bottom;
    private JComboBox areaCombox;
    private JCheckBox cyclic;
    private JNumberField begin;
    private JNumberField finish;
    private JPanel sizePane;
    private ChangeListener changeListener = null;
    private CardLayout card;
    private ColorSelectionPane startColorPane;
    private ColorSelectionPane lastColorPane;
    DocumentListener docListener = new DocumentListener(){

        public void changedUpdate(DocumentEvent documentEvent) {
            GradientPane.this.fireChagneListener();
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            GradientPane.this.fireChagneListener();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            GradientPane.this.fireChagneListener();
        }
    };
    ActionListener reviewListener = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            GradientPane.this.fireChagneListener();
        }
    };
    private ItemListener areaListener = new ItemListener(){

        public void itemStateChanged(ItemEvent itemEvent) {
            GradientPane.this.fireChagneListener();
            if (GradientPane.this.areaCombox.getSelectedIndex() == 0) {
                GradientPane.this.card.show(GradientPane.this.sizePane, "cell");
            } else {
                GradientPane.this.card.show(GradientPane.this.sizePane, "customize");
            }
        }
    };

    public GradientPane() {
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new BorderLayout());
        this.add((Component)jPanel, "North");
        JPanel jPanel2 = new JPanel();
        jPanel.add((Component)jPanel2, "North");
        jPanel2.setLayout(new GridLayout(0, 2, 2, 2));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(13, 13, 12, 12));
        JPanel jPanel3 = new JPanel(new FlowLayout(0, 4, 0));
        jPanel2.add(jPanel3);
        jPanel3.add(new JLabel(Inter.getLocText("Start") + Inter.getLocText("Position") + Inter.getLocText("Color") + ":"));
        JPanel jPanel4 = new JPanel();
        jPanel3.add(jPanel4);
        jPanel4.setLayout(new FlowLayout(0, 4, 0));
        this.startColorPane = new ColorSelectionPane(80);
        jPanel4.add(this.startColorPane);
        this.startColorPane.setColor(Color.lightGray);
        JPanel jPanel5 = new JPanel(new FlowLayout(0, 4, 0));
        jPanel2.add(jPanel5);
        jPanel5.add(new JLabel(Inter.getLocText("After") + Inter.getLocText("Position") + Inter.getLocText("Color") + ":"));
        JPanel jPanel6 = new JPanel();
        jPanel5.add(jPanel6);
        jPanel6.setLayout(new FlowLayout(0, 4, 0));
        this.lastColorPane = new ColorSelectionPane(80);
        jPanel6.add(this.lastColorPane);
        this.lastColorPane.setColor(Color.black);
        JPanel jPanel7 = new JPanel();
        jPanel.add((Component)jPanel7, "Center");
        jPanel7.setLayout(new FlowLayout(0, 4, 4));
        jPanel7.add(new JLabel(Inter.getLocText("Gradient") + Inter.getLocText("PageSetup-Orientation") + ":"));
        jPanel7.setBorder(BorderFactory.createEmptyBorder(13, 13, 12, 12));
        this.left2right = new JRadioButton(Inter.getLocText("PageSetup-Landscape"));
        jPanel7.add(this.left2right);
        this.left2right.addActionListener(this.reviewListener);
        this.top2bottom = new JRadioButton(Inter.getLocText("PageSetup-Portrait"));
        jPanel7.add(this.top2bottom);
        this.top2bottom.addActionListener(this.reviewListener);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.left2right);
        buttonGroup.add(this.top2bottom);
        JPanel jPanel8 = new JPanel(new BorderLayout());
        this.add((Component)jPanel8, "Center");
        JPanel jPanel9 = new JPanel(new FlowLayout(0, 4, 4));
        jPanel8.add((Component)jPanel9, "North");
        this.areaCombox = new JComboBox<String>(new String[]{Inter.getLocText("Current") + Inter.getLocText("Choose") + Inter.getLocText("Filed"), Inter.getLocText("Custom") + Inter.getLocText("Filed")});
        jPanel9.add(new JLabel(Inter.getLocText("Gradient") + Inter.getLocText("Filed") + Inter.getLocText("Set") + ":"));
        jPanel9.add(this.areaCombox);
        this.sizePane = new JPanel();
        this.card = new CardLayout();
        this.sizePane.setLayout(this.card);
        JPanel jPanel10 = new JPanel(new BorderLayout());
        jPanel10.setBorder(GUICoreUtils.createTitledBorder(Inter.getLocText("Filed") + Inter.getLocText("Set") + "(" + Inter.getLocText("Unit") + ":" + Inter.getLocText("px") + ")", null));
        this.begin = new JNumberField(4);
        this.begin.getDocument().addDocumentListener(this.docListener);
        this.finish = new JNumberField(4);
        this.finish.getDocument().addDocumentListener(this.docListener);
        JPanel jPanel11 = new JPanel(new FlowLayout(0, 4, 4));
        jPanel11.add(new JLabel(Inter.getLocText("Start") + Inter.getLocText("Position") + ":"));
        jPanel11.add(this.begin);
        JPanel jPanel12 = new JPanel(new FlowLayout(0, 4, 4));
        jPanel12.add(new JLabel(Inter.getLocText("After") + Inter.getLocText("Position") + ":"));
        jPanel12.add(this.finish);
        JPanel jPanel13 = new JPanel(new FlowLayout(0));
        this.cyclic = new JCheckBox(Inter.getLocText("Repeat") + Inter.getLocText("Show"));
        jPanel13.add(this.cyclic);
        this.cyclic.addActionListener(this.reviewListener);
        jPanel12.add(jPanel13);
        jPanel10.add((Component)jPanel11, "North");
        jPanel10.add((Component)jPanel12, "Center");
        JLabel jLabel = new JLabel(Inter.getLocText("According_Cell_Set_Size"));
        JPanel jPanel14 = new JPanel(new FlowLayout(0));
        jPanel14.setBorder(GUICoreUtils.createTitledBorder(Inter.getLocText("Cell") + Inter.getLocText("Field"), null));
        jPanel14.add(jLabel);
        this.sizePane.add((Component)jPanel14, "cell");
        this.sizePane.add((Component)jPanel10, "customize");
        jPanel8.add((Component)this.sizePane, "Center");
        this.areaCombox.addItemListener(this.areaListener);
        this.defaultSetting();
    }

    private void defaultSetting() {
        this.left2right.setSelected(true);
        this.areaCombox.setSelectedIndex(0);
        this.begin.setValue(0.0);
        this.finish.setValue(0.0);
        this.card.show(this.sizePane, "cell");
    }

    public void populate(Background background) {
        if (!(background instanceof GradientBackground)) {
            return;
        }
        GradientBackground gradientBackground = (GradientBackground)background;
        this.startColorPane.setColor(gradientBackground.getColor1());
        this.lastColorPane.setColor(gradientBackground.getColor2());
        if (gradientBackground.getDirection() == GradientBackground.LEFT2RIGHT) {
            this.left2right.setSelected(true);
        } else {
            this.top2bottom.setSelected(true);
        }
        if (gradientBackground.isUseCell()) {
            this.areaCombox.setSelectedIndex(0);
            return;
        }
        this.areaCombox.setSelectedIndex(1);
        this.begin.setValue(gradientBackground.getBeginPlace());
        this.finish.setValue(gradientBackground.getFinishPlace());
        this.cyclic.setSelected(gradientBackground.isCyclic());
    }

    public GradientBackground update() {
        GradientBackground gradientBackground = new GradientBackground();
        gradientBackground.setColor1(this.startColorPane.getColor());
        gradientBackground.setColor2(this.lastColorPane.getColor());
        if (this.left2right.isSelected()) {
            gradientBackground.setDirection(GradientBackground.LEFT2RIGHT);
        } else {
            gradientBackground.setDirection(GradientBackground.TOP2BOTTOM);
        }
        if (this.areaCombox.getSelectedIndex() == 0) {
            gradientBackground.setUseCell(true);
            return gradientBackground;
        }
        gradientBackground.setUseCell(false);
        gradientBackground.setBeginPlace((float)this.begin.getValue());
        gradientBackground.setFinishPlace((float)this.finish.getValue());
        gradientBackground.setCyclic(this.cyclic.isSelected());
        return gradientBackground;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeListener = changeListener;
    }

    public void fireChagneListener() {
        if (this.startColorPane.getColor() == null || this.lastColorPane.getColor() == null) {
            return;
        }
        if (this.changeListener != null) {
            ChangeEvent changeEvent = new ChangeEvent(this);
            this.changeListener.stateChanged(changeEvent);
        }
    }
}

