/*
 * Decompiled with CFR 0.152.
 */
package com.fr.dialog.core;

import com.fr.base.BaseUtils;
import com.fr.base.Inter;
import com.fr.dialog.core.ChooseFileView;
import com.fr.dialog.core.ImagePreviewPane;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JFileChooser;
import javax.swing.JScrollPane;
import javax.swing.filechooser.FileFilter;

public class ImageFileChooser
extends JFileChooser {
    private ImagePreviewPane imagePreviewPane;
    private PropertyChangeListener imagePropertyChangeListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("SelectedFileChangedProperty") && ImageFileChooser.this.isShowing()) {
                BufferedImage bufferedImage = BaseUtils.readImage(((File)propertyChangeEvent.getNewValue()).getPath());
                ImageFileChooser.this.imagePreviewPane.setImage(bufferedImage);
                ImageFileChooser.this.imagePreviewPane.repaint();
            }
        }
    };

    public ImageFileChooser() {
        this.imagePreviewPane = new ImagePreviewPane();
        this.imagePreviewPane.setPreferredSize(new Dimension(240, 240));
        this.imagePreviewPane.addPropertyChangeListener(this.imagePropertyChangeListener);
        this.setAccessory(new JScrollPane(this.imagePreviewPane));
        ExampleFileFilter exampleFileFilter = new ExampleFileFilter(new String[]{"jpg", "gif", "png", "bmp"}, Inter.getLocText("Image-Image_Files"));
        exampleFileFilter.setExtensionListInDescription(true);
        this.addChoosableFileFilter(exampleFileFilter);
        this.setAcceptAllFileFilterUsed(false);
        ChooseFileView chooseFileView = new ChooseFileView();
        chooseFileView.putIcon("jpg", BaseUtils.readIcon("/com/fr/dialog/images/file/jpgFile.gif"));
        chooseFileView.putIcon("gif", BaseUtils.readIcon("/com/fr/dialog/images/file/gifFile.gif"));
        chooseFileView.putIcon("png", BaseUtils.readIcon("/com/fr/dialog/images/file/pngFile.png"));
        chooseFileView.putIcon("bmp", BaseUtils.readIcon("/com/fr/dialog/images/file/bmpFile.gif"));
        this.setFileView(chooseFileView);
    }

    public int showDialog(Component component, String string) {
        this.imagePreviewPane.setImage(null);
        return super.showDialog(component, string);
    }

    class ExampleFileFilter
    extends FileFilter {
        private Hashtable filters = new Hashtable();
        private String description = null;
        private String fullDescription = null;
        private boolean useExtensionsInDescription = true;

        public ExampleFileFilter() {
        }

        public ExampleFileFilter(String string) {
            this(string, null);
        }

        public ExampleFileFilter(String string, String string2) {
            this();
            if (string != null) {
                this.addExtension(string);
            }
            if (string2 != null) {
                this.setDescription(string2);
            }
        }

        public ExampleFileFilter(String[] stringArray) {
            this(stringArray, null);
        }

        public ExampleFileFilter(String[] stringArray, String string) {
            this();
            for (int i = 0; i < stringArray.length; ++i) {
                this.addExtension(stringArray[i]);
            }
            if (string != null) {
                this.setDescription(string);
            }
        }

        public boolean accept(File file) {
            if (file != null) {
                if (file.isDirectory()) {
                    return true;
                }
                String string = this.getExtension(file);
                if (string != null && this.filters.get(this.getExtension(file)) != null) {
                    return true;
                }
            }
            return false;
        }

        public String getExtension(File file) {
            String string;
            int n;
            if (file != null && (n = (string = file.getName()).lastIndexOf(46)) > 0 && n < string.length() - 1) {
                return string.substring(n + 1).toLowerCase();
            }
            return null;
        }

        public void addExtension(String string) {
            if (this.filters == null) {
                this.filters = new Hashtable(5);
            }
            this.filters.put(string.toLowerCase(), this);
            this.fullDescription = null;
        }

        public String getDescription() {
            if (this.fullDescription == null) {
                if (this.description == null || this.isExtensionListInDescription()) {
                    this.fullDescription = this.description == null ? "(" : this.description + " (";
                    Enumeration enumeration = this.filters.keys();
                    if (enumeration != null) {
                        this.fullDescription = this.fullDescription + "." + enumeration.nextElement();
                        while (enumeration.hasMoreElements()) {
                            this.fullDescription = this.fullDescription + ", ." + enumeration.nextElement();
                        }
                    }
                    this.fullDescription = this.fullDescription + ")";
                } else {
                    this.fullDescription = this.description;
                }
            }
            return this.fullDescription;
        }

        public void setDescription(String string) {
            this.description = string;
            this.fullDescription = null;
        }

        public void setExtensionListInDescription(boolean bl) {
            this.useExtensionsInDescription = bl;
            this.fullDescription = null;
        }

        public boolean isExtensionListInDescription() {
            return this.useExtensionsInDescription;
        }
    }
}

