/*
 * Decompiled with CFR 0.152.
 */
package com.fr.dialog.core;

import com.fr.base.Style;
import com.fr.base.core.GraphHelper;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ImagePreviewPane
extends JComponent
implements Scrollable {
    private Image image = null;
    private Style imageStyle = null;
    private int imageWidth = 0;
    private int imageHeight = 0;
    private List changeListenerList = new ArrayList();

    public ImagePreviewPane() {
        this.setToolTipText("View Image");
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        this.image = image;
        if (this.image == null) {
            if (this.getParent() instanceof JViewport) {
                JScrollBar jScrollBar = new JScrollBar(0);
                Dimension dimension = new Dimension(this.getSize().width - jScrollBar.getPreferredSize().height, this.getSize().height - jScrollBar.getPreferredSize().height);
                ((JViewport)this.getParent()).setPreferredSize(dimension);
                this.getParent().setSize(dimension);
                ((JViewport)this.getParent()).setMinimumSize(dimension);
                ((JViewport)this.getParent()).setMaximumSize(dimension);
            }
        } else {
            GraphHelper.waitForImage(image);
            this.imageWidth = image.getWidth(null);
            this.imageHeight = image.getHeight(null);
            this.setToolTipText("Image Size: " + this.imageWidth + "x" + this.imageHeight + "px");
            this.fireChagneListener();
        }
        this.revalidate();
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.getImage() != null) {
            if (this.getImageStyle() == null) {
                graphics.drawImage(this.getImage(), 0, 0, this);
            } else {
                GraphHelper.paintImage(graphics, this.getWidth(), this.getHeight(), this.getImage(), this.getImageStyle(), this.getImageStyle().getImageLayout(), -1, -1);
            }
        }
    }

    public Dimension getPreferredSize() {
        if (this.image == null) {
            return super.getPreferredSize();
        }
        return new Dimension(this.imageWidth, this.imageHeight);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeListenerList.add(changeListener);
    }

    private void fireChagneListener() {
        if (this.changeListenerList.size() > 0) {
            ChangeEvent changeEvent = new ChangeEvent(this.getImage());
            for (int i = 0; i < this.changeListenerList.size(); ++i) {
                ((ChangeListener)this.changeListenerList.get(i)).stateChanged(changeEvent);
            }
        }
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        switch (n) {
            case 1: {
                return rectangle.height / 10;
            }
            case 0: {
                return rectangle.width / 10;
            }
        }
        throw new IllegalArgumentException("Invalid orientation: " + n);
    }

    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        switch (n) {
            case 1: {
                return rectangle.height;
            }
            case 0: {
                return rectangle.width;
            }
        }
        throw new IllegalArgumentException("Invalid orientation: " + n);
    }

    public boolean getScrollableTracksViewportWidth() {
        if (this.getParent() instanceof JViewport) {
            return this.getParent().getWidth() > this.getPreferredSize().width;
        }
        return false;
    }

    public boolean getScrollableTracksViewportHeight() {
        if (this.getParent() instanceof JViewport) {
            return this.getParent().getHeight() > this.getPreferredSize().height;
        }
        return false;
    }

    public void setImageStyle(Style style) {
        this.imageStyle = style;
    }

    public Style getImageStyle() {
        return this.imageStyle;
    }
}

