/*
 * Decompiled with CFR 0.152.
 */
package com.fr.dialog.core;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.Serializable;

public class LeftCenterRightLayout
implements LayoutManager,
Serializable {
    public static final String LEFT = "LEFT";
    public static final String CENTER = "CENTER";
    public static final String RIGHT = "RIGHT";
    private Component leftComponent;
    private Component centerComponent;
    private Component rightComponent;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLayoutComponent(String string, Component component) {
        Object object = component.getTreeLock();
        synchronized (object) {
            if (string == null) {
                string = "centerup";
            }
            if (LEFT.equals(string)) {
                this.leftComponent = component;
            } else if (CENTER.equals(string)) {
                this.centerComponent = component;
            } else if (RIGHT.equals(string)) {
                this.rightComponent = component;
            } else {
                throw new IllegalArgumentException("cannot add to layout: unknown constraint: " + string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLayoutComponent(Component component) {
        Object object = component.getTreeLock();
        synchronized (object) {
            if (component == this.leftComponent) {
                this.leftComponent = null;
            } else if (component == this.centerComponent) {
                this.centerComponent = null;
            } else if (component == this.rightComponent) {
                this.rightComponent = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension preferredLayoutSize(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            Dimension dimension = new Dimension(0, 0);
            Dimension dimension2 = this.leftComponent.getPreferredSize();
            Dimension dimension3 = this.centerComponent.getPreferredSize();
            Dimension dimension4 = this.rightComponent.getPreferredSize();
            dimension.width += dimension2.width + dimension3.width + dimension4.width;
            dimension.height += dimension2.height;
            Insets insets = container.getInsets();
            dimension.width += insets.left + insets.right;
            dimension.height += insets.top + insets.bottom;
            return dimension;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension minimumLayoutSize(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            Dimension dimension = new Dimension(0, 0);
            Dimension dimension2 = this.leftComponent.getMinimumSize();
            Dimension dimension3 = this.centerComponent.getMinimumSize();
            Dimension dimension4 = this.rightComponent.getMinimumSize();
            dimension.width += dimension2.width + dimension3.width + dimension4.width;
            dimension.height += dimension2.height;
            Insets insets = container.getInsets();
            dimension.width += insets.left + insets.right;
            dimension.height += insets.top + insets.bottom;
            return dimension;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layoutContainer(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            Insets insets = container.getInsets();
            int n = insets.top;
            int n2 = container.getHeight() - insets.bottom;
            int n3 = insets.left;
            int n4 = container.getWidth() - insets.right;
            Dimension dimension = this.centerComponent.getPreferredSize();
            int n5 = dimension.width;
            int n6 = (n4 - n3 - n5) / 2;
            this.leftComponent.setBounds(n3, n, n6, n2 - n);
            this.centerComponent.setBounds(n3 + n6, n, n5, n2 - n);
            this.rightComponent.setBounds(n4 - n6, n, n6, n2 - n);
        }
    }
}

