/*
 * Decompiled with CFR 0.152.
 */
package com.fr.dialog.core;

import com.fr.base.FRContext;
import com.fr.base.Inter;
import com.fr.base.core.GraphHelper;
import com.fr.cell.core.GUICoreUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JList;

public class LineComboBox
extends JComboBox {
    public LineComboBox(int[] nArray) {
        Integer[] integerArray = new Integer[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            integerArray[i] = new Integer(nArray[i]);
        }
        this.setModel(new DefaultComboBoxModel<Integer>(integerArray));
        this.setRenderer(new LineCellRenderer());
    }

    public int getSelectedLineStyle() {
        int n = (Integer)this.getSelectedItem();
        return n < 0 ? 0 : n;
    }

    public void setSelectedLineStyle(int n) {
        GUICoreUtils.setSelectedItem(this, new Integer(n));
    }

    class LineCellRenderer
    extends DefaultListCellRenderer {
        private int style = 0;
        private boolean isSelected = false;

        LineCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.style = (Integer)object;
            this.isSelected = bl;
            return this;
        }

        public void paint(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Dimension dimension = this.getSize();
            graphics2D.setColor(Color.black);
            graphics2D.setFont(FRContext.getDefaultValues().getFRFont());
            FontMetrics fontMetrics = GraphHelper.getFontMetrics(FRContext.getDefaultValues().getFRFont());
            if (this.style == 0) {
                GraphHelper.drawString(graphics2D, Inter.getLocText("None"), 4.0, (dimension.height - fontMetrics.getHeight()) / 2 + fontMetrics.getAscent());
            } else {
                GraphHelper.drawLine(graphics2D, 4.0, dimension.height / 2, dimension.width - 8, dimension.height / 2, this.style);
            }
            if (this.isSelected) {
                graphics2D.setColor(Color.blue);
                GraphHelper.drawRect(graphics2D, 0.0, 0.0, dimension.width - 1, dimension.height - 1);
            }
        }

        public Dimension getPreferredSize() {
            return new Dimension(60, 16);
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }
    }
}

