/*
 * Decompiled with CFR 0.152.
 */
package com.fr.dialog.core;

import com.fr.base.FRContext;
import com.fr.base.Inter;
import com.fr.base.StringUtils;
import com.fr.cell.core.GUICoreUtils;
import com.fr.cell.core.layout.LayoutFactory;
import com.fr.dialog.BaseDialog;
import com.fr.report.cellElement.Formula;
import com.fr.report.core.ScriptUtils;
import com.fr.report.parameter.Parameter;
import com.fr.report.script.Calculator;
import com.fr.util.Utils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ParameterInputDialog
extends BaseDialog {
    private Map editorNameMap;

    public static ParameterInputDialog showWindow(Window window, Parameter[] parameterArray) {
        if (window instanceof Frame) {
            return new ParameterInputDialog((Frame)window, parameterArray);
        }
        return new ParameterInputDialog((Dialog)window, parameterArray);
    }

    private ParameterInputDialog(Frame frame, Parameter[] parameterArray) {
        super(frame);
        this.initComponents(parameterArray);
    }

    private ParameterInputDialog(Dialog dialog, Parameter[] parameterArray) {
        super(dialog);
        this.initComponents(parameterArray);
    }

    protected void initComponents(Parameter[] parameterArray) {
        super.initComponents();
        JPanel jPanel = (JPanel)this.getContentPane();
        JPanel jPanel2 = new JPanel();
        jPanel.add((Component)jPanel2, "Center");
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.setBorder(BorderFactory.createTitledBorder(Inter.getLocText("Parameters") + ":"));
        FlowTableLayoutHelper flowTableLayoutHelper = new FlowTableLayoutHelper();
        this.editorNameMap = new HashMap();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (parameterArray != null && parameterArray.length > 0) {
            for (int i = 0; i < parameterArray.length; ++i) {
                Parameter parameter = parameterArray[i];
                if (arrayList.contains(parameter.getName())) continue;
                final JTextField jTextField = new JTextField();
                final Object object = parameter.getValue();
                if (object instanceof Formula || object instanceof String && ((String)object).startsWith("=")) {
                    jTextField.setText(Inter.getLocText("Utils-Default_Value") + "(" + Inter.getLocText("ParameterD-DClick_Edit") + ")");
                    jTextField.setEditable(false);
                    jTextField.addMouseListener(new MouseListener(){

                        public void mouseClicked(MouseEvent mouseEvent) {
                            if (mouseEvent.getClickCount() >= 2) {
                                Object object2 = null;
                                try {
                                    object2 = object instanceof Formula ? ScriptUtils.executeFormula(Calculator.createCalculator(), (Formula)object) : ScriptUtils.executeFormula(Calculator.createCalculator(), new Formula((String)object));
                                }
                                catch (RuntimeException runtimeException) {
                                    FRContext.getLogger().log(Level.WARNING, runtimeException.getMessage(), runtimeException);
                                }
                                jTextField.setText(Utils.objectToString(object2));
                                jTextField.setEditable(true);
                            }
                        }

                        public void mouseEntered(MouseEvent mouseEvent) {
                        }

                        public void mouseExited(MouseEvent mouseEvent) {
                        }

                        public void mousePressed(MouseEvent mouseEvent) {
                        }

                        public void mouseReleased(MouseEvent mouseEvent) {
                        }
                    });
                } else if (object != null) {
                    jTextField.setText(Utils.objectToString(object));
                }
                JPanel jPanel3 = new JPanel();
                jPanel3.setLayout(LayoutFactory.createBorderLayout());
                jPanel3.add((Component)jTextField, "Center");
                jPanel3.setPreferredSize(new Dimension(180, jPanel3.getPreferredSize().height));
                String string = parameter.getName();
                if (StringUtils.isNotBlank(parameter.getName())) {
                    string = parameter.getName();
                }
                jPanel2.add(flowTableLayoutHelper.createLabelFlowPane(string + ":", jPanel3));
                this.editorNameMap.put(jTextField, parameter.getName());
                arrayList.add(parameter.getName());
            }
        }
        flowTableLayoutHelper.adjustLabelWidth();
        jPanel.add((Component)this.createControlButtonPane(), "South");
        this.setModal(true);
        this.setTitle(Inter.getLocText("Parameters"));
        this.pack();
        if (this.getOwner() != null) {
            GUICoreUtils.setWindowCenter(this.getOwner(), this);
        }
        this.setVisible(true);
    }

    public Map update() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Iterator iterator = this.editorNameMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            JTextField jTextField = (JTextField)entry.getKey();
            if (!jTextField.isEditable()) continue;
            String string = (String)entry.getValue();
            String string2 = jTextField.getText();
            Number number = Utils.string2Number(string2);
            if (number != null) {
                hashMap.put(string, number);
                continue;
            }
            hashMap.put(string, string2);
        }
        return hashMap;
    }

    private static class FlowTableLayoutHelper {
        private List labelList = new ArrayList();

        public JPanel createLabelFlowPane(String string, JComponent jComponent) {
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new FlowLayout(0, 4, 2));
            JLabel jLabel = new JLabel(string);
            jPanel.add(jLabel);
            jLabel.setHorizontalAlignment(2);
            this.labelList.add(jLabel);
            jPanel.add(jComponent);
            return jPanel;
        }

        public void adjustLabelWidth() {
            int n;
            int n2 = 0;
            for (n = 0; n < this.labelList.size(); ++n) {
                n2 = Math.max(n2, ((JLabel)this.labelList.get((int)n)).getPreferredSize().width);
            }
            for (n = 0; n < this.labelList.size(); ++n) {
                JLabel jLabel = (JLabel)this.labelList.get(n);
                Dimension dimension = new Dimension(n2, jLabel.getPreferredSize().height);
                jLabel.setPreferredSize(dimension);
                jLabel.setSize(dimension);
                jLabel.setMinimumSize(dimension);
            }
        }
    }
}

