/*
 * Decompiled with CFR 0.152.
 */
package com.fr.dialog.core;

import com.fr.base.FRContext;
import com.fr.base.Inter;
import com.fr.base.NameStyle;
import com.fr.base.Style;
import com.fr.base.core.StyleUtils;
import com.fr.cell.GridSelection;
import com.fr.cell.ReportPane;
import com.fr.dialog.NameObject;
import com.fr.dialog.UpdatePane;
import com.fr.dialog.core.AlignmentPane;
import com.fr.dialog.core.BackgroundPane;
import com.fr.dialog.core.BorderPane;
import com.fr.dialog.core.FRFontPane;
import com.fr.dialog.core.FormatPane;
import com.fr.report.CellElement;
import com.fr.report.DefaultCellElement;
import com.fr.report.FloatElement;
import com.fr.report.TemplateReport;
import com.fr.report.core.PaintUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.util.logging.Level;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class StylePane
extends UpdatePane
implements ChangeListener {
    private ReportPane reportPane;
    protected Style oldStyle;
    private NameStyle globalStyle;
    private FormatPane formatPane = null;
    private AlignmentPane alignmentPane = null;
    private FRFontPane frFontPane = null;
    private BorderPane borderPane = null;
    private BackgroundPane backgroundPane = null;
    private PreivewArea previewArea;
    private JPanel previewPane;
    protected NameObject nameObject;
    protected ChangeListener tabChangeActionListener = new ChangeListener(){

        public void stateChanged(ChangeEvent changeEvent) {
            Object object = changeEvent.getSource();
            if (object == null || !(object instanceof JTabbedPane)) {
                return;
            }
            JTabbedPane jTabbedPane = (JTabbedPane)object;
            int n = jTabbedPane.getSelectedIndex();
            if (jTabbedPane.getComponentAt(n).getClass() == (class$javax$swing$JPanel == null ? (class$javax$swing$JPanel = StylePane.class$("javax.swing.JPanel")) : class$javax$swing$JPanel)) {
                if (n == 1) {
                    jTabbedPane.setComponentAt(n, StylePane.this.getAlignmentPane());
                } else if (n == 2) {
                    jTabbedPane.setComponentAt(n, StylePane.this.getFRFontPane());
                } else if (n == 3) {
                    jTabbedPane.setComponentAt(n, StylePane.this.getBorderPane());
                } else if (n == 4) {
                    jTabbedPane.setComponentAt(n, StylePane.this.getBackgroundPane());
                }
            }
            StylePane.this.updatePreviewArea();
        }
    };
    static /* synthetic */ Class class$javax$swing$JPanel;

    public StylePane() {
        this.setLayout(new BorderLayout());
        this.previewPane = new JPanel(new BorderLayout());
        this.add((Component)this.previewPane, "North");
        this.previewPane.setBorder(BorderFactory.createTitledBorder(Inter.getLocText("Preview") + ":"));
        this.previewArea = new PreivewArea();
        this.previewPane.add((Component)this.previewArea, "Center");
        JPanel jPanel = new JPanel(new GridLayout(2, 1, 2, 2));
        this.previewPane.add((Component)jPanel, "East");
        JTabbedPane jTabbedPane = new JTabbedPane();
        this.add((Component)jTabbedPane, "Center");
        jTabbedPane.addTab(Inter.getLocText("Format"), this.getFormatPane());
        jTabbedPane.addTab(Inter.getLocText("Alignment"), new JPanel());
        jTabbedPane.addTab(Inter.getLocText("Sytle-FRFont"), new JPanel());
        jTabbedPane.addTab(Inter.getLocText("Border"), new JPanel());
        jTabbedPane.addTab(Inter.getLocText("Background"), new JPanel());
        jTabbedPane.addChangeListener(this.tabChangeActionListener);
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.updatePreviewArea();
    }

    protected FormatPane getFormatPane() {
        if (this.formatPane == null) {
            this.formatPane = new FormatPane();
            if (this.oldStyle != null) {
                this.formatPane.populate(this.oldStyle.getFormat());
            }
        }
        return this.formatPane;
    }

    private AlignmentPane getAlignmentPane() {
        if (this.alignmentPane == null) {
            this.alignmentPane = new AlignmentPane();
            this.alignmentPane.addChangeListener(this);
            if (this.oldStyle != null) {
                this.alignmentPane.populate(this.oldStyle);
            }
        }
        return this.alignmentPane;
    }

    private FRFontPane getFRFontPane() {
        if (this.frFontPane == null) {
            this.frFontPane = new FRFontPane();
            this.frFontPane.addChangeListener(this);
            if (this.oldStyle != null) {
                this.frFontPane.populate(this.oldStyle.getFRFont());
            }
        }
        return this.frFontPane;
    }

    private BorderPane getBorderPane() {
        if (this.borderPane == null) {
            this.borderPane = new BorderPane();
            this.borderPane.addChangeListener(this);
            if (this.reportPane != null) {
                this.borderPane.populate(this.reportPane);
            } else if (this.oldStyle != null) {
                this.borderPane.populate(this.oldStyle);
            }
        }
        return this.borderPane;
    }

    private BackgroundPane getBackgroundPane() {
        if (this.backgroundPane == null) {
            this.backgroundPane = new BackgroundPane();
            this.backgroundPane.addChangeListener(this);
            if (this.oldStyle != null) {
                this.backgroundPane.populate(this.oldStyle.getBackground());
            }
        }
        return this.backgroundPane;
    }

    public NameStyle getGlobalStyle() {
        return this.globalStyle;
    }

    public void setGlobalStyle(NameStyle nameStyle) {
        this.globalStyle = nameStyle;
    }

    public void populate(ReportPane reportPane) {
        this.reportPane = reportPane;
        this.nameObject = new NameObject("", this.analyzeCurrentStyle(reportPane));
        this.populate(this.nameObject);
        this.updatePreviewArea();
    }

    private Style analyzeCurrentStyle(ReportPane reportPane) {
        Style style = null;
        GridSelection gridSelection = reportPane.getGridSelection();
        int n = gridSelection.getType();
        if (n == 1) {
            TemplateReport templateReport = reportPane.getEditingReport();
            FloatElement floatElement = templateReport.getFloatElement(gridSelection.getFloatName(0));
            style = floatElement.getStyle();
        } else {
            Rectangle rectangle = gridSelection.getEditRectangle();
            TemplateReport templateReport = reportPane.getEditingReport();
            CellElement cellElement = templateReport.getCellElement(rectangle.x, rectangle.y);
            if (cellElement != null && cellElement.getStyle() != null) {
                try {
                    style = (Style)cellElement.getStyle().clone();
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    FRContext.getLogger().log(Level.WARNING, cloneNotSupportedException.getMessage(), cloneNotSupportedException);
                }
            }
        }
        if (style == null) {
            style = Style.DEFAULT_STYLE;
        }
        return style;
    }

    public boolean updateGlobalStyle(ReportPane reportPane) {
        this.updatePreviewArea();
        NameStyle nameStyle = this.getGlobalStyle();
        TemplateReport templateReport = reportPane.getEditingReport();
        GridSelection gridSelection = reportPane.getGridSelection();
        int n = gridSelection.getType();
        if (n == 1) {
            int n2 = gridSelection.getFloatNameCount();
            for (int i = 0; i < n2; ++i) {
                String string = gridSelection.getFloatName(i);
                FloatElement floatElement = templateReport.getFloatElement(string);
                floatElement.setStyle(nameStyle);
            }
        } else {
            int n3 = gridSelection.getCellRectangleCount();
            for (int i = 0; i < n3; ++i) {
                Rectangle rectangle = gridSelection.getCellRectangle(i);
                for (int j = 0; j < rectangle.height; ++j) {
                    for (int k = 0; k < rectangle.width; ++k) {
                        int n4 = k + rectangle.x;
                        int n5 = j + rectangle.y;
                        CellElement cellElement = templateReport.getCellElement(n4, n5);
                        if (cellElement == null) {
                            cellElement = new DefaultCellElement(n4, n5);
                            templateReport.addCellElement(cellElement);
                        }
                        cellElement.setStyle(nameStyle);
                    }
                }
            }
        }
        if (this.borderPane != null) {
            this.borderPane.update(reportPane);
        }
        return true;
    }

    public boolean update(ReportPane reportPane) {
        Style style;
        Style style2 = this.analyzeCurrentStyle(reportPane);
        try {
            style = (Style)style2.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            FRContext.getLogger().log(Level.WARNING, cloneNotSupportedException.getMessage(), cloneNotSupportedException);
            return false;
        }
        if (this.nameObject == null) {
            return false;
        }
        this.update();
        style = (Style)this.nameObject.getObject();
        TemplateReport templateReport = reportPane.getEditingReport();
        GridSelection gridSelection = reportPane.getGridSelection();
        int n = gridSelection.getType();
        if (n == 1) {
            int n2 = gridSelection.getFloatNameCount();
            for (int i = 0; i < n2; ++i) {
                String string = gridSelection.getFloatName(i);
                FloatElement floatElement = templateReport.getFloatElement(string);
                floatElement.setStyle(StyleUtils.applyCellStyle(style2, style, floatElement.getStyle()));
            }
        } else {
            int n3 = gridSelection.getCellRectangleCount();
            for (int i = 0; i < n3; ++i) {
                Rectangle rectangle = gridSelection.getCellRectangle(i);
                for (int j = 0; j < rectangle.height; ++j) {
                    for (int k = 0; k < rectangle.width; ++k) {
                        int n4 = k + rectangle.x;
                        int n5 = j + rectangle.y;
                        CellElement cellElement = templateReport.getCellElement(n4, n5);
                        if (cellElement == null) {
                            cellElement = new DefaultCellElement(n4, n5);
                            templateReport.addCellElement(cellElement);
                        }
                        cellElement.setStyle(StyleUtils.applyCellStyle(style2, style, cellElement.getStyle()));
                    }
                }
            }
        }
        if (this.borderPane != null) {
            this.borderPane.update(reportPane);
        }
        reportPane.repaint();
        return true;
    }

    public void populate(Object object) {
        Style style;
        if (object == null || !(object instanceof NameObject)) {
            return;
        }
        this.nameObject = (NameObject)object;
        this.oldStyle = style = (Style)this.nameObject.getObject();
        if (this.formatPane != null) {
            this.formatPane.populate(this.oldStyle.getFormat());
        }
        if (this.alignmentPane != null) {
            this.alignmentPane.populate(this.oldStyle);
        }
        if (this.frFontPane != null) {
            this.frFontPane.populate(this.oldStyle.getFRFont());
        }
        if (this.borderPane != null) {
            this.borderPane.populate(this.oldStyle);
        }
        if (this.backgroundPane != null) {
            this.backgroundPane.populate(this.oldStyle.getBackground());
        }
        this.updatePreviewArea();
    }

    public void update() {
        if (this.nameObject == null) {
            return;
        }
        try {
            if (this.alignmentPane != null) {
                this.alignmentPane.checkValid();
            }
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, exception.getMessage());
            return;
        }
        Style style = (Style)this.nameObject.getObject();
        if (this.formatPane != null) {
            style = style.deriveFormat(this.formatPane.update());
        }
        if (this.alignmentPane != null) {
            style = this.alignmentPane.update(style);
        }
        if (this.frFontPane != null) {
            style = style.deriveFRFont(this.frFontPane.update());
        }
        if (this.frFontPane != null) {
            style = style.deriveFRFont(this.frFontPane.update());
        }
        if (this.borderPane != null) {
            style = this.borderPane.update(style);
        }
        if (this.backgroundPane != null) {
            style = style.deriveBackground(this.backgroundPane.update());
        }
        this.nameObject.setObject(style);
    }

    public void updatePreviewArea() {
        if (this.oldStyle != null) {
            if (this.nameObject == null) {
                return;
            }
            this.update();
            this.previewArea.setStyle((Style)this.nameObject.getObject());
        }
    }

    public PreivewArea getPreviewArea() {
        return this.previewArea;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class PreivewArea
    extends JComponent {
        private String paintText = "Report";
        private Style style = Style.DEFAULT_STYLE;

        public PreivewArea() {
            this.setPreferredSize(new Dimension(40, 40));
        }

        public void setStyle(Style style) {
            this.style = style;
            this.repaint();
        }

        public void paintComponent(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            if (this.style == Style.DEFAULT_STYLE) {
                PaintUtils.paintContent(graphics2D, (Object)this.paintText, this.style, this.getWidth() - 3, this.getHeight() - 3);
                return;
            }
            PaintUtils.paintBackground(graphics2D, this.style, this.getWidth() - 3, this.getHeight() - 3);
            PaintUtils.paintContent(graphics2D, (Object)this.paintText, this.style, this.getWidth() - 3, this.getHeight() - 3);
            PaintUtils.paintBorder(graphics2D, this.style, this.getWidth() - 3, this.getHeight() - 3);
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }
    }

    class FRFontListSelectionListener
    implements ListSelectionListener {
        FRFontListSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            StylePane.this.updatePreviewArea();
        }
    }
}

