/*
 * Decompiled with CFR 0.152.
 */
package com.fr.dialog.core;

import com.fr.base.FRContext;
import com.fr.base.Inter;
import com.fr.base.core.BaseCoreUtils;
import com.fr.base.core.ComparatorUtils;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.util.Locale;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

public class UnitFieldPane
extends JPanel {
    private JSpinner valueSpinner;
    private boolean useLocale = false;

    public UnitFieldPane() {
        this.setLayout(new FlowLayout(0, 3, 0));
        this.valueSpinner = new JSpinner(new SpinnerNumberModel(0.0, 0.0, Double.MAX_VALUE, 1.0));
        JFormattedTextField jFormattedTextField = ((JSpinner.DefaultEditor)this.valueSpinner.getEditor()).getTextField();
        jFormattedTextField.setColumns(4);
        this.add(this.valueSpinner);
        JLabel jLabel = new JLabel();
        Locale locale = FRContext.getLocale();
        if (this.useLocale) {
            if (ComparatorUtils.equals(Locale.CHINA, locale)) {
                jLabel.setText(Inter.getLocText("PageSetup-mm"));
            } else {
                jLabel.setText(Inter.getLocText("PageSetup-inches"));
            }
        } else {
            jLabel.setText(Inter.getLocText("PageSetup-mm"));
        }
        Dimension dimension = new Dimension(jLabel.getPreferredSize().width, this.valueSpinner.getPreferredSize().height);
        jLabel.setMinimumSize(dimension);
        jLabel.setMinimumSize(dimension);
        jLabel.setSize(dimension);
        jLabel.setPreferredSize(dimension);
        this.add(jLabel);
    }

    public double getInchesValue() {
        Locale locale = FRContext.getLocale();
        if (this.useLocale) {
            if (ComparatorUtils.equals(Locale.CHINA, locale)) {
                return BaseCoreUtils.convertMillimetersToInches(((Number)this.valueSpinner.getValue()).doubleValue());
            }
            return ((Number)this.valueSpinner.getValue()).doubleValue();
        }
        return BaseCoreUtils.convertMillimetersToInches(((Number)this.valueSpinner.getValue()).doubleValue());
    }

    public void setInchesValue(double d) {
        Locale locale = FRContext.getLocale();
        if (this.useLocale) {
            if (ComparatorUtils.equals(Locale.CHINA, locale)) {
                this.valueSpinner.setValue(new Double(BaseCoreUtils.convertInchesToMillimeters(d)));
            } else {
                this.valueSpinner.setValue(new Double(d));
            }
        } else {
            this.valueSpinner.setValue(new Double(BaseCoreUtils.convertInchesToMillimeters(d)));
        }
    }
}

