/*
 * Decompiled with CFR 0.152.
 */
package com.fr.privilege;

import com.fr.base.core.BaseCoreUtils;
import com.fr.base.core.ComparatorUtils;
import com.fr.base.core.FRCoreContext;
import com.fr.base.core.RSADecode;
import com.fr.base.core.json.JSONObject;
import com.fr.base.core.util.vt.VT4FR;
import com.fr.privilege.Privilege;
import com.fr.privilege.authority.Authority;
import com.fr.util.Consts;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

public abstract class AbstractPrivilege
implements Privilege {
    private static boolean authorityAvailable = true;
    private static final long serialVersionUID = -4406366638087696364L;
    private List authorityList = null;

    public Authority[] neededAuthority() {
        return !authorityAvailable || this.authorityList == null ? new Authority[]{} : this.authorityList.toArray(new Authority[this.authorityList.size()]);
    }

    public void addAuthority(Authority authority) {
        if (this.authorityList == null) {
            this.authorityList = new ArrayList(3);
        }
        this.authorityList.add(authority);
    }

    public int getAuthorityCount() {
        return this.authorityList == null ? 0 : this.authorityList.size();
    }

    public Authority getAuthority(int n) {
        if (n < 0 || n >= this.getAuthorityCount()) {
            return null;
        }
        return (Authority)this.authorityList.get(n);
    }

    public void clearAuthority() {
        if (this.authorityList != null) {
            this.authorityList.clear();
        }
        this.authorityList = null;
    }

    public Object clone() throws CloneNotSupportedException {
        AbstractPrivilege abstractPrivilege = (AbstractPrivilege)super.clone();
        abstractPrivilege.authorityList = null;
        int n = this.getAuthorityCount();
        for (int i = 0; i < n; ++i) {
            abstractPrivilege.addAuthority((Authority)this.getAuthority(i).clone());
        }
        return abstractPrivilege;
    }

    static {
        byte[] byArray = FRCoreContext.getBytes();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            RSADecode.decode(byArray, (OutputStream)byteArrayOutputStream);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            JSONObject jSONObject = new JSONObject(new String(byteArrayOutputStream.toByteArray(), "UTF-8"));
            authorityAvailable = jSONObject.getLong("deadline") > Calendar.getInstance().getTimeInMillis() && jSONObject.has("version") && ComparatorUtils.equals(Consts.VERSION, jSONObject.getString("version")) && (jSONObject.getLong("deadline") - Calendar.getInstance().getTimeInMillis() < 3153600000L || jSONObject.has("macaddress") && BaseCoreUtils.getMacAddresses().contains(jSONObject.getString("macaddress"))) && VT4FR.PRIVILIGE.support();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

