/*
 * Decompiled with CFR 0.152.
 */
package com.fr.privilege.authentication;

import com.fr.base.core.ComparatorUtils;
import com.fr.privilege.authentication.Authentication;
import com.fr.privilege.authority.Authority;
import com.fr.privilege.user.User;
import java.security.Principal;

public abstract class AbstractAuthentication
implements Authentication {
    private static final long serialVersionUID = 5846413362332382520L;
    private Object details;
    private Authority[] authorities;
    private boolean authenticated = false;

    public void setAuthorities(Authority[] authorityArray) {
        this.authorities = authorityArray;
    }

    public void setDetails(Object object) {
        this.details = object;
    }

    public Authority[] getAuthorities() {
        if (this.authorities == null) {
            return new Authority[0];
        }
        Authority[] authorityArray = new Authority[this.authorities.length];
        System.arraycopy(this.authorities, 0, authorityArray, 0, this.authorities.length);
        return authorityArray;
    }

    public Object getDetails() {
        return this.details;
    }

    public boolean isAuthenticated() {
        return this.authenticated;
    }

    public void setAuthenticated(boolean bl) {
        this.authenticated = bl;
    }

    public String getName() {
        if (this.getPrincipal() instanceof User) {
            return ((User)this.getPrincipal()).getUsername();
        }
        if (this.getPrincipal() instanceof Principal) {
            return ((Principal)this.getPrincipal()).getName();
        }
        return this.getPrincipal() == null ? "" : this.getPrincipal().toString();
    }

    public boolean equals(Object object) {
        return object instanceof AbstractAuthentication && ComparatorUtils.equals(((AbstractAuthentication)object).authorities, this.authorities) && ComparatorUtils.equals(((AbstractAuthentication)object).details, this.details) && ComparatorUtils.equals(((AbstractAuthentication)object).getCredentials(), this.getCredentials()) && ComparatorUtils.equals(((AbstractAuthentication)object).getPrincipal(), this.getPrincipal()) && ((AbstractAuthentication)object).authenticated == this.authenticated;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString()).append(": ");
        stringBuffer.append("Principal: ").append(this.getPrincipal()).append("; ");
        stringBuffer.append("Password: [PROTECTED]; ");
        stringBuffer.append("Authenticated: ").append(this.isAuthenticated()).append("; ");
        stringBuffer.append("Details: ").append(this.getDetails()).append("; ");
        if (this.getAuthorities() != null) {
            stringBuffer.append("Granted Authorities: ");
            for (int i = 0; i < this.getAuthorities().length; ++i) {
                if (i > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(this.getAuthorities()[i].toString());
            }
        } else {
            stringBuffer.append("Not granted any authorities");
        }
        return stringBuffer.toString();
    }
}

