/*
 * Decompiled with CFR 0.152.
 */
package com.fr.privilege.filter.core;

import com.fr.base.FRContext;
import com.fr.base.StringUtils;
import com.fr.base.core.ComparatorUtils;
import com.fr.base.core.util.TemplateUtils;
import com.fr.privilege.authentication.Authentication;
import com.fr.privilege.authentication.AuthenticationFactory;
import com.fr.privilege.filter.core.PlatformAccessDealWith;
import com.fr.privilege.filter.core.TemplateAccessDealWith;
import com.fr.privilege.manager.PrivilegeManager;
import com.fr.privilege.providers.AbstractAuthenticationProvider;
import com.fr.privilege.providers.AuthenticationProvider;
import com.fr.privilege.ui.CustomLogioutUI;
import com.fr.privilege.ui.LoginoutUI;
import com.fr.web.core.WebUtils;
import com.fr.web.core.service.LoginOutService;
import com.fr.web.core.service.PlatformService;
import com.fr.web.platform.exception.RedirectException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class FRSecurityDispatcher {
    private FRSecurityDispatcher() {
    }

    public static void dealWithRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        try {
            FRSecurityDispatcher.dealWithSecurity(httpServletRequest, httpServletResponse);
        }
        catch (RedirectException redirectException) {
            throw new RedirectException();
        }
        catch (Exception exception) {
            PrivilegeManager privilegeManager = FRContext.getPrivilegeManager();
            AuthenticationProvider authenticationProvider = privilegeManager.getAuthenticationProvider();
            if (authenticationProvider == null) {
                return;
            }
            LoginoutUI loginoutUI = authenticationProvider.getLoginoutUI();
            if (loginoutUI != null) {
                loginoutUI.redirect2LoginUI(httpServletRequest, httpServletResponse, exception.getMessage());
            }
            return;
        }
        Authentication authentication = AuthenticationFactory.extractAuthentication(httpServletRequest);
        if (authentication != null && authentication.isAuthenticated()) {
            try {
                FRSecurityDispatcher.dealWithControl(httpServletRequest, httpServletResponse);
            }
            catch (Exception exception) {
                Map map = WebUtils.createTemplateMap(httpServletRequest);
                map.put("charset", FRContext.getConfigManager().getServerCharset());
                map.put("title", "\u65e0\u6743\u9650\u8bbf\u95ee");
                TemplateUtils.dealWithTemplate("/com/fr/web/platform/html/noPri.html", httpServletResponse, map);
            }
        }
    }

    public static void dealWithSecurity(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        Authentication authentication;
        String string = WebUtils.getHTTPRequestParameter(httpServletRequest, "op");
        if (string != null && LoginOutService.getInstance().accept(string)) {
            LoginOutService.getInstance().process(httpServletRequest, httpServletResponse, string);
        }
        if ((authentication = AuthenticationFactory.extractAuthentication(httpServletRequest)) == null || !authentication.isAuthenticated()) {
            FRSecurityDispatcher.dealWithControl(httpServletRequest, httpServletResponse);
        }
    }

    public static void dealWithControl(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = WebUtils.getHTTPRequestParameter(httpServletRequest, "op");
        HttpSession httpSession = httpServletRequest.getSession(true);
        if (string != null && PlatformService.getInstance().accept(string)) {
            httpSession.setAttribute("fr_from", (Object)WebUtils.getOriginalURL(httpServletRequest));
            PlatformAccessDealWith.dealWithRequest(string, httpServletRequest, httpServletResponse);
            return;
        }
        String string2 = WebUtils.getHTTPRequestParameter(httpServletRequest, "reportlet");
        if (FRSecurityDispatcher.isLoginoutReportlet(string2)) {
            return;
        }
        if (string2 != null) {
            httpSession.setAttribute("fr_from", (Object)WebUtils.getOriginalURL(httpServletRequest));
            TemplateAccessDealWith.dealWithRequest(string2, httpServletRequest, httpServletResponse);
            return;
        }
    }

    private static boolean isLoginoutReportlet(String string) {
        if (StringUtils.isEmpty(string)) {
            return false;
        }
        PrivilegeManager privilegeManager = FRContext.getPrivilegeManager();
        AbstractAuthenticationProvider abstractAuthenticationProvider = (AbstractAuthenticationProvider)privilegeManager.getAuthenticationProvider();
        LoginoutUI loginoutUI = abstractAuthenticationProvider.getLoginoutUI();
        if (loginoutUI instanceof CustomLogioutUI) {
            String string2 = StringUtils.perfectStart(((CustomLogioutUI)loginoutUI).getLoginPath(), "/");
            string = StringUtils.perfectStart(string, "/");
            return ComparatorUtils.equals(string2, string);
        }
        return false;
    }
}

