/*
 * Decompiled with CFR 0.152.
 */
package com.fr.privilege.filter.core;

import com.fr.base.FRContext;
import com.fr.base.Inter;
import com.fr.base.StringUtils;
import com.fr.privilege.authentication.Authentication;
import com.fr.privilege.authentication.AuthenticationFactory;
import com.fr.web.core.WebUtils;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class TemplateAccessDealWith {
    private TemplateAccessDealWith() {
    }

    public static void dealWithRequest(String string, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        Authentication authentication = AuthenticationFactory.extractAuthentication(httpServletRequest);
        if (string != null) {
            TemplateAccessDealWith.accessReportlet(string, authentication, httpServletRequest);
        }
    }

    private static void accessReportlet(String string, Authentication authentication, HttpServletRequest httpServletRequest) throws Exception {
        int n;
        if (string.indexOf(".") != -1 && !string.endsWith(".cpt")) {
            return;
        }
        if (!TemplateAccessDealWith.hasLegalAccess(string = StringUtils.perfectStart(string, "/"), n = TemplateAccessDealWith.createCheckType(httpServletRequest), authentication)) {
            throw new Exception(Inter.getLocText("Privilege-Your_Authentication_Can_Not_Access_The_Reportlet") + ":" + string + ".");
        }
    }

    private static int createCheckType(HttpServletRequest httpServletRequest) {
        String string = null;
        try {
            string = WebUtils.getHTTPRequestParameter(httpServletRequest, "op");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (string == null) {
            return 0;
        }
        if ("write".equalsIgnoreCase(string)) {
            return 2;
        }
        if ("form".equalsIgnoreCase(string)) {
            return 1;
        }
        return 0;
    }

    public static boolean hasLegalAccess(String string, int n, Authentication authentication) {
        return FRContext.getPrivilegeManager().getControl().access(authentication, string, n);
    }
}

