/*
 * Decompiled with CFR 0.152.
 */
package com.fr.privilege.manager;

import com.fr.base.FCloneable;
import com.fr.base.XMLFileManager;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.privilege.authority.Control;
import com.fr.privilege.authority.NoAuthorityControl;
import com.fr.privilege.providers.AuthenticationProvider;
import com.fr.privilege.providers.NoAuthenticationProvider;
import com.fr.report.io.xml.ReportXMLUtils;
import java.io.Serializable;

public class PrivilegeManager
extends XMLFileManager
implements Serializable,
FCloneable {
    public static final String XML_TAG = "PrivilegeManager";
    private AuthenticationProvider authenticationProvider = new NoAuthenticationProvider();
    private Control control = new NoAuthorityControl();

    public boolean usePrivilege() {
        return !(this.authenticationProvider instanceof NoAuthenticationProvider) || !(this.control instanceof NoAuthorityControl);
    }

    public AuthenticationProvider getAuthenticationProvider() {
        return this.authenticationProvider;
    }

    public void setAuthenticationProvider(AuthenticationProvider authenticationProvider) {
        this.authenticationProvider = authenticationProvider;
    }

    public Control getControl() {
        return this.control;
    }

    public void setControl(Control control) {
        this.control = control;
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (string.equals("AP")) {
                this.authenticationProvider = (AuthenticationProvider)ReportXMLUtils.readXMLable(xMLableReader);
            } else if ("Control".equals(string)) {
                this.control = (Control)ReportXMLUtils.readXMLable(xMLableReader);
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        if (this.authenticationProvider != null) {
            ReportXMLUtils.writeXMLable(xMLPrintWriter, this.authenticationProvider, "AP");
        }
        if (this.control != null) {
            ReportXMLUtils.writeXMLable(xMLPrintWriter, this.control, "Control");
        }
        xMLPrintWriter.end();
    }

    public String fileName() {
        return "privilege.xml";
    }

    public Object clone() throws CloneNotSupportedException {
        PrivilegeManager privilegeManager = (PrivilegeManager)super.clone();
        if (this.authenticationProvider != null) {
            privilegeManager.authenticationProvider = this.authenticationProvider;
        }
        if (this.control != null) {
            privilegeManager.control = this.control;
        }
        return privilegeManager;
    }
}

