/*
 * Decompiled with CFR 0.152.
 */
package com.fr.privilege.providers;

import com.fr.base.FRContext;
import com.fr.base.Inter;
import com.fr.base.StringUtils;
import com.fr.base.core.json.JSONException;
import com.fr.base.core.json.JSONObject;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.privilege.authentication.Authentication;
import com.fr.privilege.authority.Authority;
import com.fr.privilege.providers.AbstractAuthenticationProvider;
import com.fr.util.Utils;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.PostMethod;

public class HttpAuthenticationProvider
extends AbstractAuthenticationProvider {
    private String url;

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String string) {
        this.url = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean authenticate(Authentication authentication) throws Exception {
        if (this.url == null) {
            throw new Exception(Inter.getLocText("Privilege-The_Url_Can_Not_Be_Null"));
        }
        HttpClient httpClient = new HttpClient();
        PostMethod postMethod = new PostMethod(this.url);
        String string = authentication.getPrincipal().toString();
        String string2 = authentication.getCredentials().toString();
        postMethod.addParameter(new NameValuePair("fr_username", string));
        postMethod.addParameter(new NameValuePair("fr_password", string2));
        int n = httpClient.executeMethod((HttpMethod)postMethod);
        if (n != 200) {
            throw new Exception("Method failed: " + postMethod.getStatusLine());
        }
        try {
            int n2;
            InputStream inputStream = postMethod.getResponseBodyAsStream();
            if (inputStream == null) {
                boolean bl = false;
                return bl;
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            Utils.copyBinaryTo(inputStream, (OutputStream)byteArrayOutputStream);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            int n3 = byArray.length;
            int n4 = 0;
            for (int i = 0; i < n3; ++i) {
                if (byArray[i] == 10 || byArray[i] == 13) continue;
                ++n4;
            }
            byte[] byArray2 = new byte[n4];
            int n5 = 0;
            boolean bl = false;
            while (n5 < n3) {
                if (byArray[n5] != 10 && byArray[n5] != 13) {
                    byArray2[bl] = byArray[n5];
                }
                ++n5;
                bl += 1;
            }
            String string3 = new String(byArray2, "GBK");
            FRContext.getLogger().log(Level.INFO, string3);
            if ("false".equalsIgnoreCase(string3.trim())) {
                bl = false;
                return bl;
            }
            authentication.setAuthenticated(true);
            String[] stringArray = string3.split(",");
            Authority[] authorityArray = new Authority[stringArray.length];
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                authorityArray[n2] = new Authority(stringArray[n2]);
            }
            authentication.setAuthorities(authorityArray);
            n2 = 1;
            return n2 != 0;
        }
        finally {
            postMethod.releaseConnection();
        }
    }

    public void readJSON(JSONObject jSONObject) throws JSONException {
        super.readJSON(jSONObject);
        if (jSONObject.has("url")) {
            this.setUrl(jSONObject.getString("url"));
        }
    }

    public void readXML(XMLableReader xMLableReader) {
        String string;
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode() && "URL".equals(string = xMLableReader.getTagName())) {
            this.url = xMLableReader.getElementValue();
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        if (StringUtils.isNotBlank(this.url)) {
            xMLPrintWriter.startTAG("URL").textNode(this.url).end();
        }
    }
}

