/*
 * Decompiled with CFR 0.152.
 */
package com.fr.privilege.providers.dao;

import com.fr.base.Inter;
import com.fr.base.StringUtils;
import com.fr.base.XMLable;
import com.fr.base.core.ComparatorUtils;
import com.fr.base.core.json.JSONException;
import com.fr.base.core.json.JSONObject;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.data.impl.NameTableData;
import com.fr.privilege.authentication.Authentication;
import com.fr.privilege.authority.Authority;
import com.fr.privilege.providers.AbstractAuthenticationProvider;
import com.fr.privilege.user.User;
import com.fr.privilege.user.UserDetails;
import com.fr.report.io.xml.ReportXMLUtils;
import com.fr.web.core.JSONReader;
import com.fr.web.platform.PlatformUtils;
import java.util.ArrayList;

public class DaoAuthenticationProvider
extends AbstractAuthenticationProvider {
    private static final long serialVersionUID = -2564032298178563645L;
    private UserConfig userConfig;
    private RoleConfig roleConfig;

    public UserConfig getUserConfig() {
        return this.userConfig;
    }

    public void setUserConfig(UserConfig userConfig) {
        this.userConfig = userConfig;
    }

    public RoleConfig getRoleConfig() {
        return this.roleConfig;
    }

    public void setRoleConfig(RoleConfig roleConfig) {
        this.roleConfig = roleConfig;
    }

    public boolean authenticate(Authentication authentication) throws Exception {
        if (authentication == null) {
            throw new Exception(Inter.getLocText("Privilege-The_Authentication_Can_Not_Be_Null") + ".");
        }
        if (authentication.isAuthenticated()) {
            return true;
        }
        String string = authentication.getPrincipal().toString();
        String string2 = authentication.getCredentials().toString();
        User user = this.loadUserByUsername(string);
        if (user == null) {
            throw new Exception(Inter.getLocText("Privilege-Invalid_User_Or_Password") + ".");
        }
        if (!ComparatorUtils.equals(user.getPassword(), string2)) {
            throw new Exception(Inter.getLocText("Privilege-Invalid_User_Or_Password") + ".");
        }
        authentication.setAuthenticated(true);
        authentication.setAuthorities(user.getAuthorities());
        return true;
    }

    public void readJSON(JSONObject jSONObject) throws JSONException {
        super.readJSON(jSONObject);
        UserConfig userConfig = new UserConfig();
        userConfig.readJSON(jSONObject);
        this.setUserConfig(userConfig);
        RoleConfig roleConfig = new RoleConfig();
        roleConfig.readJSON(jSONObject);
        this.setRoleConfig(roleConfig);
    }

    public Authority[] listAuthorities() throws Exception {
        if (this.roleConfig == null) {
            throw new Exception("The role config can not be null.");
        }
        if (StringUtils.isBlank(this.roleConfig.getTableDataName())) {
            throw new Exception("The tabledata can not be null.");
        }
        NameTableData nameTableData = new NameTableData(this.roleConfig.getTableDataName());
        int[] nArray = PlatformUtils.getColumnIndics(nameTableData, new String[]{this.roleConfig.getRoleField()});
        if (nArray[0] < 0) {
            return null;
        }
        int n = nameTableData.getRowCount();
        ArrayList<Authority> arrayList = new ArrayList<Authority>();
        for (int i = 0; i < n; ++i) {
            String string = nameTableData.getValueAt(i, nArray[0]).toString();
            Authority authority = new Authority(string);
            if (arrayList.contains(authority)) continue;
            arrayList.add(authority);
        }
        return arrayList.toArray(new Authority[arrayList.size()]);
    }

    private User loadUserByUsername(String string) throws Exception {
        if (this.userConfig == null) {
            throw new Exception(Inter.getLocText("Privilege-The_User_Config_Can_Not_Be_Null") + ".");
        }
        if (this.roleConfig == null) {
            throw new Exception(Inter.getLocText("Privilege-The_Role_Config_Can_Not_Be_Null") + ".");
        }
        try {
            String string2;
            String string3 = this.userConfig.getTableDataName();
            if (StringUtils.isBlank(string3)) {
                return null;
            }
            NameTableData nameTableData = new NameTableData(string3);
            int[] nArray = PlatformUtils.getColumnIndics(nameTableData, new String[]{this.userConfig.getUsernameField(), this.userConfig.getPasswordField()});
            String string4 = null;
            boolean bl = false;
            int n = nameTableData.getRowCount();
            for (int i = 0; i < n; ++i) {
                string2 = nameTableData.getValueAt(i, nArray[0]).toString();
                if (!string2.equals(string)) continue;
                bl = true;
                string4 = nameTableData.getValueAt(i, nArray[1]).toString();
                break;
            }
            Authority[] authorityArray = null;
            if (bl) {
                string2 = this.roleConfig.getTableDataName();
                ArrayList<Authority> arrayList = new ArrayList<Authority>();
                if (StringUtils.isNotBlank(string2)) {
                    NameTableData nameTableData2 = new NameTableData(string2);
                    int[] nArray2 = PlatformUtils.getColumnIndics(nameTableData2, new String[]{this.roleConfig.getUsernameField(), this.roleConfig.getRoleField()});
                    int n2 = nameTableData2.getRowCount();
                    for (int i = 0; i < n2; ++i) {
                        String string5 = nameTableData2.getValueAt(i, nArray2[0]).toString();
                        if (!string5.equals(string)) continue;
                        String string6 = nameTableData2.getValueAt(i, nArray2[1]).toString();
                        arrayList.add(new Authority(string6));
                    }
                }
                authorityArray = arrayList.toArray(new Authority[arrayList.size()]);
            }
            return bl ? new UserDetails(string, string4, authorityArray) : null;
        }
        catch (Exception exception) {
            throw new Exception(Inter.getLocText("Database") + Inter.getLocText("Datasource-Connection_failed") + "!");
        }
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if ("UserConfig".equals(string)) {
                this.userConfig = (UserConfig)ReportXMLUtils.readXMLable(xMLableReader);
            } else if ("RoleConfig".equals(string)) {
                this.roleConfig = (RoleConfig)ReportXMLUtils.readXMLable(xMLableReader);
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        if (this.userConfig != null) {
            ReportXMLUtils.writeXMLable(xMLPrintWriter, this.userConfig, "UserConfig");
        }
        if (this.roleConfig != null) {
            ReportXMLUtils.writeXMLable(xMLPrintWriter, this.roleConfig, "RoleConfig");
        }
    }

    public static class RoleConfig
    implements JSONReader,
    XMLable {
        public static final String XML_TAG = "RoleConfig";
        private String tableDataName;
        private String usernameField;
        private String roleField;

        public String getTableDataName() {
            return this.tableDataName;
        }

        public void setTableDataName(String string) {
            this.tableDataName = string;
        }

        public String getUsernameField() {
            return this.usernameField;
        }

        public void setUsernameField(String string) {
            this.usernameField = string;
        }

        public String getRoleField() {
            return this.roleField;
        }

        public void setRoleField(String string) {
            this.roleField = string;
        }

        public void readXML(XMLableReader xMLableReader) {
            String string;
            if (xMLableReader.isChildNode() && (string = xMLableReader.getTagName()).equals("RoleConfigAttr")) {
                this.tableDataName = xMLableReader.getAttr("tabledata");
                this.usernameField = xMLableReader.getAttr("username");
                this.roleField = xMLableReader.getAttr("role");
            }
        }

        public void writeXML(XMLPrintWriter xMLPrintWriter) {
            xMLPrintWriter.startTAG("RoleConfigAttr");
            if (StringUtils.isNotBlank(this.tableDataName)) {
                xMLPrintWriter.attr("tabledata", this.tableDataName);
            }
            if (StringUtils.isNotBlank(this.usernameField)) {
                xMLPrintWriter.attr("username", this.usernameField);
            }
            if (StringUtils.isNotBlank(this.roleField)) {
                xMLPrintWriter.attr("role", this.roleField);
            }
            xMLPrintWriter.end();
        }

        public void readJSON(JSONObject jSONObject) throws JSONException {
            if (jSONObject.has("ur_tabledata")) {
                this.tableDataName = jSONObject.getString("ur_tabledata");
            }
            if (jSONObject.has("ur_role")) {
                this.roleField = jSONObject.getString("ur_role");
            }
            if (jSONObject.has("ur_user")) {
                this.usernameField = jSONObject.getString("ur_user");
            }
        }

        public Object clone() throws CloneNotSupportedException {
            return super.clone();
        }
    }

    public static class UserConfig
    implements JSONReader,
    XMLable {
        public static final String XML_TAG = "UserConfig";
        private String tableDataName;
        private String usernameField;
        private String passwordField;

        public String getTableDataName() {
            return this.tableDataName;
        }

        public void setTableDataName(String string) {
            this.tableDataName = string;
        }

        public String getUsernameField() {
            return this.usernameField;
        }

        public void setUsernameField(String string) {
            this.usernameField = string;
        }

        public String getPasswordField() {
            return this.passwordField;
        }

        public void setPasswordField(String string) {
            this.passwordField = string;
        }

        public void readXML(XMLableReader xMLableReader) {
            String string;
            if (xMLableReader.isChildNode() && (string = xMLableReader.getTagName()).equals("UserConfigAttr")) {
                this.tableDataName = xMLableReader.getAttr("tabledata");
                this.usernameField = xMLableReader.getAttr("username");
                this.passwordField = xMLableReader.getAttr("password");
            }
        }

        public void writeXML(XMLPrintWriter xMLPrintWriter) {
            xMLPrintWriter.startTAG("UserConfigAttr");
            if (StringUtils.isNotBlank(this.tableDataName)) {
                xMLPrintWriter.attr("tabledata", this.tableDataName);
            }
            if (StringUtils.isNotBlank(this.usernameField)) {
                xMLPrintWriter.attr("username", this.usernameField);
            }
            if (StringUtils.isNotBlank(this.passwordField)) {
                xMLPrintWriter.attr("password", this.passwordField);
            }
            xMLPrintWriter.end();
        }

        public void readJSON(JSONObject jSONObject) throws JSONException {
            this.tableDataName = jSONObject.getString("up_tabledata");
            this.usernameField = jSONObject.getString("up_user");
            this.passwordField = jSONObject.getString("up_password");
        }

        public Object clone() throws CloneNotSupportedException {
            return super.clone();
        }
    }
}

