/*
 * Decompiled with CFR 0.152.
 */
package com.fr.privilege.providers.ldap;

import com.fr.base.FRContext;
import com.fr.base.StringUtils;
import com.fr.privilege.authority.Authority;
import com.fr.privilege.providers.ldap.LDAPAuthenticationProvider;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapContext;

public class LDAPUtils {
    private LDAPUtils() {
    }

    public static void closeContext(LdapContext ldapContext) {
        try {
            if (ldapContext != null) {
                ldapContext.close();
            }
        }
        catch (NamingException namingException) {
            FRContext.getLogger().warning(namingException.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Authority[] retrievalAuthority(String string, LDAPAuthenticationProvider lDAPAuthenticationProvider, LdapContext ldapContext) {
        Authority[] authorityArray = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = lDAPAuthenticationProvider.getSearchBase();
        String string3 = lDAPAuthenticationProvider.getRoleAttribute();
        String string4 = string3 = StringUtils.isBlank(string3) ? "memberOf" : string3;
        if (ldapContext != null) {
            if (!StringUtils.isBlank(string) && !StringUtils.isBlank(lDAPAuthenticationProvider.getPrincipalSuffix())) {
                string = string + lDAPAuthenticationProvider.getPrincipalSuffix();
            }
            SearchControls searchControls = new SearchControls();
            searchControls.setSearchScope(2);
            searchControls.setReturningAttributes(new String[]{string3});
            String string5 = "(&(objectClass=user)(userPrincipalName=" + string + "))";
            try {
                NamingEnumeration<SearchResult> namingEnumeration = ldapContext.search(string2, string5, searchControls);
                if (namingEnumeration != null && namingEnumeration.hasMoreElements()) {
                    SearchResult searchResult = (SearchResult)namingEnumeration.nextElement();
                    Attributes attributes = searchResult.getAttributes();
                    if (attributes == null) {
                        Authority[] authorityArray2 = null;
                        return authorityArray2;
                    }
                    NamingEnumeration<? extends Attribute> namingEnumeration2 = attributes.getAll();
                    while (namingEnumeration2.hasMoreElements()) {
                        Attribute attribute = (Attribute)namingEnumeration2.nextElement();
                        if (!attribute.getID().equals(string3)) continue;
                        NamingEnumeration<?> namingEnumeration3 = attribute.getAll();
                        while (namingEnumeration3.hasMoreElements()) {
                            String[] stringArray = ((String)namingEnumeration3.nextElement()).split(",");
                            String string6 = stringArray[0].substring(3);
                            arrayList.add(string6);
                        }
                    }
                }
                authorityArray = new Authority[arrayList.size()];
                for (int i = 0; i < authorityArray.length; ++i) {
                    authorityArray[i] = new Authority(arrayList.get(i).toString());
                }
            }
            catch (NamingException namingException) {
                FRContext.getLogger().log(Level.WARNING, namingException.getMessage());
            }
            finally {
                LDAPUtils.closeContext(ldapContext);
            }
        }
        return authorityArray;
    }
}

