/*
 * Decompiled with CFR 0.152.
 */
package com.fr.privilege.vote;

import com.fr.base.ArrayUtils;
import com.fr.base.FRContext;
import com.fr.privilege.Privilege;
import com.fr.privilege.authentication.Authentication;
import com.fr.privilege.authority.Authority;
import com.fr.privilege.vote.Vote;

public class DefaultVote
implements Vote {
    private static DefaultVote defaultVote;

    private DefaultVote() {
    }

    public static DefaultVote getDefaultVote() {
        if (defaultVote == null) {
            defaultVote = new DefaultVote();
        }
        return defaultVote;
    }

    public boolean vote(Authentication authentication, Privilege privilege) {
        if (privilege == null) {
            return true;
        }
        Object[] objectArray = privilege.neededAuthority();
        if (ArrayUtils.isEmpty(objectArray)) {
            return true;
        }
        if (!FRContext.getPrivilegeManager().usePrivilege()) {
            return true;
        }
        if (authentication == null) {
            return false;
        }
        if (!authentication.isAuthenticated()) {
            return false;
        }
        Authority[] authorityArray = authentication.getAuthorities();
        for (int i = 0; i < authorityArray.length; ++i) {
            Authority authority = authorityArray[i];
            for (int j = 0; j < objectArray.length; ++j) {
                Object object = objectArray[j];
                if (!((Authority)object).equals(authority)) continue;
                return true;
            }
        }
        return false;
    }
}

