/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report;

import com.fr.base.BaseUtils;
import com.fr.base.FCloneable;
import com.fr.base.StringUtils;
import com.fr.base.Style;
import com.fr.base.core.BaseCoreUtils;
import com.fr.base.core.serializable.ImageSerializable;
import com.fr.base.xml.XMLObject;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLReadable;
import com.fr.base.xml.XMLableReader;
import com.fr.data.core.DataXMLUtils;
import com.fr.report.CellElement;
import com.fr.report.cellElement.BarcodeAttr;
import com.fr.report.cellElement.BarcodePresent;
import com.fr.report.cellElement.CellExpandAttr;
import com.fr.report.cellElement.CellGUIAttr;
import com.fr.report.cellElement.CellInsertPolicyAttr;
import com.fr.report.cellElement.CellPageAttr;
import com.fr.report.cellElement.DictPresent;
import com.fr.report.cellElement.Present;
import com.fr.report.cellElement.core.CellElementAttribute;
import com.fr.report.cellElement.core.DSColumn;
import com.fr.report.cellElement.core.EM;
import com.fr.report.highlight.HighlightGroup;
import com.fr.report.io.xml.ReportXMLUtils;
import com.fr.report.io.xml.SynchronizedNameWidget;
import com.fr.report.io.xml.SynchronizedStyleList;
import com.fr.report.io.xml.SynchronizedVersion;
import com.fr.report.js.NameJavaScriptGroup;
import com.fr.report.parameter.Parameter;
import com.fr.report.script.Primitive;
import com.fr.report.web.ui.Widget;
import java.awt.Image;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public abstract class AbstractCellElement
implements CellElement {
    protected Style style = Style.DEFAULT_STYLE;
    protected EM optionalAttributes = EM.EMPTY_ATTR;
    protected Map attributes = null;
    protected transient Object value = Primitive.NULL;

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object object) {
        this.value = object;
    }

    public Iterator attributeKeyIterator() {
        if (this.attributes == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        return this.attributes.keySet().iterator();
    }

    public void setAttribute(Object object, Object object2) {
        if (object == null) {
            return;
        }
        if (object2 == null) {
            this.removeAttribute(object);
            return;
        }
        if (this.attributes == null) {
            this.attributes = new HashMap();
        }
        this.attributes.put(object, object2);
    }

    public Object getAttribute(Object object) {
        return this.attributes == null ? null : this.attributes.get(object);
    }

    public Object removeAttribute(Object object) {
        Object var2_2 = null;
        if (this.attributes != null && object != null) {
            var2_2 = this.attributes.remove(object);
            if (this.attributes.size() == 0) {
                this.attributes = null;
            }
        }
        return var2_2;
    }

    public Style getStyle() {
        if (this.style == null) {
            this.style = Style.DEFAULT_STYLE;
        }
        return this.style;
    }

    public void setStyle(Style style) {
        this.style = style;
    }

    public NameJavaScriptGroup getNameHyperlinkGroup() {
        return (NameJavaScriptGroup)this.optionalAttributes.get(CellElementAttribute.NAMEHYPERLINKGROUP);
    }

    public void setNameHyperlinkGroup(NameJavaScriptGroup nameJavaScriptGroup) {
        if (nameJavaScriptGroup == null) {
            this.optionalAttributes.remove(CellElementAttribute.NAMEHYPERLINKGROUP);
            if (this.optionalAttributes.size() == 0) {
                this.optionalAttributes = EM.EMPTY_ATTR;
            }
            return;
        }
        if (this.optionalAttributes == EM.EMPTY_ATTR) {
            this.optionalAttributes = new EM();
        }
        this.optionalAttributes.put(CellElementAttribute.NAMEHYPERLINKGROUP, nameJavaScriptGroup);
    }

    public HighlightGroup getHighlightGroup() {
        return (HighlightGroup)this.optionalAttributes.get(CellElementAttribute.HIGHLIGHTGROUP);
    }

    public void setHighlightGroup(HighlightGroup highlightGroup) {
        if (highlightGroup == null) {
            this.optionalAttributes.remove(CellElementAttribute.HIGHLIGHTGROUP);
            if (this.optionalAttributes.size() == 0) {
                this.optionalAttributes = EM.EMPTY_ATTR;
            }
            return;
        }
        if (this.optionalAttributes == EM.EMPTY_ATTR) {
            this.optionalAttributes = new EM();
        }
        this.optionalAttributes.put(CellElementAttribute.HIGHLIGHTGROUP, highlightGroup);
    }

    public Present getPresent() {
        return (Present)this.optionalAttributes.get(CellElementAttribute.PRESENT);
    }

    public void setPresent(Present present) {
        if (present == null) {
            this.optionalAttributes.remove(CellElementAttribute.PRESENT);
            if (this.optionalAttributes.size() == 0) {
                this.optionalAttributes = EM.EMPTY_ATTR;
            }
            return;
        }
        if (this.optionalAttributes == EM.EMPTY_ATTR) {
            this.optionalAttributes = new EM();
        }
        this.optionalAttributes.put(CellElementAttribute.PRESENT, present);
    }

    public CellGUIAttr getCellGUIAttr() {
        return (CellGUIAttr)this.optionalAttributes.get(CellElementAttribute.CELLGUIATTR);
    }

    public void setCellGUIAttr(CellGUIAttr cellGUIAttr) {
        if (cellGUIAttr == null) {
            this.optionalAttributes.remove(CellElementAttribute.CELLGUIATTR);
            if (this.optionalAttributes.size() == 0) {
                this.optionalAttributes = EM.EMPTY_ATTR;
            }
            return;
        }
        if (this.optionalAttributes == EM.EMPTY_ATTR) {
            this.optionalAttributes = new EM();
        }
        this.optionalAttributes.put(CellElementAttribute.CELLGUIATTR, cellGUIAttr);
    }

    public CellExpandAttr getCellExpandAttr() {
        return (CellExpandAttr)this.optionalAttributes.get(CellElementAttribute.CELLEXPANDATTR);
    }

    public void setCellExpandAttr(CellExpandAttr cellExpandAttr) {
        if (cellExpandAttr == null) {
            this.optionalAttributes.remove(CellElementAttribute.CELLEXPANDATTR);
            if (this.optionalAttributes.size() == 0) {
                this.optionalAttributes = EM.EMPTY_ATTR;
            }
            return;
        }
        if (this.optionalAttributes == EM.EMPTY_ATTR) {
            this.optionalAttributes = new EM();
        }
        this.optionalAttributes.put(CellElementAttribute.CELLEXPANDATTR, cellExpandAttr);
    }

    public CellInsertPolicyAttr getCellInsertPolicyAttr() {
        return (CellInsertPolicyAttr)this.optionalAttributes.get(CellElementAttribute.CELLINSERTPOLICYATTR);
    }

    public void setCellInsertPolicyAttr(CellInsertPolicyAttr cellInsertPolicyAttr) {
        if (cellInsertPolicyAttr == null) {
            this.optionalAttributes.remove(CellElementAttribute.CELLINSERTPOLICYATTR);
            if (this.optionalAttributes.size() == 0) {
                this.optionalAttributes = EM.EMPTY_ATTR;
            }
            return;
        }
        if (this.optionalAttributes == EM.EMPTY_ATTR) {
            this.optionalAttributes = new EM();
        }
        this.optionalAttributes.put(CellElementAttribute.CELLINSERTPOLICYATTR, cellInsertPolicyAttr);
    }

    public Widget getWidget() {
        return (Widget)this.optionalAttributes.get(CellElementAttribute.WIDGET);
    }

    public void setWidget(Widget widget) {
        if (widget == null) {
            this.optionalAttributes.remove(CellElementAttribute.WIDGET);
            if (this.optionalAttributes.size() == 0) {
                this.optionalAttributes = EM.EMPTY_ATTR;
            }
            return;
        }
        if (this.optionalAttributes == EM.EMPTY_ATTR) {
            this.optionalAttributes = new EM();
        }
        this.optionalAttributes.put(CellElementAttribute.WIDGET, widget);
    }

    public CellPageAttr getCellPageAttr() {
        return (CellPageAttr)this.optionalAttributes.get(CellElementAttribute.PAGE);
    }

    public void setCellPageAttr(CellPageAttr cellPageAttr) {
        if (cellPageAttr == null) {
            this.optionalAttributes.remove(CellElementAttribute.PAGE);
            if (this.optionalAttributes.size() == 0) {
                this.optionalAttributes = EM.EMPTY_ATTR;
            }
            return;
        }
        if (this.optionalAttributes == EM.EMPTY_ATTR) {
            this.optionalAttributes = new EM();
        }
        this.optionalAttributes.put(CellElementAttribute.PAGE, cellPageAttr);
    }

    public String getScript() {
        return (String)this.optionalAttributes.get(CellElementAttribute.SCRIPT);
    }

    public void setScript(String string) {
        if (string == null) {
            this.optionalAttributes.remove(CellElementAttribute.SCRIPT);
            if (this.optionalAttributes.size() == 0) {
                this.optionalAttributes = EM.EMPTY_ATTR;
            }
            return;
        }
        if (this.optionalAttributes == EM.EMPTY_ATTR) {
            this.optionalAttributes = new EM();
        }
        this.optionalAttributes.put(CellElementAttribute.SCRIPT, string);
    }

    public EM getOptionalAttributes() {
        return this.optionalAttributes;
    }

    public void setOptionalAttributes(EM eM) {
        this.optionalAttributes = eM;
    }

    public void readXML(XMLableReader xMLableReader) {
        String string;
        if (xMLableReader.isAttr()) {
            string = xMLableReader.getAttr("c");
            if (string != null) {
                this.setColumn(Math.max(Integer.parseInt(string), 0));
            }
            if ((string = xMLableReader.getAttr("r")) != null) {
                this.setRow(Math.max(Integer.parseInt(string), 0));
            }
            if ((string = xMLableReader.getAttr("cs")) != null) {
                this.setColumnSpan(Math.max(Integer.parseInt(string), 1));
            }
            if ((string = xMLableReader.getAttr("rs")) != null) {
                this.setRowSpan(Math.max(Integer.parseInt(string), 1));
            }
            if ((string = xMLableReader.getAttr("s")) != null) {
                SynchronizedStyleList.getSynchronizedStyleList(Thread.currentThread()).put(Integer.parseInt(string), this);
            }
        }
        if (xMLableReader.isChildNode()) {
            String string2 = xMLableReader.getTagName();
            if ("Object".equals(string2) || string2.equals("O")) {
                Object object = ReportXMLUtils.readObject(xMLableReader, true, this);
                if (object instanceof Parameter) {
                    object = SynchronizedNameWidget.get(((Parameter)object).getName());
                }
                this.setValue(object);
            } else if ("Style".equals(string2) || string2.equals("CellStyle")) {
                string = xMLableReader.getAttr("index");
                if (string != null) {
                    SynchronizedStyleList.getSynchronizedStyleList(Thread.currentThread()).put(Integer.parseInt(string), this);
                }
            } else if ("Present".equals(string2)) {
                this.setPresent(ReportXMLUtils.readPresent(xMLableReader));
            } else if ("NameJavaScriptGroup".equals(string2) || "NameHyperlinkGroup".equals(string2) || "NameHyperlinks".equals(string2) || "HyperlinkMap".equals(string2)) {
                NameJavaScriptGroup nameJavaScriptGroup = new NameJavaScriptGroup();
                xMLableReader.readXMLObject(nameJavaScriptGroup);
                this.setNameHyperlinkGroup(nameJavaScriptGroup);
            } else if ("HighlightList".equals(string2)) {
                HighlightGroup highlightGroup = new HighlightGroup();
                xMLableReader.readXMLObject(highlightGroup);
                this.setHighlightGroup(highlightGroup);
            } else if ("Expand".equals(string2)) {
                SynchronizedVersion synchronizedVersion;
                CellExpandAttr cellExpandAttr = new CellExpandAttr();
                xMLableReader.readXMLObject(cellExpandAttr);
                this.setCellExpandAttr(cellExpandAttr);
                if (!(this.getValue() instanceof DSColumn) && (synchronizedVersion = SynchronizedVersion.getSynchronizedVersion(Thread.currentThread())).getVersion() == 6.1) {
                    cellExpandAttr.setDirection((byte)2);
                }
            } else if ("CellGUIAttr".equals(string2)) {
                XMLObject xMLObject = new XMLObject(new CellGUIAttr()){

                    public void readXML(XMLableReader xMLableReader) {
                        if (xMLableReader.isAttr()) {
                            ((CellGUIAttr)this.obj).readXML(xMLableReader);
                        } else if (xMLableReader.isChildNode()) {
                            String string = xMLableReader.getTagName();
                            if ("Widget".equals(string) || "CellEditorDef".equals(string)) {
                                AbstractCellElement.this.setWidget(ReportXMLUtils.readCellWidget(xMLableReader));
                            } else {
                                ((CellGUIAttr)this.obj).readXML(xMLableReader);
                            }
                        }
                    }
                };
                xMLableReader.readXMLObject(xMLObject);
                this.setCellGUIAttr((CellGUIAttr)xMLObject.getObject());
            } else if (CellInsertPolicyAttr.XML_TAG.equals(string2)) {
                CellInsertPolicyAttr cellInsertPolicyAttr = new CellInsertPolicyAttr();
                xMLableReader.readXMLObject(cellInsertPolicyAttr);
                this.setCellInsertPolicyAttr(cellInsertPolicyAttr);
            } else if ("Widget".equals(string2) || "CellEditorDef".equals(string2)) {
                this.setWidget(ReportXMLUtils.readWidget(xMLableReader));
            } else if ("CellPageAttr".equals(string2) || "CellAttr".equals(string2)) {
                CellPageAttr cellPageAttr = new CellPageAttr();
                xMLableReader.readXMLObject(cellPageAttr);
                this.setCellPageAttr(cellPageAttr);
            } else if ("Script".equals(string2) && (string = xMLableReader.getElementValue()) != null) {
                this.setScript(string);
            } else if ("CellExpandAttr".equals(string2)) {
                final CellExpandAttr cellExpandAttr = new CellExpandAttr();
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        if (xMLableReader.isAttr()) {
                            String string = xMLableReader.getAttr("direction");
                            if (string != null) {
                                cellExpandAttr.setDirection((byte)Integer.parseInt(string));
                            } else {
                                cellExpandAttr.setDirection((byte)0);
                            }
                            string = xMLableReader.getAttr("parentDefault");
                            if (string != null) {
                                cellExpandAttr.setLeftParentDefault(string.equalsIgnoreCase("true"));
                                cellExpandAttr.setUpParentDefault(string.equalsIgnoreCase("true"));
                            }
                            if ((string = xMLableReader.getAttr("leftParentDefault")) != null) {
                                cellExpandAttr.setLeftParentDefault(string.equalsIgnoreCase("true"));
                            }
                            if ((string = xMLableReader.getAttr("left")) != null) {
                                cellExpandAttr.setLeftParentColumnRow(BaseUtils.convertCellStringToColumnRow(string));
                                cellExpandAttr.setLeftParentDefault(false);
                            }
                            if ((string = xMLableReader.getAttr("upParentDefault")) != null) {
                                cellExpandAttr.setUpParentDefault(string.equalsIgnoreCase("true"));
                            }
                            if ((string = xMLableReader.getAttr("up")) != null) {
                                cellExpandAttr.setUpParentColumnRow(BaseUtils.convertCellStringToColumnRow(string));
                                cellExpandAttr.setUpParentDefault(false);
                            }
                        }
                    }
                });
                this.setCellExpandAttr(cellExpandAttr);
            } else if ("BarcodeAttr".equals(string2)) {
                BarcodeAttr barcodeAttr = new BarcodeAttr();
                xMLableReader.readXMLObject(barcodeAttr);
                this.setPresent(new BarcodePresent(barcodeAttr));
            } else if ("Dict".equals(string2) || "Map".equals(string2) || "MapFactory".equals(string2)) {
                this.setPresent(new DictPresent(DataXMLUtils.readXMLDictionary(xMLableReader)));
            } else if ("Hyperlink".equals(string2)) {
                this.setNameHyperlinkGroup(new NameJavaScriptGroup(ReportXMLUtils.readJavaScript(xMLableReader)));
            } else if ("Location".equals(string2)) {
                string = xMLableReader.getAttr("column");
                if (string != null) {
                    this.setColumn(Integer.parseInt(string));
                } else {
                    string = xMLableReader.getAttr("c");
                    if (string != null) {
                        this.setColumn(Integer.parseInt(string));
                    }
                }
                string = xMLableReader.getAttr("row");
                if (string != null) {
                    this.setRow(Integer.parseInt(string));
                } else {
                    string = xMLableReader.getAttr("r");
                    if (string != null) {
                        this.setRow(Integer.parseInt(string));
                    }
                }
                string = xMLableReader.getAttr("columnSpan");
                if (string != null) {
                    this.setColumnSpan(Integer.parseInt(string));
                } else {
                    string = xMLableReader.getAttr("columnCount");
                    if (string != null) {
                        this.setColumnSpan(Integer.parseInt(string));
                    }
                }
                string = xMLableReader.getAttr("rowSpan");
                if (string != null) {
                    this.setRowSpan(Integer.parseInt(string));
                } else {
                    string = xMLableReader.getAttr("rowCount");
                    if (string != null) {
                        this.setRowSpan(Integer.parseInt(string));
                    }
                }
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        String string;
        Object object = this.getValue();
        if (object != null) {
            ReportXMLUtils.writeObject(xMLPrintWriter, object);
        }
        if ((object = this.getNameHyperlinkGroup()) != null) {
            ((NameJavaScriptGroup)object).writeXML(xMLPrintWriter);
        }
        if ((object = this.getHighlightGroup()) != null && ((HighlightGroup)object).size() > 0) {
            ((HighlightGroup)object).writeXML(xMLPrintWriter);
        }
        if ((object = this.getPresent()) != null) {
            ReportXMLUtils.writeXMLable(xMLPrintWriter, (Present)object, "Present");
        }
        if ((object = this.getCellGUIAttr()) != null) {
            ((CellGUIAttr)object).writeXML(xMLPrintWriter);
        }
        if ((object = this.getCellExpandAttr()) != null) {
            ((CellExpandAttr)object).writeXML(xMLPrintWriter);
        }
        if ((object = this.getCellInsertPolicyAttr()) != null) {
            ((CellInsertPolicyAttr)object).writeXML(xMLPrintWriter);
        }
        if ((object = this.getWidget()) != null) {
            ReportXMLUtils.writeXMLable(xMLPrintWriter, (Widget)object, "Widget");
        }
        if ((object = this.getCellPageAttr()) != null) {
            ((CellPageAttr)object).writeXML(xMLPrintWriter);
        }
        if (StringUtils.isNotBlank(string = this.getScript())) {
            xMLPrintWriter.startTAG("Script").textNode(string).end();
        }
    }

    public CellElement deriveCellElement(int n, int n2) {
        try {
            AbstractCellElement abstractCellElement = (AbstractCellElement)super.clone();
            abstractCellElement.setRow(n2);
            abstractCellElement.setColumn(n);
            return abstractCellElement;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
    }

    public CellElement deriveCellElement(int n, int n2, int n3, int n4) {
        try {
            AbstractCellElement abstractCellElement = (AbstractCellElement)super.clone();
            abstractCellElement.setRow(n2);
            abstractCellElement.setRowSpan(n4);
            abstractCellElement.setColumn(n);
            abstractCellElement.setColumnSpan(n3);
            return abstractCellElement;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
    }

    public CellElement clone(int n, int n2, int n3, int n4) throws CloneNotSupportedException {
        AbstractCellElement abstractCellElement = (AbstractCellElement)this.clone();
        abstractCellElement.setColumn(n);
        abstractCellElement.setRow(n2);
        abstractCellElement.setColumnSpan(n3);
        abstractCellElement.setRowSpan(n4);
        return abstractCellElement;
    }

    public Object clone() throws CloneNotSupportedException {
        AbstractCellElement abstractCellElement = (AbstractCellElement)super.clone();
        if (this.getValue() != null && this.getValue() instanceof FCloneable) {
            abstractCellElement.setValue(((FCloneable)this.getValue()).clone());
        }
        abstractCellElement.optionalAttributes = (EM)this.optionalAttributes.clone();
        if (this.getStyle() != null) {
            abstractCellElement.setStyle(this.getStyle());
        }
        if (this.attributes != null) {
            abstractCellElement.attributes = BaseCoreUtils.cloneMap(this.attributes);
        }
        return abstractCellElement;
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        Object object = objectInputStream.readObject();
        if (object != null) {
            this.value = object instanceof ImageSerializable ? ((ImageSerializable)object).getImage() : object;
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.value != null && this.value instanceof Image) {
            ImageSerializable imageSerializable = new ImageSerializable((Image)this.value);
            objectOutputStream.writeObject(imageSerializable);
        } else {
            objectOutputStream.writeObject(this.value);
        }
    }
}

