/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report;

import com.fr.base.core.ComparatorUtils;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLReadable;
import com.fr.base.xml.XMLableReader;
import com.fr.report.AbstractTableDataSource;
import com.fr.report.FineBook;
import com.fr.report.PageSet;
import com.fr.report.PageSetChain;
import com.fr.report.PaperSetting;
import com.fr.report.RWorkSheet;
import com.fr.report.Report;
import com.fr.report.ReportWebAttr;
import com.fr.report.ResultWorkBook;
import com.fr.report.WorkSheet;
import com.fr.report.core.PackedReport;
import com.fr.report.io.ReportExportAttr;
import com.fr.report.io.xml.ReportXMLUtils;
import com.fr.report.io.xml.SynchronizedStyleList;
import com.fr.report.io.xml.SynchronizedVersion;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractFineBook
extends AbstractTableDataSource
implements FineBook {
    private List nameReportList = new ArrayList(1);
    protected ReportWebAttr reportWebAttr = null;
    protected ReportExportAttr reportExportAttr = null;

    protected void addReport(Report report) {
        this.addReport(null, report);
    }

    protected void addReport(String string, Report report) {
        this.addReport(this.getReportCount(), string, report);
    }

    protected void addReport(int n, Report report) {
        this.addReport(n, null, report);
    }

    protected abstract void setWorkBook(Report var1, FineBook var2);

    protected void addReport(int n, String string, Report report) {
        if (string == null) {
            string = this.__autoReportName();
        }
        this.nameReportList.add(n, new NameReport(string, report));
        this.setWorkBook(report, this);
    }

    private NameReport __getNameReportByIndex(int n) {
        return (NameReport)this.nameReportList.get(n);
    }

    public String getReportName(int n) {
        return this.__getNameReportByIndex(n).name;
    }

    public void setReportName(int n, String string) {
        this.__getNameReportByIndex(n).name = string;
    }

    public Report getReport(int n) {
        return this.__getNameReportByIndex(n).report;
    }

    protected void setReport(int n, Report report) {
        this.setWorkBook(report, this);
        this.__getNameReportByIndex(n).report = report;
    }

    protected void setReport(int n, String string, Report report) {
        this.setWorkBook(report, this);
        this.__getNameReportByIndex(n).name = string;
        this.__getNameReportByIndex(n).report = report;
    }

    protected int getReportIndex(Report report) {
        int n = this.nameReportList.size();
        for (int i = 0; i < n; ++i) {
            if (((NameReport)this.nameReportList.get(i)).report != report) continue;
            return i;
        }
        return -1;
    }

    public void removeReport(String string) {
        int n = this.nameReportList.size();
        for (int i = 0; i < n; ++i) {
            NameReport nameReport = this.__getNameReportByIndex(i);
            if (!ComparatorUtils.equals(string, nameReport.name)) continue;
            this.setWorkBook(nameReport.report, null);
            this.nameReportList.remove(i);
            return;
        }
    }

    public void removeReports() {
        int n = this.nameReportList.size();
        for (int i = 0; i < n; ++i) {
            this.setWorkBook(this.__getNameReportByIndex(i).report, null);
        }
        this.nameReportList.clear();
    }

    public void removeReport(int n) {
        NameReport nameReport = (NameReport)this.nameReportList.remove(n);
        this.setWorkBook(nameReport.report, null);
    }

    public int getReportCount() {
        return this.nameReportList.size();
    }

    public ReportWebAttr getReportWebAttr() {
        return this.reportWebAttr;
    }

    public void setReportWebAttr(ReportWebAttr reportWebAttr) {
        this.reportWebAttr = reportWebAttr;
    }

    public void setReportExportAttr(ReportExportAttr reportExportAttr) {
        this.reportExportAttr = reportExportAttr;
    }

    public ReportExportAttr getReportExportAttr() {
        return this.reportExportAttr;
    }

    public PageSetChain generateReportPageSet(List list) {
        PageSet[] pageSetArray = new PageSet[this.getReportCount()];
        for (int i = 0; i < pageSetArray.length; ++i) {
            pageSetArray[i] = this.getReport(i).generateReportPageSet(list == null ? null : (PaperSetting)list.get(i));
        }
        return new PageSetChain(pageSetArray);
    }

    public Object clone() throws CloneNotSupportedException {
        AbstractFineBook abstractFineBook = (AbstractFineBook)super.clone();
        ArrayList<NameReport> arrayList = new ArrayList<NameReport>();
        int n = this.nameReportList.size();
        for (int i = 0; i < n; ++i) {
            NameReport nameReport = (NameReport)((NameReport)this.nameReportList.get(i)).clone();
            this.setWorkBook(nameReport.report, abstractFineBook);
            arrayList.add(nameReport);
        }
        abstractFineBook.nameReportList = arrayList;
        if (this.getReportWebAttr() != null) {
            abstractFineBook.setReportWebAttr((ReportWebAttr)this.getReportWebAttr().clone());
        }
        if (this.getReportExportAttr() != null) {
            abstractFineBook.setReportExportAttr((ReportExportAttr)this.getReportExportAttr().clone());
        }
        return abstractFineBook;
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        ReportExportAttr reportExportAttr;
        super.writeXML(xMLPrintWriter);
        ReportWebAttr reportWebAttr = this.getReportWebAttr();
        if (reportWebAttr != null) {
            xMLPrintWriter.startTAG("ReportWebAttr");
            reportWebAttr.writeXML(xMLPrintWriter);
            xMLPrintWriter.end();
        }
        if ((reportExportAttr = this.getReportExportAttr()) != null) {
            reportExportAttr.writeXML(xMLPrintWriter);
        }
        int n = this.getReportCount();
        for (int i = 0; i < n; ++i) {
            Report report = this.getReport(i);
            if (report == null) continue;
            String string = report.getClass().getName();
            xMLPrintWriter.startTAG("Report").attr("class", string).attr("name", this.getReportName(i));
            report.writeXML(xMLPrintWriter);
            xMLPrintWriter.end();
        }
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (string.equals("Version")) {
                String string2 = xMLableReader.getElementValue();
                if (string2 != null) {
                    SynchronizedVersion synchronizedVersion = SynchronizedVersion.getSynchronizedVersion(Thread.currentThread());
                    synchronizedVersion.setVersion(Double.parseDouble(string2));
                }
            } else if (string.equals("XMLVersion")) {
                String string3 = xMLableReader.getElementValue();
                if (string3 != null) {
                    SynchronizedVersion synchronizedVersion = SynchronizedVersion.getSynchronizedVersion(Thread.currentThread());
                    synchronizedVersion.setXmlVersionByString(string3);
                }
            } else if ("StyleList".equals(string) || "CellStyleList".equals(string)) {
                final SynchronizedStyleList synchronizedStyleList = SynchronizedStyleList.getSynchronizedStyleList(Thread.currentThread());
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        String string;
                        if (xMLableReader.isChildNode() && ("Style".equals(string = xMLableReader.getTagName()) || "CellStyle".equals(string))) {
                            synchronizedStyleList.addStyle(ReportXMLUtils.readFullStyle(xMLableReader));
                        }
                    }
                });
            } else if ("Report".equals(string)) {
                Report report = null;
                String string4 = xMLableReader.getAttr("class");
                if (string4 != null) {
                    report = ReportXMLUtils.readReportFromClassName(string4);
                }
                if (!SynchronizedVersion.isAfterREPORT_REFECT_FOR65_2_XML_VERSION() && this instanceof ResultWorkBook && report instanceof WorkSheet) {
                    report = new RWorkSheet();
                }
                String string5 = "";
                string4 = xMLableReader.getAttr("title");
                if (string4 != null) {
                    string5 = string4;
                }
                if ((string4 = xMLableReader.getAttr("name")) != null) {
                    string5 = string4;
                }
                if (report instanceof PackedReport) {
                    xMLableReader.readXMLObject(report);
                    this.addReport(string5, report);
                } else {
                    this.addReport(string5, report);
                    xMLableReader.readXMLObject(report);
                }
            } else if ("ReportWebAttr".equals(string)) {
                ReportWebAttr reportWebAttr = this.getReportWebAttr();
                if (reportWebAttr == null) {
                    reportWebAttr = new ReportWebAttr();
                    this.setReportWebAttr(reportWebAttr);
                }
                xMLableReader.readXMLObject(reportWebAttr);
            } else if ("ReportExportAttr".equals(string)) {
                ReportExportAttr reportExportAttr = new ReportExportAttr();
                xMLableReader.readXMLObject(reportExportAttr);
                this.setReportExportAttr(reportExportAttr);
            }
        }
    }

    private String __autoReportName() {
        String string = "sheet1";
        int n = this.nameReportList.size();
        for (int i = 0; i < n; ++i) {
            String string2 = this.__getNameReportByIndex(i).name;
            if (!string2.toLowerCase().matches("^sheet[1-9]\\d*$")) continue;
            String string3 = "sheet" + (Integer.parseInt(string2.toLowerCase().substring(5)) + 1);
            if (i != this.getReportCount() - 1 && this.containsIgnoreCase(string3)) continue;
            string = string3;
            break;
        }
        return string;
    }

    private boolean containsIgnoreCase(String string) {
        int n = this.nameReportList.size();
        for (int i = 0; i < n; ++i) {
            String string2 = this.__getNameReportByIndex(i).name;
            if (!string2.equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    private static class NameReport
    implements Cloneable,
    Serializable {
        private static final long serialVersionUID = -4090072956249660275L;
        private String name;
        private Report report;

        private NameReport(String string, Report report) {
            this.name = string;
            this.report = report;
        }

        public Object clone() throws CloneNotSupportedException {
            NameReport nameReport = (NameReport)super.clone();
            nameReport.report = (Report)this.report.clone();
            return nameReport;
        }
    }
}

