/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report;

import com.fr.base.ColumnRow;
import com.fr.base.FRContext;
import com.fr.base.FRFont;
import com.fr.base.Style;
import com.fr.base.background.Background;
import com.fr.base.core.ComparatorUtils;
import com.fr.base.core.FRCoreContext;
import com.fr.base.core.GraphHelper;
import com.fr.base.xml.BaseXMLUtils;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLReadable;
import com.fr.base.xml.XMLableReader;
import com.fr.data.condition.Condition;
import com.fr.data.condition.LiteConditionUtils;
import com.fr.report.ArrayPageSet;
import com.fr.report.Cell;
import com.fr.report.CellCase;
import com.fr.report.CellElement;
import com.fr.report.DefaultCellCase;
import com.fr.report.DefaultCellElement;
import com.fr.report.Elem;
import com.fr.report.FineBook;
import com.fr.report.FloatElement;
import com.fr.report.PageSet;
import com.fr.report.PaperSetting;
import com.fr.report.Report;
import com.fr.report.ReportHF;
import com.fr.report.ReportPageAttr;
import com.fr.report.ReportSettings;
import com.fr.report.cellElement.CellPageAttr;
import com.fr.report.cellElement.Formula;
import com.fr.report.core.DynamicValueList;
import com.fr.report.core.PaintUtils;
import com.fr.report.core.ScriptUtils;
import com.fr.report.core.SheetPageGenerator;
import com.fr.report.core.headerfooter.HFElement;
import com.fr.report.io.xml.HFElementXML;
import com.fr.report.io.xml.ReportXMLUtils;
import com.fr.report.io.xml.SynchronizedStyleList;
import com.fr.report.io.xml.SynchronizedVersion;
import com.fr.util.Utils;
import java.awt.FontMetrics;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;

public abstract class AbstractReport
implements Report {
    protected FineBook fineBook;
    public DynamicValueList rowHeightList_DEC = new DynamicValueList(19, 50);
    public DynamicValueList columnWidthList_DEC = new DynamicValueList(72, 20);
    protected List floatElementList = new ArrayList();
    private CellCase cellcase;
    protected ReportSettings reportSettings = null;
    protected ReportPageAttr reportPageAttr = null;
    protected Hashtable headerHash = new Hashtable();
    protected Hashtable footerHash = new Hashtable();

    public AbstractReport() {
        this.initReportAttributes();
        this.cellcase = new DefaultCellCase();
    }

    protected void initReportAttributes() {
        this.reportSettings = new ReportSettings();
    }

    public ReportSettings getReportSettings() {
        return this.reportSettings;
    }

    public void setReportSettings(ReportSettings reportSettings) {
        this.reportSettings = reportSettings;
    }

    public ReportPageAttr getReportPageAttr() {
        return this.reportPageAttr;
    }

    public void setReportPageAttr(ReportPageAttr reportPageAttr) {
        this.reportPageAttr = reportPageAttr;
    }

    public ReportHF getHeader(int n) {
        ReportHF reportHF = (ReportHF)this.headerHash.get(new Integer(n));
        if (reportHF == null && n == 0) {
            reportHF = new ReportHF();
            this.headerHash.put(new Integer(n), reportHF);
        }
        return reportHF;
    }

    public void setHeader(int n, ReportHF reportHF) {
        if (reportHF == null) {
            this.headerHash.remove(new Integer(n));
        } else {
            this.headerHash.put(new Integer(n), reportHF);
        }
    }

    public ReportHF getFooter(int n) {
        ReportHF reportHF = (ReportHF)this.footerHash.get(new Integer(n));
        if (reportHF == null && n == 0) {
            reportHF = new ReportHF();
            this.footerHash.put(new Integer(n), reportHF);
        }
        return reportHF;
    }

    public void setFooter(int n, ReportHF reportHF) {
        if (reportHF == null) {
            this.footerHash.remove(new Integer(n));
        } else {
            this.footerHash.put(new Integer(n), reportHF);
        }
    }

    public void addCellElement(CellElement cellElement, boolean bl) {
        this.cellcase.add(cellElement, bl);
    }

    public Object getCellValue(int n, int n2) {
        CellElement cellElement = (CellElement)this.cellcase.get(n, n2);
        return cellElement != null ? cellElement.getValue() : null;
    }

    public void setCellValue(int n, int n2, Object object) {
        CellElement cellElement = (CellElement)this.cellcase.get(n, n2);
        if (cellElement != null) {
            cellElement.setValue(object);
            return;
        }
        this.cellcase.add(new DefaultCellElement(n, n2, object), true);
    }

    public CellElement getCellElement(int n, int n2) {
        return (CellElement)this.cellcase.get(n, n2);
    }

    public boolean removeCellElement(CellElement cellElement) {
        if (cellElement == null) {
            return true;
        }
        if (this.cellcase.get(cellElement.getColumn(), cellElement.getRow()) == cellElement) {
            this.cellcase.removeCell(cellElement.getColumn(), cellElement.getRow());
            return true;
        }
        return false;
    }

    public CellElement removeCellElement(int n, int n2) {
        return (CellElement)this.cellcase.removeCell(n, n2);
    }

    public void removeAllCellElements() {
        this.cellcase.clear();
    }

    public void removeRow(int n) {
        this.cellcase.removeRow(n);
        this.__mod_column_row(new RemoveRowMOD(n));
    }

    public void removeColumn(int n) {
        this.cellcase.removeColumn(n);
        this.__mod_column_row(new RemoveColumnMOD(n));
    }

    public void insertRow(int n) {
        this.cellcase.insertRow(n);
        this.__mod_column_row(new InsertRowMOD(n));
    }

    public void insertColumn(int n) {
        this.cellcase.insertColumn(n);
        this.__mod_column_row(new InsertColumnMOD(n));
    }

    public int getColumnCount() {
        return this.cellcase.getColumnCount();
    }

    public int getRowCount() {
        return this.cellcase.getRowCount();
    }

    public Iterator cellIterator() {
        return this.cellcase.cellIterator();
    }

    public Iterator intersect(int n, int n2, int n3, int n4) {
        return this.cellcase.intersect(n, n2, n3, n4);
    }

    public Iterator getColumn(int n) {
        return this.cellcase.getColumn(n);
    }

    public Iterator getRow(int n) {
        return this.cellcase.getRow(n);
    }

    public void merge(int n, int n2, int n3, int n4) {
        Cell cell = null;
        for (int i = n; i <= n2; ++i) {
            for (int j = n3; j <= n4; ++j) {
                CellElement cellElement = (CellElement)this.cellcase.get(j, i);
                if (cellElement == null) continue;
                if (cell == null) {
                    cell = cellElement;
                }
                this.cellcase.removeCell(cellElement.getColumn(), cellElement.getRow());
            }
        }
        if (cell != null) {
            cell.setColumn(n3);
            cell.setRow(n);
            cell.setColumnSpan(n4 - n3 + 1);
            cell.setRowSpan(n2 - n + 1);
        } else {
            cell = new DefaultCellElement(n3, n, n4 - n3 + 1, n2 - n + 1, null);
        }
        this.cellcase.add(cell, true);
    }

    public void recalculateCellCase() {
        if (this.cellcase != null) {
            this.cellcase.recalculate();
        }
    }

    public void setCellCase(CellCase cellCase) {
        this.cellcase = cellCase;
    }

    protected CellCase getCellCase() {
        return this.cellcase;
    }

    public void cacheCellElement(int n, int n2, boolean bl) {
        this.cellcase.toCache(n, n2, bl);
    }

    public void releaseCellElementCache() {
        this.cellcase.releaseCache();
    }

    public Object cloneWithoutCellCase() throws CloneNotSupportedException {
        AbstractReport abstractReport = (AbstractReport)super.clone();
        this.cloneWithoutCellCase4Report(abstractReport);
        return abstractReport;
    }

    protected void cloneWithoutCellCase4Report(AbstractReport abstractReport) throws CloneNotSupportedException {
        Object object;
        if (abstractReport == null) {
            return;
        }
        abstractReport.rowHeightList_DEC = (DynamicValueList)this.rowHeightList_DEC.clone();
        abstractReport.columnWidthList_DEC = (DynamicValueList)this.columnWidthList_DEC.clone();
        List list = null;
        try {
            list = (List)FRCoreContext.classForName(this.floatElementList.getClass().getName()).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            FRContext.getLogger().log(Level.WARNING, classNotFoundException.getMessage(), classNotFoundException);
        }
        catch (InstantiationException instantiationException) {
            FRContext.getLogger().log(Level.WARNING, instantiationException.getMessage(), instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            FRContext.getLogger().log(Level.WARNING, illegalAccessException.getMessage(), illegalAccessException);
        }
        if (list != null) {
            int n = this.floatElementList.size();
            for (int i = 0; i < n; ++i) {
                list.add(((FloatElement)this.floatElementList.get(i)).clone());
            }
            abstractReport.floatElementList = list;
        }
        abstractReport.cellcase = null;
        if (this.getReportSettings() != null) {
            abstractReport.setReportSettings((ReportSettings)this.getReportSettings().clone());
        }
        if (this.getReportPageAttr() != null) {
            abstractReport.setReportPageAttr((ReportPageAttr)this.getReportPageAttr().clone());
        }
        Hashtable hashtable = new Hashtable();
        Enumeration enumeration = this.headerHash.keys();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            hashtable.put(object, ((ReportHF)this.headerHash.get(object)).clone());
        }
        abstractReport.headerHash = hashtable;
        object = new Hashtable();
        Enumeration enumeration2 = this.footerHash.keys();
        while (enumeration2.hasMoreElements()) {
            Object k = enumeration2.nextElement();
            ((Hashtable)object).put(k, (Object)((ReportHF)this.footerHash.get(k)).clone());
        }
        abstractReport.footerHash = object;
    }

    public Object deriveClearReportWithReadOnlyAttr() throws CloneNotSupportedException {
        AbstractReport abstractReport = (AbstractReport)super.clone();
        abstractReport.cellcase = new DefaultCellCase();
        abstractReport.floatElementList = new ArrayList();
        abstractReport.rowHeightList_DEC = new DynamicValueList(19, 50);
        abstractReport.columnWidthList_DEC = new DynamicValueList(72, 20);
        return abstractReport;
    }

    public FineBook getBook() {
        return this.fineBook;
    }

    public PageSet generateReportPageSet(PaperSetting paperSetting) {
        return new ArrayPageSet(new SheetPageGenerator(this, paperSetting).getReportPages(), false);
    }

    protected void setBook(FineBook fineBook) {
        this.fineBook = fineBook;
    }

    public void addCellElement(CellElement cellElement) {
        this.addCellElement(cellElement, true);
    }

    protected Object __mod_column_row(MOD_COLUMN_ROW mOD_COLUMN_ROW) {
        if (mOD_COLUMN_ROW == null || mOD_COLUMN_ROW.intercept()) {
            return null;
        }
        mOD_COLUMN_ROW.mod_cwidth_rheight();
        Iterator iterator = this.cellIterator();
        while (iterator.hasNext()) {
            CellElement cellElement = (CellElement)iterator.next();
            this.insertChangeCellElement(cellElement, mOD_COLUMN_ROW);
        }
        return mOD_COLUMN_ROW;
    }

    protected void insertChangeCellElement(CellElement cellElement, MOD_COLUMN_ROW mOD_COLUMN_ROW) {
        Object object = cellElement.getValue();
        if (object instanceof Formula) {
            Formula formula = (Formula)object;
            formula.setContent(mOD_COLUMN_ROW.mod_fm_statement(formula.getContent().substring(1)));
        }
    }

    public int getRowHeight(int n) {
        return this.rowHeightList_DEC.get(n);
    }

    public void setRowHeight(int n, int n2) {
        if (n2 < 0) {
            n2 = 0;
        }
        this.rowHeightList_DEC.set(n, n2);
    }

    public int getColumnWidth(int n) {
        return this.columnWidthList_DEC.get(n);
    }

    public void setColumnWidth(int n, int n2) {
        if (n2 < 0) {
            n2 = 0;
        }
        this.columnWidthList_DEC.set(n, n2);
    }

    public void addFloatElement(FloatElement floatElement) {
        this.floatElementList.add(floatElement);
    }

    public FloatElement getFloatElement(String string) {
        int n = this.floatElementList.size();
        for (int i = 0; i < n; ++i) {
            FloatElement floatElement = (FloatElement)this.floatElementList.get(i);
            if (!ComparatorUtils.equals(floatElement.getName(), string)) continue;
            return floatElement;
        }
        return null;
    }

    public Iterator floatIterator() {
        return this.floatElementList.iterator();
    }

    public FloatElement removeFloatElement(String string) {
        for (int i = this.floatElementList.size() - 1; i >= 0; --i) {
            FloatElement floatElement = (FloatElement)this.floatElementList.get(i);
            if (!ComparatorUtils.equals(floatElement.getName(), string)) continue;
            this.floatElementList.remove(i);
            return floatElement;
        }
        return null;
    }

    public boolean removeFloatElement(FloatElement floatElement) {
        int n = this.floatElementList.indexOf(floatElement);
        boolean bl = false;
        if (n >= 0) {
            bl = this.floatElementList.remove(floatElement);
        }
        return bl;
    }

    public void removeAllFloatElements() {
        this.floatElementList.clear();
    }

    public void bringFloatElementToFront(FloatElement floatElement) {
        int n = this.floatElementList.indexOf(floatElement);
        if (n == -1 || n == this.floatElementList.size() - 1) {
            return;
        }
        this.floatElementList.remove(n);
        this.floatElementList.add(floatElement);
    }

    public void sendFloatElementToBack(FloatElement floatElement) {
        int n = this.floatElementList.indexOf(floatElement);
        if (n == -1 || n == 0) {
            return;
        }
        this.floatElementList.remove(n);
        this.floatElementList.add(0, floatElement);
    }

    public void bringFloatElementForward(FloatElement floatElement) {
        int n = this.floatElementList.indexOf(floatElement);
        if (n == -1 || n == this.floatElementList.size() - 1) {
            return;
        }
        Utils.swap(this.floatElementList, n, n + 1);
    }

    public void sendFloatElementBackward(FloatElement floatElement) {
        int n = this.floatElementList.indexOf(floatElement);
        if (n == -1 || n == 0) {
            return;
        }
        Utils.swap(this.floatElementList, n, n - 1);
    }

    public void shrinkTOFitRowHeightForCellElement(CellElement cellElement) {
        int n;
        if (cellElement == null) {
            return;
        }
        int n2 = cellElement.getRow();
        int n3 = this.rowHeightList_DEC.getRangeValue(n2, n2 + (n = cellElement.getRowSpan()));
        if (n3 == 0) {
            return;
        }
        int n4 = this.columnWidthList_DEC.getRangeValue(cellElement.getColumn(), cellElement.getColumn() + cellElement.getColumnSpan());
        if (n4 < 5) {
            return;
        }
        int n5 = PaintUtils.analyzeCellElementPreferredHeight(cellElement, n4);
        if (n == 1) {
            if (this.rowHeightList_DEC.get(n2) > 0) {
                this.rowHeightList_DEC.set(n2, Math.max(n5, this.rowHeightList_DEC.get(n2)));
            }
        } else {
            int n6 = n5 - n3;
            if (n6 > 0) {
                boolean bl;
                int n7;
                int n8 = n2 + n - 1;
                int n9 = n;
                for (n7 = n2; n7 <= n8; ++n7) {
                    if (this.rowHeightList_DEC.get(n7) != 0) continue;
                    --n9;
                }
                for (n7 = n2; n7 <= n8; ++n7) {
                    if (this.rowHeightList_DEC.get(n7) <= 0) continue;
                    this.rowHeightList_DEC.set(n7, this.rowHeightList_DEC.get(n7) + n6 / n9);
                }
                n7 = 0;
                for (int i = n2; i <= n8 && n7 < n6 % n9; ++i) {
                    if (this.rowHeightList_DEC.get(i) <= 0) continue;
                    this.rowHeightList_DEC.set(i, this.rowHeightList_DEC.get(i) + 1);
                    ++n7;
                }
                CellPageAttr cellPageAttr = cellElement.getCellPageAttr();
                Style style = cellElement.getStyle();
                if (style == null) {
                    style = Style.DEFAULT_STYLE;
                }
                boolean bl2 = bl = cellPageAttr != null && !cellPageAttr.isRepeat();
                if (bl && style.getRotation() == 0 && style.getVerticalText() == 0 && style.getTextStyle() == 0 && n9 != 1) {
                    FRFont fRFont = style.getFRFont();
                    FontMetrics fontMetrics = GraphHelper.getFontMetrics(fRFont);
                    int n10 = fontMetrics.getHeight() + style.getLineSpacing();
                    int n11 = style.getSpacingBefore();
                    int n12 = 0;
                    int n13 = 1;
                    for (int i = n2; i <= n8; ++i) {
                        if (this.rowHeightList_DEC.get(i) <= 0) continue;
                        n12 = n11;
                        if (n13 == n9) {
                            this.rowHeightList_DEC.set(i, this.rowHeightList_DEC.get(i) - n12);
                        } else {
                            n11 = (this.rowHeightList_DEC.get(i) - n12) % n10;
                            if (n11 != 0) {
                                n11 = n10 - n11;
                            }
                            this.rowHeightList_DEC.set(i, this.rowHeightList_DEC.get(i) + n11 - (n13 == 1 ? 0 : n12));
                        }
                        ++n13;
                    }
                }
            }
        }
    }

    public void shrinkTOFitColumnWidthForCellElement(CellElement cellElement) {
        if (cellElement == null) {
            return;
        }
        int n = cellElement.getRow();
        int n2 = cellElement.getRowSpan();
        int n3 = this.rowHeightList_DEC.getRangeValue(n, n + n2);
        int n4 = this.columnWidthList_DEC.getRangeValue(cellElement.getColumn(), cellElement.getColumn() + cellElement.getColumnSpan());
        if (n4 == 0) {
            return;
        }
        double d = PaintUtils.getPreferredWidth(cellElement, n3);
        if (cellElement.getColumnSpan() == 1) {
            this.columnWidthList_DEC.set(cellElement.getColumn(), (int)Math.max(d, (double)this.columnWidthList_DEC.get(cellElement.getColumn())));
        } else {
            int n5;
            int n6 = cellElement.getColumn() + cellElement.getColumnSpan() - 1;
            double d2 = d - (double)this.columnWidthList_DEC.getRangeValue(cellElement.getColumn(), n6 + 1);
            int n7 = cellElement.getColumnSpan();
            for (n5 = cellElement.getColumn(); n5 <= n6; ++n5) {
                if (this.columnWidthList_DEC.get(n5) != 0) continue;
                --n7;
            }
            if (d2 > 0.0) {
                for (n5 = cellElement.getColumn(); n5 <= n6; ++n5) {
                    if (this.columnWidthList_DEC.get(n5) <= 0) continue;
                    this.columnWidthList_DEC.set(n5, (int)((double)this.columnWidthList_DEC.get(n5) + d2 / (double)n7));
                }
            }
            n5 = 0;
            for (int i = cellElement.getColumn(); i <= n6 && (double)n5 < d2 % (double)n7; ++i) {
                if (this.columnWidthList_DEC.get(i) <= 0) continue;
                this.columnWidthList_DEC.set(i, this.columnWidthList_DEC.get(i) + 1);
                ++n5;
            }
        }
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (string.equals("Version")) {
                String string2 = xMLableReader.getElementValue();
                if (string2 != null) {
                    SynchronizedVersion synchronizedVersion = SynchronizedVersion.getSynchronizedVersion(Thread.currentThread());
                    synchronizedVersion.setVersion(Double.parseDouble(string2));
                }
            } else if (string.equals("XMLVersion")) {
                String string3 = xMLableReader.getElementValue();
                if (string3 != null) {
                    SynchronizedVersion synchronizedVersion = SynchronizedVersion.getSynchronizedVersion(Thread.currentThread());
                    synchronizedVersion.setXmlVersionByString(string3);
                }
            } else if (string.equals("Header")) {
                this.readReportHF(xMLableReader, true);
            } else if (string.equals("Footer")) {
                this.readReportHF(xMLableReader, false);
            } else if ("ReportSettings".equals(string) || "ReportSetting".equals(string)) {
                ReportSettings reportSettings = this.getReportSettings();
                if (reportSettings == null) {
                    reportSettings = new ReportSettings();
                    this.setReportSettings(reportSettings);
                }
                xMLableReader.readXMLObject(reportSettings);
            } else if ("ReportPageAttr".equals(string)) {
                ReportPageAttr reportPageAttr = new ReportPageAttr();
                xMLableReader.readXMLObject(reportPageAttr);
                this.setReportPageAttr(reportPageAttr);
            } else if ("StyleList".equals(string) || "CellStyleList".equals(string)) {
                final SynchronizedStyleList synchronizedStyleList = SynchronizedStyleList.getSynchronizedStyleList(Thread.currentThread());
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        String string;
                        if (xMLableReader.isChildNode() && ("Style".equals(string = xMLableReader.getTagName()) || "CellStyle".equals(string))) {
                            synchronizedStyleList.addStyle(ReportXMLUtils.readFullStyle(xMLableReader));
                        }
                    }
                });
            } else if ("CellElementList".equals(string)) {
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        if (xMLableReader.isChildNode()) {
                            CellElement cellElement = AbstractReport.this.createDefaultCellElementCase();
                            xMLableReader.readXMLObject(cellElement);
                            AbstractReport.this.addCellElement(cellElement, false);
                        }
                    }
                });
            } else if (string.equals("RowHeight")) {
                this.rowHeightList_DEC = this.readDynamicValueList(xMLableReader);
            } else if (string.equals("ColumnWidth")) {
                this.columnWidthList_DEC = this.readDynamicValueList(xMLableReader);
            } else if (string.equals("FloatElementList")) {
                ReportXMLUtils.readReportFloatElementList(xMLableReader, this);
            }
        }
    }

    protected abstract CellElement createDefaultCellElementCase();

    protected void readReportHF(XMLableReader xMLableReader, boolean bl) {
        final ReportHF reportHF = new ReportHF();
        String string = xMLableReader.getAttr("reportPageType");
        if (string != null) {
            if (bl) {
                this.setHeader(Integer.parseInt(string), reportHF);
            } else {
                this.setFooter(Integer.parseInt(string), reportHF);
            }
        } else if (bl) {
            this.setHeader(0, reportHF);
        } else {
            this.setFooter(0, reportHF);
        }
        string = xMLableReader.getAttr("printBackground");
        if (string != null) {
            reportHF.setPrintBackground(Boolean.valueOf(string));
        }
        xMLableReader.readXMLObject(new XMLReadable(){

            public void readXML(XMLableReader xMLableReader) {
                if (xMLableReader.isChildNode()) {
                    String string = xMLableReader.getTagName();
                    if (string.equals("LeftList")) {
                        ArrayList arrayList = reportHF.getLeftList();
                        if (arrayList == null) {
                            arrayList = new ArrayList();
                            reportHF.setLeftList(arrayList);
                        }
                        arrayList.clear();
                        AbstractReport.this.readHFElement(arrayList, xMLableReader);
                    } else if (string.equals("CenterList")) {
                        ArrayList arrayList = reportHF.getCenterList();
                        if (arrayList == null) {
                            arrayList = new ArrayList();
                            reportHF.setCenterList(arrayList);
                        }
                        arrayList.clear();
                        AbstractReport.this.readHFElement(arrayList, xMLableReader);
                    } else if (string.equals("RightList")) {
                        ArrayList arrayList = reportHF.getRightList();
                        if (arrayList == null) {
                            arrayList = new ArrayList();
                            reportHF.setRightList(arrayList);
                        }
                        arrayList.clear();
                        AbstractReport.this.readHFElement(arrayList, xMLableReader);
                    } else if (string.equals("Background")) {
                        reportHF.setBackground(BaseXMLUtils.readBackground(xMLableReader));
                    }
                }
            }
        });
    }

    private void readHFElement(final List list, XMLableReader xMLableReader) {
        xMLableReader.readXMLObject(new XMLReadable(){

            public void readXML(XMLableReader xMLableReader) {
                HFElement hFElement;
                if (xMLableReader.isChildNode() && (hFElement = HFElementXML.readXML(xMLableReader)) != null) {
                    list.add(hFElement);
                }
            }
        });
    }

    private DynamicValueList readDynamicValueList(XMLableReader xMLableReader) {
        DynamicValueList dynamicValueList = null;
        String string = xMLableReader.getAttr("defaultValue");
        if (string != null) {
            try {
                dynamicValueList = new DynamicValueList(Integer.parseInt(string));
            }
            catch (NumberFormatException numberFormatException) {
                dynamicValueList = new DynamicValueList((int)Double.parseDouble(string));
            }
        }
        if (dynamicValueList != null && (string = xMLableReader.getElementValue()) != null) {
            String[] stringArray = Utils.splitString(string, ',');
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i] == null || stringArray[i].length() <= 0) continue;
                dynamicValueList.set(i, (int)Double.parseDouble(stringArray[i]));
            }
        }
        return dynamicValueList;
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        Elem elem;
        Object object;
        ReportPageAttr reportPageAttr;
        ReportSettings reportSettings = this.getReportSettings();
        if (reportSettings != null) {
            reportSettings.writeXML(xMLPrintWriter);
        }
        if ((reportPageAttr = this.getReportPageAttr()) != null) {
            xMLPrintWriter.startTAG("ReportPageAttr");
            reportPageAttr.writeXML(xMLPrintWriter);
            xMLPrintWriter.end();
        }
        Enumeration enumeration = this.headerHash.keys();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            this.writeHF(xMLPrintWriter, (ReportHF)this.headerHash.get(object), true, (Integer)object);
        }
        object = this.footerHash.keys();
        while (object.hasMoreElements()) {
            Object e = object.nextElement();
            this.writeHF(xMLPrintWriter, (ReportHF)this.footerHash.get(e), false, (Integer)e);
        }
        xMLPrintWriter.startTAG("RowHeight");
        this.writeDynamicValueList(xMLPrintWriter, this.rowHeightList_DEC);
        xMLPrintWriter.end();
        xMLPrintWriter.startTAG("ColumnWidth");
        this.writeDynamicValueList(xMLPrintWriter, this.columnWidthList_DEC);
        xMLPrintWriter.end();
        int n = this.floatElementList.size();
        if (n > 0) {
            xMLPrintWriter.startTAG("FloatElementList");
            for (int i = 0; i < n; ++i) {
                elem = (FloatElement)this.floatElementList.get(i);
                ReportXMLUtils.writeFloatElement(xMLPrintWriter, elem);
            }
            xMLPrintWriter.end();
        }
        xMLPrintWriter.startTAG("CellElementList");
        Iterator iterator = this.cellcase.cellIterator();
        while (iterator.hasNext()) {
            elem = (CellElement)iterator.next();
            ReportXMLUtils.writeCellElement(xMLPrintWriter, (CellElement)elem);
        }
        xMLPrintWriter.end();
    }

    private void writeHF(XMLPrintWriter xMLPrintWriter, ReportHF reportHF, boolean bl, int n) {
        List list;
        List list2;
        if (bl) {
            xMLPrintWriter.startTAG("Header");
        } else {
            xMLPrintWriter.startTAG("Footer");
        }
        xMLPrintWriter.attr("reportPageType", n);
        if (!reportHF.isPrintBackground()) {
            xMLPrintWriter.attr("printBackground", reportHF.isPrintBackground());
        }
        Background background = reportHF.getBackground();
        BaseXMLUtils.writeBackground(xMLPrintWriter, background);
        List list3 = reportHF.getLeftList();
        if (list3 != null) {
            this.writeHFElementList(xMLPrintWriter, list3, "LeftList");
        }
        if ((list2 = reportHF.getCenterList()) != null) {
            this.writeHFElementList(xMLPrintWriter, list2, "CenterList");
        }
        if ((list = reportHF.getRightList()) != null) {
            this.writeHFElementList(xMLPrintWriter, list, "RightList");
        }
        xMLPrintWriter.end();
    }

    private void writeHFElementList(XMLPrintWriter xMLPrintWriter, List list, String string) {
        xMLPrintWriter.startTAG(string);
        for (int i = 0; i < list.size(); ++i) {
            HFElementXML.writeXML(xMLPrintWriter, (HFElement)list.get(i));
        }
        xMLPrintWriter.end();
    }

    private void writeDynamicValueList(XMLPrintWriter xMLPrintWriter, DynamicValueList dynamicValueList) {
        xMLPrintWriter.attr("defaultValue", dynamicValueList.getDefaultValue());
        StringBuffer stringBuffer = new StringBuffer();
        int n = dynamicValueList.size();
        for (int i = 0; i <= n; ++i) {
            if (i != 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(dynamicValueList.get(i));
        }
        xMLPrintWriter.textNode(stringBuffer.toString());
    }

    public Object clone() throws CloneNotSupportedException {
        AbstractReport abstractReport = (AbstractReport)super.clone();
        this.clone4Report(abstractReport);
        return abstractReport;
    }

    protected Object clone4Report(AbstractReport abstractReport) throws CloneNotSupportedException {
        this.cloneWithoutCellCase4Report(abstractReport);
        abstractReport.cellcase = (CellCase)this.cellcase.clone();
        return abstractReport;
    }

    private class RemoveRowMOD
    implements MOD_COLUMN_ROW {
        private int rowIndex;

        public RemoveRowMOD(int n) {
            this.rowIndex = n;
        }

        public boolean intercept() {
            return this.rowIndex < 0;
        }

        public ColumnRow mod_columnrow(ColumnRow columnRow) {
            if (columnRow != null && columnRow.getRow() > this.rowIndex) {
                columnRow = ColumnRow.valueOf(columnRow.getColumn(), columnRow.getRow() - 1);
            }
            return columnRow;
        }

        public void mod_condition(Condition condition) {
            LiteConditionUtils.convertLiteConditionWhenRemoveRow(condition, this.rowIndex);
        }

        public void mod_cwidth_rheight() {
            AbstractReport.this.rowHeightList_DEC.remove(this.rowIndex);
        }

        public String mod_fm_statement(String string) {
            return ScriptUtils.moveRow(string, this.rowIndex, -1);
        }
    }

    private class RemoveColumnMOD
    implements MOD_COLUMN_ROW {
        private int columnIndex;

        public RemoveColumnMOD(int n) {
            this.columnIndex = n;
        }

        public boolean intercept() {
            return this.columnIndex < 0;
        }

        public ColumnRow mod_columnrow(ColumnRow columnRow) {
            if (columnRow != null && columnRow.getColumn() > this.columnIndex) {
                columnRow = ColumnRow.valueOf(columnRow.getColumn() - 1, columnRow.getRow());
            }
            return columnRow;
        }

        public void mod_condition(Condition condition) {
            LiteConditionUtils.convertLiteConditionWhenRemoveCol(condition, this.columnIndex);
        }

        public void mod_cwidth_rheight() {
            AbstractReport.this.columnWidthList_DEC.remove(this.columnIndex);
        }

        public String mod_fm_statement(String string) {
            return ScriptUtils.moveColumn(string, this.columnIndex, -1);
        }
    }

    private class InsertRowMOD
    implements MOD_COLUMN_ROW {
        private int rowIndex;

        public InsertRowMOD(int n) {
            this.rowIndex = n;
        }

        public boolean intercept() {
            return this.rowIndex < 0;
        }

        public ColumnRow mod_columnrow(ColumnRow columnRow) {
            if (columnRow != null && columnRow.getRow() >= this.rowIndex) {
                columnRow = ColumnRow.valueOf(columnRow.getColumn(), columnRow.getRow() + 1);
            }
            return columnRow;
        }

        public void mod_condition(Condition condition) {
            LiteConditionUtils.convertLiteConditionWhenInsertRow(condition, this.rowIndex);
        }

        public void mod_cwidth_rheight() {
            AbstractReport.this.rowHeightList_DEC.insert(this.rowIndex);
        }

        public String mod_fm_statement(String string) {
            return ScriptUtils.moveRow(string, this.rowIndex, 1);
        }
    }

    private class InsertColumnMOD
    implements MOD_COLUMN_ROW {
        private int columnIndex;

        public InsertColumnMOD(int n) {
            this.columnIndex = n;
        }

        public boolean intercept() {
            return this.columnIndex < 0;
        }

        public ColumnRow mod_columnrow(ColumnRow columnRow) {
            if (columnRow != null && columnRow.getColumn() >= this.columnIndex) {
                columnRow = ColumnRow.valueOf(columnRow.getColumn() + 1, columnRow.getRow());
            }
            return columnRow;
        }

        public void mod_condition(Condition condition) {
            LiteConditionUtils.convertLiteConditionWhenInsertCol(condition, this.columnIndex);
        }

        public void mod_cwidth_rheight() {
            AbstractReport.this.columnWidthList_DEC.insert(this.columnIndex);
        }

        public String mod_fm_statement(String string) {
            return ScriptUtils.moveColumn(string, this.columnIndex, 1);
        }
    }

    protected static interface MOD_COLUMN_ROW {
        public boolean intercept();

        public void mod_cwidth_rheight();

        public String mod_fm_statement(String var1);

        public ColumnRow mod_columnrow(ColumnRow var1);

        public void mod_condition(Condition var1);
    }
}

