/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report;

import com.fr.base.core.ComparatorUtils;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLReadable;
import com.fr.base.xml.XMLableReader;
import com.fr.data.TableData;
import com.fr.data.core.DataXMLUtils;
import com.fr.report.TableDataSource;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractTableDataSource
implements TableDataSource {
    private static final String XML_TAG = "TableDataMap";
    protected List tableDataNameList = new ArrayList();
    protected List tableDataList = new ArrayList();

    public Iterator getTableDataNameIterator() {
        return this.tableDataNameList.iterator();
    }

    public TableData getTableData(String string) {
        int n = this.tableDataNameList.indexOf(string);
        if (n == -1) {
            return null;
        }
        return (TableData)this.tableDataList.get(n);
    }

    public void putTableData(String string, TableData tableData) {
        if (string == null) {
            return;
        }
        int n = this.tableDataNameList.indexOf(string);
        if (tableData == null) {
            if (n != -1) {
                this.tableDataNameList.remove(n);
                this.tableDataList.remove(n);
            }
        } else if (n != -1) {
            this.tableDataList.set(n, tableData);
        } else {
            this.tableDataNameList.add(string);
            this.tableDataList.add(tableData);
        }
    }

    public boolean renameTableData(String string, String string2) {
        if (string2 == null || string == null) {
            return false;
        }
        if (ComparatorUtils.equals(string, string2)) {
            return false;
        }
        int n = this.tableDataNameList.indexOf(string);
        if (n == -1) {
            return false;
        }
        this.tableDataNameList.set(n, string2);
        return true;
    }

    public void removeTableData(String string) {
        if (string == null) {
            return;
        }
        int n = this.tableDataNameList.indexOf(string);
        if (n != -1) {
            this.tableDataNameList.remove(n);
            this.tableDataList.remove(n);
        }
    }

    public void clearAllTableData() {
        this.tableDataNameList.clear();
        this.tableDataList.clear();
    }

    public void readXML(XMLableReader xMLableReader) {
        String string;
        if (xMLableReader.isChildNode() && (string = xMLableReader.getTagName()).equals(XML_TAG)) {
            xMLableReader.readXMLObject(new XMLReadable(){

                public void readXML(XMLableReader xMLableReader) {
                    if (xMLableReader.isAttr()) {
                        AbstractTableDataSource.this.clearAllTableData();
                    }
                    if (xMLableReader.isChildNode()) {
                        String string = xMLableReader.getAttr("name");
                        if ("NameTableData".equals(xMLableReader.getTagName())) {
                            xMLableReader.readXMLObject(new XMLReadable(this, string){
                                private final /* synthetic */ String val$name;
                                private final /* synthetic */ 1 this$1;
                                {
                                    this.this$1 = var1_1;
                                    this.val$name = string;
                                }

                                public void readXML(XMLableReader xMLableReader) {
                                    if (xMLableReader.getTagName().equals("TableData")) {
                                        TableData tableData = DataXMLUtils.readXMLTableData(xMLableReader);
                                        1.access$000(this.this$1).putTableData(this.val$name, tableData);
                                    }
                                }
                            });
                        } else {
                            TableData tableData = DataXMLUtils.readXMLTableData(xMLableReader);
                            AbstractTableDataSource.this.putTableData(string, tableData);
                        }
                    }
                }

                static /* synthetic */ AbstractTableDataSource access$000(1 var0) {
                    return var0.AbstractTableDataSource.this;
                }
            });
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        if (this.tableDataNameList != null && this.tableDataNameList.size() > 0) {
            xMLPrintWriter.startTAG(XML_TAG);
            for (int i = 0; i < this.tableDataNameList.size(); ++i) {
                String string = (String)this.tableDataNameList.get(i);
                TableData tableData = (TableData)this.tableDataList.get(i);
                DataXMLUtils.writeXMLTableData(xMLPrintWriter, tableData, string);
            }
            xMLPrintWriter.end();
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

