/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report;

import com.fr.base.core.list.FRCacheList;
import com.fr.report.Cell;
import com.fr.report.CellCase;
import com.fr.report.CellElement;
import com.fr.report.core.ReportUtils;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class DefaultCellCase
implements CellCase {
    private List rowList;
    private int columnCount;

    public DefaultCellCase() {
        this(1, 1);
    }

    public DefaultCellCase(int n, int n2) {
        this.rowList = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            this.rowList.add(new Row(n2));
        }
        this.columnCount = n2;
    }

    public void toCache(int n, int n2, boolean bl) {
        if (!(this.rowList instanceof FRCacheList)) {
            List list = this.rowList;
            this.rowList = new FRCacheList(n, n2, "CE", bl);
            this.rowList.addAll(list);
            list.clear();
        }
    }

    public void releaseCache() {
        if (this.rowList instanceof FRCacheList) {
            this.rowList.clear();
        }
    }

    public Iterator cellIterator() {
        return new CellIterator();
    }

    public Iterator intersect(int n, int n2, int n3, int n4) {
        return new IntersectIterator(n, n2, n3, n4);
    }

    public Iterator getColumn(int n) {
        return new ColumnIterator(n);
    }

    public Iterator getRow(int n) {
        return new RowIterator(n);
    }

    public int getRowCount() {
        return this.rowList.size();
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public void add(Cell cell, boolean bl) {
        if (cell == null) {
            return;
        }
        int n = cell.getRow();
        int n2 = cell.getRowSpan();
        int n3 = cell.getColumn();
        int n4 = cell.getColumnSpan();
        if (n < 0 || n2 <= 0 || n3 < 0 || n4 <= 0) {
            return;
        }
        if (bl) {
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n4; ++j) {
                    this.removeCell(n3 + j, n + i);
                }
            }
        }
        this.__nailCellElement(cell);
        this.columnCount = Math.max(this.columnCount, n3 + n4);
    }

    public Cell get(int n, int n2) {
        if (n2 >= this.rowList.size() || n2 < 0) {
            return null;
        }
        Row row = (Row)this.rowList.get(n2);
        return row.getElement(n);
    }

    public Cell removeCell(int n, int n2) {
        Cell cell = this.get(n, n2);
        if (this.__liftCellElement(cell)) {
            if (cell.getColumn() + cell.getColumnSpan() == this.columnCount) {
                this.recalculateColumnCount();
            }
            if (cell.getRow() + cell.getRowSpan() == this.rowList.size()) {
                this.recalculateRowCount();
            }
            return cell;
        }
        return null;
    }

    public void clear() {
        this.rowList.clear();
        this.columnCount = 0;
    }

    public void insertColumn(int n) {
        int n2 = this.rowList.size();
        for (int i = 0; i < n2; ++i) {
            Row row = (Row)this.rowList.get(i);
            for (int j = row.width() - 1; j >= n; --j) {
                Cell cell = row.getElement(j);
                if (cell == null || cell.getColumn() != j || cell.getRow() != i) continue;
                cell.setColumn(cell.getColumn() + 1);
            }
            Cell cell = row.getElement(n);
            row.insert(n);
            if (cell == null || cell.getColumn() >= n) continue;
            if (cell.getRow() == i) {
                cell.setColumnSpan(cell.getColumnSpan() + 1);
            }
            row.setElement(n, cell);
        }
        ++this.columnCount;
    }

    public void insertRow(int n) {
        Cell cell;
        int n2;
        int n3;
        Row row;
        if (n > this.rowList.size()) {
            return;
        }
        for (int i = this.rowList.size() - 1; i >= n; --i) {
            row = (Row)this.rowList.get(i);
            n3 = row.width();
            for (n2 = 0; n2 < n3; ++n2) {
                cell = row.getElement(n2);
                if (cell == null || cell.getColumn() != n2 || cell.getRow() != i) continue;
                cell.setRow(cell.getRow() + 1);
            }
        }
        Row row2 = new Row();
        if (n < this.rowList.size()) {
            row = (Row)this.rowList.get(n);
            n3 = row.width();
            for (n2 = 0; n2 < n3; ++n2) {
                cell = row.getElement(n2);
                if (cell == null || cell.getRow() >= n) continue;
                if (cell.getColumn() == n2) {
                    cell.setRowSpan(cell.getRowSpan() + 1);
                }
                row2.setElement(n2, cell);
            }
        }
        this.rowList.add(n, row2);
    }

    public int removeColumn(int n) {
        Row row;
        int n2;
        int n3 = 0;
        if (n >= this.columnCount || n < 0) {
            return n3;
        }
        int n4 = this.rowList.size();
        for (n2 = 0; n2 < n4; ++n2) {
            row = (Row)this.rowList.get(n2);
            Cell cell = row.getElement(n);
            if (cell == null) continue;
            if (cell.getColumn() == n && cell.getRow() == n2) {
                this.__liftCellElement(cell);
                if (cell.getColumnSpan() > 1) {
                    cell.setColumn(cell.getColumn() + 1);
                    cell.setColumnSpan(cell.getColumnSpan() - 1);
                    this.__nailCellElement(cell);
                    continue;
                }
                ++n3;
                continue;
            }
            if (cell.getColumn() >= n || cell.getRow() != n2) continue;
            cell.setColumnSpan(cell.getColumnSpan() - 1);
        }
        n4 = this.rowList.size();
        for (n2 = 0; n2 < n4; ++n2) {
            row = (Row)this.rowList.get(n2);
            int n5 = row.width();
            for (int i = n + 1; i < n5; ++i) {
                Cell cell = row.getElement(i);
                if (cell == null || cell.getColumn() != i || cell.getRow() != n2) continue;
                cell.setColumn(cell.getColumn() - 1);
            }
        }
        n4 = this.rowList.size();
        for (n2 = 0; n2 < n4; ++n2) {
            ((Row)this.rowList.get(n2)).removeColumn(n);
        }
        --this.columnCount;
        return n3;
    }

    public int removeRow(int n) {
        int n2;
        int n3 = 0;
        if (n >= this.rowList.size() || n < 0) {
            return n3;
        }
        Row row = (Row)this.rowList.get(n);
        int n4 = row.width();
        for (n2 = 0; n2 < n4; ++n2) {
            Cell cell = row.getElement(n2);
            if (cell == null) continue;
            if (cell.getColumn() == n2 && cell.getRow() == n) {
                this.__liftCellElement(cell);
                if (cell.getRowSpan() > 1) {
                    cell.setRow(cell.getRow() + 1);
                    cell.setRowSpan(cell.getRowSpan() - 1);
                    this.__nailCellElement(cell);
                    continue;
                }
                ++n3;
                continue;
            }
            if (cell.getRow() >= n || cell.getColumn() != n2) continue;
            cell.setRowSpan(cell.getRowSpan() - 1);
        }
        n4 = this.rowList.size();
        for (n2 = n + 1; n2 < n4; ++n2) {
            row = (Row)this.rowList.get(n2);
            int n5 = row.width();
            for (int i = 0; i < n5; ++i) {
                Cell cell = row.getElement(i);
                if (cell == null || cell.getColumn() != i || cell.getRow() != n2) continue;
                cell.setRow(cell.getRow() - 1);
            }
        }
        this.rowList.remove(n);
        return n3;
    }

    public void recalculate() {
        this.recalculateRowCount();
        this.recalculateColumnCount();
    }

    private void recalculateColumnCount() {
        int n = 0;
        int n2 = this.rowList.size();
        for (int i = 0; i < n2; ++i) {
            n = Math.max(n, ((Row)this.rowList.get(i)).getNotNullWidth());
        }
        this.columnCount = n;
    }

    private void recalculateRowCount() {
        for (int i = this.rowList.size() - 1; i >= 0 && ((Row)this.rowList.get(i)).getNotNullWidth() == 0; --i) {
            this.rowList.remove(i);
        }
    }

    private void ensureCapacity(int n) {
        while (n > this.rowList.size()) {
            this.rowList.add(new Row());
        }
    }

    public void __nailCellElement(Cell cell) {
        int n = cell.getRow();
        int n2 = cell.getColumn();
        this.ensureCapacity(n + cell.getRowSpan());
        int n3 = cell.getRowSpan();
        for (int i = 0; i < n3; ++i) {
            Row row = (Row)this.rowList.get(n + i);
            int n4 = cell.getColumnSpan();
            for (int j = 0; j < n4; ++j) {
                row.setElement(n2 + j, cell);
            }
        }
    }

    public boolean __liftCellElement(Cell cell) {
        if (cell == null) {
            return false;
        }
        int n = cell.getRow();
        int n2 = cell.getColumn();
        int n3 = cell.getRowSpan();
        for (int i = 0; i < n3; ++i) {
            Row row = (Row)this.rowList.get(n + i);
            int n4 = cell.getColumnSpan();
            for (int j = 0; j < n4; ++j) {
                if (row.getElement(n2 + j) != cell) continue;
                row.setElement(n2 + j, null);
            }
        }
        return true;
    }

    public Object clone() throws CloneNotSupportedException {
        DefaultCellCase defaultCellCase = (DefaultCellCase)super.clone();
        defaultCellCase.rowList = new ArrayList(this.rowList.size());
        Iterator iterator = this.cellIterator();
        while (iterator.hasNext()) {
            CellElement cellElement = (CellElement)iterator.next();
            defaultCellCase.__nailCellElement((CellElement)cellElement.clone());
        }
        return defaultCellCase;
    }

    private class RowIterator
    implements Iterator {
        private int rowIndex;
        int current_column = -1;
        int next_column = 0;
        Cell next;

        public RowIterator(int n) {
            this.rowIndex = n;
            this.findNext();
        }

        public boolean hasNext() {
            return this.next != null;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("At last element");
            }
            Cell cell = this.next;
            this.findNext();
            return cell;
        }

        public void remove() {
            DefaultCellCase.this.removeCell(this.current_column, this.rowIndex);
        }

        private void findNext() {
            if (this.rowIndex < 0 || this.rowIndex >= DefaultCellCase.this.rowList.size()) {
                return;
            }
            Row row = (Row)DefaultCellCase.this.rowList.get(this.rowIndex);
            while (this.next_column < row.width()) {
                Cell cell = row.getElement(this.next_column);
                this.current_column = this.next_column++;
                if (cell == null || cell.getColumn() != this.current_column || cell.getRow() != this.rowIndex) continue;
                this.next = cell;
                return;
            }
            this.next = null;
        }
    }

    private class ColumnIterator
    implements Iterator {
        private int columnIndex;
        private int current_row = -1;
        private int next_row = 0;
        private Cell next;

        ColumnIterator(int n) {
            this.columnIndex = n;
            this.findNext();
        }

        public boolean hasNext() {
            return this.next != null;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("At last element");
            }
            Cell cell = this.next;
            this.findNext();
            return cell;
        }

        public void remove() {
            DefaultCellCase.this.removeCell(this.columnIndex, this.current_row);
        }

        private void findNext() {
            while (this.next_row < DefaultCellCase.this.rowList.size()) {
                Cell cell = ((Row)DefaultCellCase.this.rowList.get(this.next_row)).getElement(this.columnIndex);
                this.current_row = this.next_row++;
                if (cell == null || cell.getColumn() != this.columnIndex || cell.getRow() != this.current_row) continue;
                this.next = cell;
                return;
            }
            this.next = null;
        }
    }

    private class IntersectIterator
    implements Iterator {
        private int columnFrom;
        private int columnTo;
        private int rowFrom;
        private int rowTo;
        private int thisrow;
        private int thiscol;
        private int nextrow;
        private int nextcol;
        Cell next = null;

        private IntersectIterator(int n, int n2, int n3, int n4) {
            this.columnFrom = Math.max(n, 0);
            this.columnTo = Math.min(n + n3 - 1, DefaultCellCase.this.columnCount - 1);
            this.rowFrom = Math.max(n2, 0);
            this.rowTo = Math.min(n2 + n4 - 1, DefaultCellCase.this.rowList.size() - 1);
            this.thisrow = -1;
            this.thiscol = -1;
            this.nextrow = this.rowFrom;
            this.nextcol = this.columnFrom - 1;
            this.findNext();
        }

        public boolean hasNext() {
            return this.next != null;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("At last element");
            }
            Cell cell = this.next;
            this.thiscol = this.nextcol;
            this.thisrow = this.nextrow;
            this.findNext();
            return cell;
        }

        public void remove() {
            DefaultCellCase.this.removeCell(this.thiscol, this.thisrow);
        }

        private void findNext() {
            int n = this.nextcol + 1;
            for (int i = this.nextrow; i <= this.rowTo && DefaultCellCase.this.rowList.size() > i; ++i) {
                Row row = (Row)DefaultCellCase.this.rowList.get(i);
                while (n <= this.columnTo) {
                    Cell cell = row.getElement(n);
                    if (cell != null) {
                        Rectangle rectangle = ReportUtils.intersection(cell.getColumn(), cell.getColumn() + cell.getColumnSpan(), cell.getRow(), cell.getRow() + cell.getRowSpan(), this.columnFrom, this.columnTo + 1, this.rowFrom, this.rowTo + 1);
                        if (rectangle.width > 0 && rectangle.height > 0 && rectangle.x == n && rectangle.y == i) {
                            this.nextrow = i;
                            this.nextcol = n;
                            this.next = cell;
                            return;
                        }
                    }
                    ++n;
                }
                n = this.columnFrom;
            }
            this.next = null;
        }
    }

    private class CellIterator
    implements Iterator {
        int thisrow = -1;
        int thiscol = -1;
        int nextrow = 0;
        int nextcol = -1;
        Cell next = null;

        CellIterator() {
            this.findNext();
        }

        public boolean hasNext() {
            return this.next != null;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("At last element");
            }
            Cell cell = this.next;
            this.thiscol = this.nextcol;
            this.thisrow = this.nextrow;
            this.findNext();
            return cell;
        }

        public void remove() {
            DefaultCellCase.this.removeCell(this.thiscol, this.thisrow);
        }

        private void findNext() {
            int n = this.nextcol + 1;
            for (int i = this.nextrow; i < DefaultCellCase.this.rowList.size(); ++i) {
                Row row = (Row)DefaultCellCase.this.rowList.get(i);
                while (n < row.width()) {
                    Cell cell = row.getElement(n);
                    if (cell != null && cell.getColumn() == n && cell.getRow() == i) {
                        this.nextrow = i;
                        this.nextcol = n;
                        this.next = cell;
                        return;
                    }
                    ++n;
                }
                n = 0;
            }
            this.next = null;
        }
    }

    private static class Row
    implements Serializable,
    Cloneable {
        private static final long serialVersionUID = 4518514222514670793L;
        private Cell[] elementData = null;

        Row() {
        }

        Row(int n) {
            this.elementData = new Cell[n];
        }

        public void setElement(int n, Cell cell) {
            this.ensureCapacity(n + 1);
            this.elementData[n] = cell;
            if (cell == null) {
                this.shrink_array();
            }
        }

        private void shrink_array() {
            int n;
            for (n = this.elementData.length - 1; n >= 0 && this.elementData[n] == null; --n) {
            }
            if (n + 1 < this.width()) {
                Cell[] cellArray = this.elementData;
                this.elementData = new CellElement[n + 1];
                System.arraycopy(cellArray, 0, this.elementData, 0, this.elementData.length);
            }
        }

        public void insert(int n) {
            int n2 = this.width();
            if (n >= n2 || n < 0) {
                return;
            }
            this.ensureCapacity(n2 + 1);
            System.arraycopy(this.elementData, n, this.elementData, n + 1, n2 - n);
            this.elementData[n] = null;
        }

        public Cell getElement(int n) {
            if (n >= this.width() || n < 0) {
                return null;
            }
            return this.elementData[n];
        }

        public void removeColumn(int n) {
            int n2 = this.width();
            if (n >= n2 || n < 0) {
                return;
            }
            Cell[] cellArray = this.elementData;
            this.elementData = new CellElement[n2 - 1];
            if (n > 0) {
                System.arraycopy(cellArray, 0, this.elementData, 0, n);
            }
            System.arraycopy(cellArray, n + 1, this.elementData, n, this.elementData.length - n);
        }

        public int width() {
            return this.elementData == null ? 0 : this.elementData.length;
        }

        public int getNotNullWidth() {
            if (this.elementData == null) {
                return 0;
            }
            for (int i = this.elementData.length - 1; i >= 0; --i) {
                if (this.elementData[i] == null) continue;
                return i + 1;
            }
            return 0;
        }

        public String toString() {
            return "size:" + this.width();
        }

        private void ensureCapacity(int n) {
            if (this.elementData == null) {
                this.elementData = new CellElement[n];
            } else {
                int n2 = this.elementData.length;
                if (n > n2) {
                    Cell[] cellArray = this.elementData;
                    this.elementData = new CellElement[n];
                    System.arraycopy(cellArray, 0, this.elementData, 0, cellArray.length);
                }
            }
        }
    }
}

