/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report;

import com.fr.base.FRFont;
import com.fr.base.Style;
import com.fr.base.background.ColorBackground;
import com.fr.base.xml.XMLableReader;
import com.fr.report.CellElement;
import com.fr.report.DefaultCellElement;
import com.fr.report.RWorkSheet;
import com.fr.report.Report;
import java.awt.Color;

public class EditResultWorkSheet
extends RWorkSheet {
    protected CellElement createDefaultCellElementCase() {
        return new EditCellELement();
    }

    public static class EditCellELement
    extends DefaultCellElement {
        private static final int B = 2;
        private static final int I = 4;
        private static final int U = 8;
        private static final int ST = 16;
        private static final int BTOP = 2;
        private static final int BRIGHT = 4;
        private static final int BBOTTOM = 8;
        private static final int BLEFT = 16;
        private boolean valueDirty = false;
        private String fontName = null;
        private int fontSize = -1;
        private Color fontColor = null;
        private int fontStyle = -1;
        private int borderStyle = -1;
        private Color backgroundColor = null;
        private int horizontal_alignment = -1;
        private int vertical_alignment = -1;

        public void readXML(XMLableReader xMLableReader) {
            super.readXML(xMLableReader);
            if (xMLableReader.isAttr()) {
                int n;
                String string = xMLableReader.getAttr("vd");
                if (string != null) {
                    this.valueDirty = true;
                }
                if ((string = xMLableReader.getAttr("ff")) != null) {
                    this.fontName = string;
                }
                if ((string = xMLableReader.getAttr("fs")) != null) {
                    this.fontSize = Integer.parseInt(string);
                }
                if ((string = xMLableReader.getAttr("fc")) != null) {
                    this.fontColor = new Color(Integer.parseInt(string.substring(1), 16));
                }
                if ((string = xMLableReader.getAttr("ft")) != null) {
                    this.fontStyle = Integer.parseInt(string);
                }
                if ((string = xMLableReader.getAttr("br")) != null) {
                    this.borderStyle = Integer.parseInt(string);
                }
                if ((string = xMLableReader.getAttr("bg")) != null) {
                    this.backgroundColor = new Color(Integer.parseInt(string.substring(1), 16));
                }
                if ((string = xMLableReader.getAttr("ta")) != null) {
                    n = Integer.parseInt(string);
                    this.horizontal_alignment = n == 0 ? 2 : (n == 1 ? 0 : 4);
                }
                if ((string = xMLableReader.getAttr("va")) != null) {
                    n = Integer.parseInt(string);
                    this.vertical_alignment = n == 0 ? 1 : (n == 1 ? 0 : 3);
                }
            }
        }

        public void checkDirtyValueAndStyle(CellElement cellElement, Report report) {
            int n;
            int n2;
            FRFont fRFont;
            if (report == null) {
                return;
            }
            if (cellElement == null) {
                cellElement = new DefaultCellElement(this.getColumn(), this.getRow(), this.getColumnSpan(), this.getRowSpan(), this.getValue());
                report.addCellElement(cellElement, false);
            } else if (this.valueDirty) {
                cellElement.setValue(this.getValue());
            }
            Style style = cellElement.getStyle();
            if (style == null) {
                cellElement.setStyle(Style.DEFAULT_STYLE);
            }
            FRFont fRFont2 = fRFont = style.getFRFont();
            if (fRFont == null) {
                fRFont2 = FRFont.getInstance();
            }
            if (this.fontName != null) {
                fRFont2 = fRFont2.applyName(this.fontName);
            }
            if (this.fontSize > 0) {
                fRFont2 = fRFont2.applySize(this.fontSize);
            }
            if (this.fontColor != null) {
                fRFont2 = fRFont2.applyForeground(this.fontColor);
            }
            if (this.fontStyle > 0) {
                n2 = 0;
                if ((this.fontStyle & 2) != 0) {
                    ++n2;
                }
                if ((this.fontStyle & 4) != 0) {
                    n2 += 2;
                }
                if (n2 != fRFont2.getStyle()) {
                    fRFont2 = fRFont2.applyStyle(n2);
                }
                int n3 = n2 = (this.fontStyle & 8) != 0 ? 1 : 0;
                if (n2 != fRFont2.getUnderline()) {
                    fRFont2 = fRFont2.applyUnderline(n2);
                }
                int n4 = n = (this.fontStyle & 0x10) != 0 ? 1 : 0;
                if (n != fRFont2.isStrikethrough()) {
                    fRFont2 = fRFont2.applyStrikethrough(n != 0);
                }
            }
            if (fRFont2 != fRFont) {
                style = style.deriveFRFont(fRFont2);
            }
            if (this.backgroundColor != null) {
                style = style.deriveBackground(ColorBackground.getInstance(this.backgroundColor));
            }
            if (this.borderStyle > 0) {
                n2 = (this.borderStyle & 2) != 0 ? 1 : 0;
                n = (this.borderStyle & 4) != 0 ? 1 : 0;
                int n5 = (this.borderStyle & 8) != 0 ? 1 : 0;
                int n6 = (this.borderStyle & 0x10) != 0 ? 1 : 0;
                style = style.deriveBorder(n2, Color.black, n5, Color.black, n6, Color.black, n, Color.black);
            }
            if (this.horizontal_alignment >= 0 && this.horizontal_alignment != style.getHorizontalAlignment()) {
                style = style.deriveHorizontalAlignment(this.horizontal_alignment);
            }
            if (this.vertical_alignment >= 0 && this.vertical_alignment != style.getVerticalAlignment()) {
                style = style.deriveVerticalAlignment(this.vertical_alignment);
            }
            cellElement.setStyle(style);
        }
    }
}

