/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report;

import com.fr.base.Painter;
import com.fr.base.Style;
import com.fr.base.background.ColorBackground;
import com.fr.base.core.ComparatorUtils;
import com.fr.base.core.GraphHelper;
import com.fr.base.core.html.Tag;
import com.fr.base.core.serializable.ImageSerializable;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLReadable;
import com.fr.base.xml.XMLableReader;
import com.fr.chart.ChartPainter;
import com.fr.report.Elem;
import com.fr.report.cellElement.CellExpandAttr;
import com.fr.report.cellElement.CellGUIAttr;
import com.fr.report.cellElement.CellInsertPolicyAttr;
import com.fr.report.cellElement.CellPageAttr;
import com.fr.report.cellElement.Formula;
import com.fr.report.cellElement.Present;
import com.fr.report.core.PaintUtils;
import com.fr.report.highlight.HighlightGroup;
import com.fr.report.io.xml.ReportXMLUtils;
import com.fr.report.io.xml.SynchronizedStyleList;
import com.fr.report.js.NameJavaScriptGroup;
import com.fr.report.web.ui.Widget;
import com.fr.web.Repository;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Iterator;

public class FloatElement
implements Elem,
XMLReadable,
Cloneable,
Serializable {
    private static int index = 0;
    private String name = "";
    private int row = 0;
    private int column = 0;
    private int leftDistance = 0;
    private int topDistance = 0;
    private Dimension size = new Dimension(100, 100);
    private transient Object value = null;
    private Style style = null;
    private NameJavaScriptGroup nameHyperlinkGroup = null;

    public FloatElement() {
        this("");
    }

    public FloatElement(Object object) {
        this(0, 0, 0, 0, new Dimension(100, 100), object);
    }

    public FloatElement(int n, int n2, Object object) {
        this(n, n2, 0, 0, object);
    }

    public FloatElement(int n, int n2, int n3, int n4, Object object) {
        this(n, n2, n3, n4, new Dimension(100, 100), object);
    }

    public FloatElement(int n, int n2, int n3, int n4, Dimension dimension, Object object) {
        this.name = "Float" + index++;
        this.setRow(n2);
        this.setColumn(n);
        this.setLeftDistance(n3);
        this.setTopDistance(n4);
        this.setSize(dimension);
        this.setValue(object);
        this.style = Style.getInstance();
        this.style = this.style.deriveBackground(ColorBackground.getInstance(Color.WHITE));
        this.style = this.style.deriveBorder(1, Color.black, 1, Color.black, 1, Color.black, 1, Color.black);
    }

    public String getName() {
        return this.name;
    }

    public int getRow() {
        return this.row;
    }

    public void setRow(int n) {
        this.row = n;
    }

    public int getColumn() {
        return this.column;
    }

    public void setColumn(int n) {
        this.column = n;
    }

    public int getLeftDistance() {
        return this.leftDistance;
    }

    public void setLeftDistance(int n) {
        this.leftDistance = n;
    }

    public int getTopDistance() {
        return this.topDistance;
    }

    public void setTopDistance(int n) {
        this.topDistance = n;
    }

    public Dimension getSize() {
        return this.size;
    }

    public void setSize(Dimension dimension) {
        this.size = dimension;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object object) {
        this.value = object;
    }

    public Style getStyle() {
        if (this.style == null) {
            this.style = Style.DEFAULT_STYLE;
        }
        return this.style;
    }

    public void setStyle(Style style) {
        this.style = style;
    }

    public NameJavaScriptGroup getNameHyperlinkGroup() {
        return this.nameHyperlinkGroup;
    }

    public void setNameHyperlinkGroup(NameJavaScriptGroup nameJavaScriptGroup) {
        this.nameHyperlinkGroup = nameJavaScriptGroup;
    }

    public Tag toTag(Repository repository) {
        int n = (int)this.getSize().getWidth();
        int n2 = (int)this.getSize().getHeight();
        Tag tag = null;
        if (this.getValue() instanceof ChartPainter) {
            Tag tag2 = new Tag("td");
            tag = new Tag("table").cls("x-chart-table").sub(new Tag("tr").sub(tag2));
            ((ChartPainter)this.getValue()).paintTag(repository, n, n2, this.style, tag2, this);
        } else {
            BufferedImage bufferedImage = GraphHelper.createBufferedImage(n, n2, 6);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.setPaint(Color.white);
            PaintUtils.paintFloatElement(graphics2D, this, n - 1, n2 - 1);
            bufferedImage.flush();
            graphics2D.dispose();
            tag = repository.checkoutImageTag(bufferedImage, n, n2);
        }
        return tag;
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if ("Location".equals(string)) {
                String string2 = xMLableReader.getAttr("column");
                if (string2 != null) {
                    this.setColumn(Integer.parseInt(string2));
                }
                if ((string2 = xMLableReader.getAttr("row")) != null) {
                    this.setRow(Integer.parseInt(string2));
                }
                if ((string2 = xMLableReader.getAttr("leftDistance")) != null) {
                    this.setLeftDistance((int)Double.parseDouble(string2));
                }
                if ((string2 = xMLableReader.getAttr("topDistance")) != null) {
                    this.setTopDistance((int)Double.parseDouble(string2));
                }
                int n = 0;
                int n2 = 0;
                string2 = xMLableReader.getAttr("width");
                if (string2 != null) {
                    n = (int)Double.parseDouble(string2);
                }
                if ((string2 = xMLableReader.getAttr("height")) != null) {
                    n2 = (int)Double.parseDouble(string2);
                }
                this.setSize(new Dimension(n, n2));
            } else if (string.equals("Style")) {
                String string3 = xMLableReader.getAttr("index");
                if (string3 != null) {
                    SynchronizedStyleList.getSynchronizedStyleList(Thread.currentThread()).put(Integer.parseInt(string3), this);
                }
            } else if ("NameJavaScriptGroup".equals(string) || "NameJavaScriptGroup".equals(string) || "NameHyperlinks".equals(string) || "HyperlinkMap".equals(string)) {
                NameJavaScriptGroup nameJavaScriptGroup = new NameJavaScriptGroup();
                xMLableReader.readXMLObject(nameJavaScriptGroup);
                this.setNameHyperlinkGroup(nameJavaScriptGroup);
            } else if ("O".equals(string) || "Object".equals(string)) {
                this.setValue(ReportXMLUtils.readObject(xMLableReader, true, null));
            } else if ("Hyperlink".equals(string)) {
                this.setNameHyperlinkGroup(new NameJavaScriptGroup(ReportXMLUtils.readJavaScript(xMLableReader)));
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("Location").attr("column", this.getColumn()).attr("row", this.getRow()).attr("leftDistance", this.getLeftDistance()).attr("topDistance", this.getTopDistance()).attr("width", this.getSize().getWidth()).attr("height", this.getSize().getHeight()).end();
        ReportXMLUtils.writeObject(xMLPrintWriter, this.getValue());
        if (this.style != null && !ComparatorUtils.equals(this.style, Style.DEFAULT_STYLE)) {
            ReportXMLUtils.writeIndexStyle(xMLPrintWriter, this.style);
        }
        if (this.getNameHyperlinkGroup() != null) {
            this.getNameHyperlinkGroup().writeXML(xMLPrintWriter);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        Object object = objectInputStream.readObject();
        if (object != null) {
            this.value = object instanceof ImageSerializable ? ((ImageSerializable)object).getImage() : object;
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.value != null && this.value instanceof Image) {
            ImageSerializable imageSerializable = new ImageSerializable((Image)this.value);
            objectOutputStream.writeObject(imageSerializable);
        } else {
            objectOutputStream.writeObject(this.value);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        FloatElement floatElement = (FloatElement)super.clone();
        floatElement.name = "Float" + index++;
        if (this.getValue() != null) {
            if (this.getValue() instanceof Formula) {
                floatElement.setValue(((Formula)this.getValue()).clone());
            } else if (this.getValue() instanceof Painter) {
                floatElement.setValue(((Painter)this.getValue()).clone());
            }
        }
        if (this.getSize() != null) {
            Dimension dimension = this.getSize();
            floatElement.setSize((Dimension)dimension.clone());
        }
        if (this.getNameHyperlinkGroup() != null) {
            floatElement.setNameHyperlinkGroup((NameJavaScriptGroup)this.getNameHyperlinkGroup().clone());
        }
        if (this.style != null) {
            floatElement.setStyle((Style)this.style.clone());
        }
        return floatElement;
    }

    public FloatElement deriveFloatElement(int n, int n2, int n3, int n4, Dimension dimension) throws CloneNotSupportedException {
        FloatElement floatElement = (FloatElement)super.clone();
        floatElement.setColumn(n);
        floatElement.setRow(n2);
        floatElement.setLeftDistance(n3);
        floatElement.setTopDistance(n4);
        floatElement.setSize(dimension);
        return floatElement;
    }

    public Iterator attributeKeyIterator() {
        throw new UnsupportedOperationException();
    }

    public Object getAttribute(Object object) {
        throw new UnsupportedOperationException();
    }

    public CellExpandAttr getCellExpandAttr() {
        throw new UnsupportedOperationException();
    }

    public CellGUIAttr getCellGUIAttr() {
        throw new UnsupportedOperationException();
    }

    public CellPageAttr getCellPageAttr() {
        throw new UnsupportedOperationException();
    }

    public CellInsertPolicyAttr getCellInsertPolicyAttr() {
        throw new UnsupportedOperationException();
    }

    public Widget getWidget() {
        throw new UnsupportedOperationException();
    }

    public HighlightGroup getHighlightGroup() {
        throw new UnsupportedOperationException();
    }

    public Present getPresent() {
        throw new UnsupportedOperationException();
    }

    public String getScript() {
        throw new UnsupportedOperationException();
    }

    public Object removeAttribute(Object object) {
        throw new UnsupportedOperationException();
    }

    public void setAttribute(Object object, Object object2) {
        throw new UnsupportedOperationException();
    }

    public void setCellExpandAttr(CellExpandAttr cellExpandAttr) {
        throw new UnsupportedOperationException();
    }

    public void setCellGUIAttr(CellGUIAttr cellGUIAttr) {
        throw new UnsupportedOperationException();
    }

    public void setCellPageAttr(CellPageAttr cellPageAttr) {
        throw new UnsupportedOperationException();
    }

    public void setCellInsertPolicyAttr(CellInsertPolicyAttr cellInsertPolicyAttr) {
        throw new UnsupportedOperationException();
    }

    public void setWidget(Widget widget) {
        throw new UnsupportedOperationException();
    }

    public void setHighlightGroup(HighlightGroup highlightGroup) {
        throw new UnsupportedOperationException();
    }

    public void setPresent(Present present) {
        throw new UnsupportedOperationException();
    }

    public void setScript(String string) {
        throw new UnsupportedOperationException();
    }
}

