/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report;

import com.fr.base.core.list.IntList;
import com.fr.report.PageSet;
import com.fr.report.ReportPage;

public class PageSetChain
extends PageSet {
    private ChainInfo[] chainInfos;
    private int pageCount = -1;
    private PageSetChain case4traversing = null;
    private Object traversing_lock = new Object();

    public PageSetChain(PageSet[] pageSetArray) {
        this.chainInfos = new ChainInfo[pageSetArray.length];
        for (int i = 0; i < pageSetArray.length; ++i) {
            this.chainInfos[i] = new ChainInfo(pageSetArray[i]);
        }
        this.initPageCount();
    }

    private PageSetChain(ChainInfo[] chainInfoArray) {
        this.chainInfos = chainInfoArray;
        this.initPageCount();
    }

    private void initPageCount() {
        this.pageCount = 0;
        for (int i = 0; i < this.chainInfos.length; ++i) {
            this.chainInfos[i].startIndex = this.pageCount;
            if (this.chainInfos[i].pageSet.sizePredictable()) {
                this.pageCount += this.chainInfos[i].pageSet.size();
            } else {
                this.chainInfos[i].endIndex = Integer.MAX_VALUE;
                this.pageCount = Integer.MAX_VALUE;
                break;
            }
            this.chainInfos[i].endIndex = this.pageCount - 1;
        }
    }

    public int size() {
        return this.pageCount;
    }

    public boolean sizePredictable() {
        for (int i = 0; i < this.chainInfos.length; ++i) {
            if (this.chainInfos[i].pageSet.sizePredictable()) continue;
            return false;
        }
        return true;
    }

    public boolean pageCached() {
        for (int i = 0; i < this.chainInfos.length; ++i) {
            if (this.chainInfos[i].pageSet.pageCached()) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PageSet getTraversingCase() {
        Object object = this.traversing_lock;
        synchronized (object) {
            if (this.case4traversing == null) {
                ChainInfo[] chainInfoArray = new ChainInfo[this.chainInfos.length];
                for (int i = 0; i < chainInfoArray.length; ++i) {
                    chainInfoArray[i] = new ChainInfo(this.chainInfos[i].pageSet.getTraversingCase());
                    chainInfoArray[i].startIndex = this.chainInfos[i].startIndex;
                    chainInfoArray[i].endIndex = this.chainInfos[i].endIndex;
                }
                this.case4traversing = new PageSetChain(chainInfoArray);
            }
        }
        return this.case4traversing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReportPage getPage(int n) {
        if (n < 0) {
            return null;
        }
        for (int i = 0; i < this.chainInfos.length; ++i) {
            if (this.chainInfos[i].startIndex > n || n > this.chainInfos[i].endIndex) continue;
            ReportPage reportPage = this.chainInfos[i].getReportPage(n - this.chainInfos[i].startIndex);
            if (reportPage == null && this.chainInfos[i].endIndex == Integer.MAX_VALUE) {
                PageSetChain pageSetChain = this;
                synchronized (pageSetChain) {
                    if (this.chainInfos[i].endIndex == Integer.MAX_VALUE && this.sizePredictable()) {
                        this.initPageCount();
                        if (n > this.pageCount - 1) {
                            return null;
                        }
                        return this.getPage(n);
                    }
                }
            }
            reportPage.getPageInfo().setTotalPages(this.pageCount == Integer.MAX_VALUE ? -1 : this.pageCount);
            reportPage.setCurrentPageNumber(n + 1);
            return reportPage;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IntList getChainPageInfo() {
        if (!this.pageCached() || !this.sizePredictable()) {
            return null;
        }
        for (int i = 0; i < this.chainInfos.length; ++i) {
            if (this.chainInfos[i].endIndex != Integer.MAX_VALUE) continue;
            PageSetChain pageSetChain = this;
            synchronized (pageSetChain) {
                if (this.chainInfos[i].endIndex == Integer.MAX_VALUE) {
                    this.initPageCount();
                    break;
                }
                continue;
            }
        }
        IntList intList = new IntList(this.chainInfos.length);
        for (int i = 0; i < this.chainInfos.length; ++i) {
            intList.add(this.chainInfos[i].startIndex);
        }
        return intList;
    }

    public PageSet getReportPageSet(int n) {
        if (this.chainInfos == null || this.chainInfos.length <= n) {
            return null;
        }
        return this.chainInfos[n].pageSet;
    }

    public void release() {
        for (int i = 0; i < this.chainInfos.length; ++i) {
            this.chainInfos[i].pageSet.release();
        }
        if (this.case4traversing != null) {
            this.case4traversing.release();
        }
    }

    private class ChainInfo {
        private int startIndex;
        private int endIndex;
        private PageSet pageSet;

        private ChainInfo(PageSet pageSet) {
            this.pageSet = pageSet;
        }

        private ReportPage getReportPage(int n) {
            return this.pageSet.getPage(n);
        }
    }
}

