/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report;

import com.fr.base.FRContext;
import com.fr.base.Inter;
import com.fr.base.core.BaseCoreUtils;
import com.fr.base.core.ComparatorUtils;
import com.fr.util.Utils;
import java.io.Serializable;
import java.util.Locale;

public class PaperSize
implements Cloneable,
Serializable {
    public static final PaperSize PAPERSIZE_9X11 = new PaperSize(9.0, 11.0);
    public static final PaperSize PAPERSIZE_10X11 = new PaperSize(10.0, 11.0);
    public static final PaperSize PAPERSIZE_10X14 = new PaperSize(10.0, 14.0);
    public static final PaperSize PAPERSIZE_11X17 = new PaperSize(11.0, 17.0);
    public static final PaperSize PAPERSIZE_15x11 = new PaperSize(15.0, 11.0);
    public static final PaperSize PAPERSIZE_LETTER = new PaperSize(8.5, 11.0);
    public static final PaperSize PAPERSIZE_NOTE = new PaperSize(7.5, 10.0);
    public static final PaperSize PAPERSIZE_LEGAL = new PaperSize(8.5, 14.0);
    public static final PaperSize PAPERSIZE_A0 = new PaperSize(33.056, 46.778);
    public static final PaperSize PAPERSIZE_A1 = new PaperSize(23.389, 33.056);
    public static final PaperSize PAPERSIZE_A2 = new PaperSize(16.528, 23.389);
    public static final PaperSize PAPERSIZE_A3 = new PaperSize(11.693, 16.536);
    public static final PaperSize PAPERSIZE_A3_XL = new PaperSize(12.67717, 17.51969);
    public static final PaperSize PAPERSIZE_A4 = new PaperSize(8.268, 11.693);
    public static final PaperSize PAPERSIZE_A4_XL = new PaperSize(9.26772, 12.68898);
    public static final PaperSize PAPERSIZE_A4_ML = new PaperSize(8.268, 12.99213);
    public static final PaperSize PAPERSIZE_A5 = new PaperSize(5.827, 8.268);
    public static final PaperSize PAPERSIZE_A5_XL = new PaperSize(6.8504, 9.25197);
    public static final PaperSize PAPERSIZE_A6 = new PaperSize(4.125, 5.847);
    public static final PaperSize PAPERSIZE_A7 = new PaperSize(2.917, 4.125);
    public static final PaperSize PAPERSIZE_A8 = new PaperSize(2.056, 2.917);
    public static final PaperSize PAPERSIZE_B0 = new PaperSize(39.389, 55.667);
    public static final PaperSize PAPERSIZE_B1 = new PaperSize(27.833, 39.389);
    public static final PaperSize PAPERSIZE_B2 = new PaperSize(19.694, 27.833);
    public static final PaperSize PAPERSIZE_B3 = new PaperSize(13.917, 19.694);
    public static final PaperSize PAPERSIZE_B4 = new PaperSize(9.842976, 13.937654);
    public static final PaperSize PAPERSIZE_B4_JIS = new PaperSize(10.11812, 14.3308);
    public static final PaperSize PAPERSIZE_B5_JIS = new PaperSize(7.165687, 10.118579);
    public static final PaperSize PAPERSIZE_B6_JIS = new PaperSize(5.0394, 7.165355);
    public static final PaperSize PAPERSIZE_A3_ROTATE = PAPERSIZE_A3.rotate();
    public static final PaperSize PAPERSIZE_A4_ROTATE = PAPERSIZE_A4.rotate();
    public static final PaperSize PAPERSIZE_A5_ROTATE = PAPERSIZE_A5.rotate();
    public static final PaperSize PAPERSIZE_A6_ROTATE = PAPERSIZE_A6.rotate();
    public static final PaperSize PAPERSIZE_B4_JIS_ROTATE = PAPERSIZE_B4_JIS.rotate();
    public static final PaperSize PAPERSIZE_B5_JIS_ROTATE = PAPERSIZE_B5_JIS.rotate();
    public static final PaperSize PAPERSIZE_B6_JIS_ROTATE = PAPERSIZE_B6_JIS.rotate();
    public static final PaperSize PAPERSIZE_TABLOID = new PaperSize(11.0, 17.0);
    public static final PaperSize PAPERSIZE_LEDGER = new PaperSize(17.0, 11.0);
    public static final PaperSize PAPERSIZE_HALFLETTER = new PaperSize(5.5, 8.5);
    public static final PaperSize PAPERSIZE_EXECUTIVE = new PaperSize(7.2481, 10.5);
    public static final PaperSize PAPERSIZE_FOLIO = new PaperSize(8.5, 13.0);
    public static final PaperSize PAPERSIZE_QUARTO = new PaperSize(8.4646, 10.82678);
    public static final int PREDEFINED = 0;
    public static final int USERDEFINED = 1;
    private double width;
    private double height;

    public PaperSize() {
        this(PAPERSIZE_A4.getWidth(), PAPERSIZE_A4.getHeight());
    }

    public PaperSize(double d, double d2) {
        this.setWidth(d);
        this.setHeight(d2);
    }

    public double getWidth() {
        return this.width;
    }

    public void setWidth(double d) {
        this.width = d;
    }

    public double getHeight() {
        return this.height;
    }

    public void setHeight(double d) {
        this.height = d;
    }

    public PaperSize rotate() {
        return new PaperSize(this.getHeight(), this.getWidth());
    }

    public boolean equals(Object object) {
        if (!(object instanceof PaperSize)) {
            return false;
        }
        PaperSize paperSize = (PaperSize)object;
        return this.getWidth() == paperSize.getWidth() && this.getHeight() == paperSize.getHeight();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public String toString() {
        Locale locale = FRContext.getLocale();
        if (ComparatorUtils.equals(Locale.CHINA, locale)) {
            return Utils.doubleToString(BaseCoreUtils.convertInchesToMillimeters(this.getWidth())) + "x" + Utils.doubleToString(BaseCoreUtils.convertInchesToMillimeters(this.getHeight())) + Inter.getLocText("PageSetup-mm");
        }
        return this.getWidth() + "x" + this.getHeight() + Inter.getLocText("PageSetup-inches");
    }
}

