/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report;

import com.fr.base.FRContext;
import com.fr.base.background.ColorBackground;
import com.fr.base.core.FT;
import com.fr.base.core.GraphHelper;
import com.fr.base.core.list.IntList;
import com.fr.report.Cell;
import com.fr.report.CellElement;
import com.fr.report.FloatElement;
import com.fr.report.PageInfo;
import com.fr.report.PaperSetting;
import com.fr.report.PaperSize;
import com.fr.report.Report;
import com.fr.report.ReportGetter;
import com.fr.report.ReportHF;
import com.fr.report.ReportPageAttr;
import com.fr.report.ReportSettings;
import com.fr.report.cellElement.CellPageAttr;
import com.fr.report.cellElement.CoverCellElement;
import com.fr.report.cellElement.Formula;
import com.fr.report.cellElement.core.CellElementAttribute;
import com.fr.report.cellElement.core.CellUtils;
import com.fr.report.cellElement.core.ResultSubReport;
import com.fr.report.core.DynamicValueList;
import com.fr.report.core.PaintUtils;
import com.fr.report.core.ReportHelper;
import com.fr.report.core.ReportUtils;
import com.fr.report.painter.PagePainter;
import com.fr.util.Utils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.sql.Clob;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import javax.imageio.ImageIO;

public class ReportPage
implements ReportGetter,
Printable,
Serializable {
    private static final long serialVersionUID = 4854581643677224811L;
    protected Report source_report;
    private FT[] column_line_array;
    private FT[] row_line_array;
    private int currentPageNumber;
    private PageInfo pageInfo;
    private ReportSettings reportSettings = null;
    private IntList row_height_list = null;
    private IntList column_width_list = null;
    private DynamicValueList columnWidthList;
    private DynamicValueList rowHeightList;
    private int contentWidth = -1;
    private int contentHeight = -1;
    private int x;
    private int y;
    private PaperSetting paperSetting;

    public ReportPage(Report report, PageInfo pageInfo, PaperSetting paperSetting, FT[] fTArray, FT[] fTArray2, int n, int n2) {
        this.setPageInfo(pageInfo);
        this.source_report = report;
        this.row_line_array = fTArray;
        this.column_line_array = fTArray2;
        this.paperSetting = paperSetting;
        this.x = n;
        this.y = n2;
        this.columnWidthList = ReportHelper.getColumnWidthList(this.source_report);
        this.rowHeightList = ReportHelper.getRowHeightList(this.source_report);
        this.initRowHeightArray();
        this.initColumnWidthArray();
    }

    public Report getSourceReport() {
        return this.source_report;
    }

    public int[] getXY() {
        return new int[]{this.x, this.y};
    }

    private void initColumnWidthArray() {
        if (this.column_width_list == null) {
            this.column_width_list = new IntList();
            for (int i = 0; i < this.column_line_array.length; ++i) {
                FT fT = this.column_line_array[i];
                for (int j = fT.from; j < fT.to; ++j) {
                    this.column_width_list.add(this.source_report.getColumnWidth(j));
                }
            }
        }
    }

    private void initRowHeightArray() {
        if (this.row_height_list == null) {
            this.row_height_list = new IntList();
            for (int i = 0; i < this.row_line_array.length; ++i) {
                FT fT = this.row_line_array[i];
                for (int j = fT.from; j < fT.to; ++j) {
                    this.row_height_list.add(this.source_report.getRowHeight(j));
                }
            }
        }
    }

    public void setCurrentPageNumber(int n) {
        this.currentPageNumber = n;
    }

    public int getCurrentPageNumber() {
        return this.currentPageNumber;
    }

    public int getTotalPages() {
        return this.getPageInfo().getTotalPages();
    }

    public void setPageInfo(PageInfo pageInfo) {
        this.pageInfo = pageInfo;
    }

    public PageInfo getPageInfo() {
        return this.pageInfo;
    }

    public ReportHF getHeader() {
        ReportHF reportHF = null;
        if (this.currentPageNumber == 1) {
            reportHF = this.getHeader(1);
        }
        if (reportHF != null) {
            return reportHF;
        }
        if (this.currentPageNumber == this.getTotalPages()) {
            reportHF = this.getHeader(2);
        }
        if (reportHF != null) {
            return reportHF;
        }
        if (this.currentPageNumber % 2 != 0) {
            reportHF = this.getHeader(3);
        }
        if (reportHF != null) {
            return reportHF;
        }
        if (this.currentPageNumber % 2 == 0) {
            reportHF = this.getHeader(4);
        }
        if (reportHF != null) {
            return reportHF;
        }
        return this.getHeader(0);
    }

    public ReportHF getFooter() {
        ReportHF reportHF = null;
        if (this.currentPageNumber == 1) {
            reportHF = this.getFooter(1);
        }
        if (reportHF != null) {
            return reportHF;
        }
        if (this.currentPageNumber == this.getTotalPages()) {
            reportHF = this.getFooter(2);
        }
        if (reportHF != null) {
            return reportHF;
        }
        if (this.currentPageNumber % 2 != 0) {
            reportHF = this.getFooter(3);
        }
        if (reportHF != null) {
            return reportHF;
        }
        if (this.currentPageNumber % 2 == 0) {
            reportHF = this.getFooter(4);
        }
        if (reportHF != null) {
            return reportHF;
        }
        return this.getFooter(0);
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        double d;
        double d2;
        double d3;
        double d4;
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        ReportSettings reportSettings = this.source_report.getReportSettings();
        if (reportSettings.isLonelyPage()) {
            int n2;
            DynamicValueList dynamicValueList = ReportHelper.getColumnWidthList(this.source_report);
            DynamicValueList dynamicValueList2 = ReportHelper.getRowHeightList(this.source_report);
            int n3 = this.source_report.getColumnCount();
            int n4 = this.source_report.getRowCount();
            int n5 = 0;
            int n6 = 0;
            for (n2 = 0; n2 < n3; ++n2) {
                n5 += dynamicValueList.get(n2);
            }
            for (n2 = 0; n2 < n4; ++n2) {
                n6 += dynamicValueList2.get(n2);
            }
            d4 = (double)this.getPageWidth() / ((double)(this.getMarginLeft() + this.getMarginRight()) + (double)n5);
            d3 = (double)this.getPageHeight() / ((double)n6 + (double)this.getMarginTop() + (double)this.getMarginBottom());
            d4 = d4 < 1.0 ? d4 : 1.0;
            d3 = d3 < 1.0 ? d3 : 1.0;
            graphics2D.scale(d4, d3);
        }
        if ((d2 = Math.min(d3 = (d4 = (double)this.source_report.getReportSettings().getResolution() / 72.0) * (pageFormat.getImageableWidth() / (double)this.getPageWidth()), d = d4 * (pageFormat.getImageableHeight() / (double)this.getPageHeight()))) < 1.0) {
            graphics2D.scale(d2, d2);
        }
        new PagePainter(this, graphics2D, true).convert();
        return 0;
    }

    public Iterator cellIterator(Rectangle rectangle) {
        return this.source_report.intersect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public Iterator floatIterator(Rectangle rectangle) {
        return this.source_report.floatIterator();
    }

    public Image toImage() {
        return this.toImage(true);
    }

    public Image toImage(boolean bl) {
        int n = this.getPageWidth();
        int n2 = this.getPageHeight();
        BufferedImage bufferedImage = GraphHelper.createBufferedImage(n, n2, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        new PagePainter(this, graphics2D, bl).convert();
        return bufferedImage;
    }

    public int getColumnWidth(int n) {
        return this.column_width_list.get(n);
    }

    public int getRowHeight(int n) {
        return this.row_height_list.get(n);
    }

    public Iterator cellIterator() {
        return new PageCellIterator();
    }

    public int getColumnCount() {
        return this.column_width_list.size();
    }

    public Iterator getRow(int n) {
        return new PageRowIterator(n);
    }

    public int getRowCount() {
        return this.row_height_list.size();
    }

    public Iterator floatIterator() {
        return new PageFloatIterator();
    }

    public ReportHF getFooter(int n) {
        return this.source_report.getFooter(n);
    }

    public ReportHF getHeader(int n) {
        return this.source_report.getHeader(n);
    }

    public ReportPageAttr getReportPageAttr() {
        return this.source_report.getReportPageAttr();
    }

    public ReportSettings getReportSettings() {
        if (this.reportSettings == null) {
            this.reportSettings = ReportUtils.getReportSettings(this.source_report);
        }
        return this.reportSettings;
    }

    public int getPageWidth() {
        if (this.paperSetting != null) {
            return ReportUtils.getPaperWidth(this.paperSetting);
        }
        return this.getContentWidth();
    }

    public int getPageHeight() {
        if (this.paperSetting != null) {
            return ReportUtils.getPaperHeight(this.paperSetting);
        }
        return this.getContentHeight();
    }

    public int getMarginTop() {
        if (this.paperSetting != null) {
            return ReportUtils.getMarginTop(this.paperSetting);
        }
        return 0;
    }

    public int getMarginLeft() {
        if (this.paperSetting != null) {
            return ReportUtils.getMarginLeft(this.paperSetting);
        }
        return 0;
    }

    public int getMarginBottom() {
        if (this.paperSetting != null) {
            return ReportUtils.getMarginBottom(this.paperSetting);
        }
        return 0;
    }

    public int getMarginRight() {
        if (this.paperSetting != null) {
            return ReportUtils.getMarginRight(this.paperSetting);
        }
        return 0;
    }

    public synchronized int getContentWidth() {
        if (this.contentWidth == -1) {
            DynamicValueList dynamicValueList = ReportHelper.createColumnWidthList(this);
            this.contentWidth = Math.max(dynamicValueList.getRangeValueFromZero(this.getColumnCount()), 1);
            Iterator iterator = this.floatIterator();
            while (iterator.hasNext()) {
                FloatElement floatElement = (FloatElement)iterator.next();
                int n = dynamicValueList.getRangeValueFromZero(floatElement.getColumn()) + floatElement.getLeftDistance();
                int n2 = floatElement.getSize().width + 1;
                this.contentWidth = Math.max(this.contentWidth, n + n2);
            }
        }
        return this.contentWidth;
    }

    public synchronized int getContentHeight() {
        if (this.contentHeight == -1) {
            DynamicValueList dynamicValueList = ReportHelper.createRowHeightList(this);
            this.contentHeight = Math.max(dynamicValueList.getRangeValueFromZero(this.getRowCount()), 1);
            Iterator iterator = this.floatIterator();
            while (iterator.hasNext()) {
                FloatElement floatElement = (FloatElement)iterator.next();
                int n = dynamicValueList.getRangeValueFromZero(floatElement.getRow()) + floatElement.getTopDistance();
                int n2 = floatElement.getSize().height + 1;
                this.contentHeight = Math.max(this.contentHeight, n + n2);
            }
        }
        return this.contentHeight;
    }

    public PageFormat getPageFormat(PageFormat pageFormat) {
        pageFormat = pageFormat == null ? new PageFormat() : (PageFormat)pageFormat.clone();
        ReportSettings reportSettings = this.getReportSettings();
        int n = reportSettings.getOrientation();
        PaperSize paperSize = reportSettings.getPaperSize();
        Paper paper = pageFormat.getPaper();
        paper.setSize(paperSize.getWidth() * 72.0, paperSize.getHeight() * 72.0);
        paper.setImageableArea(0.0, 0.0, paperSize.getWidth() * 72.0, paperSize.getHeight() * 72.0);
        pageFormat.setPaper(paper);
        if (n == 1) {
            pageFormat.setOrientation(0);
        } else {
            pageFormat.setOrientation(1);
        }
        return pageFormat;
    }

    private void checkCellElementValue(CellElement cellElement, CellElement cellElement2, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, Rectangle rectangle4) {
        Object object;
        Object object2;
        Object object3 = cellElement.getValue();
        if (object3 instanceof Formula) {
            object2 = (Formula)object3;
            object3 = ((Formula)object2).getResult();
            cellElement.setValue(object3);
        }
        if (object3 instanceof String && !object3.equals(object2 = this.applyPageNumber2String((String)object3))) {
            object3 = object2;
            cellElement.setValue(object3);
        }
        if (cellElement2.getPresent() != null) {
            cellElement.setValue(cellElement2.getAttribute(CellElementAttribute.PRESENT_VALUE));
        }
        if (object3 instanceof byte[]) {
            object2 = cellElement2.getAttribute(CellElementAttribute.ATT_TYPE);
            if (object2 != null && "image".equals((String)object2)) {
                try {
                    cellElement.setValue(ImageIO.read(new ByteArrayInputStream((byte[])object3)));
                }
                catch (IOException iOException) {
                    FRContext.getLogger().log(Level.WARNING, iOException.getMessage(), iOException);
                }
            }
        } else if (object3 instanceof ResultSubReport) {
            object2 = new Rectangle(this.columnWidthList.getRangeValue(rectangle.x, rectangle2.x), this.rowHeightList.getRangeValue(rectangle.y, rectangle2.y), this.columnWidthList.getRangeValue(cellElement2.getColumn(), cellElement2.getColumn() + cellElement2.getColumnSpan()), this.rowHeightList.getRangeValue(cellElement2.getRow(), cellElement2.getRow() + cellElement2.getRowSpan()));
            object = new Rectangle(this.columnWidthList.getRangeValue(rectangle2.x, rectangle.x), this.rowHeightList.getRangeValue(rectangle2.y, rectangle.y), this.columnWidthList.getRangeValue(rectangle.x, rectangle.x + rectangle.width), this.rowHeightList.getRangeValue(rectangle.y, rectangle.y + rectangle.height));
            cellElement.setValue(CellUtils.value2Image(object3, cellElement.getStyle(), (Rectangle)object2, (Rectangle)object));
        }
        object3 = cellElement.getValue();
        if (rectangle3 != null && (object3 instanceof String || object3 instanceof Clob)) {
            if (object3 instanceof Clob) {
                object3 = Utils.clob2String((Clob)object3);
            }
            boolean bl = cellElement2.getCellGUIAttr() != null && cellElement2.getCellGUIAttr().isShowAsHTML();
            object = GraphHelper.createBufferedImage(rectangle4.width, rectangle4.height, 2);
            Graphics2D graphics2D = ((BufferedImage)object).createGraphics();
            graphics2D.setPaint(Color.white);
            ColorBackground.getInstance(Color.white).paint(graphics2D, new Rectangle2D.Double(0.0, 0.0, rectangle4.width, rectangle4.height));
            if (bl) {
                PaintUtils.paintHTMLContent(graphics2D, (String)object3, cellElement2.getStyle(), rectangle3, rectangle4);
            } else {
                PaintUtils.paintContent(graphics2D, object3, cellElement2.getStyle(), rectangle3, rectangle4);
            }
            ((Image)object).flush();
            graphics2D.dispose();
            cellElement.setValue(object);
        }
    }

    private Object applyPageNumber2String(String string) {
        if (string.indexOf("$$totalPage_number") > -1 || string.indexOf("$$page_number") > -1) {
            return Utils.replaceAllString(Utils.replaceAllString(string, "$$totalPage_number", String.valueOf(this.getTotalPages())), "$$page_number", String.valueOf(this.getCurrentPageNumber()));
        }
        return string;
    }

    private class PageFloatIterator
    implements Iterator {
        private Iterator current_it;
        private FloatElement next = null;

        private PageFloatIterator() {
            this.current_it = ReportPage.this.source_report.floatIterator();
            this.findNext();
        }

        public boolean hasNext() {
            return this.next != null;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("At last element");
            }
            FloatElement floatElement = this.next;
            this.findNext();
            return floatElement;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void findNext() {
            while (this.current_it.hasNext()) {
                Point point = new Point(0, 0);
                FloatElement floatElement = (FloatElement)this.current_it.next();
                for (int i = 0; i < ReportPage.this.column_line_array.length; ++i) {
                    FT fT = ReportPage.this.column_line_array[i];
                    for (int j = 0; j < ReportPage.this.row_line_array.length; ++j) {
                        FT fT2 = ReportPage.this.row_line_array[j];
                        Rectangle rectangle = new Rectangle(fT.from, fT2.from, fT.to - fT.from, fT2.to - fT2.from);
                        Rectangle rectangle2 = new Rectangle(ReportPage.this.columnWidthList.getRangeValueFromZero(rectangle.x), ReportPage.this.rowHeightList.getRangeValueFromZero(rectangle.y), ReportPage.this.columnWidthList.getRangeValue(rectangle.x, rectangle.x + rectangle.width), ReportPage.this.rowHeightList.getRangeValue(rectangle.y, rectangle.y + rectangle.height));
                        FloatElement floatElement2 = this.intersectFloatElement(floatElement, rectangle, rectangle2, point, ReportPage.this.columnWidthList, ReportPage.this.rowHeightList);
                        if (floatElement2 != null) {
                            this.next = floatElement2;
                            return;
                        }
                        point.y += fT2.to - fT2.from;
                    }
                    point.y = 0;
                    point.x += fT.to - fT.from;
                }
            }
            this.next = null;
        }

        private FloatElement intersectFloatElement(FloatElement floatElement, Rectangle rectangle, Rectangle rectangle2, Point point, DynamicValueList dynamicValueList, DynamicValueList dynamicValueList2) {
            int n = floatElement.getColumn();
            int n2 = floatElement.getRow();
            Rectangle rectangle3 = new Rectangle(dynamicValueList.getRangeValueFromZero(n) + floatElement.getLeftDistance(), dynamicValueList2.getRangeValueFromZero(n2) + floatElement.getTopDistance(), floatElement.getSize().width, floatElement.getSize().height);
            Rectangle rectangle4 = rectangle2.intersection(rectangle3);
            if (rectangle4.width > 0 && rectangle4.height > 0) {
                int n3;
                int n4;
                int n5 = 0;
                int n6 = 0;
                int n7 = 0;
                int n8 = 0;
                while (n7 + (n4 = dynamicValueList.get(n5)) <= rectangle4.x) {
                    n7 += n4;
                    ++n5;
                }
                while (n8 + (n3 = dynamicValueList2.get(n6)) <= rectangle4.y) {
                    n8 += n3;
                    ++n6;
                }
                try {
                    floatElement = floatElement.deriveFloatElement(point.x + n5 - rectangle.x, point.y + n6 - rectangle.y, rectangle4.x - n7, rectangle4.y - n8, new Dimension(rectangle4.width, rectangle4.height));
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    FRContext.getLogger().log(Level.WARNING, cloneNotSupportedException.getMessage(), cloneNotSupportedException);
                    floatElement.setColumn(point.x + n5 - rectangle.x);
                    floatElement.setRow(point.y + n6 - rectangle.y);
                    floatElement.setLeftDistance(rectangle4.x - n7);
                    floatElement.setTopDistance(rectangle4.y - n8);
                    floatElement.setSize(new Dimension(rectangle4.width, rectangle4.height));
                }
                return floatElement;
            }
            return null;
        }
    }

    private class PageRowIterator
    implements Iterator {
        private int current_ri = -1;
        private int row_offset = -1;
        private int current_ci = 0;
        private Cell next = null;
        private Iterator current_it;
        private Point offsetColumnRow;

        private PageRowIterator(int n) {
            int n2 = n;
            for (int i = 0; i < ReportPage.this.row_line_array.length; ++i) {
                FT fT = ReportPage.this.row_line_array[i];
                int n3 = fT.to - fT.from;
                if (n3 > n2) {
                    this.current_ri = i;
                    this.row_offset = n2;
                    break;
                }
                n2 -= n3;
            }
            this.offsetColumnRow = new Point(0, n - n2);
            this.findNext();
        }

        public boolean hasNext() {
            return this.next != null;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("At last element");
            }
            Cell cell = this.next;
            this.findNext();
            return cell;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void findNext() {
            if (this.current_ri == -1) {
                return;
            }
            FT fT = ReportPage.this.row_line_array[this.current_ri];
            for (int i = this.current_ci; i < ReportPage.this.column_line_array.length; ++i) {
                Cloneable cloneable;
                this.current_ci = i;
                FT fT2 = ReportPage.this.column_line_array[i];
                Rectangle rectangle = new Rectangle(fT2.from, fT.from, fT2.to - fT2.from, fT.to - fT.from);
                if (this.current_it == null) {
                    cloneable = new Rectangle(fT2.from, fT.from + this.row_offset, fT2.to - fT2.from, 1);
                    this.current_it = ReportPage.this.cellIterator((Rectangle)cloneable);
                }
                while (this.current_it.hasNext()) {
                    Cell cell;
                    cloneable = (CellElement)this.current_it.next();
                    if (this.row_offset > 0 && cloneable.getRow() < fT.from + this.row_offset || (cell = this.intersectCell((CellElement)cloneable, rectangle, this.offsetColumnRow, ReportPage.this.column_line_array, ReportPage.this.row_line_array, ReportPage.this.columnWidthList, ReportPage.this.rowHeightList)) == null) continue;
                    this.next = cell;
                    return;
                }
                this.current_it = null;
                this.offsetColumnRow.x += fT2.to - fT2.from;
            }
            this.next = null;
        }

        private Cell intersectCell(CellElement cellElement, Rectangle rectangle, Point point, FT[] fTArray, FT[] fTArray2, DynamicValueList dynamicValueList, DynamicValueList dynamicValueList2) {
            Rectangle rectangle2 = new Rectangle(cellElement.getColumn(), cellElement.getRow(), cellElement.getColumnSpan(), cellElement.getRowSpan());
            Rectangle rectangle3 = rectangle2.intersection(rectangle);
            CoverCellElement coverCellElement = null;
            CellPageAttr cellPageAttr = cellElement.getCellPageAttr();
            if (cellPageAttr == null) {
                cellPageAttr = CellPageAttr.DEFAULT_CELLPAGEATTR;
            }
            boolean bl = cellPageAttr.isRepeat() && !(cellElement.getValue() instanceof ResultSubReport);
            Rectangle rectangle4 = null;
            Rectangle rectangle5 = null;
            if (!rectangle3.equals(rectangle2)) {
                FT fT;
                int n;
                if (!bl) {
                    rectangle4 = new Rectangle(dynamicValueList.getRangeValue(rectangle3.x, rectangle2.x), dynamicValueList2.getRangeValue(rectangle3.y, rectangle2.y), dynamicValueList.getRangeValue(rectangle2.x, rectangle2.x + rectangle2.width), dynamicValueList2.getRangeValue(rectangle2.y, rectangle2.y + rectangle2.height));
                    rectangle5 = new Rectangle(-rectangle4.x, -rectangle4.y, dynamicValueList.getRangeValue(rectangle3.x, rectangle3.x + rectangle3.width), dynamicValueList2.getRangeValue(rectangle3.y, rectangle3.y + rectangle3.height));
                }
                int n2 = 0;
                int n3 = 0;
                int n4 = 0;
                for (n = 0; n < fTArray.length; ++n) {
                    fT = fTArray[n];
                    if (rectangle2.x >= fT.to || fT.from >= rectangle2.x + rectangle2.width) continue;
                    if (this.current_ci > n) {
                        return null;
                    }
                    ++n2;
                    n3 += Math.min(fT.to, rectangle2.x + rectangle2.width) - Math.max(rectangle2.x, fT.from);
                }
                for (n = 0; n < fTArray2.length; ++n) {
                    fT = fTArray2[n];
                    if (rectangle2.y >= fT.to || fT.from >= rectangle2.y + rectangle2.height) continue;
                    if (this.current_ri > n) {
                        return null;
                    }
                    ++n2;
                    n4 += Math.min(fT.to, rectangle2.y + rectangle2.height) - Math.max(rectangle2.y, fT.from);
                }
                if (n2 > 1) {
                    if (n3 == 0) {
                        n3 = rectangle3.width;
                    }
                    if (n4 == 0) {
                        n4 = rectangle3.height;
                    }
                    coverCellElement = new CoverCellElement(cellElement, point.x + rectangle3.x - rectangle.x, point.y + rectangle3.y - rectangle.y, n3, n4);
                }
            }
            if (coverCellElement == null) {
                coverCellElement = new CoverCellElement(cellElement, point.x + rectangle3.x - rectangle.x, point.y + rectangle3.y - rectangle.y, rectangle3.width, rectangle3.height);
            }
            ReportPage.this.checkCellElementValue(coverCellElement, cellElement, rectangle3, rectangle2, rectangle4, rectangle5);
            return coverCellElement;
        }
    }

    private class PageCellIterator
    implements Iterator {
        private int current_ri = 0;
        private int current_row = 0;
        private int current_ci = 0;
        private Iterator current_it = null;
        private Cell next = null;
        private Point offsetColumnRow = new Point(0, 0);
        private List mergedCellList = new ArrayList();

        private PageCellIterator() {
            this.findNext();
        }

        public boolean hasNext() {
            return this.next != null;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("At last element");
            }
            Cell cell = this.next;
            this.findNext();
            return cell;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void findNext() {
            for (int i = this.current_ri; i < ReportPage.this.row_line_array.length; ++i) {
                FT fT = ReportPage.this.row_line_array[i];
                this.current_ri = i;
                for (int j = this.current_row; j < fT.to - fT.from; ++j) {
                    this.current_row = j;
                    for (int k = this.current_ci; k < ReportPage.this.column_line_array.length; ++k) {
                        Cloneable cloneable;
                        this.current_ci = k;
                        FT fT2 = ReportPage.this.column_line_array[k];
                        Rectangle rectangle = new Rectangle(fT2.from, fT.from, fT2.to - fT2.from, fT.to - fT.from);
                        if (this.current_it == null) {
                            cloneable = new Rectangle(fT2.from, fT.from + j, fT2.to - fT2.from, 1);
                            this.current_it = ReportPage.this.cellIterator((Rectangle)cloneable);
                        }
                        while (this.current_it.hasNext()) {
                            Cell cell;
                            cloneable = (CellElement)this.current_it.next();
                            if (j > 0 && cloneable.getRow() < fT.from + j || (cell = this.intersectCell((CellElement)cloneable, rectangle, this.offsetColumnRow, ReportPage.this.column_line_array, ReportPage.this.row_line_array, ReportPage.this.columnWidthList, ReportPage.this.rowHeightList)) == null) continue;
                            this.next = cell;
                            return;
                        }
                        this.current_it = null;
                        this.offsetColumnRow.x += fT2.to - fT2.from;
                    }
                    this.current_ci = 0;
                    this.offsetColumnRow.x = 0;
                }
                this.current_row = 0;
                this.offsetColumnRow.y += fT.to - fT.from;
            }
            this.next = null;
        }

        private Cell intersectCell(CellElement cellElement, Rectangle rectangle, Point point, FT[] fTArray, FT[] fTArray2, DynamicValueList dynamicValueList, DynamicValueList dynamicValueList2) {
            Rectangle rectangle2 = new Rectangle(cellElement.getColumn(), cellElement.getRow(), cellElement.getColumnSpan(), cellElement.getRowSpan());
            Rectangle rectangle3 = rectangle2.intersection(rectangle);
            CoverCellElement coverCellElement = null;
            CellPageAttr cellPageAttr = cellElement.getCellPageAttr();
            if (cellPageAttr == null) {
                cellPageAttr = CellPageAttr.DEFAULT_CELLPAGEATTR;
            }
            boolean bl = cellPageAttr.isRepeat() && !(cellElement.getValue() instanceof ResultSubReport);
            Rectangle rectangle4 = null;
            Rectangle rectangle5 = null;
            Rectangle rectangle6 = null;
            Rectangle rectangle7 = null;
            if (!rectangle3.equals(rectangle2)) {
                FT fT;
                int n;
                int n2;
                int n3;
                int n4;
                if (!bl) {
                    rectangle6 = new Rectangle(dynamicValueList.getRangeValue(rectangle.x, rectangle2.x), dynamicValueList2.getRangeValue(rectangle.y, rectangle2.y), dynamicValueList.getRangeValue(rectangle2.x, rectangle2.x + rectangle2.width), dynamicValueList2.getRangeValue(rectangle2.y, rectangle2.y + rectangle2.height));
                    n4 = 0;
                    if (rectangle.x > rectangle2.x) {
                        n4 = dynamicValueList.getRangeValue(rectangle2.x, rectangle.x);
                    }
                    n3 = dynamicValueList.getRangeValue(rectangle3.x, rectangle3.x + rectangle3.width);
                    n2 = 0;
                    if (rectangle.y > rectangle2.y) {
                        n2 = dynamicValueList2.getRangeValue(rectangle2.y, rectangle.y);
                    }
                    n = dynamicValueList2.getRangeValue(rectangle3.y, rectangle3.y + rectangle3.height);
                    rectangle7 = new Rectangle(n4, n2, n3, n);
                    rectangle4 = new Rectangle(dynamicValueList.getRangeValue(rectangle3.x, rectangle2.x), dynamicValueList2.getRangeValue(rectangle3.y, rectangle2.y), dynamicValueList.getRangeValue(rectangle2.x, rectangle2.x + rectangle2.width), dynamicValueList2.getRangeValue(rectangle2.y, rectangle2.y + rectangle2.height));
                    rectangle5 = new Rectangle(-rectangle4.x, -rectangle4.y, dynamicValueList.getRangeValue(rectangle3.x, rectangle3.x + rectangle3.width), dynamicValueList2.getRangeValue(rectangle3.y, rectangle3.y + rectangle3.height));
                }
                if (this.mergedCellList.contains(cellElement)) {
                    return null;
                }
                n4 = 0;
                n3 = 0;
                n2 = 0;
                for (n = 0; n < fTArray.length; ++n) {
                    fT = fTArray[n];
                    if (rectangle2.x >= fT.to || fT.from >= rectangle2.x + rectangle2.width) continue;
                    ++n4;
                    n3 += Math.min(fT.to, rectangle2.x + rectangle2.width) - Math.max(rectangle2.x, fT.from);
                }
                for (n = 0; n < fTArray2.length; ++n) {
                    fT = fTArray2[n];
                    if (rectangle2.y >= fT.to || fT.from >= rectangle2.y + rectangle2.height) continue;
                    ++n4;
                    n2 += Math.min(fT.to, rectangle2.y + rectangle2.height) - Math.max(rectangle2.y, fT.from);
                }
                if (n4 > 1) {
                    this.mergedCellList.add(cellElement);
                    if (n3 == 0) {
                        n3 = rectangle3.width;
                    }
                    if (n2 == 0) {
                        n2 = rectangle3.height;
                    }
                    coverCellElement = new CoverCellElement(cellElement, point.x + rectangle3.x - rectangle.x, point.y + rectangle3.y - rectangle.y, n3, n2);
                }
            }
            if (coverCellElement == null) {
                coverCellElement = new CoverCellElement(cellElement, point.x + rectangle3.x - rectangle.x, point.y + rectangle3.y - rectangle.y, rectangle3.width, rectangle3.height);
            }
            if (rectangle6 != null) {
                coverCellElement.setCellPaintInfo(rectangle6, rectangle7, cellElement.getValue());
            }
            ReportPage.this.checkCellElementValue(coverCellElement, cellElement, rectangle3, rectangle2, rectangle4, rectangle5);
            return coverCellElement;
        }
    }
}

