/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report;

import com.fr.base.Inter;
import com.fr.base.XMLable;
import com.fr.base.background.Background;
import com.fr.base.background.ColorBackground;
import com.fr.base.core.ComparatorUtils;
import com.fr.base.xml.BaseXMLUtils;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.report.CellElement;
import com.fr.report.ParameterReport;
import com.fr.report.io.xml.ReportXMLUtils;
import com.fr.report.io.xml.SynchronizedNameWidget;
import com.fr.report.parameter.CustomParameterUI;
import com.fr.report.parameter.Parameter;
import com.fr.report.parameter.ParameterProcessor;
import com.fr.report.parameter.ParameterUI;
import com.fr.report.web.ui.FieldEditor;
import com.fr.report.web.ui.Widget;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class ReportParameterAttr
implements XMLable {
    public static final int POPUP = 0;
    public static final int EMBED = 1;
    private boolean delayPlaying = true;
    private boolean showWindow = false;
    private int windowPosition = 1;
    private static final int LEFTPOSITION = 0;
    private static final int CENTERPOSITION = 1;
    private static final int RIGHTPOSITION = 2;
    private int align = 1;
    private Background background = ColorBackground.getInstance(new Color(238, 238, 238));
    private ParameterUI parameterUI = null;
    private ParameterProcessor parameterProcessor = null;
    private List parameters = new ArrayList();
    private String parameterWindowTitle = Inter.getLocText("Parameter");

    public String getParameterWindowTitle() {
        return this.parameterWindowTitle;
    }

    public void setParameterWindowTitle(String string) {
        this.parameterWindowTitle = string;
    }

    public boolean isShowWindow() {
        return this.showWindow;
    }

    public void setShowWindow(boolean bl) {
        this.showWindow = bl;
    }

    public boolean isDelayPlaying() {
        return this.delayPlaying;
    }

    public void setDelayPlaying(boolean bl) {
        this.delayPlaying = bl;
    }

    public int getWindowPosition() {
        return this.windowPosition;
    }

    public void setWindowPosition(int n) {
        this.windowPosition = n;
    }

    public void setAlign(int n) {
        this.align = n;
    }

    public int getAlign() {
        return this.align;
    }

    public ParameterUI getParameterUI() {
        return this.parameterUI;
    }

    public void setParameterUI(ParameterUI parameterUI) {
        this.parameterUI = parameterUI;
    }

    public ParameterProcessor getParameterProcessor() {
        return this.parameterProcessor;
    }

    public void setParameterProcessor(ParameterProcessor parameterProcessor) {
        this.parameterProcessor = parameterProcessor;
    }

    public void addParameter(Parameter parameter) {
        this.parameters.add(parameter);
    }

    public void clearParameters() {
        this.parameters.clear();
    }

    public void clearParameter(Parameter parameter) {
        this.parameters.remove(parameter);
    }

    public Parameter[] getParameters() {
        return this.parameters.toArray(new Parameter[this.parameters.size()]);
    }

    public Background getBackground() {
        return this.background;
    }

    public void setBackground(Background background) {
        this.background = background;
    }

    public void readXML(XMLableReader xMLableReader) {
        String string = null;
        if (xMLableReader.isChildNode()) {
            String string2 = xMLableReader.getTagName();
            if ("Attributes".equals(string2)) {
                string = xMLableReader.getAttr("showWindow");
                if (string != null) {
                    this.setShowWindow(Boolean.valueOf(string));
                }
                if ((string = xMLableReader.getAttr("delayPlaying")) != null) {
                    this.setDelayPlaying(Boolean.valueOf(string));
                }
                if ((string = xMLableReader.getAttr("windowPosition")) != null) {
                    this.setWindowPosition(Integer.parseInt(string));
                }
                if ((string = xMLableReader.getAttr("align")) != null) {
                    this.setAlign(Integer.parseInt(string));
                }
                if ((string = xMLableReader.getAttr("userDefineWindow")) != null) {
                    this.parameterUI = Boolean.valueOf(string).booleanValue() ? new CustomParameterUI() : CustomParameterUI.createDefaultParameterUI();
                }
            } else if ("ParameterInterface".equals(string2) || "ParameterUI".equals(string2)) {
                if (ComparatorUtils.equals(xMLableReader.getAttr("class"), "com.fr.report.parameter.DefaultParameterInterface")) {
                    this.setShowWindow(false);
                } else {
                    this.setParameterUI(ReportXMLUtils.readParameterUI(xMLableReader));
                }
            } else if ("PP".equals(string2)) {
                this.parameterProcessor = ReportXMLUtils.readParameterProcessor(xMLableReader);
            } else if ("PWTitle".equals(string2)) {
                this.setParameterWindowTitle(xMLableReader.getElementValue());
            } else if ("Parameter".equals(string2)) {
                this.parameters.add(ReportXMLUtils.readParameter(xMLableReader));
            } else if ("WorkSheet".equals(string2)) {
                ParameterReport parameterReport = new ParameterReport();
                xMLableReader.readXMLObject(parameterReport);
                Iterator iterator = parameterReport.cellIterator();
                while (iterator.hasNext()) {
                    Object object;
                    CellElement cellElement = (CellElement)iterator.next();
                    if (cellElement.getValue() instanceof Parameter) {
                        object = (Parameter)cellElement.getValue();
                        cellElement.setValue(((Parameter)object).getValue());
                        continue;
                    }
                    if (cellElement.getValue() instanceof FieldEditor) {
                        object = SynchronizedNameWidget.getDefaultValue(((FieldEditor)cellElement.getValue()).getFieldName());
                        cellElement.setWidget((Widget)cellElement.getValue());
                        cellElement.setValue(object);
                        continue;
                    }
                    if (!(cellElement.getValue() instanceof Widget)) continue;
                    cellElement.setWidget((Widget)cellElement.getValue());
                    cellElement.setValue(null);
                }
                if (parameterReport != null && this.getParameterUI() instanceof CustomParameterUI) {
                    this.setParameterUI(new CustomParameterUI(parameterReport));
                }
            } else if ("Parameters".equals(string2)) {
                this.parameters.addAll(Arrays.asList(ReportXMLUtils.readParameters(xMLableReader)));
            } else if ("Background".equals(string2)) {
                this.setBackground(BaseXMLUtils.readBackground(xMLableReader));
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("Attributes").attr("showWindow", this.showWindow).attr("delayPlaying", this.delayPlaying).attr("windowPosition", this.windowPosition).attr("align", this.align).end();
        xMLPrintWriter.startTAG("PWTitle").textNode(this.getParameterWindowTitle()).end();
        ReportXMLUtils.writeXMLable(xMLPrintWriter, this.parameterUI, "ParameterUI");
        int n = this.parameters.size();
        for (int i = 0; i < n; ++i) {
            ReportXMLUtils.writeParameter(xMLPrintWriter, (Parameter)this.parameters.get(i));
        }
        if (this.parameterProcessor != null) {
            ReportXMLUtils.writeParameterProcessor(xMLPrintWriter, this.parameterProcessor);
        }
        if (!ColorBackground.getInstance(new Color(238, 238, 238)).equals(this.background)) {
            BaseXMLUtils.writeBackground(xMLPrintWriter, this.background);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        ReportParameterAttr reportParameterAttr = (ReportParameterAttr)super.clone();
        if (this.parameterUI != null) {
            reportParameterAttr.parameterUI = (ParameterUI)this.parameterUI.clone();
        }
        if (this.parameterProcessor != null) {
            reportParameterAttr.parameterProcessor = (ParameterProcessor)this.parameterProcessor.clone();
        }
        reportParameterAttr.parameters = new ArrayList();
        int n = this.parameters.size();
        for (int i = 0; i < n; ++i) {
            reportParameterAttr.parameters.add(((Parameter)this.parameters.get(i)).clone());
        }
        return reportParameterAttr;
    }
}

