/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report;

import com.fr.base.ColumnRow;
import com.fr.base.XMLable;
import com.fr.base.background.Background;
import com.fr.base.background.ColorBackground;
import com.fr.base.xml.BaseXMLUtils;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.report.Margin;
import com.fr.report.PaperSize;
import java.awt.Color;
import java.io.Serializable;

public class ReportSettings
implements XMLable,
Cloneable,
Serializable {
    public static final ReportSettings DEFAULTSETTINGS = new ReportSettings();
    public static final int DEFAULT_RESOLUTION = 96;
    private static final long serialVersionUID = -3314213013399129839L;
    public static final String XML_TAG = "ReportSettings";
    private int orientation = 0;
    private PaperSize paperSize = new PaperSize();
    private Margin margin = new Margin(0.27, 0.75, 0.27, 0.75);
    private boolean lonelyPage = false;
    private int resolution = 96;
    private int pageOrder = 0;
    private boolean isHorizontalCenterOnPage = false;
    private boolean isVerticalCenterOnPage = false;
    private int firstPageNumber = 1;
    private Background background = ColorBackground.getInstance(Color.white);
    private boolean isPreviewBackground = true;
    private boolean isPrintBackground = true;
    private ColumnRow writeFrozenColumnRow;
    private double headerHeight = 0.0;
    private double footerHeight = 0.0;
    private int shrinkToFitMode = 1;

    public ColumnRow getWriteFrozenColumnRow() {
        return this.writeFrozenColumnRow;
    }

    public void setWriteFrozenColumnRow(ColumnRow columnRow) {
        this.writeFrozenColumnRow = columnRow;
    }

    public boolean isLonelyPage() {
        return this.lonelyPage;
    }

    public void setLonelyPage(boolean bl) {
        this.lonelyPage = bl;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int n) {
        this.orientation = n;
    }

    public PaperSize getPaperSize() {
        return this.paperSize;
    }

    public void setPaperSize(PaperSize paperSize) {
        this.paperSize = paperSize;
    }

    public Margin getMargin() {
        return this.margin;
    }

    public void setMargin(Margin margin) {
        this.margin = margin;
    }

    public int getResolution() {
        return this.resolution;
    }

    public void setResolution(int n) {
        this.resolution = n;
    }

    public int getPageOrder() {
        return this.pageOrder;
    }

    public void setPageOrder(int n) {
        this.pageOrder = n;
    }

    public int getShrinkToFitMode() {
        return this.shrinkToFitMode;
    }

    public void setShrinkToFitMode(int n) {
        this.shrinkToFitMode = n;
    }

    public boolean isHorizontalCenterOnPage() {
        return this.isHorizontalCenterOnPage;
    }

    public void setHorizontalCenterOnPage(boolean bl) {
        this.isHorizontalCenterOnPage = bl;
    }

    public boolean isVerticalCenterOnPage() {
        return this.isVerticalCenterOnPage;
    }

    public void setVerticalCenterOnPage(boolean bl) {
        this.isVerticalCenterOnPage = bl;
    }

    public int getFirstPageNumber() {
        return this.firstPageNumber;
    }

    public void setFirstPageNumber(int n) {
        this.firstPageNumber = n;
    }

    public Background getBackground() {
        return this.background;
    }

    public void setBackground(Background background) {
        this.background = background;
    }

    public boolean isPreviewBackground() {
        return this.isPreviewBackground;
    }

    public void setPreviewBackground(boolean bl) {
        this.isPreviewBackground = bl;
    }

    public boolean isPrintBackground() {
        return this.isPrintBackground;
    }

    public void setPrintBackground(boolean bl) {
        this.isPrintBackground = bl;
    }

    public double getHeaderHeight() {
        return this.headerHeight;
    }

    public void setHeaderHeight(double d) {
        this.headerHeight = d;
    }

    public double getFooterHeight() {
        return this.footerHeight;
    }

    public void setFooterHeight(double d) {
        this.footerHeight = d;
    }

    public void readXML(XMLableReader xMLableReader) {
        String string;
        if (xMLableReader.isAttr()) {
            string = xMLableReader.getAttr("firstPageNumber");
            if (string != null) {
                this.setFirstPageNumber(Integer.parseInt(string));
            }
            if ((string = xMLableReader.getAttr("orientation")) != null) {
                this.setOrientation(Integer.parseInt(string));
            }
            if ((string = xMLableReader.getAttr("resolution")) != null) {
                this.setResolution(Integer.parseInt(string));
            }
            if ((string = xMLableReader.getAttr("pageOrder")) != null) {
                this.setPageOrder(Integer.parseInt(string));
            }
            if ((string = xMLableReader.getAttr("shrinkToFit")) != null) {
                this.setShrinkToFitMode(Boolean.valueOf(string) != false ? 1 : 0);
            }
            if ((string = xMLableReader.getAttr("shrinkToFitMode")) != null) {
                this.setShrinkToFitMode(Integer.parseInt(string));
            }
            if ((string = xMLableReader.getAttr("isLonelyPage")) != null) {
                this.setLonelyPage(Boolean.valueOf(string));
            }
            if ((string = xMLableReader.getAttr("isHorizontalCenterOnPage")) != null) {
                this.setHorizontalCenterOnPage(Boolean.valueOf(string));
            }
            if ((string = xMLableReader.getAttr("isVerticalCenterOnPage")) != null) {
                this.setVerticalCenterOnPage(Boolean.valueOf(string));
            }
            if ((string = xMLableReader.getAttr("firstPageNumber")) != null) {
                this.setFirstPageNumber(Integer.parseInt(string));
            }
            if ((string = xMLableReader.getAttr("headerHeight")) != null) {
                this.setHeaderHeight(Double.parseDouble(string));
            }
            if ((string = xMLableReader.getAttr("footerHeight")) != null) {
                this.setFooterHeight(Double.parseDouble(string));
            }
            if ((string = xMLableReader.getAttr("previewBackground")) != null) {
                this.setPreviewBackground(Boolean.valueOf(string));
            }
            if ((string = xMLableReader.getAttr("printBackground")) != null) {
                this.setPrintBackground(Boolean.valueOf(string));
            }
        }
        if (xMLableReader.isChildNode()) {
            ColumnRow columnRow;
            String string2 = xMLableReader.getTagName();
            if (string2.equals("PaperSize")) {
                PaperSize paperSize = this.getPaperSize();
                if (paperSize == null) {
                    paperSize = new PaperSize();
                    this.setPaperSize(paperSize);
                }
                if ((string = xMLableReader.getAttr("width")) != null) {
                    paperSize.setWidth(Double.parseDouble(string));
                }
                if ((string = xMLableReader.getAttr("height")) != null) {
                    paperSize.setHeight(Double.parseDouble(string));
                }
            } else if (string2.equals("Margin")) {
                Margin margin = this.getMargin();
                if (margin == null) {
                    margin = new Margin();
                    this.setMargin(margin);
                }
                if ((string = xMLableReader.getAttr("top")) != null) {
                    margin.setTop(Double.parseDouble(string));
                }
                if ((string = xMLableReader.getAttr("left")) != null) {
                    margin.setLeft(Double.parseDouble(string));
                }
                if ((string = xMLableReader.getAttr("bottom")) != null) {
                    margin.setBottom(Double.parseDouble(string));
                }
                if ((string = xMLableReader.getAttr("right")) != null) {
                    margin.setRight(Double.parseDouble(string));
                }
            } else if (string2.equals("Background")) {
                this.setBackground(BaseXMLUtils.readBackground(xMLableReader));
            } else if (xMLableReader.getTagName().equals("FrozenColumnRow") && (string = xMLableReader.getAttr("columnrow")) != null && ColumnRow.validate(columnRow = ColumnRow.valueOf(string))) {
                this.setWriteFrozenColumnRow(columnRow);
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        Margin margin;
        PaperSize paperSize;
        xMLPrintWriter.startTAG(XML_TAG);
        if (this.getFirstPageNumber() != 1) {
            xMLPrintWriter.attr("firstPageNumber", this.getFirstPageNumber());
        }
        if (this.getOrientation() != 0) {
            xMLPrintWriter.attr("orientation", this.getOrientation());
        }
        if (this.getResolution() != 96) {
            xMLPrintWriter.attr("resolution", this.getResolution());
        }
        if (this.getPageOrder() != 0) {
            xMLPrintWriter.attr("paegOrder", this.getPageOrder());
        }
        if (this.shrinkToFitMode != 1) {
            xMLPrintWriter.attr("shrinkToFitMode", this.getShrinkToFitMode());
        }
        if (this.isLonelyPage()) {
            xMLPrintWriter.attr("isLonelyPage", this.isLonelyPage());
        }
        if (this.isHorizontalCenterOnPage()) {
            xMLPrintWriter.attr("isHorizontalCenterOnPage", this.isHorizontalCenterOnPage());
        }
        if (this.isVerticalCenterOnPage()) {
            xMLPrintWriter.attr("isVerticalCenterOnPage", this.isVerticalCenterOnPage());
        }
        if (this.getHeaderHeight() != 0.53) {
            xMLPrintWriter.attr("headerHeight", this.getHeaderHeight());
        }
        if (this.getFooterHeight() != 0.53) {
            xMLPrintWriter.attr("footerHeight", this.getFooterHeight());
        }
        if (!this.isPrintBackground()) {
            xMLPrintWriter.attr("printBackground", this.isPrintBackground());
        }
        if (ColumnRow.validate(this.writeFrozenColumnRow)) {
            xMLPrintWriter.startTAG("FrozenColumnRow").attr("columnrow", this.writeFrozenColumnRow.toString()).end();
        }
        if ((paperSize = this.getPaperSize()) != null && !paperSize.equals(PaperSize.PAPERSIZE_A4)) {
            xMLPrintWriter.startTAG("PaperSize").attr("width", paperSize.getWidth()).attr("height", paperSize.getHeight()).end();
        }
        if ((margin = this.getMargin()) != null && (margin.getTop() != 0.47 || margin.getLeft() != 0.75 || margin.getBottom() != 0.47 || margin.getRight() != 0.75)) {
            xMLPrintWriter.startTAG("Margin").attr("top", margin.getTop()).attr("left", margin.getLeft()).attr("bottom", margin.getBottom()).attr("right", margin.getRight()).end();
        }
        Background background = this.getBackground();
        if (!ColorBackground.getInstance(Color.white).equals(background)) {
            BaseXMLUtils.writeBackground(xMLPrintWriter, background);
        }
        xMLPrintWriter.end();
    }

    public Object clone() throws CloneNotSupportedException {
        ReportSettings reportSettings = (ReportSettings)super.clone();
        reportSettings.setPaperSize((PaperSize)this.getPaperSize().clone());
        reportSettings.setMargin((Margin)this.getMargin().clone());
        if (this.writeFrozenColumnRow != null) {
            reportSettings.setWriteFrozenColumnRow((ColumnRow)this.writeFrozenColumnRow.clone());
        }
        if (this.getBackground() != null) {
            reportSettings.setBackground((Background)this.getBackground().clone());
        } else {
            reportSettings.setBackground(null);
        }
        return reportSettings;
    }
}

