/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report;

import com.fr.base.ColumnRow;
import com.fr.base.StringUtils;
import com.fr.base.background.Background;
import com.fr.base.background.ColorBackground;
import com.fr.base.xml.BaseXMLUtils;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLReadable;
import com.fr.base.xml.XMLableReader;
import com.fr.report.io.xml.SynchronizedFrozenColumnRow;
import com.fr.report.web.EmailManager;
import com.fr.report.web.Printer;
import com.fr.report.web.ToolBarManager;
import com.fr.report.web.WebForm;
import com.fr.report.web.WebPage;
import com.fr.report.web.WebView;
import com.fr.report.web.WebWrite;
import java.awt.Color;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class ReportWebAttr
implements XMLReadable,
Cloneable,
Serializable {
    private String title = null;
    private EmailManager email;
    private Printer printer;
    private WebPage page = null;
    private WebView view = null;
    private WebForm form = null;
    private WebWrite write = null;
    private List jsImportList = null;
    private List cssImportList = null;
    private List writeCssImportList = null;
    private List widgetCssImportList = null;
    private Background background = null;
    private long cacheValidateTime = 0L;

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public void setCacheValidateTime(long l) {
        this.cacheValidateTime = l;
    }

    public long getCacheValidateTime() {
        return this.cacheValidateTime;
    }

    public WebPage getWebPage() {
        return this.page;
    }

    public void setWebPage(WebPage webPage) {
        this.page = webPage;
    }

    public WebView getWebView() {
        return this.view;
    }

    public void setWebView(WebView webView) {
        this.view = webView;
    }

    public WebForm getWebForm() {
        return this.form;
    }

    public void setWebForm(WebForm webForm) {
        this.form = webForm;
    }

    public WebWrite getWebWrite() {
        return this.write;
    }

    public void setWebWrite(WebWrite webWrite) {
        this.write = webWrite;
    }

    public EmailManager getEmailManager() {
        return this.email;
    }

    public void setEmailManager(EmailManager emailManager) {
        this.email = emailManager;
    }

    public Printer getPrinter() {
        return this.printer;
    }

    public void setPrinter(Printer printer) {
        this.printer = printer;
    }

    public Background getBackground() {
        return this.background;
    }

    public void setBackground(Background background) {
        this.background = background;
    }

    public int getJSImportCount() {
        return this.jsImportList == null ? 0 : this.jsImportList.size();
    }

    public String getJSImport(int n) {
        return this.jsImportList == null ? null : (String)this.jsImportList.get(n);
    }

    public void clearJSImportList() {
        if (this.jsImportList != null) {
            this.jsImportList.clear();
        }
    }

    public void addJSImport(String string) {
        if (this.jsImportList == null) {
            this.jsImportList = new ArrayList();
        }
        this.jsImportList.add(string);
    }

    public int getCSSImportCount() {
        return this.cssImportList == null ? 0 : this.cssImportList.size();
    }

    public String getCSSImport(int n) {
        return this.cssImportList == null ? null : (String)this.cssImportList.get(n);
    }

    public void clearCSSImportList() {
        if (this.cssImportList != null) {
            this.cssImportList.clear();
        }
    }

    public void addCSSImport(String string) {
        if (this.cssImportList == null) {
            this.cssImportList = new ArrayList();
        }
        this.cssImportList.add(string);
    }

    public int getWriteCSSImportCount() {
        return this.writeCssImportList == null ? 0 : this.writeCssImportList.size();
    }

    public String getWriteCSSImport(int n) {
        return this.writeCssImportList == null ? null : (String)this.writeCssImportList.get(n);
    }

    public void clearWriteCSSImportList() {
        if (this.writeCssImportList != null) {
            this.writeCssImportList.clear();
        }
    }

    public void addWriteCSSImport(String string) {
        if (this.writeCssImportList == null) {
            this.writeCssImportList = new ArrayList();
        }
        this.writeCssImportList.add(string);
    }

    public int getWidgetCSSImportCount() {
        return this.widgetCssImportList == null ? 0 : this.widgetCssImportList.size();
    }

    public String getWidgetCSSImport(int n) {
        return this.widgetCssImportList == null ? null : (String)this.widgetCssImportList.get(n);
    }

    public void clearWidgetCSSImportList() {
        if (this.widgetCssImportList != null) {
            this.widgetCssImportList.clear();
        }
    }

    public void addWidgetCSSImport(String string) {
        if (this.widgetCssImportList == null) {
            this.widgetCssImportList = new ArrayList();
        }
        this.widgetCssImportList.add(string);
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string;
            String string2 = xMLableReader.getTagName();
            if (string2.equals("Title")) {
                String string3 = xMLableReader.getElementValue();
                if (StringUtils.isNotBlank(string3)) {
                    this.setTitle(string3);
                }
            } else if (string2.equals("ServerPrinter")) {
                this.printer = new Printer();
                xMLableReader.readXMLObject(this.printer);
            } else if (string2.equals("EmailManager")) {
                this.email = new EmailManager();
                xMLableReader.readXMLObject(this.email);
            } else if (string2.equals("Background")) {
                this.setBackground(BaseXMLUtils.readBackground(xMLableReader));
            } else if (string2.equals("CSSImport")) {
                String string4 = xMLableReader.getElementValue();
                if (string4 != null) {
                    this.addCSSImport(string4);
                }
            } else if (string2.equals("WriteCSSImport")) {
                String string5 = xMLableReader.getElementValue();
                if (string5 != null) {
                    this.addWriteCSSImport(string5);
                }
            } else if (string2.equals("WidgetCSSImport")) {
                String string6 = xMLableReader.getElementValue();
                if (string6 != null) {
                    this.addWidgetCSSImport(string6);
                }
            } else if (string2.equals("JSImport")) {
                String string7 = xMLableReader.getElementValue();
                if (string7 != null) {
                    this.addJSImport(string7);
                }
            } else if (string2.equals("WebPageContent")) {
                this.page = new WebPage();
                xMLableReader.readXMLObject(this.page);
            } else if (string2.equals("WebViewContent")) {
                this.view = new WebView();
                xMLableReader.readXMLObject(this.view);
            } else if (string2.equals("WebWriteContent")) {
                this.write = new WebWrite();
                xMLableReader.readXMLObject(this.write);
            } else if ("WebFormContent".equals(string2)) {
                this.form = new WebForm();
                xMLableReader.readXMLObject(this.form);
            } else if ("CacheValidateTime".equals(string2)) {
                this.setCacheValidateTime(Long.parseLong(xMLableReader.getElementValue()));
            } else if (string2.equals("ToolbarManager")) {
                ToolBarManager toolBarManager = new ToolBarManager();
                xMLableReader.readXMLObject(toolBarManager);
                if (this.page == null) {
                    this.page = new WebPage();
                }
                this.page.setToolBarManagers(new ToolBarManager[]{toolBarManager});
            } else if (string2.equals("FrozenColumnRow") && ((string = xMLableReader.getAttr("FrozenColumnRow")) != null || (string = xMLableReader.getAttr("frozenColumnRow")) != null)) {
                ColumnRow columnRow = ColumnRow.valueOf(string);
                if (this.write == null) {
                    this.write = new WebWrite();
                }
                SynchronizedFrozenColumnRow.putSynchronizedFrozenColumnRow(columnRow);
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        int n;
        if (StringUtils.isNotBlank(this.getTitle())) {
            xMLPrintWriter.startTAG("Title").textNode(this.getTitle()).end();
        }
        if (this.email != null) {
            this.email.writeXML(xMLPrintWriter);
        }
        if (this.printer != null) {
            this.printer.writeXML(xMLPrintWriter);
        }
        if (this.page != null) {
            xMLPrintWriter.startTAG("WebPageContent");
            this.page.writeXML(xMLPrintWriter);
            xMLPrintWriter.end();
        }
        if (this.view != null) {
            xMLPrintWriter.startTAG("WebViewContent");
            this.view.writeXML(xMLPrintWriter);
            xMLPrintWriter.end();
        }
        if (this.form != null) {
            xMLPrintWriter.startTAG("WebFormContent");
            this.form.writeXML(xMLPrintWriter);
            xMLPrintWriter.end();
        }
        if (this.write != null) {
            xMLPrintWriter.startTAG("WebWriteContent");
            this.write.writeXML(xMLPrintWriter);
            xMLPrintWriter.end();
        }
        Background background = this.getBackground();
        if (!ColorBackground.getInstance(Color.white).equals(background)) {
            BaseXMLUtils.writeBackground(xMLPrintWriter, background);
        }
        int n2 = this.getCSSImportCount();
        for (n = 0; n < n2; ++n) {
            xMLPrintWriter.startTAG("CSSImport").textNode(this.getCSSImport(n)).end();
        }
        n2 = this.getWriteCSSImportCount();
        for (n = 0; n < n2; ++n) {
            xMLPrintWriter.startTAG("WriteCSSImport").textNode(this.getWriteCSSImport(n)).end();
        }
        n2 = this.getWidgetCSSImportCount();
        for (n = 0; n < n2; ++n) {
            xMLPrintWriter.startTAG("WidgetCSSImport").textNode(this.getWidgetCSSImport(n)).end();
        }
        n2 = this.getJSImportCount();
        for (n = 0; n < n2; ++n) {
            xMLPrintWriter.startTAG("JSImport").textNode(this.getJSImport(n)).end();
        }
        xMLPrintWriter.startTAG("CacheValidateTime").textNode(String.valueOf(this.cacheValidateTime)).end();
    }

    public Object clone() throws CloneNotSupportedException {
        ReportWebAttr reportWebAttr = (ReportWebAttr)super.clone();
        if (this.background != null) {
            reportWebAttr.background = (Background)this.background.clone();
        }
        if (this.email != null) {
            reportWebAttr.email = (EmailManager)this.email.clone();
        }
        if (this.printer != null) {
            reportWebAttr.printer = (Printer)this.printer.clone();
        }
        if (this.page != null) {
            reportWebAttr.page = (WebPage)this.page.clone();
        }
        if (this.view != null) {
            reportWebAttr.view = (WebView)this.view.clone();
        }
        if (this.form != null) {
            reportWebAttr.form = (WebForm)this.form.clone();
        }
        if (this.write != null) {
            reportWebAttr.write = (WebWrite)this.write.clone();
        }
        if (this.cssImportList != null) {
            reportWebAttr.cssImportList = new ArrayList();
            reportWebAttr.cssImportList.addAll(this.cssImportList);
        }
        if (this.writeCssImportList != null) {
            reportWebAttr.writeCssImportList = new ArrayList();
            reportWebAttr.writeCssImportList.addAll(this.writeCssImportList);
        }
        if (this.widgetCssImportList != null) {
            reportWebAttr.widgetCssImportList = new ArrayList();
            reportWebAttr.widgetCssImportList.addAll(this.widgetCssImportList);
        }
        if (this.jsImportList != null) {
            reportWebAttr.jsImportList = new ArrayList();
            reportWebAttr.jsImportList.addAll(this.jsImportList);
        }
        return reportWebAttr;
    }
}

