/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report;

import com.fr.base.FRContext;
import com.fr.base.Inter;
import com.fr.base.XMLable;
import com.fr.base.core.FRCoreContext;
import com.fr.base.core.util.vt.VT4FR;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.report.ResultReport;
import com.fr.report.TableDataSource;
import com.fr.report.cellElement.Formula;
import com.fr.report.core.FormException;
import com.fr.report.write.BuiltInSQLSubmiter;
import com.fr.report.write.ClassSubmiter;
import com.fr.report.write.FreeSQLSubmiter;
import com.fr.report.write.Submiter;
import com.fr.report.write.ValueVerifier;
import com.fr.util.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public class ReportWriteAttr
implements XMLable {
    private List submiterNameList = new ArrayList();
    private List submiterList = new ArrayList();
    private List valueVerifierList = new ArrayList();

    public int getSubmiterCount() {
        return this.submiterList.size();
    }

    public Submiter getSubmiter(int n) {
        return (Submiter)this.submiterList.get(n);
    }

    public void addSubmiter(Submiter submiter) {
        this.submiterList.add(submiter);
        this.submiterNameList.add("");
    }

    public void addSubmiter(String string, Submiter submiter) {
        this.submiterList.add(submiter);
        this.submiterNameList.add(string);
    }

    public void clearSubmiters() {
        this.submiterList.clear();
        this.submiterNameList.clear();
    }

    public String getSubmiterNameList(int n) {
        return (String)this.submiterNameList.get(n);
    }

    public void addValueVerifier(ValueVerifier valueVerifier) {
        this.valueVerifierList.add(valueVerifier);
    }

    public void removeValueVerifier(int n) {
        this.valueVerifierList.remove(n);
    }

    public int getValueVerifierCount() {
        return this.valueVerifierList.size();
    }

    public ValueVerifier getValueVerifier(int n) {
        return (ValueVerifier)this.valueVerifierList.get(n);
    }

    public void clearValueVerifiers() {
        this.valueVerifierList.clear();
    }

    public void submit(ResultReport resultReport, TableDataSource tableDataSource, Map map) throws FormException {
        if (this.submiterList.size() > 0) {
            int n = this.submiterList.size();
            for (int i = 0; i < n && (VT4FR.ADVANCED_ONLINE_WRITE.support() || i <= 0); ++i) {
                Submiter submiter = (Submiter)this.submiterList.get(i);
                try {
                    submiter.execute(resultReport, tableDataSource, map);
                    continue;
                }
                catch (Exception exception) {
                    throw new FormException("submiter error happens.\n" + exception.getMessage(), exception);
                }
            }
        } else {
            FRContext.getLogger().log(Level.INFO, "No Sumbiter defined!");
        }
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if ("Submiter".equals(string)) {
                String string2 = null;
                String string3 = xMLableReader.getAttr("class");
                if (string3 != null) {
                    string2 = string3;
                }
                if (string2 == null) {
                    return;
                }
                String string4 = null;
                string3 = xMLableReader.getAttr("name");
                if (string3 != null) {
                    string4 = string3;
                }
                if (string4 == null) {
                    this.readOld6_2rcXML(xMLableReader);
                    return;
                }
                Submiter submiter = null;
                if (string2.endsWith(".BuiltInSQLSubmiter")) {
                    submiter = new BuiltInSQLSubmiter();
                } else if (string2.endsWith(".FreeSQLSubmiter")) {
                    submiter = new FreeSQLSubmiter();
                } else if (string2.endsWith(".ClassSubmiter")) {
                    submiter = new ClassSubmiter();
                } else {
                    try {
                        submiter = (Submiter)FRCoreContext.classForName(string2).newInstance();
                    }
                    catch (Exception exception) {
                        FRContext.getLogger().log(Level.SEVERE, "Load class with name: " + string3, exception);
                    }
                }
                xMLableReader.readXMLObject(submiter);
                this.addSubmiter(string4, submiter);
            } else if ("VV".equals(string)) {
                this.addValueVerifier((ValueVerifier)xMLableReader.readXMLObject(new ValueVerifier()));
            } else if ("ValueVerifier".equals(string)) {
                String[] stringArray;
                ValueVerifier valueVerifier = new ValueVerifier();
                String string5 = xMLableReader.getAttr("type");
                if (string5 != null) {
                    valueVerifier.setType(Integer.parseInt(string5));
                }
                if ((string5 = xMLableReader.getElementValue()) != null && (stringArray = Utils.splitString(string5, ",,.,,")) != null && stringArray.length == 2) {
                    valueVerifier.setFormula(new Formula(stringArray[0]));
                    valueVerifier.setMessage(stringArray[1]);
                }
            } else if ("WriteSQLAttr".equals(string) || "InsertAttr".equals(string)) {
                BuiltInSQLSubmiter builtInSQLSubmiter = new BuiltInSQLSubmiter();
                builtInSQLSubmiter.readOldXML(xMLableReader);
                this.addSubmiter(builtInSQLSubmiter);
            }
        }
    }

    private void readOld6_2rcXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if ("Submiter".equals(string)) {
                String string2 = null;
                String string3 = xMLableReader.getAttr("class");
                if (string3 != null) {
                    string2 = string3;
                }
                if (string2 == null) {
                    return;
                }
                Submiter submiter = null;
                if (string2.startsWith("BuiltInSQLSubmiter")) {
                    submiter = new BuiltInSQLSubmiter();
                    if (string2.equals("BuiltInSQLSubmiter")) {
                        this.addSubmiter(Inter.getLocText("RWA-BuildIn_SQL"), submiter);
                    } else {
                        this.addSubmiter(string2.replaceAll("BuiltInSQLSubmiter", ""), submiter);
                    }
                } else if (string2.startsWith("FreeSQLSubmiter")) {
                    submiter = new FreeSQLSubmiter();
                    if (string2.equals("FreeSQLSubmiter")) {
                        this.addSubmiter(Inter.getLocText("RWA-Free_SQL"), submiter);
                    } else {
                        this.addSubmiter(string2.replaceAll("FreeSQLSubmiter", ""), submiter);
                    }
                } else if (string2.startsWith("ClassSubmiter")) {
                    submiter = new ClassSubmiter();
                    if (string2.equals("ClassSubmiter")) {
                        this.addSubmiter(Inter.getLocText("RWA-Class"), submiter);
                    } else {
                        this.addSubmiter(string2.replaceAll("ClassSubmiter", ""), submiter);
                    }
                } else {
                    try {
                        submiter = (Submiter)FRCoreContext.classForName(string2).newInstance();
                    }
                    catch (Exception exception) {
                        FRContext.getLogger().log(Level.SEVERE, "Load class with name: " + string3, exception);
                    }
                }
                xMLableReader.readXMLObject(submiter);
                this.addSubmiter(submiter);
            } else if ("ValueVerifier".equals(string)) {
                String[] stringArray;
                ValueVerifier valueVerifier = new ValueVerifier();
                this.addValueVerifier(valueVerifier);
                String string4 = xMLableReader.getAttr("type");
                if (string4 != null) {
                    valueVerifier.setType(Integer.parseInt(string4));
                }
                if ((string4 = xMLableReader.getElementValue()) != null && (stringArray = Utils.splitString(string4, ",,.,,")) != null && stringArray.length == 2) {
                    valueVerifier.setFormula(new Formula(stringArray[0]));
                    valueVerifier.setMessage(stringArray[1]);
                }
            } else if ("WriteSQLAttr".equals(string) || "InsertAttr".equals(string)) {
                BuiltInSQLSubmiter builtInSQLSubmiter = new BuiltInSQLSubmiter();
                builtInSQLSubmiter.readOldXML(xMLableReader);
                this.addSubmiter(builtInSQLSubmiter);
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        int n;
        xMLPrintWriter.startTAG("ReportWriteAttr");
        int n2 = this.getSubmiterCount();
        for (n = 0; n < n2; ++n) {
            Submiter submiter = this.getSubmiter(n);
            xMLPrintWriter.startTAG("Submiter").attr("class", submiter.getClass().getName()).attr("name", this.getSubmiterNameList(n));
            submiter.writeXML(xMLPrintWriter);
            xMLPrintWriter.end();
        }
        int n3 = this.getValueVerifierCount();
        for (n = 0; n < n3; ++n) {
            ValueVerifier valueVerifier = this.getValueVerifier(n);
            valueVerifier.writeXML(xMLPrintWriter);
        }
        xMLPrintWriter.end();
    }

    public Object clone() throws CloneNotSupportedException {
        int n;
        ReportWriteAttr reportWriteAttr = (ReportWriteAttr)super.clone();
        if (this.submiterList != null) {
            reportWriteAttr.submiterList = new ArrayList();
            for (n = 0; n < this.submiterList.size(); ++n) {
                reportWriteAttr.submiterList.add(((Submiter)this.submiterList.get(n)).clone());
            }
        }
        if (this.submiterNameList != null) {
            reportWriteAttr.submiterNameList = new ArrayList();
            reportWriteAttr.submiterNameList.addAll(this.submiterNameList);
        }
        if (this.valueVerifierList != null) {
            reportWriteAttr.valueVerifierList = new ArrayList();
            for (n = 0; n < this.valueVerifierList.size(); ++n) {
                reportWriteAttr.valueVerifierList.add(((ValueVerifier)this.valueVerifierList.get(n)).clone());
            }
        }
        return reportWriteAttr;
    }
}

