/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report;

import com.fr.base.core.ComparatorUtils;
import com.fr.base.core.util.vt.VT4FR;
import com.fr.data.TableData;
import com.fr.report.AbstractTemplateWorkBook;
import com.fr.report.CellElement;
import com.fr.report.RWorkBook;
import com.fr.report.Report;
import com.fr.report.ReportParameterAttr;
import com.fr.report.ResultWorkBook;
import com.fr.report.TemplateReport;
import com.fr.report.cellElement.Formula;
import com.fr.report.cellElement.core.DSColumn;
import com.fr.report.core.ParameterHelper;
import com.fr.report.core.ScriptUtils;
import com.fr.report.parameter.Parameter;
import com.fr.report.script.Calculator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;

public class WorkBook
extends AbstractTemplateWorkBook {
    public WorkBook() {
    }

    public WorkBook(TemplateReport templateReport) {
        this.addReport(templateReport);
    }

    public void addReport(int n, TemplateReport templateReport) {
        super.addReport(n, null, templateReport);
    }

    public void addReport(int n, String string, TemplateReport templateReport) {
        super.addReport(n, string, templateReport);
    }

    public ResultWorkBook execute(Map map) {
        this.apply4Parameters(map);
        RWorkBook rWorkBook = new RWorkBook();
        this.dealWithExecutedAttr(rWorkBook);
        int n = this.getReportCount();
        for (int i = 0; i < n && (i <= 0 || VT4FR.WORK_BOOK.support()); ++i) {
            rWorkBook.addReport(this.getReportName(i), this.getTemplateReport(i).execute(map));
        }
        return rWorkBook;
    }

    public ResultWorkBook execute4Write(Map map) {
        this.apply4Parameters(map);
        RWorkBook rWorkBook = new RWorkBook();
        this.dealWithExecutedAttr(rWorkBook);
        int n = this.getReportCount();
        for (int i = 0; i < n && (i <= 0 || VT4FR.WORK_BOOK.support()); ++i) {
            rWorkBook.addReport(this.getReportName(i), this.getTemplateReport(i).execute4Write(map));
        }
        return rWorkBook;
    }

    public ResultWorkBook execute4Form(Map map) {
        this.apply4Parameters(map);
        RWorkBook rWorkBook = new RWorkBook();
        this.dealWithExecutedAttr(rWorkBook);
        int n = this.getReportCount();
        for (int i = 0; i < n && (i <= 0 || VT4FR.WORK_BOOK.support()); ++i) {
            rWorkBook.addReport(this.getReportName(i), this.getTemplateReport(i).execute4Form(map));
        }
        return rWorkBook;
    }

    private void dealWithExecutedAttr(ResultWorkBook resultWorkBook) {
        if (resultWorkBook == null) {
            return;
        }
        Iterator iterator = this.getTableDataNameIterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            resultWorkBook.putTableData(string, this.getTableData(string));
        }
        if (this.getReportWebAttr() != null) {
            resultWorkBook.setReportWebAttr(this.getReportWebAttr());
        }
        if (this.getReportExportAttr() != null) {
            resultWorkBook.setReportExportAttr(this.getReportExportAttr());
        }
    }

    public Parameter[] getParameters() {
        ArrayList<Parameter> arrayList = new ArrayList<Parameter>();
        ParameterHelper.addGlobal_ParameterToList(arrayList);
        ReportParameterAttr reportParameterAttr = this.getReportParameterAttr();
        if (reportParameterAttr != null && reportParameterAttr.getParameters() != null) {
            arrayList.addAll(Arrays.asList(reportParameterAttr.getParameters()));
        }
        int n = this.tableDataList.size();
        for (int i = 0; i < n; ++i) {
            TableData tableData = (TableData)this.tableDataList.get(i);
            if (tableData == null || tableData.getParameters() == null) continue;
            arrayList.addAll(Arrays.asList(tableData.getParameters()));
        }
        return arrayList.toArray(new Parameter[arrayList.size()]);
    }

    public void apply4Parameters(Map map) {
        ReportParameterAttr reportParameterAttr = this.getReportParameterAttr();
        if (reportParameterAttr != null) {
            Parameter[] parameterArray = reportParameterAttr.getParameters();
            for (int i = 0; i < parameterArray.length; ++i) {
                if (map.get(parameterArray[i].getName()) != null) continue;
                Object object = parameterArray[i].getValue();
                if (object instanceof Formula) {
                    object = ScriptUtils.executeFormula(Calculator.createCalculator(), (Formula)object);
                }
                map.put(parameterArray[i].getName(), object);
            }
            if (reportParameterAttr.getParameterProcessor() != null) {
                map = reportParameterAttr.getParameterProcessor().process(map);
            }
        }
    }

    public boolean renameTableData(String string, String string2) {
        if (super.renameTableData(string, string2)) {
            if (this.getTableData(string) == null) {
                for (int i = 0; i < this.getReportCount(); ++i) {
                    Report report = this.getReport(i);
                    if (report == null) continue;
                    Iterator iterator = report.cellIterator();
                    while (iterator.hasNext()) {
                        DSColumn dSColumn;
                        CellElement cellElement = (CellElement)iterator.next();
                        Object object = cellElement.getValue();
                        if (!(object instanceof DSColumn) || !ComparatorUtils.equals((dSColumn = (DSColumn)object).getDSName(), string)) continue;
                        dSColumn.setDSName(string2);
                    }
                }
            }
            return true;
        }
        return false;
    }
}

