/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report;

import com.fr.base.Style;
import com.fr.base.core.GraphHelper;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.report.AbstractTemplateReport;
import com.fr.report.CellElement;
import com.fr.report.DefaultCellElement;
import com.fr.report.LayerReportAttr;
import com.fr.report.RWorkSheet;
import com.fr.report.ReportPageAttr;
import com.fr.report.ResultReport;
import com.fr.report.WorkSheetAttr;
import com.fr.report.core.PaintUtils;
import com.fr.report.core.cal.LayerPageReport;
import com.fr.report.core.cal.LayerReport;
import com.fr.report.core.cal.SE;
import java.awt.FontMetrics;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;

public class WorkSheet
extends AbstractTemplateReport {
    private static final long serialVersionUID = -8922304295595224713L;
    private WorkSheetAttr workSheetAttr = null;
    private LayerReportAttr layerReportAttr = null;

    public void reset() {
        this.removeAllCellElements();
        this.removeAllFloatElements();
        this.columnWidthList_DEC.reset();
        this.rowHeightList_DEC.reset();
    }

    public WorkSheetAttr getWorkSheetAttr() {
        return this.workSheetAttr;
    }

    public void setWorkSheetAttr(WorkSheetAttr workSheetAttr) {
        this.workSheetAttr = workSheetAttr;
    }

    public LayerReportAttr getLayerReportAttr() {
        return this.layerReportAttr;
    }

    public void setLayerReportAttr(LayerReportAttr layerReportAttr) {
        this.layerReportAttr = layerReportAttr;
    }

    public void adjustColumnPreferredWidth(int n) {
        Iterator iterator = this.cellIterator();
        while (iterator.hasNext()) {
            CellElement cellElement = (CellElement)iterator.next();
            if (cellElement.getColumn() != n) continue;
            Style style = cellElement.getStyle();
            Object object = cellElement.getValue();
            if (!(object instanceof String)) continue;
            FontMetrics fontMetrics = GraphHelper.getFontMetrics(style.getFRFont());
            this.columnWidthList_DEC.set(n, Math.max(this.columnWidthList_DEC.get(n), fontMetrics.stringWidth((String)object)));
        }
    }

    public void adjustRowPreferredHeight(int n) {
        Iterator iterator = this.cellIterator();
        while (iterator.hasNext()) {
            CellElement cellElement = (CellElement)iterator.next();
            if (cellElement.getRow() != n) continue;
            int n2 = cellElement.getColumn();
            int n3 = cellElement.getRow();
            int n4 = PaintUtils.analyzeCellElementPreferredHeight(cellElement, this.columnWidthList_DEC.getRangeValue(n2, n2 + cellElement.getColumnSpan()));
            if (n4 <= this.getRowHeight(n3)) continue;
            this.setRowHeight(n, n4);
        }
    }

    public ResultReport execute(Map map) {
        return this._execute(map, 0);
    }

    public ResultReport execute4Write(Map map) {
        return this._execute(map, 1);
    }

    public ResultReport execute4Form(Map map) {
        return this._execute(map, 2);
    }

    private ResultReport _execute(Map map, int n) {
        WorkSheet workSheet;
        try {
            workSheet = (WorkSheet)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
        if (map == null) {
            map = Collections.EMPTY_MAP;
        }
        if (n == 0 && this.layerReportAttr != null) {
            if (this.layerReportAttr.isPageQuery()) {
                return new LayerPageReport(workSheet, map, this.layerReportAttr.getCountPerPage());
            }
            return new LayerReport(workSheet, map);
        }
        SE sE = new SE(workSheet, map);
        return sE.execute(n);
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if ("WorkSheetAttr".equals(string) || "LinearReportAttr".equals(string) || "ComplexSheetAttr".equals(string)) {
                if (this.workSheetAttr == null) {
                    this.workSheetAttr = new WorkSheetAttr();
                }
                xMLableReader.readXMLObject(this.workSheetAttr);
            } else if ("LayerAttr".equals(string)) {
                if (Boolean.valueOf(xMLableReader.getElementValue()).booleanValue()) {
                    this.setLayerReportAttr(new LayerReportAttr());
                }
            } else if ("LayerReportAttr".equals(string)) {
                if (this.getLayerReportAttr() == null) {
                    this.setLayerReportAttr(new LayerReportAttr());
                }
                xMLableReader.readXMLObject(this.getLayerReportAttr());
            } else if (string.equals("SheetRegion")) {
                String string2;
                ReportPageAttr reportPageAttr = this.getReportPageAttr();
                if (reportPageAttr == null) {
                    reportPageAttr = new ReportPageAttr();
                    this.setReportPageAttr(reportPageAttr);
                }
                if ((string2 = xMLableReader.getAttr("prhf")) != null) {
                    reportPageAttr.setRepeatHeaderRowFrom(this.parseIntWithoutException(string2));
                }
                if ((string2 = xMLableReader.getAttr("drf")) != null) {
                    reportPageAttr.setRepeatHeaderRowTo(this.parseIntWithoutException(string2));
                }
                if ((string2 = xMLableReader.getAttr("prff")) != null) {
                    reportPageAttr.setRepeatFooterRowFrom(this.parseIntWithoutException(string2));
                }
                if ((string2 = xMLableReader.getAttr("frff")) != null) {
                    reportPageAttr.setRepeatFooterRowTo(this.parseIntWithoutException(string2));
                }
                if ((string2 = xMLableReader.getAttr("pcht")) != null) {
                    reportPageAttr.setRepeatHeaderColumnFrom(0);
                    reportPageAttr.setRepeatHeaderColumnTo(this.parseIntWithoutException(string2));
                }
                if ((string2 = xMLableReader.getAttr("pcff")) != null) {
                    reportPageAttr.setRepeatFooterColumnFrom(this.parseIntWithoutException(string2));
                }
            } else if (string.equals("SpreadSheetAttributes")) {
                String string3;
                ReportPageAttr reportPageAttr = this.getReportPageAttr();
                if (reportPageAttr == null) {
                    reportPageAttr = new ReportPageAttr();
                    this.setReportPageAttr(reportPageAttr);
                }
                if ((string3 = xMLableReader.getAttr("startRepeatRow")) != null) {
                    reportPageAttr.setRepeatHeaderRowFrom(this.parseIntWithoutException(string3));
                }
                if ((string3 = xMLableReader.getAttr("endRepeatRow")) != null) {
                    reportPageAttr.setRepeatHeaderRowTo(this.parseIntWithoutException(string3));
                }
                if ((string3 = xMLableReader.getAttr("startRepeatColumn")) != null) {
                    reportPageAttr.setRepeatHeaderColumnFrom(this.parseIntWithoutException(string3));
                }
                if ((string3 = xMLableReader.getAttr("endRepeatColumn")) != null) {
                    reportPageAttr.setRepeatHeaderColumnTo(this.parseIntWithoutException(string3));
                }
            }
        }
    }

    private int parseIntWithoutException(String string) {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        if (this.workSheetAttr != null) {
            this.workSheetAttr.writeXML(xMLPrintWriter);
        }
        if (this.layerReportAttr != null) {
            this.layerReportAttr.writeXML(xMLPrintWriter);
        }
    }

    public WorkSheet cloneWithoutCell() throws CloneNotSupportedException {
        WorkSheet workSheet = (WorkSheet)super.cloneWithoutCellCase();
        if (this.workSheetAttr != null && this.workSheetAttr.getDirection() != 2) {
            workSheet.workSheetAttr = (WorkSheetAttr)this.workSheetAttr.clone();
            workSheet.reportPageAttr = null;
        }
        if (this.layerReportAttr != null) {
            workSheet.layerReportAttr = (LayerReportAttr)this.layerReportAttr.clone();
        }
        return workSheet;
    }

    public void convertWithoutCellCaseToResultReport(RWorkSheet rWorkSheet) throws CloneNotSupportedException {
        super.cloneWithoutCellCase4Report(rWorkSheet);
    }

    public Object clone() throws CloneNotSupportedException {
        WorkSheet workSheet = (WorkSheet)super.clone();
        if (this.workSheetAttr != null) {
            workSheet.workSheetAttr = (WorkSheetAttr)this.workSheetAttr.clone();
        }
        if (this.layerReportAttr != null) {
            workSheet.layerReportAttr = (LayerReportAttr)this.layerReportAttr.clone();
        }
        return workSheet;
    }

    public Object deriveClearReportWithReadOnlyAttr() throws CloneNotSupportedException {
        return super.deriveClearReportWithReadOnlyAttr();
    }

    protected CellElement createDefaultCellElementCase() {
        return new DefaultCellElement();
    }
}

