/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.adhoc;

import com.fr.base.core.json.JSONObject;
import com.fr.data.util.function.AverageFunction;
import com.fr.data.util.function.CountFunction;
import com.fr.data.util.function.DataFunction;
import com.fr.data.util.function.MaxFunction;
import com.fr.data.util.function.MinFunction;
import com.fr.data.util.function.SumFunction;
import com.fr.report.adhoc.SimpleADHOCColumn;
import com.fr.report.cellElement.Formula;
import java.util.HashMap;
import java.util.Map;

public class ADHOCSummaryColumn
extends SimpleADHOCColumn {
    private String weeklySummaryColumn;
    private String monthlySummaryColumn;
    private String yearlySummaryColumn;
    private String function;
    private Map funMap = new HashMap();

    public void initMap() {
        if (this.funMap.size() < 1) {
            this.funMap.put("sum", new SumFunction());
            this.funMap.put("ave", new AverageFunction());
            this.funMap.put("max", new MaxFunction());
            this.funMap.put("min", new MinFunction());
            this.funMap.put("count", new CountFunction());
            this.funMap.put("weeksummary", new SumFunction());
            this.funMap.put("monthsummary", new SumFunction());
            this.funMap.put("yearsummary", new SumFunction());
        }
    }

    public Formula createWMYFormula() {
        String string = null;
        if (this.getFunctionString().equals("weeksummary") || this.getFunctionString().equals("monthsummary") || this.getFunctionString().equals("yearsummary")) {
            // empty if block
        }
        Formula formula = new Formula(string);
        return formula;
    }

    public DataFunction getFunction() {
        if (this.funMap.size() < 1) {
            this.initMap();
        }
        return (DataFunction)this.funMap.get(this.getFunctionString());
    }

    public String getWeeklySummaryColumn() {
        return this.weeklySummaryColumn;
    }

    public void setWeeklySummaryColumn(String string) {
        this.weeklySummaryColumn = string;
    }

    public String getMonthlySummaryColumn() {
        return this.monthlySummaryColumn;
    }

    public void setMonthlySummaryColumn(String string) {
        this.monthlySummaryColumn = string;
    }

    public String getYearlySummaryColumn() {
        return this.yearlySummaryColumn;
    }

    public void setYearlySummaryColumn(String string) {
        this.yearlySummaryColumn = string;
    }

    public String getFunctionString() {
        return this.function;
    }

    public void setFunction(String string) {
        this.function = string;
    }

    public JSONObject createJSON() throws Exception {
        return null;
    }

    public void parseJSON(JSONObject jSONObject) throws Exception {
        super.parseJSON(jSONObject);
        this.setFunction(jSONObject.getString("funname"));
        if (jSONObject.has("weeksummary")) {
            this.setWeeklySummaryColumn(jSONObject.getString("weeksummary"));
        }
        if (jSONObject.has("monthsummary")) {
            this.setMonthlySummaryColumn(jSONObject.getString("monthsummary"));
        }
        if (jSONObject.has("yearsummary")) {
            this.setYearlySummaryColumn(jSONObject.getString("yearsummary"));
        }
    }
}

