/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.adhoc;

import com.fr.base.ColumnRow;
import com.fr.base.Inter;
import com.fr.base.StringUtils;
import com.fr.base.core.json.JSONArray;
import com.fr.base.core.json.JSONObject;
import com.fr.report.CellElement;
import com.fr.report.DefaultCellElement;
import com.fr.report.WorkBook;
import com.fr.report.WorkSheet;
import com.fr.report.adhoc.ADHOCColumn;
import com.fr.report.adhoc.ADHOCReportStyleUtils;
import com.fr.report.adhoc.CrossedADHOCStyle;
import com.fr.report.adhoc.NormalADHOCReport;
import com.fr.report.cellElement.CellExpandAttr;
import com.fr.report.cellElement.Formula;
import com.fr.report.cellElement.core.DSColumn;
import com.fr.report.cellElement.core.FunctionGrouper;
import com.fr.report.cellElement.core.SummaryGrouper;
import com.fr.report.core.SheetUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class CrossedADHOCReport
extends NormalADHOCReport {
    public static int TYPE = 1;
    private ADHOCColumn[] columnColumns;
    private ADHOCColumn[] rowColumns;
    private CrossedADHOCStyle crossedADHOCStyle;

    public ADHOCColumn[] getColumnColumns() {
        return this.columnColumns;
    }

    public void setColumnColumns(ADHOCColumn[] aDHOCColumnArray) {
        this.columnColumns = aDHOCColumnArray;
    }

    public ADHOCColumn[] getRowColumns() {
        return this.rowColumns;
    }

    public void setRowColumns(ADHOCColumn[] aDHOCColumnArray) {
        this.rowColumns = aDHOCColumnArray;
    }

    public CrossedADHOCStyle getCrossedADHOCStyle() {
        return this.crossedADHOCStyle;
    }

    public void setCrossedADHOCStyle(CrossedADHOCStyle crossedADHOCStyle) {
        this.crossedADHOCStyle = crossedADHOCStyle;
    }

    public WorkBook createWorkBook() {
        WorkBook workBook = new WorkBook();
        workBook.putTableData(this.getViewName(), this.getADHOCData());
        WorkSheet workSheet = new WorkSheet();
        List list = this.cacuCells();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            workSheet.addCellElement((DefaultCellElement)iterator.next());
        }
        if (StringUtils.isNotBlank(this.getTitle())) {
            workSheet.setRowHeight(0, this.crossedADHOCStyle.getRowTitleHeight());
        }
        int n = this.totalWidth();
        for (int i = 0; i < n; ++i) {
            workSheet.setColumnWidth(i, this.crossedADHOCStyle.getColumnWidth());
        }
        SheetUtils.calculateDefaultParent(workSheet);
        workBook.addReport(workSheet);
        return workBook;
    }

    public int totalWidth() {
        return this.columnColumns.length + this.rowColumns.length + 1;
    }

    private List cacuCells() {
        ArrayList<CellElement> arrayList = new ArrayList<CellElement>();
        if (this.generateTitleCell(0, 0) != null) {
            arrayList.add(this.generateTitleCell(0, 0));
            arrayList.add(this.generateSubTitleCell(0, 1));
        }
        arrayList.addAll(this.generateColumnCells());
        arrayList.addAll(this.generateRowCells());
        arrayList.add(this.generateSummaryCell());
        arrayList.addAll(this.generateOtherSummaryCells());
        return arrayList;
    }

    private CellElement generateTitleCell(int n, int n2) {
        if (StringUtils.isBlank(this.getTitle())) {
            return null;
        }
        DefaultCellElement defaultCellElement = new DefaultCellElement(n, n2);
        defaultCellElement.setColumnSpan(this.columnColumns.length + this.rowColumns.length + 1);
        defaultCellElement.setValue(this.getTitle());
        defaultCellElement.setStyle(this.crossedADHOCStyle.getTitleStyle());
        return defaultCellElement;
    }

    private CellElement generateSubTitleCell(int n, int n2) {
        if (StringUtils.isBlank(this.getSubtitle())) {
            return null;
        }
        DefaultCellElement defaultCellElement = new DefaultCellElement(n, n2);
        defaultCellElement.setColumnSpan(this.columnColumns.length + this.rowColumns.length + 1);
        defaultCellElement.setValue(this.getTitle());
        defaultCellElement.setStyle(this.crossedADHOCStyle.getTitleStyle());
        return defaultCellElement;
    }

    private List generateColumnCells() {
        int n = this.rowColumns.length;
        int n2 = this.titleAppend();
        ArrayList<DefaultCellElement> arrayList = new ArrayList<DefaultCellElement>();
        int n3 = this.columnColumns.length;
        for (int i = 0; i < n3; ++i) {
            DefaultCellElement defaultCellElement = new DefaultCellElement(n, n2 + i);
            defaultCellElement.setStyle(this.crossedADHOCStyle.getReportCotentStyle());
            CellExpandAttr cellExpandAttr = new CellExpandAttr();
            cellExpandAttr.setDirection((byte)1);
            defaultCellElement.setCellExpandAttr(cellExpandAttr);
            defaultCellElement.setColumnSpan(n3 - i);
            DSColumn dSColumn = new DSColumn();
            dSColumn.setColumnName(this.columnColumns[i].getColumnName());
            dSColumn.setDSName(this.getViewName());
            dSColumn.setOrder(this.columnColumns[i].getSort());
            if (i == 0) {
                dSColumn.setCondition(this.getCondition());
            }
            FunctionGrouper functionGrouper = new FunctionGrouper();
            functionGrouper.setDivideMode(0);
            functionGrouper.setCustom(false);
            dSColumn.setGrouper(functionGrouper);
            defaultCellElement.setValue(dSColumn);
            arrayList.add(defaultCellElement);
            if (i <= 0) continue;
            DefaultCellElement defaultCellElement2 = new DefaultCellElement(n + n3 - i, n2 + i);
            defaultCellElement2.setStyle(this.crossedADHOCStyle.getSummaryStyle());
            defaultCellElement2.setValue(Inter.getLocText("Summary"));
            defaultCellElement2.setRowSpan(n3 - i);
            arrayList.add(defaultCellElement2);
        }
        return arrayList;
    }

    private List generateRowCells() {
        int n = 0;
        int n2 = this.titleAppend() + this.columnColumns.length;
        ArrayList<DefaultCellElement> arrayList = new ArrayList<DefaultCellElement>();
        int n3 = this.columnColumns.length;
        int n4 = this.rowColumns.length;
        for (int i = 0; i < n4; ++i) {
            DefaultCellElement defaultCellElement = new DefaultCellElement(n + i, n2);
            defaultCellElement.setStyle(this.crossedADHOCStyle.getReportCotentStyle());
            CellExpandAttr cellExpandAttr = new CellExpandAttr();
            cellExpandAttr.setDirection((byte)0);
            defaultCellElement.setCellExpandAttr(cellExpandAttr);
            defaultCellElement.setRowSpan(n4 - i);
            DSColumn dSColumn = new DSColumn();
            dSColumn.setColumnName(this.rowColumns[i].getColumnName());
            dSColumn.setDSName(this.getViewName());
            dSColumn.setOrder(this.rowColumns[i].getSort());
            if (i == 0) {
                dSColumn.setCondition(this.getCondition());
            }
            FunctionGrouper functionGrouper = new FunctionGrouper();
            functionGrouper.setDivideMode(0);
            functionGrouper.setCustom(false);
            dSColumn.setGrouper(functionGrouper);
            defaultCellElement.setValue(dSColumn);
            arrayList.add(defaultCellElement);
            if (i <= 0) continue;
            DefaultCellElement defaultCellElement2 = new DefaultCellElement(n + i, n2 + n4 - i);
            defaultCellElement2.setStyle(this.crossedADHOCStyle.getSummaryStyle());
            defaultCellElement2.setValue(Inter.getLocText("Summary"));
            defaultCellElement2.setColumnSpan(n4 - i);
            arrayList.add(defaultCellElement2);
        }
        return arrayList;
    }

    private CellElement generateSummaryCell() {
        DefaultCellElement defaultCellElement = new DefaultCellElement(this.summaryCellPosition()[0], this.summaryCellPosition()[1]);
        defaultCellElement.setStyle(this.crossedADHOCStyle.getReportCotentStyle());
        CellExpandAttr cellExpandAttr = new CellExpandAttr();
        cellExpandAttr.setDirection((byte)2);
        defaultCellElement.setCellExpandAttr(cellExpandAttr);
        DSColumn dSColumn = new DSColumn();
        dSColumn.setColumnName(this.getSummaryColumn().getColumnName());
        dSColumn.setDSName(this.getViewName());
        SummaryGrouper summaryGrouper = new SummaryGrouper();
        summaryGrouper.setFunction(this.getSummaryColumn().getFunction());
        dSColumn.setGrouper(summaryGrouper);
        defaultCellElement.setValue(dSColumn);
        return defaultCellElement;
    }

    private List generateOtherSummaryCells() {
        ArrayList<DefaultCellElement> arrayList = new ArrayList<DefaultCellElement>();
        int n = this.columnColumns.length + this.rowColumns.length;
        DefaultCellElement defaultCellElement = new DefaultCellElement(n, this.titleAppend());
        defaultCellElement.setStyle(this.crossedADHOCStyle.getSummaryStyle());
        defaultCellElement.setValue(Inter.getLocText("Summary"));
        defaultCellElement.setRowSpan(this.columnColumns.length);
        arrayList.add(defaultCellElement);
        DefaultCellElement defaultCellElement2 = new DefaultCellElement(0, n + this.titleAppend());
        defaultCellElement2.setStyle(this.crossedADHOCStyle.getSummaryStyle());
        defaultCellElement2.setValue(Inter.getLocText("Summary"));
        defaultCellElement2.setColumnSpan(this.rowColumns.length);
        arrayList.add(defaultCellElement2);
        for (int i = this.summaryCellPosition()[0]; i < n + 1; ++i) {
            int n2 = n + 1 + this.titleAppend();
            for (int j = this.summaryCellPosition()[1]; j < n2; ++j) {
                if (i == this.summaryCellPosition()[0] && j == this.summaryCellPosition()[1]) continue;
                DefaultCellElement defaultCellElement3 = new DefaultCellElement(i, j);
                defaultCellElement3.setStyle(this.crossedADHOCStyle.getSummaryStyle());
                defaultCellElement3.setValue(new Formula(this.getSummaryColumn().getFunction().getFormula() + "(" + this.getSummaryCellPlace() + ")"));
                arrayList.add(defaultCellElement3);
            }
        }
        return arrayList;
    }

    private String getSummaryCellPlace() {
        return ColumnRow.valueOf(this.summaryCellPosition()[0], this.summaryCellPosition()[1]).toString();
    }

    private int[] summaryCellPosition() {
        return new int[]{this.rowColumns.length, this.columnColumns.length + this.titleAppend()};
    }

    private int titleAppend() {
        int n = 0;
        if (StringUtils.isNotEmpty(this.getTitle())) {
            ++n;
        }
        if (StringUtils.isNotEmpty(this.getSubtitle())) {
            ++n;
        }
        return n;
    }

    public JSONObject createJSON() throws Exception {
        return null;
    }

    public void parseJSON(JSONObject jSONObject) throws Exception {
        ADHOCColumn aDHOCColumn;
        int n;
        ADHOCColumn[] aDHOCColumnArray;
        int n2;
        JSONArray jSONArray;
        super.parseJSON(jSONObject);
        if (jSONObject.has("columns")) {
            jSONArray = jSONObject.getJSONArray("columns");
            n2 = jSONArray.length();
            aDHOCColumnArray = new ADHOCColumn[n2];
            for (n = 0; n < n2; ++n) {
                aDHOCColumn = new ADHOCColumn();
                aDHOCColumn.parseJSON(jSONArray.getJSONObject(n));
                aDHOCColumnArray[n] = aDHOCColumn;
            }
            this.setColumnColumns(aDHOCColumnArray);
        }
        if (jSONObject.has("rows")) {
            jSONArray = jSONObject.getJSONArray("rows");
            n2 = jSONArray.length();
            aDHOCColumnArray = new ADHOCColumn[n2];
            for (n = 0; n < n2; ++n) {
                aDHOCColumn = new ADHOCColumn();
                aDHOCColumn.parseJSON(jSONArray.getJSONObject(n));
                aDHOCColumnArray[n] = aDHOCColumn;
            }
            this.setRowColumns(aDHOCColumnArray);
        }
        if (jSONObject.has("crossedstyle")) {
            this.setCrossedADHOCStyle(ADHOCReportStyleUtils.getCrossedStyle(jSONObject.getInt("crossedstyle")));
        }
    }
}

