/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.adhoc;

import com.fr.base.ColumnRow;
import com.fr.base.Inter;
import com.fr.base.StringUtils;
import com.fr.base.XMLable;
import com.fr.base.core.json.JSONArray;
import com.fr.base.core.json.JSONObject;
import com.fr.report.CellElement;
import com.fr.report.DefaultCellElement;
import com.fr.report.WorkBook;
import com.fr.report.WorkSheet;
import com.fr.report.adhoc.ADHOCColumn;
import com.fr.report.adhoc.ADHOCReportStyleUtils;
import com.fr.report.adhoc.NormalADHOCReport;
import com.fr.report.adhoc.SimpleADHOCColumn;
import com.fr.report.adhoc.SimpleADHOCStyle;
import com.fr.report.cellElement.CellExpandAttr;
import com.fr.report.cellElement.Formula;
import com.fr.report.cellElement.core.DSColumn;
import com.fr.report.cellElement.core.FunctionGrouper;
import com.fr.report.cellElement.core.RecordGrouper;
import com.fr.report.cellElement.core.SummaryGrouper;
import com.fr.report.core.SheetUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SimpleADHOCReport
extends NormalADHOCReport {
    public static int TYPE = 0;
    private SimpleADHOCColumn[] displayColumns;
    private ADHOCColumn[] groupColumns;
    private ADHOCColumn sortColumn;
    private SimpleADHOCStyle simpleADHOCStyle;
    private List detailColumns;

    public SimpleADHOCStyle getSimpleADHOCStyle() {
        return this.simpleADHOCStyle;
    }

    public void setSimpleADHOCStyle(SimpleADHOCStyle simpleADHOCStyle) {
        this.simpleADHOCStyle = simpleADHOCStyle;
    }

    public SimpleADHOCColumn[] getDisplayColumns() {
        return this.displayColumns;
    }

    public void setDisplayColumns(SimpleADHOCColumn[] simpleADHOCColumnArray) {
        this.displayColumns = simpleADHOCColumnArray;
    }

    public ADHOCColumn[] getGroupColumns() {
        return this.groupColumns;
    }

    public void setGroupColumns(ADHOCColumn[] aDHOCColumnArray) {
        this.groupColumns = aDHOCColumnArray;
    }

    public ADHOCColumn getSortColumns() {
        return this.sortColumn;
    }

    public void setSortColumns(ADHOCColumn aDHOCColumn) {
        this.sortColumn = aDHOCColumn;
    }

    private List getDetailColumns() {
        if (this.detailColumns == null) {
            this.detailColumns = new ArrayList();
            if (this.displayColumns != null) {
                int n = this.displayColumns.length;
                for (int i = 0; i < n; ++i) {
                    if (this.isGroupOrSortColumn(this.displayColumns[i])) continue;
                    this.detailColumns.add(this.displayColumns[i]);
                }
            }
        }
        return this.detailColumns;
    }

    private boolean isGroupOrSortColumn(SimpleADHOCColumn simpleADHOCColumn) {
        if (this.groupColumns != null) {
            int n = this.groupColumns.length;
            for (int i = 0; i < n; ++i) {
                if (!this.groupColumns[i].getColumnName().equals(simpleADHOCColumn.getColumnName())) continue;
                return true;
            }
        }
        if (this.getSummaryColumn() != null && this.getSummaryColumn().getColumnName().equals(simpleADHOCColumn.getColumnName())) {
            return true;
        }
        if (this.sortColumn != null) {
            return this.sortColumn.getColumnName().equals(simpleADHOCColumn.getColumnName());
        }
        return false;
    }

    public WorkBook createWorkBook() {
        WorkBook workBook = new WorkBook();
        workBook.putTableData(this.getViewName(), this.getADHOCData());
        WorkSheet workSheet = new WorkSheet();
        workBook.addReport(workSheet);
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.titleCells());
        arrayList.addAll(this.headerColumns());
        arrayList.addAll(this.generateContentColumns());
        arrayList.addAll(this.generateOtherColumns());
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            workSheet.addCellElement((CellElement)iterator.next());
        }
        SheetUtils.calculateDefaultParent(workSheet);
        if (StringUtils.isNotBlank(this.getTitle())) {
            workSheet.setRowHeight(0, this.simpleADHOCStyle.getRowTitleHeight());
        }
        int n = this.totalWidth();
        for (int i = 0; i < n; ++i) {
            workSheet.setColumnWidth(i, this.simpleADHOCStyle.getColumnWidth());
        }
        return workBook;
    }

    private int totalWidth() {
        return this.getDetailColumns().size() + (this.groupColumns == null ? 0 : this.groupColumns.length) + (this.getSummaryColumn() == null ? 0 : 1) + (this.sortColumn == null ? 0 : 1);
    }

    private List titleCells() {
        ArrayList<DefaultCellElement> arrayList = new ArrayList<DefaultCellElement>();
        if (StringUtils.isNotEmpty(this.getTitle())) {
            DefaultCellElement defaultCellElement = new DefaultCellElement(0, 0);
            defaultCellElement.setColumnSpan(this.totalWidth());
            defaultCellElement.setValue(this.getTitle());
            defaultCellElement.setStyle(this.simpleADHOCStyle.getTitleStyle());
            arrayList.add(defaultCellElement);
            if (StringUtils.isNotEmpty(this.getSubtitle())) {
                DefaultCellElement defaultCellElement2 = new DefaultCellElement(0, 1);
                defaultCellElement2.setColumnSpan(this.totalWidth());
                defaultCellElement2.setValue(this.getSubtitle());
                defaultCellElement2.setStyle(this.simpleADHOCStyle.getSubTitleStyle());
                arrayList.add(defaultCellElement2);
            }
        }
        return arrayList;
    }

    private int titleHeight() {
        int n = 0;
        if (StringUtils.isNotEmpty(this.getTitle())) {
            ++n;
            if (StringUtils.isNotEmpty(this.getSubtitle())) {
                ++n;
            }
        }
        return n;
    }

    private List headerColumns() {
        int n;
        ArrayList<DefaultCellElement> arrayList = new ArrayList<DefaultCellElement>();
        int n2 = 0;
        if (this.groupColumns != null) {
            n2 = this.groupColumns.length;
            for (n = 0; n < n2; ++n) {
                DefaultCellElement defaultCellElement = new DefaultCellElement(n, this.titleHeight());
                defaultCellElement.setValue(this.groupColumns[n].getColumnName());
                defaultCellElement.setStyle(this.simpleADHOCStyle.getReportHeaderStyle());
                arrayList.add(defaultCellElement);
            }
        }
        n = this.getDetailColumns().size();
        for (int i = 0; i < n; ++i) {
            DefaultCellElement defaultCellElement = new DefaultCellElement(n2 + i, this.titleHeight());
            defaultCellElement.setValue(((SimpleADHOCColumn)this.getDetailColumns().get(i)).getColumnName());
            defaultCellElement.setStyle(this.simpleADHOCStyle.getReportHeaderStyle());
            arrayList.add(defaultCellElement);
        }
        if (this.getSummaryColumn() != null) {
            DefaultCellElement defaultCellElement = new DefaultCellElement(n2 + n, this.titleHeight());
            defaultCellElement.setValue(this.getSummaryColumn().getColumnName());
            defaultCellElement.setStyle(this.simpleADHOCStyle.getReportHeaderStyle());
            arrayList.add(defaultCellElement);
        }
        return arrayList;
    }

    private List generateContentColumns() {
        Cloneable cloneable;
        XMLable xMLable;
        XMLable xMLable2;
        Cloneable cloneable2;
        int n;
        int n2;
        ArrayList<Cloneable> arrayList = new ArrayList<Cloneable>();
        int n3 = this.titleHeight() + 1;
        int n4 = 0;
        int n5 = this.getDetailColumns().size() + (this.sortColumn == null ? 0 : 1);
        int n6 = n2 = n5 == 0 ? 0 : 1;
        if (this.groupColumns != null) {
            n4 = this.groupColumns.length;
            for (n = 0; n < n4; ++n) {
                DefaultCellElement defaultCellElement = new DefaultCellElement(n, n3);
                defaultCellElement.setStyle(this.simpleADHOCStyle.getReportCotentStyle());
                cloneable2 = new CellExpandAttr();
                ((CellExpandAttr)cloneable2).setDirection((byte)0);
                defaultCellElement.setCellExpandAttr((CellExpandAttr)cloneable2);
                if (this.getSummaryColumn() != null) {
                    defaultCellElement.setRowSpan(n4 - n + n2);
                }
                xMLable2 = new DSColumn();
                ((DSColumn)xMLable2).setColumnName(this.groupColumns[n].getColumnName());
                ((DSColumn)xMLable2).setDSName(this.getViewName());
                ((DSColumn)xMLable2).setOrder(this.groupColumns[n].getSort());
                if (n == 0) {
                    ((DSColumn)xMLable2).setCondition(this.getCondition());
                }
                xMLable = new FunctionGrouper();
                ((FunctionGrouper)xMLable).setDivideMode(0);
                ((FunctionGrouper)xMLable).setCustom(false);
                ((DSColumn)xMLable2).setGrouper((RecordGrouper)xMLable);
                defaultCellElement.setValue(xMLable2);
                arrayList.add(defaultCellElement);
                if (this.getSummaryColumn() == null || n <= 0) continue;
                cloneable = new DefaultCellElement(n, n3 + n4 - n + n2);
                cloneable.setStyle(this.simpleADHOCStyle.getSummaryStyle());
                cloneable.setValue(Inter.getLocText("Summary"));
                cloneable.setColumnSpan(n4 - n + n5);
                arrayList.add(cloneable);
            }
        }
        int n7 = this.getDetailColumns().size();
        for (n = 0; n < n7; ++n) {
            cloneable2 = new DefaultCellElement(n4 + n, n3);
            cloneable2.setStyle(this.simpleADHOCStyle.getReportCotentStyle());
            xMLable2 = new CellExpandAttr();
            ((CellExpandAttr)xMLable2).setDirection((byte)0);
            cloneable2.setCellExpandAttr((CellExpandAttr)xMLable2);
            xMLable = new DSColumn();
            ((DSColumn)xMLable).setColumnName(((SimpleADHOCColumn)this.getDetailColumns().get(n)).getColumnName());
            ((DSColumn)xMLable).setDSName(this.getViewName());
            if (n == 0 && this.groupColumns == null) {
                ((DSColumn)xMLable).setCondition(this.getCondition());
            }
            cloneable = new FunctionGrouper();
            ((FunctionGrouper)cloneable).setDivideMode(1);
            ((FunctionGrouper)cloneable).setCustom(false);
            ((DSColumn)xMLable).setGrouper((RecordGrouper)cloneable);
            cloneable2.setValue(xMLable);
            arrayList.add(cloneable2);
        }
        if (this.sortColumn != null) {
            DefaultCellElement defaultCellElement = new DefaultCellElement(n4 + this.getDetailColumns().size(), n3);
            defaultCellElement.setStyle(this.simpleADHOCStyle.getReportCotentStyle());
            CellExpandAttr cellExpandAttr = new CellExpandAttr();
            cellExpandAttr.setDirection((byte)0);
            defaultCellElement.setCellExpandAttr(cellExpandAttr);
            cloneable2 = new DSColumn();
            ((DSColumn)cloneable2).setColumnName(this.sortColumn.getColumnName());
            ((DSColumn)cloneable2).setDSName(this.getViewName());
            ((DSColumn)cloneable2).setOrder(this.sortColumn.getSort());
            if (this.groupColumns == null && this.getDetailColumns().size() == 0) {
                ((DSColumn)cloneable2).setCondition(this.getCondition());
            }
            xMLable2 = new FunctionGrouper();
            ((FunctionGrouper)xMLable2).setDivideMode(1);
            ((FunctionGrouper)xMLable2).setCustom(false);
            ((DSColumn)cloneable2).setGrouper((RecordGrouper)xMLable2);
            defaultCellElement.setValue(cloneable2);
            arrayList.add(defaultCellElement);
        }
        if (this.getSummaryColumn() != null) {
            DefaultCellElement defaultCellElement = new DefaultCellElement(n4 + n5, n3);
            defaultCellElement.setStyle(this.simpleADHOCStyle.getReportCotentStyle());
            CellExpandAttr cellExpandAttr = new CellExpandAttr();
            cellExpandAttr.setDirection((byte)2);
            defaultCellElement.setCellExpandAttr(cellExpandAttr);
            cloneable2 = new DSColumn();
            ((DSColumn)cloneable2).setColumnName(this.getSummaryColumn().getColumnName());
            ((DSColumn)cloneable2).setDSName(this.getViewName());
            if (this.groupColumns == null && this.getDetailColumns().size() == 0 && this.sortColumn == null) {
                ((DSColumn)cloneable2).setCondition(this.getCondition());
            }
            xMLable2 = new SummaryGrouper();
            ((SummaryGrouper)xMLable2).setFunction(this.getSummaryColumn().getFunction());
            ((DSColumn)cloneable2).setGrouper((RecordGrouper)xMLable2);
            defaultCellElement.setValue(cloneable2);
            arrayList.add(defaultCellElement);
        }
        return arrayList;
    }

    private List generateOtherColumns() {
        int n = this.getDetailColumns().size() + (this.sortColumn == null ? 0 : 1);
        int n2 = n == 0 ? 0 : 1;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (this.getSummaryColumn() != null) {
            Object object;
            DefaultCellElement defaultCellElement = new DefaultCellElement(0, this.titleHeight() + this.groupColumns.length + 1 + n2);
            defaultCellElement.setValue(Inter.getLocText("Summary"));
            defaultCellElement.setColumnSpan(this.totalWidth() - 1);
            defaultCellElement.setStyle(this.simpleADHOCStyle.getSummaryStyle());
            arrayList.add(defaultCellElement);
            if (n > 0) {
                object = new DefaultCellElement(this.groupColumns.length, this.titleHeight() + 2);
                object.setValue(Inter.getLocText("Summary"));
                object.setColumnSpan(this.totalWidth() - 1 - this.groupColumns.length);
                object.setStyle(this.simpleADHOCStyle.getSummaryStyle());
                arrayList.add(object);
            }
            object = this.getSummaryColumn().getFunction().getFormula() + "(" + this.getSummaryCell() + ")";
            int n3 = (this.groupColumns == null ? 0 : this.groupColumns.length) + n2;
            for (int i = 0; i < n3; ++i) {
                DefaultCellElement defaultCellElement2 = new DefaultCellElement(this.summaryCellPosition()[0], this.summaryCellPosition()[1] + i + 1);
                defaultCellElement2.setValue(new Formula((String)object));
                defaultCellElement2.setStyle(this.simpleADHOCStyle.getSummaryStyle());
                arrayList.add(defaultCellElement2);
            }
        }
        return arrayList;
    }

    private String getSummaryCell() {
        return ColumnRow.valueOf(this.summaryCellPosition()[0], this.summaryCellPosition()[1]).toString();
    }

    private int[] summaryCellPosition() {
        return new int[]{this.totalWidth() - (this.getSummaryColumn() == null ? 0 : 1), this.titleHeight() + 1};
    }

    public JSONObject createJSON() throws Exception {
        return null;
    }

    public void parseJSON(JSONObject jSONObject) throws Exception {
        SimpleADHOCColumn simpleADHOCColumn;
        int n;
        SimpleADHOCColumn[] simpleADHOCColumnArray;
        int n2;
        Object object;
        super.parseJSON(jSONObject);
        if (jSONObject.has("displaycolumns")) {
            object = jSONObject.getJSONArray("displaycolumns");
            n2 = ((JSONArray)object).length();
            simpleADHOCColumnArray = new SimpleADHOCColumn[n2];
            for (n = 0; n < n2; ++n) {
                simpleADHOCColumn = new SimpleADHOCColumn();
                simpleADHOCColumn.parseJSON(((JSONArray)object).getJSONObject(n));
                simpleADHOCColumnArray[n] = simpleADHOCColumn;
            }
            this.setDisplayColumns(simpleADHOCColumnArray);
        }
        if (jSONObject.has("groupcolumns")) {
            object = jSONObject.getJSONArray("groupcolumns");
            n2 = ((JSONArray)object).length();
            simpleADHOCColumnArray = new ADHOCColumn[n2];
            for (n = 0; n < n2; ++n) {
                simpleADHOCColumn = new ADHOCColumn();
                ((ADHOCColumn)simpleADHOCColumn).parseJSON(((JSONArray)object).getJSONObject(n));
                simpleADHOCColumnArray[n] = simpleADHOCColumn;
            }
            this.setGroupColumns((ADHOCColumn[])simpleADHOCColumnArray);
        }
        if (jSONObject.has("sortcolumn")) {
            object = new ADHOCColumn();
            ((ADHOCColumn)object).parseJSON(jSONObject.getJSONObject("sortcolumn"));
            this.setSortColumns((ADHOCColumn)object);
        }
        if (jSONObject.has("simplestyle")) {
            this.setSimpleADHOCStyle(ADHOCReportStyleUtils.getSimpleStyle(jSONObject.getInt("simplestyle")));
        }
    }
}

