/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.cellElement;

import com.fr.base.XMLable;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.report.core.barcode.BarCodeUtils;

public class BarcodeAttr
implements XMLable {
    public static final int CODE39 = 0;
    public static final int CODE39CHECK = 1;
    public static final int CODABAR = 2;
    public static final int CODE128 = 3;
    public static final int CODE128A = 4;
    public static final int CODE128B = 5;
    public static final int CODE128C = 6;
    public static final int EAN128 = 7;
    public static final int USPS = 8;
    public static final int SHIPMENT_ID = 9;
    public static final int SSCC_18 = 10;
    public static final int SCC_14 = 11;
    public static final int GTIN = 12;
    public static final int PDF417 = 13;
    public static final int USD_4 = 14;
    public static final int NW_7 = 15;
    private int type;
    private int barWidth = 1;
    private int barHeight = 12;
    private boolean drawingText = true;

    public BarcodeAttr() {
        this(0);
    }

    public BarcodeAttr(int n) {
        this.type = n;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int n) {
        this.type = n;
    }

    public int getBarWidth() {
        return this.barWidth;
    }

    public void setBarWidth(int n) {
        this.barWidth = n;
    }

    public int getBarHeight() {
        return this.barHeight;
    }

    public void setBarHeight(int n) {
        this.barHeight = n;
    }

    public boolean isDrawingText() {
        return this.drawingText;
    }

    public void setDrawingText(boolean bl) {
        this.drawingText = bl;
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isAttr()) {
            String string = xMLableReader.getAttr("type");
            if (string != null) {
                this.type = Integer.parseInt(string);
            }
            if ((string = xMLableReader.getAttr("width")) != null) {
                this.barWidth = Integer.parseInt(string);
            }
            if ((string = xMLableReader.getAttr("height")) != null) {
                this.barHeight = Integer.parseInt(string);
            }
            if ((string = xMLableReader.getAttr("draw")) != null) {
                this.drawingText = Boolean.valueOf(string);
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("BarcodeAttr");
        if (this.type != 0) {
            xMLPrintWriter.attr("type", this.type);
        }
        if (this.barWidth != 1) {
            xMLPrintWriter.attr("width", this.barWidth);
        }
        if (this.barHeight != 12) {
            xMLPrintWriter.attr("height", this.barHeight);
        }
        if (!this.drawingText) {
            xMLPrintWriter.attr("draw", this.drawingText);
        }
        xMLPrintWriter.end();
    }

    public String toString() {
        return BarCodeUtils.getBarCodeTypeName(this.type);
    }

    public boolean equals(Object object) {
        return object instanceof BarcodeAttr && this.type == ((BarcodeAttr)object).type && this.barHeight == ((BarcodeAttr)object).barHeight && this.barWidth == ((BarcodeAttr)object).barWidth && this.drawingText == ((BarcodeAttr)object).drawingText;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

