/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.cellElement;

import com.fr.base.ColumnRow;
import com.fr.base.ColumnRowRelated;
import com.fr.base.FRContext;
import com.fr.base.StringUtils;
import com.fr.base.XMLable;
import com.fr.base.core.ComparatorUtils;
import com.fr.base.core.antlr.ANTLRException;
import com.fr.base.core.serializable.ImageSerializable;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.report.io.xml.ReportXMLUtils;
import com.fr.report.script.Calculator;
import java.awt.Image;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.logging.Level;

public class Formula
implements XMLable,
ColumnRowRelated {
    private String content = "";
    private transient Object result = null;
    private boolean reserveInResult = false;
    private boolean reserveOnWrite = true;

    public Formula() {
    }

    public Formula(String string) {
        this.setContent(string);
    }

    public String getContent() {
        if (this.content.trim().startsWith("=")) {
            return this.content;
        }
        return "=" + this.content;
    }

    public void setContent(String string) {
        this.content = string;
        if (this.content.trim().startsWith("=")) {
            this.content = this.content.trim().substring(1);
        }
    }

    public Object getResult() {
        return this.result;
    }

    public void setResult(Object object) {
        this.result = object;
    }

    public boolean isReserveInResult() {
        return this.reserveInResult;
    }

    public void setReserveInResult(boolean bl) {
        this.reserveInResult = bl;
    }

    public boolean isReserveOnWrite() {
        return this.reserveOnWrite;
    }

    public void setReserveOnWrite(boolean bl) {
        this.reserveOnWrite = bl;
    }

    public boolean isEmpty() {
        return "=".equals(this.getContent());
    }

    public ColumnRow[] getRelatedColumnRows() {
        if (StringUtils.isNotBlank(this.content)) {
            try {
                return Calculator.relatedColumnRowArray(this.content);
            }
            catch (ANTLRException aNTLRException) {
                FRContext.getLogger().log(Level.WARNING, aNTLRException.getMessage(), aNTLRException);
            }
        }
        return new ColumnRow[0];
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        Object object = objectInputStream.readObject();
        if (object != null) {
            this.result = object instanceof ImageSerializable ? ((ImageSerializable)object).getImage() : object;
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.result != null && this.result instanceof Image) {
            ImageSerializable imageSerializable = new ImageSerializable((Image)this.result);
            objectOutputStream.writeObject(imageSerializable);
        } else {
            objectOutputStream.writeObject(this.result);
        }
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if ("Attributes".equals(string)) {
                String string2 = xMLableReader.getAttr("reserveExecute");
                if (string2 != null) {
                    this.setReserveInResult(Boolean.valueOf(string2));
                }
                if ((string2 = xMLableReader.getAttr("reserveInWeb")) != null) {
                    this.setReserveOnWrite(Boolean.valueOf(string2));
                }
                if ((string2 = xMLableReader.getElementValue()) != null) {
                    this.setContent(string2);
                }
            } else if ("O".equals(string)) {
                this.setResult(ReportXMLUtils.readObject(xMLableReader));
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("Attributes");
        if (this.isReserveInResult()) {
            xMLPrintWriter.attr("reserveExecute", this.isReserveInResult());
        }
        if (!this.isReserveOnWrite()) {
            xMLPrintWriter.attr("reserveInWeb", this.isReserveOnWrite());
        }
        xMLPrintWriter.textNode(this.getContent());
        xMLPrintWriter.end();
        Object object = this.result;
        if (object != null) {
            ReportXMLUtils.writeObject(xMLPrintWriter, object);
        }
    }

    public boolean equals(Object object) {
        return object instanceof Formula && this.isReserveInResult() == ((Formula)object).isReserveInResult() && this.isReserveOnWrite() == ((Formula)object).isReserveOnWrite() && ComparatorUtils.equals(this.getContent(), ((Formula)object).getContent());
    }

    public String toString() {
        return this.getContent();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

