/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.cellElement;

import com.fr.base.FRContext;
import com.fr.base.core.ComparatorUtils;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.data.TableData;
import com.fr.data.TableDataException;
import com.fr.report.script.Calculator;
import com.fr.report.script.core.parser.UtilEvalError;
import com.fr.util.Utils;
import java.io.Serializable;
import java.util.logging.Level;

public abstract class TableDataColumn
implements Serializable,
Cloneable {
    protected transient Integer realColumnIndex = null;

    private TableDataColumn() {
    }

    public static TableDataColumn createColumn(String string) {
        return new ColumnName(string);
    }

    public static TableDataColumn createColumn(int n) {
        return new ColumnIndex(n);
    }

    public abstract int getColumnIndex(TableData var1, Calculator var2);

    public static String getColumnName(TableDataColumn tableDataColumn) {
        if (tableDataColumn == null) {
            return null;
        }
        if (tableDataColumn instanceof ColumnName) {
            return ((ColumnName)tableDataColumn).getName();
        }
        return tableDataColumn.toString();
    }

    public static boolean isFirstColumn(TableDataColumn tableDataColumn, TableData tableData) {
        try {
            if (tableData == null || tableData.getColumnCount() <= 0) {
                return false;
            }
        }
        catch (TableDataException tableDataException) {
            FRContext.getLogger().log(Level.WARNING, tableDataException.getMessage(), tableDataException);
            return false;
        }
        if (tableDataColumn instanceof ColumnIndex) {
            return ((ColumnIndex)tableDataColumn).getIndex() == 0;
        }
        if (tableDataColumn instanceof ColumnName) {
            try {
                return ComparatorUtils.tableDataColumnNameEquals(((ColumnName)tableDataColumn).getName(), tableData.getColumnName(0));
            }
            catch (TableDataException tableDataException) {
                FRContext.getLogger().log(Level.WARNING, tableDataException.getMessage(), tableDataException);
                return false;
            }
        }
        return false;
    }

    public static boolean isLastColumn(TableDataColumn tableDataColumn, TableData tableData) {
        if (tableData == null) {
            return false;
        }
        int n = 0;
        try {
            n = tableData.getColumnCount();
        }
        catch (TableDataException tableDataException) {
            FRContext.getLogger().log(Level.WARNING, tableDataException.getMessage(), tableDataException);
        }
        if (n <= 0) {
            return false;
        }
        if (tableDataColumn instanceof ColumnIndex) {
            return ((ColumnIndex)tableDataColumn).getIndex() == n - 1;
        }
        if (tableDataColumn instanceof ColumnName) {
            try {
                return ComparatorUtils.tableDataColumnNameEquals(((ColumnName)tableDataColumn).getName(), tableData.getColumnName(n - 1));
            }
            catch (TableDataException tableDataException) {
                FRContext.getLogger().log(Level.WARNING, tableDataException.getMessage(), tableDataException);
                return false;
            }
        }
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public static TableDataColumn readXML(XMLableReader xMLableReader) {
        String string = xMLableReader.getAttr("columnName");
        if (string != null) {
            return TableDataColumn.createColumn(string);
        }
        string = xMLableReader.getAttr("ci");
        if (string != null) {
            return TableDataColumn.createColumn(Integer.parseInt(string));
        }
        string = xMLableReader.getAttr("columnIndex");
        if (string != null) {
            return TableDataColumn.createColumn(Integer.parseInt(string) + 1);
        }
        return null;
    }

    public static void writeXML(XMLPrintWriter xMLPrintWriter, TableDataColumn tableDataColumn) {
        if (tableDataColumn instanceof ColumnIndex) {
            xMLPrintWriter.attr("ci", ((ColumnIndex)tableDataColumn).index);
        } else if (tableDataColumn instanceof ColumnName) {
            xMLPrintWriter.attr("columnName", ((ColumnName)tableDataColumn).name);
        }
    }

    private static class ColumnName
    extends TableDataColumn {
        private String name;

        public ColumnName(String string) {
            this.name = string;
        }

        public String getName() {
            return this.name;
        }

        public int getColumnIndex(TableData tableData, Calculator calculator) {
            if (this.realColumnIndex == null) {
                if (this.name.startsWith("=")) {
                    try {
                        Object object = calculator.eval(this.name.substring(1));
                        if (object instanceof Number) {
                            return ColumnName.createColumn(((Number)object).intValue()).getColumnIndex(tableData, calculator);
                        }
                        return ColumnName.createColumn(Utils.objectToString(object)).getColumnIndex(tableData, calculator);
                    }
                    catch (UtilEvalError utilEvalError) {
                        FRContext.getLogger().log(Level.WARNING, utilEvalError.getMessage(), utilEvalError);
                    }
                }
                this.realColumnIndex = new Integer(Integer.MIN_VALUE);
                if (this.name.matches("^#\\d+$")) {
                    this.realColumnIndex = new Integer(ColumnName.createColumn(Integer.parseInt(this.name.substring(1))).getColumnIndex(tableData, calculator));
                } else {
                    int n = 0;
                    try {
                        n = tableData.getColumnCount();
                    }
                    catch (TableDataException tableDataException) {
                        FRContext.getLogger().log(Level.WARNING, tableDataException.getMessage(), tableDataException);
                    }
                    for (int i = 0; i < n; ++i) {
                        try {
                            if (!ComparatorUtils.tableDataColumnNameEquals(this.name, tableData.getColumnName(i))) continue;
                            this.realColumnIndex = new Integer(i);
                            break;
                        }
                        catch (TableDataException tableDataException) {
                            FRContext.getLogger().log(Level.WARNING, tableDataException.getMessage(), tableDataException);
                        }
                    }
                }
            }
            return this.realColumnIndex;
        }

        public boolean equals(Object object) {
            return object instanceof ColumnName && ((ColumnName)object).name.equals(this.name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public String toString() {
            return this.name;
        }
    }

    private static class ColumnIndex
    extends TableDataColumn {
        private int index;

        public ColumnIndex(int n) {
            this.index = n;
        }

        public int getIndex() {
            return this.index;
        }

        public int getColumnIndex(TableData tableData, Calculator calculator) {
            if (this.realColumnIndex == null) {
                this.realColumnIndex = new Integer(Integer.MIN_VALUE);
                try {
                    if (this.index >= 0 && this.index <= tableData.getColumnCount()) {
                        this.realColumnIndex = new Integer(this.index - 1);
                    }
                }
                catch (TableDataException tableDataException) {
                    FRContext.getLogger().log(Level.WARNING, tableDataException.getMessage(), tableDataException);
                }
            }
            return this.realColumnIndex;
        }

        public boolean equals(Object object) {
            return object instanceof ColumnIndex && ((ColumnIndex)object).index == this.index;
        }

        public int hashCode() {
            return this.index;
        }

        public String toString() {
            return "#" + this.index;
        }
    }
}

