/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.cellElement.core;

import com.fr.base.Style;
import com.fr.base.background.Background;
import com.fr.base.background.ColorBackground;
import com.fr.base.core.GraphHelper;
import com.fr.data.Dictionary;
import com.fr.report.CellElement;
import com.fr.report.cellElement.BarcodeAttr;
import com.fr.report.cellElement.BarcodePresent;
import com.fr.report.cellElement.DictPresent;
import com.fr.report.cellElement.Present;
import com.fr.report.core.PaintUtils;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;

public class CellUtils {
    private CellUtils() {
    }

    public static Dictionary getDictionary(CellElement cellElement) {
        Present present = cellElement.getPresent();
        if (present instanceof DictPresent) {
            return ((DictPresent)present).getDictionary();
        }
        return null;
    }

    public static void setDictionary(CellElement cellElement, Dictionary dictionary) {
        Present present = cellElement.getPresent();
        if (present instanceof DictPresent) {
            if (dictionary == null) {
                cellElement.setPresent(null);
            } else {
                ((DictPresent)present).setDictionary(dictionary);
            }
        } else if (dictionary != null) {
            cellElement.setPresent(new DictPresent(dictionary));
        }
    }

    public static BarcodeAttr getBarcodeAttr(CellElement cellElement) {
        Present present = cellElement.getPresent();
        if (present instanceof BarcodePresent) {
            return ((BarcodePresent)present).getBarcode();
        }
        return null;
    }

    public static void setBarcodeAttr(CellElement cellElement, BarcodeAttr barcodeAttr) {
        Present present = cellElement.getPresent();
        if (present instanceof BarcodePresent) {
            if (barcodeAttr == null) {
                cellElement.setPresent(null);
            } else {
                ((BarcodePresent)present).setBarcode(barcodeAttr);
            }
        } else if (barcodeAttr != null) {
            cellElement.setPresent(new BarcodePresent(barcodeAttr));
        }
    }

    public static Image value2ImageWithBackground(Object object, Style style, int n, int n2) {
        BufferedImage bufferedImage = GraphHelper.createBufferedImage(n, n2, 6);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setPaint(Color.white);
        Background background = style.getBackground() != null ? style.getBackground() : ColorBackground.getInstance(Color.WHITE);
        background.paint(graphics2D, new Rectangle(n, n2));
        PaintUtils.paintContent(graphics2D, object, style, n, n2);
        bufferedImage.flush();
        graphics2D.dispose();
        return bufferedImage;
    }

    public static Image value2Image(Object object, Style style, int n, int n2) {
        BufferedImage bufferedImage = GraphHelper.createBufferedImage(n, n2, 6);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setPaint(Color.white);
        PaintUtils.paintContent(graphics2D, object, style, n, n2);
        bufferedImage.flush();
        graphics2D.dispose();
        return bufferedImage;
    }

    public static Image value2Image(Object object, Style style, Rectangle rectangle, Rectangle rectangle2) {
        BufferedImage bufferedImage = GraphHelper.createBufferedImage(rectangle2.width, rectangle2.height, 6);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setPaint(Color.white);
        PaintUtils.paintContent(graphics2D, object, style, rectangle, rectangle2);
        bufferedImage.flush();
        graphics2D.dispose();
        return bufferedImage;
    }
}

