/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.cellElement.core;

import com.fr.base.FRContext;
import com.fr.base.Inter;
import com.fr.base.core.list.IntList;
import com.fr.base.core.util.vt.VT4FR;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.data.TableData;
import com.fr.data.TableDataException;
import com.fr.report.cellElement.core.ConditionGroup;
import com.fr.report.cellElement.core.FunctionGrouper;
import com.fr.report.cellElement.core.Group;
import com.fr.report.cellElement.core.MonoGrouper;
import com.fr.report.cellElement.core.RecordGrouper;
import com.fr.report.script.Calculator;
import com.fr.report.script.Primitive;
import java.util.ArrayList;
import java.util.logging.Level;

public class CustomGrouper
extends RecordGrouper {
    public static final int TOGETHER = 0;
    public static final int DISCARD = 1;
    public static final int LEAVE = 2;
    private boolean force = false;
    private ConditionGroup[] conditionGroups;
    private boolean more = true;
    private int other = 0;
    private String odisplay = Inter.getLocText("Other");

    public boolean isForce() {
        return this.force;
    }

    public void setForce(boolean bl) {
        this.force = bl;
    }

    public boolean isMore() {
        return this.more;
    }

    public void setMore(boolean bl) {
        this.more = bl;
    }

    public ConditionGroup[] getConditionGroups() {
        return this.conditionGroups;
    }

    public void setConditionGroups(ConditionGroup[] conditionGroupArray) {
        this.conditionGroups = conditionGroupArray;
    }

    public int getOther() {
        return this.other;
    }

    public void setOther(int n) {
        this.other = n;
    }

    public String getOdisplay() {
        return this.odisplay;
    }

    public void setOdisplay(String string) {
        this.odisplay = string;
    }

    public Group[] group(TableData tableData, int n, int[] nArray, Calculator calculator) {
        int n2;
        int n3;
        if (!VT4FR.ADVANCED_FORMULA.support()) {
            return new MonoGrouper().group(tableData, n, nArray, calculator);
        }
        if (n == -1) {
            return super.group(tableData, n, nArray, calculator);
        }
        if (nArray == null) {
            try {
                nArray = IntList.range(tableData.getRowCount());
            }
            catch (TableDataException tableDataException) {
                FRContext.getLogger().log(Level.WARNING, tableDataException.getMessage(), tableDataException);
            }
        }
        if (this.conditionGroups == null || n < 0 || nArray.length == 0) {
            return new Group[0];
        }
        Object[] objectArray = new Object[this.conditionGroups.length];
        IntList[] intListArray = new IntList[this.conditionGroups.length];
        for (int i = 0; i < this.conditionGroups.length; ++i) {
            objectArray[i] = this.conditionGroups[i].getDisplay();
            intListArray[i] = new IntList();
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        IntList intList = new IntList();
        for (int i = 0; i < nArray.length; ++i) {
            n3 = nArray[i];
            boolean bl = false;
            for (n2 = 0; n2 < this.conditionGroups.length; ++n2) {
                ConditionGroup conditionGroup = this.conditionGroups[n2];
                if (conditionGroup.getCondition().evalTableData(tableData, new int[]{n3}, n, calculator).length <= 0) continue;
                intListArray[n2].add(n3);
                bl = true;
                if (!this.more) break;
            }
            if (bl) continue;
            try {
                arrayList.add(tableData.getValueAt(n3, n));
            }
            catch (TableDataException tableDataException) {
                FRContext.getLogger().log(Level.WARNING, tableDataException.getMessage(), tableDataException);
                arrayList.add(Primitive.NULL);
            }
            intList.add(n3);
        }
        ArrayList<Group> arrayList2 = new ArrayList<Group>();
        for (n3 = 0; n3 < intListArray.length; ++n3) {
            IntList intList2 = intListArray[n3];
            if (!this.force && intList2.size() == 0) continue;
            arrayList2.add(new Group(objectArray[n3], intList2.toArray()));
        }
        if (this.other != 1 && intList.size() > 0) {
            switch (this.other) {
                case 0: {
                    arrayList2.add(new Group(this.odisplay, intList.toArray()));
                    break;
                }
                case 2: {
                    FunctionGrouper functionGrouper = new FunctionGrouper();
                    Group[] groupArray = ((RecordGrouper)functionGrouper).group(tableData, n, intList.toArray(), calculator);
                    int n4 = groupArray.length;
                    for (n2 = 0; n2 < n4; ++n2) {
                        arrayList2.add(groupArray[n2]);
                    }
                    break;
                }
            }
        }
        return arrayList2.toArray(new Group[arrayList2.size()]);
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if ("Attr".equals(string)) {
                String string2 = xMLableReader.getAttr("other");
                if (string2 != null) {
                    this.setOther(Integer.parseInt(string2));
                }
                if ((string2 = xMLableReader.getAttr("odisplay")) != null) {
                    this.setOdisplay(string2);
                }
                if ((string2 = xMLableReader.getAttr("force")) != null) {
                    this.setForce(Boolean.valueOf(string2));
                }
                if ((string2 = xMLableReader.getAttr("more")) != null) {
                    this.setForce(Boolean.valueOf(string2));
                }
            } else if ("ConditionListGroup".equals(string)) {
                ConditionGroup conditionGroup = new ConditionGroup();
                xMLableReader.readXMLObject(conditionGroup);
                if (this.conditionGroups == null) {
                    this.conditionGroups = new ConditionGroup[]{conditionGroup};
                } else {
                    ConditionGroup[] conditionGroupArray = this.conditionGroups;
                    this.conditionGroups = new ConditionGroup[conditionGroupArray.length + 1];
                    System.arraycopy(conditionGroupArray, 0, this.conditionGroups, 0, conditionGroupArray.length);
                    this.conditionGroups[conditionGroupArray.length] = conditionGroup;
                }
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("Attr");
        xMLPrintWriter.attr("other", this.other);
        if (this.other == 0 && !this.odisplay.equals("Others")) {
            xMLPrintWriter.attr("odisplay", this.odisplay);
        }
        if (this.force) {
            xMLPrintWriter.attr("force", this.force);
        }
        if (!this.more) {
            xMLPrintWriter.attr("more", this.more);
        }
        xMLPrintWriter.end();
        if (this.conditionGroups != null) {
            for (int i = 0; i < this.conditionGroups.length; ++i) {
                xMLPrintWriter.startTAG("ConditionListGroup");
                this.conditionGroups[i].writeXML(xMLPrintWriter);
                xMLPrintWriter.end();
            }
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

