/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.cellElement.core;

import com.fr.base.FRContext;
import com.fr.base.StringUtils;
import com.fr.base.Style;
import com.fr.base.XMLable;
import com.fr.base.core.ComparatorUtils;
import com.fr.base.core.list.IntList;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLReadable;
import com.fr.base.xml.XMLableReader;
import com.fr.data.TableData;
import com.fr.data.condition.Condition;
import com.fr.data.core.DataUtils;
import com.fr.data.core.DataXMLUtils;
import com.fr.data.impl.RowsTableData;
import com.fr.report.cellElement.Formula;
import com.fr.report.cellElement.TableDataColumn;
import com.fr.report.cellElement.core.FunctionGrouper;
import com.fr.report.cellElement.core.Group;
import com.fr.report.cellElement.core.IndexGrouper;
import com.fr.report.cellElement.core.MonoGrouper;
import com.fr.report.cellElement.core.RecordGrouper;
import com.fr.report.cellElement.core.SelectCount;
import com.fr.report.cellElement.core.SummaryGrouper;
import com.fr.report.core.PaintUtils;
import com.fr.report.io.xml.ReportXMLUtils;
import com.fr.report.painter.AbstractPainter;
import com.fr.report.parameter.Parameter;
import com.fr.report.script.Calculator;
import com.fr.report.script.SingleRowNameSpace;
import com.fr.report.script.core.parser.UtilEvalError;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.logging.Level;

public class DSColumn
extends AbstractPainter {
    private String dsName;
    private TableDataColumn column;
    private boolean reselect = false;
    private Condition condition;
    private RecordGrouper grouper;
    private Parameter[] parameters;
    private int order = 0;
    private String sortFormula = null;
    private Comparator sortComparator = null;
    private SelectCount selectCount = null;
    private String result = null;

    public String getDSName() {
        return this.dsName;
    }

    public void setDSName(String string) {
        this.dsName = string;
    }

    public Parameter[] getParameters() {
        return this.parameters == null ? new Parameter[]{} : this.parameters;
    }

    public void setParameters(Parameter[] parameterArray) {
        this.parameters = parameterArray;
    }

    public String getColumnName() {
        return TableDataColumn.getColumnName(this.column);
    }

    public void setColumnName(String string) {
        this.column = TableDataColumn.createColumn(string);
    }

    public TableDataColumn getColumn() {
        return this.column;
    }

    public void setColumn(TableDataColumn tableDataColumn) {
        this.column = tableDataColumn;
    }

    public Condition getCondition() {
        return this.condition;
    }

    public void setCondition(Condition condition) {
        this.condition = condition;
    }

    public RecordGrouper getGrouper() {
        if (this.grouper == null) {
            this.grouper = new FunctionGrouper();
        }
        return this.grouper;
    }

    public void setGrouper(RecordGrouper recordGrouper) {
        this.grouper = recordGrouper;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int n) {
        this.order = n;
    }

    public String getSortFormula() {
        return this.sortFormula;
    }

    public void setSortFormula(String string) {
        this.sortFormula = string;
    }

    public Comparator getSortComparator() {
        return this.sortComparator;
    }

    public void setSortComparator(Comparator comparator) {
        this.sortComparator = comparator;
    }

    public boolean isReselect() {
        return this.reselect;
    }

    public void setReselect(boolean bl) {
        this.reselect = bl;
    }

    public SelectCount getSelectCount() {
        return this.selectCount;
    }

    public void setSelectCount(SelectCount selectCount) {
        this.selectCount = selectCount;
    }

    public String getResult() {
        return this.result;
    }

    public void setResult(String string) {
        this.result = string;
    }

    public void clearAdvanced() {
        this.grouper = null;
        this.order = 0;
        this.sortFormula = null;
        this.sortComparator = null;
        this.selectCount = null;
        this.result = null;
    }

    public Iterator dataIterator(TableData tableData, int n, int[] nArray, Calculator calculator) {
        return new DataIterator(this.getGrouper().groupIterator(tableData, n, nArray, calculator), tableData, calculator);
    }

    public Group[] dealwith_condition_group_sort_select_result(TableData tableData, int n, int[] nArray, Calculator calculator) {
        nArray = this.getCondition() == null ? nArray : this.getCondition().evalTableData(tableData, nArray, n, calculator);
        return this.dealwith_result(this.dealwith_select(this.dealwith_sort(this.getGrouper().group(tableData, n, nArray, calculator), tableData, calculator), calculator), tableData, calculator);
    }

    private Group[] dealwith_sort(Group[] groupArray, TableData tableData, Calculator calculator) {
        int n;
        if (this.order == 0) {
            return groupArray;
        }
        GroupComparable[] groupComparableArray = new GroupComparable[groupArray.length];
        for (n = 0; n < groupComparableArray.length; ++n) {
            Group group = groupArray[n];
            Object object = null;
            if (this.sortFormula == null) {
                object = group.getValue();
            } else {
                calculator.setCurrentRowsTableData(new RowsTableData(tableData, group.getArray()));
                SingleRowNameSpace singleRowNameSpace = new SingleRowNameSpace(tableData, group.getArray() == null || group.getArray().length > 0 ? group.getArray()[0] : -1, group.getValue());
                calculator.pushNameSpace(singleRowNameSpace);
                if (this.sortFormula.startsWith("=")) {
                    this.sortFormula = this.sortFormula.substring(1);
                }
                try {
                    object = calculator.eval(this.sortFormula);
                }
                catch (UtilEvalError utilEvalError) {
                    String string = "error happens at DSColumn.sort\nformula expression is " + this.sortFormula + "\nerror message is " + utilEvalError.getMessage();
                    FRContext.getLogger().log(Level.WARNING, string, utilEvalError);
                }
                calculator.removeNameSpace(singleRowNameSpace);
                calculator.setCurrentRowsTableData(null);
            }
            groupComparableArray[n] = new GroupComparable(group, object);
        }
        Arrays.sort(groupComparableArray, new GroupComparableComparator(this.sortComparator, this.order));
        for (n = 0; n < groupComparableArray.length; ++n) {
            groupArray[n] = groupComparableArray[n].group;
        }
        return groupArray;
    }

    private Group[] dealwith_select(Group[] groupArray, Calculator calculator) {
        Group[] groupArray2;
        String string;
        if (this.selectCount == null) {
            return groupArray;
        }
        String string2 = this.selectCount.getFormulaCount();
        int n = -1;
        if (StringUtils.isNotBlank(string2)) {
            try {
                n = Integer.parseInt(calculator.eval(string2).toString());
            }
            catch (Exception exception) {
                string = "error happens at calculating DSColumn, SelectCount's formula\nformula expression is " + string2 + "\nerror message is " + exception.getMessage();
                FRContext.getLogger().log(Level.WARNING, string, exception);
            }
        }
        switch (this.selectCount.getType()) {
            case 1: {
                n = n < 0 ? groupArray.length : Math.min(n, groupArray.length);
                groupArray2 = new Group[n];
                System.arraycopy(groupArray, 0, groupArray2, 0, n);
                break;
            }
            case 2: {
                n = n < 0 ? groupArray.length : Math.min(n, groupArray.length);
                groupArray2 = new Group[n];
                System.arraycopy(groupArray, groupArray.length - n, groupArray2, 0, n);
                break;
            }
            case 3: {
                n = groupArray.length / 2 + groupArray.length % 2;
                groupArray2 = new Group[n];
                for (int i = 0; i < n; ++i) {
                    groupArray2[i] = groupArray[i * 2];
                }
                break;
            }
            case 4: {
                n = groupArray.length / 2;
                groupArray2 = new Group[n];
                for (int i = 0; i < n; ++i) {
                    groupArray2[i] = groupArray[i * 2 + 1];
                }
                break;
            }
            default: {
                int[] nArray;
                string = this.selectCount.getSerial();
                if (StringUtils.isNotBlank(string) && string.startsWith("=")) {
                    try {
                        string = calculator.eval(string.substring(1)).toString();
                    }
                    catch (UtilEvalError utilEvalError) {
                        FRContext.getLogger().log(Level.WARNING, utilEvalError.getMessage(), utilEvalError);
                    }
                }
                if ((nArray = IntList.toIntArrayDecimal(string, ',')) != null && nArray.length > 0) {
                    ArrayList<Group> arrayList = new ArrayList<Group>();
                    int n2 = nArray.length;
                    for (int i = 0; i < n2; ++i) {
                        int n3 = nArray[i] - 1;
                        if (n3 >= groupArray.length || n3 < 0) continue;
                        arrayList.add(groupArray[n3]);
                    }
                    groupArray2 = new Group[arrayList.size()];
                    arrayList.toArray(groupArray2);
                    break;
                }
                groupArray2 = groupArray;
            }
        }
        return groupArray2;
    }

    private Group[] dealwith_result(Group[] groupArray, TableData tableData, Calculator calculator) {
        String string;
        if (this.result == null) {
            return groupArray;
        }
        String string2 = string = this.result.startsWith("=") ? this.result.substring(1) : this.result;
        if ("$$$".equals(string) || "".equals(string)) {
            return groupArray;
        }
        for (int i = 0; i < groupArray.length; ++i) {
            Group group = groupArray[i];
            SingleRowNameSpace singleRowNameSpace = null;
            if (group.getArray() != null && group.getArray().length > 0 && tableData != null) {
                singleRowNameSpace = new SingleRowNameSpace(tableData, group.getArray()[0], group.getValue());
                calculator.pushNameSpace(singleRowNameSpace);
            }
            try {
                group.setValue(calculator.eval(string));
            }
            catch (UtilEvalError utilEvalError) {
                String string3 = "error happens at calculate formula\nformula expression is " + string + "\nerror message is " + utilEvalError.getMessage();
                FRContext.getLogger().log(Level.WARNING, string3, utilEvalError);
            }
            if (singleRowNameSpace == null) continue;
            calculator.removeNameSpace(singleRowNameSpace);
        }
        return groupArray;
    }

    public void paint(Graphics graphics, int n, int n2, Style style) {
        PaintUtils.paintCellStyleString((Graphics2D)graphics, n, n2, this.toString(), style);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.dsName).append('.');
        if (this.reselect) {
            stringBuffer.append("(R)");
        }
        if (this.grouper instanceof FunctionGrouper && ((FunctionGrouper)this.grouper).getDivideMode() == 1) {
            stringBuffer.append("S(");
            stringBuffer.append(this.column);
            stringBuffer.append(")");
        } else if (this.grouper instanceof MonoGrouper) {
            stringBuffer.append("S(");
            stringBuffer.append(this.column);
            stringBuffer.append(")");
        } else if (this.grouper instanceof SummaryGrouper) {
            stringBuffer.append(DataUtils.getFunctionDisplayName(((SummaryGrouper)this.grouper).getFunction())).append("(");
            stringBuffer.append(this.column);
            stringBuffer.append(")");
        } else if (this.grouper instanceof IndexGrouper) {
            stringBuffer.append(this.column);
        } else {
            stringBuffer.append("G").append("(");
            stringBuffer.append(this.column);
            stringBuffer.append(")");
        }
        return stringBuffer.toString();
    }

    public Object clone() throws CloneNotSupportedException {
        DSColumn dSColumn = (DSColumn)super.clone();
        if (this.column != null) {
            dSColumn.column = (TableDataColumn)this.column.clone();
        }
        if (this.condition != null) {
            dSColumn.condition = (Condition)this.condition.clone();
        }
        if (this.grouper != null) {
            dSColumn.grouper = (RecordGrouper)this.grouper.clone();
        }
        if (this.selectCount != null) {
            dSColumn.selectCount = (SelectCount)this.selectCount.clone();
        }
        if (this.parameters != null) {
            dSColumn.parameters = new Parameter[this.parameters.length];
            for (int i = 0; i < this.parameters.length; ++i) {
                dSColumn.parameters[i] = (Parameter)this.parameters[i].clone();
            }
        }
        return dSColumn;
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if ("Attributes".equals(string)) {
                String string2 = xMLableReader.getAttr("dbName");
                if (string2 != null) {
                    this.setDSName(string2);
                }
                if ((string2 = xMLableReader.getAttr("dsName")) != null) {
                    this.setDSName(string2);
                }
                this.column = TableDataColumn.readXML(xMLableReader);
            } else if ("Condition".equals(string)) {
                this.condition = DataXMLUtils.readXMLCondition(xMLableReader);
            } else if (string.equals("Complex")) {
                RecordGrouper recordGrouper;
                String string3 = xMLableReader.getAttr("order");
                if (string3 != null) {
                    this.setOrder(Integer.parseInt(string3));
                }
                if ((string3 = xMLableReader.getAttr("reselect")) != null) {
                    this.setReselect(string3.equalsIgnoreCase("true"));
                }
                if ((string3 = xMLableReader.getAttr("type")) != null) {
                    switch (Integer.parseInt(string3)) {
                        case 1: {
                            this.setGrouper(new FunctionGrouper());
                            break;
                        }
                        case 2: {
                            recordGrouper = new FunctionGrouper();
                            ((FunctionGrouper)recordGrouper).setDivideMode(1);
                            this.setGrouper(recordGrouper);
                            break;
                        }
                        case 3: {
                            this.setGrouper(new SummaryGrouper());
                        }
                    }
                }
                if ((string3 = xMLableReader.getAttr("function")) != null) {
                    recordGrouper = new SummaryGrouper();
                    ((SummaryGrouper)recordGrouper).setFunction(DataXMLUtils.readXMLDataFunction(string3));
                    this.setGrouper(recordGrouper);
                }
            } else if ("Result".equals(string)) {
                this.result = xMLableReader.getElementValue();
            } else if ("SortFormula".equals(string)) {
                this.sortFormula = xMLableReader.getElementValue();
                if (this.sortFormula == null) {
                    xMLableReader.readXMLObject(new XMLReadable(){

                        public void readXML(XMLableReader xMLableReader) {
                            String string;
                            if (xMLableReader.isChildNode() && ("Object".equals(string = xMLableReader.getTagName()) || "O".equals(string))) {
                                Object object = ReportXMLUtils.readObject(xMLableReader);
                                if (object instanceof Formula) {
                                    DSColumn.this.sortFormula = ((Formula)object).getContent();
                                } else {
                                    DSColumn.this.sortFormula = object + "";
                                }
                            }
                        }
                    });
                }
            } else if ("Comparator".equals(string)) {
                this.sortComparator = DataXMLUtils.readXMLComparator(xMLableReader);
            } else if ("SelectCount".equals(string)) {
                this.selectCount = new SelectCount();
                xMLableReader.readXMLObject(this.selectCount);
            } else if ("RG".equals(string)) {
                this.grouper = ReportXMLUtils.readXMLRecordGrouper(xMLableReader);
            } else if ("Parameters".equals(string)) {
                final ArrayList arrayList = new ArrayList();
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        if ("Parameter".equals(xMLableReader.getTagName())) {
                            arrayList.add(ReportXMLUtils.readParameter(xMLableReader));
                        }
                    }
                });
                if (arrayList.size() > 0) {
                    this.parameters = new Parameter[arrayList.size()];
                    arrayList.toArray(this.parameters);
                }
            } else if ("Object".equals(string) || "O".equals(string)) {
                this.result = ((Formula)ReportXMLUtils.readObject(xMLableReader)).getContent();
            } else if ("GC".equals(string)) {
                this.setGrouper(ReportXMLUtils.readXMLRecordGrouper(xMLableReader));
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("Attributes").attr("dsName", this.getDSName());
        TableDataColumn.writeXML(xMLPrintWriter, this.column);
        xMLPrintWriter.end();
        DataXMLUtils.writeXMLCondition(xMLPrintWriter, this.condition);
        xMLPrintWriter.startTAG("Complex");
        if (this.getOrder() != 0) {
            xMLPrintWriter.attr("order", this.getOrder());
        }
        if (this.isReselect()) {
            xMLPrintWriter.attr("reselect", "true");
        }
        xMLPrintWriter.end();
        if (this.grouper != null) {
            ReportXMLUtils.writeXMLable(xMLPrintWriter, this.grouper, "RG");
        }
        if (this.sortFormula != null && this.sortFormula.length() > 0) {
            xMLPrintWriter.startTAG("SortFormula").textNode(this.sortFormula).end();
        }
        if (this.sortComparator instanceof XMLable) {
            DataXMLUtils.writeXMLComparator(xMLPrintWriter, this.sortComparator);
        }
        if (this.selectCount != null) {
            this.selectCount.writeXML(xMLPrintWriter);
        }
        if (this.result != null) {
            xMLPrintWriter.startTAG("Result").textNode(this.result).end();
        }
        ReportXMLUtils.writeParameters(xMLPrintWriter, this.parameters);
    }

    private class DataIterator
    implements Iterator {
        private Iterator groupIterator;
        private Calculator calculator;
        private TableData tableData;
        private transient Group curGroup = null;
        private int next_count = 0;
        private int select_count = -1;
        private IntList selectList;

        DataIterator(Iterator iterator, TableData tableData, Calculator calculator) {
            this.groupIterator = iterator;
            this.tableData = tableData;
            this.calculator = calculator;
            if (DSColumn.this.selectCount != null) {
                String string;
                Object object;
                String string2 = DSColumn.this.selectCount.getFormulaCount();
                if (StringUtils.isNotBlank(string2)) {
                    try {
                        this.select_count = Integer.parseInt(calculator.eval(string2).toString());
                    }
                    catch (Exception exception) {
                        object = "error happens at calculating DSColumn, SelectCount's formula\nformula expression is " + string2 + "\nerror message is " + exception.getMessage();
                        FRContext.getLogger().log(Level.WARNING, (String)object, exception);
                    }
                }
                if (StringUtils.isNotBlank(string = DSColumn.this.selectCount.getSerial()) && string.startsWith("=")) {
                    try {
                        string = calculator.eval(string.substring(1)).toString();
                    }
                    catch (UtilEvalError utilEvalError) {
                        FRContext.getLogger().log(Level.WARNING, utilEvalError.getMessage(), utilEvalError);
                    }
                }
                object = IntList.toIntArrayDecimal(string, ',');
                this.selectList = new IntList();
                for (int i = 0; i < ((int[])object).length; ++i) {
                    this.selectList.add(object[i]);
                }
            }
        }

        public boolean hasNext() {
            block6: while (this.groupIterator.hasNext()) {
                ++this.next_count;
                this.curGroup = (Group)this.groupIterator.next();
                if (DSColumn.this.selectCount != null) {
                    switch (DSColumn.this.selectCount.getType()) {
                        case 1: {
                            if (this.next_count <= this.select_count) break;
                            this.curGroup = null;
                            continue block6;
                        }
                        case 2: {
                            break;
                        }
                        case 3: {
                            if (this.next_count % 2 == 1) break;
                            this.curGroup = null;
                            continue block6;
                        }
                        case 4: {
                            if (this.next_count % 2 == 0) break;
                            this.curGroup = null;
                            continue block6;
                        }
                        default: {
                            if (this.selectList == null || this.selectList.contain(this.next_count)) break;
                            this.curGroup = null;
                            continue block6;
                        }
                    }
                }
                if (DSColumn.this.condition != null && !DSColumn.this.condition.eval(this.curGroup.getValue(), this.calculator)) {
                    this.curGroup = null;
                    continue;
                }
                return true;
            }
            return false;
        }

        public Object next() {
            String string;
            if (DSColumn.this.result == null) {
                return this.curGroup;
            }
            String string2 = string = DSColumn.this.result.startsWith("=") ? DSColumn.this.result.substring(1) : DSColumn.this.result;
            if ("$$$".equals(string) || "".equals(string)) {
                return this.curGroup;
            }
            SingleRowNameSpace singleRowNameSpace = null;
            if (this.curGroup.getArray() != null && this.curGroup.getArray().length > 0 && this.tableData != null) {
                singleRowNameSpace = new SingleRowNameSpace(this.tableData, this.curGroup.getArray()[0], this.curGroup.getValue());
                this.calculator.pushNameSpace(singleRowNameSpace);
            }
            try {
                this.curGroup.setValue(this.calculator.eval(string));
            }
            catch (UtilEvalError utilEvalError) {
                String string3 = "error happens at calculate formula\nformula expression is " + string + "\nerror message is " + utilEvalError.getMessage();
                FRContext.getLogger().log(Level.WARNING, string3, utilEvalError);
                return this.curGroup;
            }
            if (singleRowNameSpace != null) {
                this.calculator.removeNameSpace(singleRowNameSpace);
            }
            return this.curGroup;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static final class GroupComparableComparator
    implements Comparator {
        private Comparator comparator = null;
        private int order = 1;

        public GroupComparableComparator(Comparator comparator, int n) {
            this.comparator = comparator;
            this.order = n;
        }

        public int compare(Object object, Object object2) {
            if (!(object instanceof GroupComparable) || !(object2 instanceof GroupComparable)) {
                return 0;
            }
            GroupComparable groupComparable = (GroupComparable)object;
            GroupComparable groupComparable2 = (GroupComparable)object2;
            int n = this.comparator == null ? ComparatorUtils.compare(groupComparable.comparable, groupComparable2.comparable) : this.comparator.compare(groupComparable.comparable, groupComparable2.comparable);
            if (this.order == 1) {
                return n;
            }
            return 0 - n;
        }
    }

    private static final class GroupComparable {
        private Group group;
        private Object comparable;

        public GroupComparable(Group group, Object object) {
            this.group = group;
            this.comparable = object;
        }
    }
}

