/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.cellElement.core;

import com.fr.base.FRContext;
import com.fr.base.core.ComparatorUtils;
import com.fr.base.core.list.IntList;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.data.TableData;
import com.fr.data.TableDataException;
import com.fr.report.cellElement.Formula;
import com.fr.report.cellElement.core.Group;
import com.fr.report.cellElement.core.MonoGrouper;
import com.fr.report.cellElement.core.RecordGrouper;
import com.fr.report.core.ScriptUtils;
import com.fr.report.script.Calculator;
import com.fr.report.script.Primitive;
import com.fr.report.script.SingleRowNameSpace;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;

public class FunctionGrouper
extends RecordGrouper {
    public static final int GROUPING_MODE = 0;
    public static final int LIST_MODE = 1;
    public static final int CONTINUUM_MODE = 2;
    private int divideMode = 0;
    private boolean isCustom = false;
    private String formulaContent = null;

    public boolean isCustom() {
        return this.isCustom;
    }

    public void setCustom(boolean bl) {
        this.isCustom = bl;
    }

    public int getDivideMode() {
        return this.divideMode;
    }

    public void setDivideMode(int n) {
        this.divideMode = n;
    }

    public String getFormulaContent() {
        return this.formulaContent;
    }

    public void setFormulaContent(String string) {
        this.formulaContent = string;
    }

    public Group[] group(TableData tableData, int n, int[] nArray, Calculator calculator) {
        Group[] groupArray;
        if (n == -1) {
            return super.group(tableData, n, nArray, calculator);
        }
        if (nArray == null) {
            try {
                nArray = IntList.range(tableData.getRowCount());
            }
            catch (TableDataException tableDataException) {
                FRContext.getLogger().log(Level.WARNING, tableDataException.getMessage(), tableDataException);
            }
        }
        SingleRowNameSpace singleRowNameSpace = new SingleRowNameSpace(tableData, -1, null);
        calculator.pushNameSpace(singleRowNameSpace);
        if (this.divideMode == 0) {
            int n2;
            int n3;
            HashMap<Object, IntList> hashMap = new HashMap<Object, IntList>();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            ArrayList<IntList> arrayList2 = new ArrayList<IntList>();
            for (n3 = 0; n3 < nArray.length; ++n3) {
                n2 = nArray[n3];
                Object object = this.current_v(tableData, n2, n, singleRowNameSpace, calculator);
                IntList intList = (IntList)hashMap.get(object);
                if (intList == null) {
                    intList = new IntList();
                    intList.add(n2);
                    arrayList.add(object);
                    arrayList2.add(intList);
                    hashMap.put(object, intList);
                    continue;
                }
                intList.add(n2);
            }
            groupArray = new Group[arrayList.size()];
            n2 = arrayList.size();
            for (n3 = 0; n3 < n2; ++n3) {
                groupArray[n3] = new Group(arrayList.get(n3), ((IntList)arrayList2.get(n3)).toArray());
            }
        } else if (this.divideMode == 2) {
            ArrayList<Group> arrayList = new ArrayList<Group>();
            if (nArray.length > 0) {
                int n4 = nArray[0];
                Object object = this.current_v(tableData, n4, n, singleRowNameSpace, calculator);
                IntList intList = new IntList();
                intList.add(n4);
                for (int i = 1; i < nArray.length; ++i) {
                    n4 = nArray[i];
                    Object object2 = this.current_v(tableData, n4, n, singleRowNameSpace, calculator);
                    if (ComparatorUtils.equals(object, object2)) {
                        intList.add(n4);
                        continue;
                    }
                    arrayList.add(new Group(object, intList.toArray()));
                    object = object2;
                    intList = new IntList();
                    intList.add(n4);
                }
                arrayList.add(new Group(object, intList.toArray()));
            }
            groupArray = arrayList.toArray(new Group[arrayList.size()]);
        } else {
            ArrayList<Group> arrayList = new ArrayList<Group>();
            for (int i = 0; i < nArray.length; ++i) {
                arrayList.add(new Group(this.current_v(tableData, nArray[i], n, singleRowNameSpace, calculator), new int[]{nArray[i]}));
            }
            groupArray = arrayList.toArray(new Group[arrayList.size()]);
        }
        calculator.removeNameSpace(singleRowNameSpace);
        return groupArray;
    }

    public Iterator groupIterator(TableData tableData, int n, int[] nArray, Calculator calculator) {
        if (this.divideMode == 1) {
            return new MonoGrouper().groupIterator(tableData, n, nArray, calculator);
        }
        if (this.divideMode == 2) {
            return new ContinuumIterator(tableData, n, nArray, calculator);
        }
        return new ContinuumIterator(tableData, n, nArray, calculator);
    }

    private Object current_v(TableData tableData, int n, int n2, SingleRowNameSpace singleRowNameSpace, Calculator calculator) {
        Object object = null;
        try {
            object = tableData.getValueAt(n, n2);
        }
        catch (TableDataException tableDataException) {
            FRContext.getLogger().log(Level.WARNING, tableDataException.getMessage(), tableDataException);
        }
        if (this.isCustom && this.formulaContent != null) {
            singleRowNameSpace.setRowIndex(n);
            singleRowNameSpace.setCurrentValue(object);
            object = ScriptUtils.executeFormula(calculator, new Formula(this.formulaContent));
        }
        return object;
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if ("Attr".equals(string)) {
                String string2 = xMLableReader.getAttr("divideMode");
                if (string2 != null) {
                    this.setDivideMode(Integer.valueOf(string2));
                }
            } else if ("Custom".equals(string)) {
                String string3 = xMLableReader.getAttr("isCustom");
                if (string3 != null) {
                    this.setCustom(Boolean.valueOf(string3));
                }
            } else if ("FC".equals(string)) {
                this.formulaContent = xMLableReader.getElementValue();
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        if (this.divideMode != 0) {
            xMLPrintWriter.startTAG("Attr").attr("divideMode", this.divideMode).end();
        }
        if (this.isCustom) {
            xMLPrintWriter.startTAG("Custom").attr("isCustom", this.isCustom).end();
        }
        if (this.formulaContent != null) {
            xMLPrintWriter.startTAG("FC").textNode(this.formulaContent).end();
        }
    }

    private static class ContinuumIterator
    implements Iterator {
        private TableData data;
        private int columnIndex;
        private int[] rows;
        private Calculator calculator;
        private int nextArrayIndex = -1;
        private int nextTableDataIndex = -1;
        private Group nextGroup;
        private int current_group_index = -1;
        private int need_group_index = 0;

        ContinuumIterator(TableData tableData, int n, int[] nArray, Calculator calculator) {
            this.data = tableData;
            this.columnIndex = n;
            this.rows = nArray;
            this.calculator = calculator;
        }

        private void nextRowIndex() {
            if (this.rows == null) {
                ++this.nextTableDataIndex;
            } else {
                ++this.nextArrayIndex;
                this.nextTableDataIndex = this.nextArrayIndex >= this.rows.length ? -1 : this.rows[this.nextArrayIndex];
            }
        }

        private Object getObject(int n) {
            try {
                if (n < 0 || !this.data.hasRow(n)) {
                    return Primitive.NULL;
                }
                if (this.columnIndex == -1) {
                    return new Integer(n + 1);
                }
                return this.data.getValueAt(n, this.columnIndex);
            }
            catch (TableDataException tableDataException) {
                FRContext.getLogger().log(Level.WARNING, tableDataException.getMessage(), tableDataException);
                return Primitive.NULL;
            }
        }

        private void findNext() {
            this.nextRowIndex();
            Object object = this.getObject(this.nextTableDataIndex);
            if (ComparatorUtils.equals(object, Primitive.NULL)) {
                this.nextGroup = null;
                return;
            }
            IntList intList = new IntList();
            intList.add(this.nextTableDataIndex);
            int n = this.nextTableDataIndex;
            int n2 = this.nextArrayIndex;
            this.nextRowIndex();
            while (this.nextTableDataIndex > n && ComparatorUtils.equals(this.getObject(this.nextTableDataIndex), object)) {
                intList.add(this.nextTableDataIndex);
                n = this.nextTableDataIndex;
                n2 = this.nextArrayIndex;
                this.nextRowIndex();
            }
            this.nextTableDataIndex = n;
            this.nextArrayIndex = n2;
            this.nextGroup = new Group(object, intList.toArray());
        }

        public boolean hasNext() {
            while (this.current_group_index < this.need_group_index) {
                this.findNext();
                ++this.current_group_index;
            }
            return this.nextGroup != null;
        }

        public Object next() {
            while (this.current_group_index < this.need_group_index) {
                this.findNext();
                ++this.current_group_index;
            }
            ++this.need_group_index;
            return this.nextGroup;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

