/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.cellElement.core;

import com.fr.base.FRContext;
import com.fr.base.core.list.IntList;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.data.TableData;
import com.fr.data.TableDataException;
import com.fr.report.cellElement.core.Group;
import com.fr.report.cellElement.core.RecordGrouper;
import com.fr.report.script.Calculator;
import java.util.logging.Level;

public class IndexGrouper
extends RecordGrouper {
    private int index;

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int n) {
        this.index = n;
    }

    public Group[] group(TableData tableData, int n, int[] nArray, Calculator calculator) {
        if (n == -1) {
            return super.group(tableData, n, nArray, calculator);
        }
        if (nArray == null) {
            try {
                nArray = IntList.range(tableData.getRowCount());
            }
            catch (TableDataException tableDataException) {
                FRContext.getLogger().log(Level.WARNING, tableDataException.getMessage(), tableDataException);
            }
        }
        Object object = null;
        int n2 = 0;
        if (this.index >= 0 && this.index < nArray.length) {
            n2 = nArray[this.index];
            try {
                object = tableData.getValueAt(n2, n);
            }
            catch (TableDataException tableDataException) {
                FRContext.getLogger().log(Level.WARNING, tableDataException.getMessage(), tableDataException);
            }
        }
        return new Group[]{new Group(object, new int[]{n2})};
    }

    public void readXML(XMLableReader xMLableReader) {
        String string;
        if (xMLableReader.isChildNode() && "Attr".equals(xMLableReader.getTagName()) && (string = xMLableReader.getAttr("index")) != null) {
            this.setIndex(Integer.parseInt(string));
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("Attr").attr("index", this.index).end();
    }
}

